/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisvideo.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.kinesisvideo.model.ChannelType;
import software.amazon.awssdk.services.kinesisvideo.model.KinesisVideoRequest;
import software.amazon.awssdk.services.kinesisvideo.model.SingleMasterConfiguration;
import software.amazon.awssdk.services.kinesisvideo.model.Tag;
import software.amazon.awssdk.services.kinesisvideo.model.TagOnCreateListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateSignalingChannelRequest
extends KinesisVideoRequest
implements ToCopyableBuilder<Builder, CreateSignalingChannelRequest> {
    private static final SdkField<String> CHANNEL_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ChannelName").getter(CreateSignalingChannelRequest.getter(CreateSignalingChannelRequest::channelName)).setter(CreateSignalingChannelRequest.setter(Builder::channelName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChannelName").build()}).build();
    private static final SdkField<String> CHANNEL_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ChannelType").getter(CreateSignalingChannelRequest.getter(CreateSignalingChannelRequest::channelTypeAsString)).setter(CreateSignalingChannelRequest.setter(Builder::channelType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChannelType").build()}).build();
    private static final SdkField<SingleMasterConfiguration> SINGLE_MASTER_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SingleMasterConfiguration").getter(CreateSignalingChannelRequest.getter(CreateSignalingChannelRequest::singleMasterConfiguration)).setter(CreateSignalingChannelRequest.setter(Builder::singleMasterConfiguration)).constructor(SingleMasterConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SingleMasterConfiguration").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(CreateSignalingChannelRequest.getter(CreateSignalingChannelRequest::tags)).setter(CreateSignalingChannelRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANNEL_NAME_FIELD, CHANNEL_TYPE_FIELD, SINGLE_MASTER_CONFIGURATION_FIELD, TAGS_FIELD));
    private final String channelName;
    private final String channelType;
    private final SingleMasterConfiguration singleMasterConfiguration;
    private final List<Tag> tags;

    private CreateSignalingChannelRequest(BuilderImpl builder) {
        super(builder);
        this.channelName = builder.channelName;
        this.channelType = builder.channelType;
        this.singleMasterConfiguration = builder.singleMasterConfiguration;
        this.tags = builder.tags;
    }

    public String channelName() {
        return this.channelName;
    }

    public ChannelType channelType() {
        return ChannelType.fromValue(this.channelType);
    }

    public String channelTypeAsString() {
        return this.channelType;
    }

    public SingleMasterConfiguration singleMasterConfiguration() {
        return this.singleMasterConfiguration;
    }

    public boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public List<Tag> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.channelName());
        hashCode = 31 * hashCode + Objects.hashCode(this.channelTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.singleMasterConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateSignalingChannelRequest)) {
            return false;
        }
        CreateSignalingChannelRequest other = (CreateSignalingChannelRequest)((Object)obj);
        return Objects.equals(this.channelName(), other.channelName()) && Objects.equals(this.channelTypeAsString(), other.channelTypeAsString()) && Objects.equals(this.singleMasterConfiguration(), other.singleMasterConfiguration()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public String toString() {
        return ToString.builder((String)"CreateSignalingChannelRequest").add("ChannelName", (Object)this.channelName()).add("ChannelType", (Object)this.channelTypeAsString()).add("SingleMasterConfiguration", (Object)this.singleMasterConfiguration()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ChannelName": {
                return Optional.ofNullable(clazz.cast(this.channelName()));
            }
            case "ChannelType": {
                return Optional.ofNullable(clazz.cast(this.channelTypeAsString()));
            }
            case "SingleMasterConfiguration": {
                return Optional.ofNullable(clazz.cast(this.singleMasterConfiguration()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateSignalingChannelRequest, T> g) {
        return obj -> g.apply((CreateSignalingChannelRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends KinesisVideoRequest.BuilderImpl
    implements Builder {
        private String channelName;
        private String channelType;
        private SingleMasterConfiguration singleMasterConfiguration;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateSignalingChannelRequest model) {
            super(model);
            this.channelName(model.channelName);
            this.channelType(model.channelType);
            this.singleMasterConfiguration(model.singleMasterConfiguration);
            this.tags(model.tags);
        }

        public final String getChannelName() {
            return this.channelName;
        }

        @Override
        public final Builder channelName(String channelName) {
            this.channelName = channelName;
            return this;
        }

        public final void setChannelName(String channelName) {
            this.channelName = channelName;
        }

        public final String getChannelType() {
            return this.channelType;
        }

        @Override
        public final Builder channelType(String channelType) {
            this.channelType = channelType;
            return this;
        }

        @Override
        public final Builder channelType(ChannelType channelType) {
            this.channelType(channelType == null ? null : channelType.toString());
            return this;
        }

        public final void setChannelType(String channelType) {
            this.channelType = channelType;
        }

        public final SingleMasterConfiguration.Builder getSingleMasterConfiguration() {
            return this.singleMasterConfiguration != null ? this.singleMasterConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder singleMasterConfiguration(SingleMasterConfiguration singleMasterConfiguration) {
            this.singleMasterConfiguration = singleMasterConfiguration;
            return this;
        }

        public final void setSingleMasterConfiguration(SingleMasterConfiguration.BuilderImpl singleMasterConfiguration) {
            this.singleMasterConfiguration = singleMasterConfiguration != null ? singleMasterConfiguration.build() : null;
        }

        public final Collection<Tag.Builder> getTags() {
            if (this.tags instanceof SdkAutoConstructList) {
                return null;
            }
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagOnCreateListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagOnCreateListCopier.copyFromBuilder(tags);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateSignalingChannelRequest build() {
            return new CreateSignalingChannelRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends KinesisVideoRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateSignalingChannelRequest> {
        public Builder channelName(String var1);

        public Builder channelType(String var1);

        public Builder channelType(ChannelType var1);

        public Builder singleMasterConfiguration(SingleMasterConfiguration var1);

        default public Builder singleMasterConfiguration(Consumer<SingleMasterConfiguration.Builder> singleMasterConfiguration) {
            return this.singleMasterConfiguration((SingleMasterConfiguration)((SingleMasterConfiguration.Builder)SingleMasterConfiguration.builder().applyMutation(singleMasterConfiguration)).build());
        }

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

