/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisvideo.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure that encapsulates a signaling channel's metadata and properties.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ChannelInfo implements SdkPojo, Serializable, ToCopyableBuilder<ChannelInfo.Builder, ChannelInfo> {
    private static final SdkField<String> CHANNEL_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ChannelName").getter(getter(ChannelInfo::channelName)).setter(setter(Builder::channelName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChannelName").build()).build();

    private static final SdkField<String> CHANNEL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ChannelARN").getter(getter(ChannelInfo::channelARN)).setter(setter(Builder::channelARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChannelARN").build()).build();

    private static final SdkField<String> CHANNEL_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ChannelType").getter(getter(ChannelInfo::channelTypeAsString)).setter(setter(Builder::channelType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChannelType").build()).build();

    private static final SdkField<String> CHANNEL_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ChannelStatus").getter(getter(ChannelInfo::channelStatusAsString))
            .setter(setter(Builder::channelStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChannelStatus").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime").getter(getter(ChannelInfo::creationTime)).setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<SingleMasterConfiguration> SINGLE_MASTER_CONFIGURATION_FIELD = SdkField
            .<SingleMasterConfiguration> builder(MarshallingType.SDK_POJO).memberName("SingleMasterConfiguration")
            .getter(getter(ChannelInfo::singleMasterConfiguration)).setter(setter(Builder::singleMasterConfiguration))
            .constructor(SingleMasterConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SingleMasterConfiguration").build())
            .build();

    private static final SdkField<String> VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Version")
            .getter(getter(ChannelInfo::version)).setter(setter(Builder::version))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Version").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANNEL_NAME_FIELD,
            CHANNEL_ARN_FIELD, CHANNEL_TYPE_FIELD, CHANNEL_STATUS_FIELD, CREATION_TIME_FIELD, SINGLE_MASTER_CONFIGURATION_FIELD,
            VERSION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String channelName;

    private final String channelARN;

    private final String channelType;

    private final String channelStatus;

    private final Instant creationTime;

    private final SingleMasterConfiguration singleMasterConfiguration;

    private final String version;

    private ChannelInfo(BuilderImpl builder) {
        this.channelName = builder.channelName;
        this.channelARN = builder.channelARN;
        this.channelType = builder.channelType;
        this.channelStatus = builder.channelStatus;
        this.creationTime = builder.creationTime;
        this.singleMasterConfiguration = builder.singleMasterConfiguration;
        this.version = builder.version;
    }

    /**
     * <p>
     * The name of the signaling channel.
     * </p>
     * 
     * @return The name of the signaling channel.
     */
    public final String channelName() {
        return channelName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the signaling channel.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the signaling channel.
     */
    public final String channelARN() {
        return channelARN;
    }

    /**
     * <p>
     * The type of the signaling channel.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #channelType} will
     * return {@link ChannelType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #channelTypeAsString}.
     * </p>
     * 
     * @return The type of the signaling channel.
     * @see ChannelType
     */
    public final ChannelType channelType() {
        return ChannelType.fromValue(channelType);
    }

    /**
     * <p>
     * The type of the signaling channel.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #channelType} will
     * return {@link ChannelType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #channelTypeAsString}.
     * </p>
     * 
     * @return The type of the signaling channel.
     * @see ChannelType
     */
    public final String channelTypeAsString() {
        return channelType;
    }

    /**
     * <p>
     * Current status of the signaling channel.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #channelStatus}
     * will return {@link Status#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #channelStatusAsString}.
     * </p>
     * 
     * @return Current status of the signaling channel.
     * @see Status
     */
    public final Status channelStatus() {
        return Status.fromValue(channelStatus);
    }

    /**
     * <p>
     * Current status of the signaling channel.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #channelStatus}
     * will return {@link Status#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #channelStatusAsString}.
     * </p>
     * 
     * @return Current status of the signaling channel.
     * @see Status
     */
    public final String channelStatusAsString() {
        return channelStatus;
    }

    /**
     * <p>
     * The time at which the signaling channel was created.
     * </p>
     * 
     * @return The time at which the signaling channel was created.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * A structure that contains the configuration for the <code>SINGLE_MASTER</code> channel type.
     * </p>
     * 
     * @return A structure that contains the configuration for the <code>SINGLE_MASTER</code> channel type.
     */
    public final SingleMasterConfiguration singleMasterConfiguration() {
        return singleMasterConfiguration;
    }

    /**
     * <p>
     * The current version of the signaling channel.
     * </p>
     * 
     * @return The current version of the signaling channel.
     */
    public final String version() {
        return version;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(channelName());
        hashCode = 31 * hashCode + Objects.hashCode(channelARN());
        hashCode = 31 * hashCode + Objects.hashCode(channelTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(channelStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(singleMasterConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(version());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ChannelInfo)) {
            return false;
        }
        ChannelInfo other = (ChannelInfo) obj;
        return Objects.equals(channelName(), other.channelName()) && Objects.equals(channelARN(), other.channelARN())
                && Objects.equals(channelTypeAsString(), other.channelTypeAsString())
                && Objects.equals(channelStatusAsString(), other.channelStatusAsString())
                && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(singleMasterConfiguration(), other.singleMasterConfiguration())
                && Objects.equals(version(), other.version());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ChannelInfo").add("ChannelName", channelName()).add("ChannelARN", channelARN())
                .add("ChannelType", channelTypeAsString()).add("ChannelStatus", channelStatusAsString())
                .add("CreationTime", creationTime()).add("SingleMasterConfiguration", singleMasterConfiguration())
                .add("Version", version()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ChannelName":
            return Optional.ofNullable(clazz.cast(channelName()));
        case "ChannelARN":
            return Optional.ofNullable(clazz.cast(channelARN()));
        case "ChannelType":
            return Optional.ofNullable(clazz.cast(channelTypeAsString()));
        case "ChannelStatus":
            return Optional.ofNullable(clazz.cast(channelStatusAsString()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "SingleMasterConfiguration":
            return Optional.ofNullable(clazz.cast(singleMasterConfiguration()));
        case "Version":
            return Optional.ofNullable(clazz.cast(version()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ChannelInfo, T> g) {
        return obj -> g.apply((ChannelInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ChannelInfo> {
        /**
         * <p>
         * The name of the signaling channel.
         * </p>
         * 
         * @param channelName
         *        The name of the signaling channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channelName(String channelName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the signaling channel.
         * </p>
         * 
         * @param channelARN
         *        The Amazon Resource Name (ARN) of the signaling channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channelARN(String channelARN);

        /**
         * <p>
         * The type of the signaling channel.
         * </p>
         * 
         * @param channelType
         *        The type of the signaling channel.
         * @see ChannelType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChannelType
         */
        Builder channelType(String channelType);

        /**
         * <p>
         * The type of the signaling channel.
         * </p>
         * 
         * @param channelType
         *        The type of the signaling channel.
         * @see ChannelType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChannelType
         */
        Builder channelType(ChannelType channelType);

        /**
         * <p>
         * Current status of the signaling channel.
         * </p>
         * 
         * @param channelStatus
         *        Current status of the signaling channel.
         * @see Status
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Status
         */
        Builder channelStatus(String channelStatus);

        /**
         * <p>
         * Current status of the signaling channel.
         * </p>
         * 
         * @param channelStatus
         *        Current status of the signaling channel.
         * @see Status
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Status
         */
        Builder channelStatus(Status channelStatus);

        /**
         * <p>
         * The time at which the signaling channel was created.
         * </p>
         * 
         * @param creationTime
         *        The time at which the signaling channel was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * A structure that contains the configuration for the <code>SINGLE_MASTER</code> channel type.
         * </p>
         * 
         * @param singleMasterConfiguration
         *        A structure that contains the configuration for the <code>SINGLE_MASTER</code> channel type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder singleMasterConfiguration(SingleMasterConfiguration singleMasterConfiguration);

        /**
         * <p>
         * A structure that contains the configuration for the <code>SINGLE_MASTER</code> channel type.
         * </p>
         * This is a convenience that creates an instance of the {@link SingleMasterConfiguration.Builder} avoiding the
         * need to create one manually via {@link SingleMasterConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link SingleMasterConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #singleMasterConfiguration(SingleMasterConfiguration)}.
         * 
         * @param singleMasterConfiguration
         *        a consumer that will call methods on {@link SingleMasterConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #singleMasterConfiguration(SingleMasterConfiguration)
         */
        default Builder singleMasterConfiguration(Consumer<SingleMasterConfiguration.Builder> singleMasterConfiguration) {
            return singleMasterConfiguration(SingleMasterConfiguration.builder().applyMutation(singleMasterConfiguration).build());
        }

        /**
         * <p>
         * The current version of the signaling channel.
         * </p>
         * 
         * @param version
         *        The current version of the signaling channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder version(String version);
    }

    static final class BuilderImpl implements Builder {
        private String channelName;

        private String channelARN;

        private String channelType;

        private String channelStatus;

        private Instant creationTime;

        private SingleMasterConfiguration singleMasterConfiguration;

        private String version;

        private BuilderImpl() {
        }

        private BuilderImpl(ChannelInfo model) {
            channelName(model.channelName);
            channelARN(model.channelARN);
            channelType(model.channelType);
            channelStatus(model.channelStatus);
            creationTime(model.creationTime);
            singleMasterConfiguration(model.singleMasterConfiguration);
            version(model.version);
        }

        public final String getChannelName() {
            return channelName;
        }

        public final void setChannelName(String channelName) {
            this.channelName = channelName;
        }

        @Override
        @Transient
        public final Builder channelName(String channelName) {
            this.channelName = channelName;
            return this;
        }

        public final String getChannelARN() {
            return channelARN;
        }

        public final void setChannelARN(String channelARN) {
            this.channelARN = channelARN;
        }

        @Override
        @Transient
        public final Builder channelARN(String channelARN) {
            this.channelARN = channelARN;
            return this;
        }

        public final String getChannelType() {
            return channelType;
        }

        public final void setChannelType(String channelType) {
            this.channelType = channelType;
        }

        @Override
        @Transient
        public final Builder channelType(String channelType) {
            this.channelType = channelType;
            return this;
        }

        @Override
        @Transient
        public final Builder channelType(ChannelType channelType) {
            this.channelType(channelType == null ? null : channelType.toString());
            return this;
        }

        public final String getChannelStatus() {
            return channelStatus;
        }

        public final void setChannelStatus(String channelStatus) {
            this.channelStatus = channelStatus;
        }

        @Override
        @Transient
        public final Builder channelStatus(String channelStatus) {
            this.channelStatus = channelStatus;
            return this;
        }

        @Override
        @Transient
        public final Builder channelStatus(Status channelStatus) {
            this.channelStatus(channelStatus == null ? null : channelStatus.toString());
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        @Transient
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final SingleMasterConfiguration.Builder getSingleMasterConfiguration() {
            return singleMasterConfiguration != null ? singleMasterConfiguration.toBuilder() : null;
        }

        public final void setSingleMasterConfiguration(SingleMasterConfiguration.BuilderImpl singleMasterConfiguration) {
            this.singleMasterConfiguration = singleMasterConfiguration != null ? singleMasterConfiguration.build() : null;
        }

        @Override
        @Transient
        public final Builder singleMasterConfiguration(SingleMasterConfiguration singleMasterConfiguration) {
            this.singleMasterConfiguration = singleMasterConfiguration;
            return this;
        }

        public final String getVersion() {
            return version;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        @Override
        @Transient
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        @Override
        public ChannelInfo build() {
            return new ChannelInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
