/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisvideo.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListTagsForStreamRequest extends KinesisVideoRequest implements
        ToCopyableBuilder<ListTagsForStreamRequest.Builder, ListTagsForStreamRequest> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListTagsForStreamRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<String> STREAM_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StreamARN").getter(getter(ListTagsForStreamRequest::streamARN)).setter(setter(Builder::streamARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamARN").build()).build();

    private static final SdkField<String> STREAM_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StreamName").getter(getter(ListTagsForStreamRequest::streamName)).setter(setter(Builder::streamName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            STREAM_ARN_FIELD, STREAM_NAME_FIELD));

    private final String nextToken;

    private final String streamARN;

    private final String streamName;

    private ListTagsForStreamRequest(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.streamARN = builder.streamARN;
        this.streamName = builder.streamName;
    }

    /**
     * <p>
     * If you specify this parameter and the result of a <code>ListTagsForStream</code> call is truncated, the response
     * includes a token that you can use in the next request to fetch the next batch of tags.
     * </p>
     * 
     * @return If you specify this parameter and the result of a <code>ListTagsForStream</code> call is truncated, the
     *         response includes a token that you can use in the next request to fetch the next batch of tags.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the stream that you want to list tags for.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the stream that you want to list tags for.
     */
    public final String streamARN() {
        return streamARN;
    }

    /**
     * <p>
     * The name of the stream that you want to list tags for.
     * </p>
     * 
     * @return The name of the stream that you want to list tags for.
     */
    public final String streamName() {
        return streamName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(streamARN());
        hashCode = 31 * hashCode + Objects.hashCode(streamName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTagsForStreamRequest)) {
            return false;
        }
        ListTagsForStreamRequest other = (ListTagsForStreamRequest) obj;
        return Objects.equals(nextToken(), other.nextToken()) && Objects.equals(streamARN(), other.streamARN())
                && Objects.equals(streamName(), other.streamName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListTagsForStreamRequest").add("NextToken", nextToken()).add("StreamARN", streamARN())
                .add("StreamName", streamName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "StreamARN":
            return Optional.ofNullable(clazz.cast(streamARN()));
        case "StreamName":
            return Optional.ofNullable(clazz.cast(streamName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListTagsForStreamRequest, T> g) {
        return obj -> g.apply((ListTagsForStreamRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends KinesisVideoRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListTagsForStreamRequest> {
        /**
         * <p>
         * If you specify this parameter and the result of a <code>ListTagsForStream</code> call is truncated, the
         * response includes a token that you can use in the next request to fetch the next batch of tags.
         * </p>
         * 
         * @param nextToken
         *        If you specify this parameter and the result of a <code>ListTagsForStream</code> call is truncated,
         *        the response includes a token that you can use in the next request to fetch the next batch of tags.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the stream that you want to list tags for.
         * </p>
         * 
         * @param streamARN
         *        The Amazon Resource Name (ARN) of the stream that you want to list tags for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamARN(String streamARN);

        /**
         * <p>
         * The name of the stream that you want to list tags for.
         * </p>
         * 
         * @param streamName
         *        The name of the stream that you want to list tags for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamName(String streamName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends KinesisVideoRequest.BuilderImpl implements Builder {
        private String nextToken;

        private String streamARN;

        private String streamName;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTagsForStreamRequest model) {
            super(model);
            nextToken(model.nextToken);
            streamARN(model.streamARN);
            streamName(model.streamName);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getStreamARN() {
            return streamARN;
        }

        public final void setStreamARN(String streamARN) {
            this.streamARN = streamARN;
        }

        @Override
        @Transient
        public final Builder streamARN(String streamARN) {
            this.streamARN = streamARN;
            return this;
        }

        public final String getStreamName() {
            return streamName;
        }

        public final void setStreamName(String streamName) {
            this.streamName = streamName;
        }

        @Override
        @Transient
        public final Builder streamName(String streamName) {
            this.streamName = streamName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListTagsForStreamRequest build() {
            return new ListTagsForStreamRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
