/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisvideo.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure that contains the configuration for the <code>SINGLE_MASTER</code> channel type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SingleMasterConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<SingleMasterConfiguration.Builder, SingleMasterConfiguration> {
    private static final SdkField<Integer> MESSAGE_TTL_SECONDS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MessageTtlSeconds").getter(getter(SingleMasterConfiguration::messageTtlSeconds))
            .setter(setter(Builder::messageTtlSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MessageTtlSeconds").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MESSAGE_TTL_SECONDS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer messageTtlSeconds;

    private SingleMasterConfiguration(BuilderImpl builder) {
        this.messageTtlSeconds = builder.messageTtlSeconds;
    }

    /**
     * <p>
     * The period of time a signaling channel retains underlivered messages before they are discarded.
     * </p>
     * 
     * @return The period of time a signaling channel retains underlivered messages before they are discarded.
     */
    public final Integer messageTtlSeconds() {
        return messageTtlSeconds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(messageTtlSeconds());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SingleMasterConfiguration)) {
            return false;
        }
        SingleMasterConfiguration other = (SingleMasterConfiguration) obj;
        return Objects.equals(messageTtlSeconds(), other.messageTtlSeconds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SingleMasterConfiguration").add("MessageTtlSeconds", messageTtlSeconds()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MessageTtlSeconds":
            return Optional.ofNullable(clazz.cast(messageTtlSeconds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SingleMasterConfiguration, T> g) {
        return obj -> g.apply((SingleMasterConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SingleMasterConfiguration> {
        /**
         * <p>
         * The period of time a signaling channel retains underlivered messages before they are discarded.
         * </p>
         * 
         * @param messageTtlSeconds
         *        The period of time a signaling channel retains underlivered messages before they are discarded.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder messageTtlSeconds(Integer messageTtlSeconds);
    }

    static final class BuilderImpl implements Builder {
        private Integer messageTtlSeconds;

        private BuilderImpl() {
        }

        private BuilderImpl(SingleMasterConfiguration model) {
            messageTtlSeconds(model.messageTtlSeconds);
        }

        public final Integer getMessageTtlSeconds() {
            return messageTtlSeconds;
        }

        public final void setMessageTtlSeconds(Integer messageTtlSeconds) {
            this.messageTtlSeconds = messageTtlSeconds;
        }

        @Override
        @Transient
        public final Builder messageTtlSeconds(Integer messageTtlSeconds) {
            this.messageTtlSeconds = messageTtlSeconds;
            return this;
        }

        @Override
        public SingleMasterConfiguration build() {
            return new SingleMasterConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
