/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisvideo.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateStreamRequest extends KinesisVideoRequest implements
        ToCopyableBuilder<CreateStreamRequest.Builder, CreateStreamRequest> {
    private static final SdkField<String> DEVICE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DeviceName").getter(getter(CreateStreamRequest::deviceName)).setter(setter(Builder::deviceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceName").build()).build();

    private static final SdkField<String> STREAM_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StreamName").getter(getter(CreateStreamRequest::streamName)).setter(setter(Builder::streamName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamName").build()).build();

    private static final SdkField<String> MEDIA_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MediaType").getter(getter(CreateStreamRequest::mediaType)).setter(setter(Builder::mediaType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MediaType").build()).build();

    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KmsKeyId").getter(getter(CreateStreamRequest::kmsKeyId)).setter(setter(Builder::kmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()).build();

    private static final SdkField<Integer> DATA_RETENTION_IN_HOURS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("DataRetentionInHours").getter(getter(CreateStreamRequest::dataRetentionInHours))
            .setter(setter(Builder::dataRetentionInHours))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataRetentionInHours").build())
            .build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(CreateStreamRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEVICE_NAME_FIELD,
            STREAM_NAME_FIELD, MEDIA_TYPE_FIELD, KMS_KEY_ID_FIELD, DATA_RETENTION_IN_HOURS_FIELD, TAGS_FIELD));

    private final String deviceName;

    private final String streamName;

    private final String mediaType;

    private final String kmsKeyId;

    private final Integer dataRetentionInHours;

    private final Map<String, String> tags;

    private CreateStreamRequest(BuilderImpl builder) {
        super(builder);
        this.deviceName = builder.deviceName;
        this.streamName = builder.streamName;
        this.mediaType = builder.mediaType;
        this.kmsKeyId = builder.kmsKeyId;
        this.dataRetentionInHours = builder.dataRetentionInHours;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The name of the device that is writing to the stream.
     * </p>
     * <note>
     * <p>
     * In the current implementation, Kinesis Video Streams does not use this name.
     * </p>
     * </note>
     * 
     * @return The name of the device that is writing to the stream. </p> <note>
     *         <p>
     *         In the current implementation, Kinesis Video Streams does not use this name.
     *         </p>
     */
    public final String deviceName() {
        return deviceName;
    }

    /**
     * <p>
     * A name for the stream that you are creating.
     * </p>
     * <p>
     * The stream name is an identifier for the stream, and must be unique for each account and region.
     * </p>
     * 
     * @return A name for the stream that you are creating.</p>
     *         <p>
     *         The stream name is an identifier for the stream, and must be unique for each account and region.
     */
    public final String streamName() {
        return streamName;
    }

    /**
     * <p>
     * The media type of the stream. Consumers of the stream can use this information when processing the stream. For
     * more information about media types, see <a
     * href="http://www.iana.org/assignments/media-types/media-types.xhtml">Media Types</a>. If you choose to specify
     * the <code>MediaType</code>, see <a href="https://tools.ietf.org/html/rfc6838#section-4.2">Naming Requirements</a>
     * for guidelines.
     * </p>
     * <p>
     * Example valid values include "video/h264" and "video/h264,audio/aac".
     * </p>
     * <p>
     * This parameter is optional; the default value is <code>null</code> (or empty in JSON).
     * </p>
     * 
     * @return The media type of the stream. Consumers of the stream can use this information when processing the
     *         stream. For more information about media types, see <a
     *         href="http://www.iana.org/assignments/media-types/media-types.xhtml">Media Types</a>. If you choose to
     *         specify the <code>MediaType</code>, see <a href="https://tools.ietf.org/html/rfc6838#section-4.2">Naming
     *         Requirements</a> for guidelines.</p>
     *         <p>
     *         Example valid values include "video/h264" and "video/h264,audio/aac".
     *         </p>
     *         <p>
     *         This parameter is optional; the default value is <code>null</code> (or empty in JSON).
     */
    public final String mediaType() {
        return mediaType;
    }

    /**
     * <p>
     * The ID of the Key Management Service (KMS) key that you want Kinesis Video Streams to use to encrypt stream data.
     * </p>
     * <p>
     * If no key ID is specified, the default, Kinesis Video-managed key (<code>aws/kinesisvideo</code>) is used.
     * </p>
     * <p>
     * For more information, see <a href=
     * "https://docs.aws.amazon.com/kms/latest/APIReference/API_DescribeKey.html#API_DescribeKey_RequestParameters"
     * >DescribeKey</a>.
     * </p>
     * 
     * @return The ID of the Key Management Service (KMS) key that you want Kinesis Video Streams to use to encrypt
     *         stream data.</p>
     *         <p>
     *         If no key ID is specified, the default, Kinesis Video-managed key (<code>aws/kinesisvideo</code>) is
     *         used.
     *         </p>
     *         <p>
     *         For more information, see <a href=
     *         "https://docs.aws.amazon.com/kms/latest/APIReference/API_DescribeKey.html#API_DescribeKey_RequestParameters"
     *         >DescribeKey</a>.
     */
    public final String kmsKeyId() {
        return kmsKeyId;
    }

    /**
     * <p>
     * The number of hours that you want to retain the data in the stream. Kinesis Video Streams retains the data in a
     * data store that is associated with the stream.
     * </p>
     * <p>
     * The default value is 0, indicating that the stream does not persist data.
     * </p>
     * <p>
     * When the <code>DataRetentionInHours</code> value is 0, consumers can still consume the fragments that remain in
     * the service host buffer, which has a retention time limit of 5 minutes and a retention memory limit of 200 MB.
     * Fragments are removed from the buffer when either limit is reached.
     * </p>
     * 
     * @return The number of hours that you want to retain the data in the stream. Kinesis Video Streams retains the
     *         data in a data store that is associated with the stream.</p>
     *         <p>
     *         The default value is 0, indicating that the stream does not persist data.
     *         </p>
     *         <p>
     *         When the <code>DataRetentionInHours</code> value is 0, consumers can still consume the fragments that
     *         remain in the service host buffer, which has a retention time limit of 5 minutes and a retention memory
     *         limit of 200 MB. Fragments are removed from the buffer when either limit is reached.
     */
    public final Integer dataRetentionInHours() {
        return dataRetentionInHours;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A list of tags to associate with the specified stream. Each tag is a key-value pair (the value is optional).
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return A list of tags to associate with the specified stream. Each tag is a key-value pair (the value is
     *         optional).
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(deviceName());
        hashCode = 31 * hashCode + Objects.hashCode(streamName());
        hashCode = 31 * hashCode + Objects.hashCode(mediaType());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(dataRetentionInHours());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateStreamRequest)) {
            return false;
        }
        CreateStreamRequest other = (CreateStreamRequest) obj;
        return Objects.equals(deviceName(), other.deviceName()) && Objects.equals(streamName(), other.streamName())
                && Objects.equals(mediaType(), other.mediaType()) && Objects.equals(kmsKeyId(), other.kmsKeyId())
                && Objects.equals(dataRetentionInHours(), other.dataRetentionInHours()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateStreamRequest").add("DeviceName", deviceName()).add("StreamName", streamName())
                .add("MediaType", mediaType()).add("KmsKeyId", kmsKeyId()).add("DataRetentionInHours", dataRetentionInHours())
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DeviceName":
            return Optional.ofNullable(clazz.cast(deviceName()));
        case "StreamName":
            return Optional.ofNullable(clazz.cast(streamName()));
        case "MediaType":
            return Optional.ofNullable(clazz.cast(mediaType()));
        case "KmsKeyId":
            return Optional.ofNullable(clazz.cast(kmsKeyId()));
        case "DataRetentionInHours":
            return Optional.ofNullable(clazz.cast(dataRetentionInHours()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateStreamRequest, T> g) {
        return obj -> g.apply((CreateStreamRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends KinesisVideoRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateStreamRequest> {
        /**
         * <p>
         * The name of the device that is writing to the stream.
         * </p>
         * <note>
         * <p>
         * In the current implementation, Kinesis Video Streams does not use this name.
         * </p>
         * </note>
         * 
         * @param deviceName
         *        The name of the device that is writing to the stream. </p> <note>
         *        <p>
         *        In the current implementation, Kinesis Video Streams does not use this name.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceName(String deviceName);

        /**
         * <p>
         * A name for the stream that you are creating.
         * </p>
         * <p>
         * The stream name is an identifier for the stream, and must be unique for each account and region.
         * </p>
         * 
         * @param streamName
         *        A name for the stream that you are creating.</p>
         *        <p>
         *        The stream name is an identifier for the stream, and must be unique for each account and region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamName(String streamName);

        /**
         * <p>
         * The media type of the stream. Consumers of the stream can use this information when processing the stream.
         * For more information about media types, see <a
         * href="http://www.iana.org/assignments/media-types/media-types.xhtml">Media Types</a>. If you choose to
         * specify the <code>MediaType</code>, see <a href="https://tools.ietf.org/html/rfc6838#section-4.2">Naming
         * Requirements</a> for guidelines.
         * </p>
         * <p>
         * Example valid values include "video/h264" and "video/h264,audio/aac".
         * </p>
         * <p>
         * This parameter is optional; the default value is <code>null</code> (or empty in JSON).
         * </p>
         * 
         * @param mediaType
         *        The media type of the stream. Consumers of the stream can use this information when processing the
         *        stream. For more information about media types, see <a
         *        href="http://www.iana.org/assignments/media-types/media-types.xhtml">Media Types</a>. If you choose to
         *        specify the <code>MediaType</code>, see <a
         *        href="https://tools.ietf.org/html/rfc6838#section-4.2">Naming Requirements</a> for guidelines.</p>
         *        <p>
         *        Example valid values include "video/h264" and "video/h264,audio/aac".
         *        </p>
         *        <p>
         *        This parameter is optional; the default value is <code>null</code> (or empty in JSON).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mediaType(String mediaType);

        /**
         * <p>
         * The ID of the Key Management Service (KMS) key that you want Kinesis Video Streams to use to encrypt stream
         * data.
         * </p>
         * <p>
         * If no key ID is specified, the default, Kinesis Video-managed key (<code>aws/kinesisvideo</code>) is used.
         * </p>
         * <p>
         * For more information, see <a href=
         * "https://docs.aws.amazon.com/kms/latest/APIReference/API_DescribeKey.html#API_DescribeKey_RequestParameters"
         * >DescribeKey</a>.
         * </p>
         * 
         * @param kmsKeyId
         *        The ID of the Key Management Service (KMS) key that you want Kinesis Video Streams to use to encrypt
         *        stream data.</p>
         *        <p>
         *        If no key ID is specified, the default, Kinesis Video-managed key (<code>aws/kinesisvideo</code>) is
         *        used.
         *        </p>
         *        <p>
         *        For more information, see <a href=
         *        "https://docs.aws.amazon.com/kms/latest/APIReference/API_DescribeKey.html#API_DescribeKey_RequestParameters"
         *        >DescribeKey</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyId(String kmsKeyId);

        /**
         * <p>
         * The number of hours that you want to retain the data in the stream. Kinesis Video Streams retains the data in
         * a data store that is associated with the stream.
         * </p>
         * <p>
         * The default value is 0, indicating that the stream does not persist data.
         * </p>
         * <p>
         * When the <code>DataRetentionInHours</code> value is 0, consumers can still consume the fragments that remain
         * in the service host buffer, which has a retention time limit of 5 minutes and a retention memory limit of 200
         * MB. Fragments are removed from the buffer when either limit is reached.
         * </p>
         * 
         * @param dataRetentionInHours
         *        The number of hours that you want to retain the data in the stream. Kinesis Video Streams retains the
         *        data in a data store that is associated with the stream.</p>
         *        <p>
         *        The default value is 0, indicating that the stream does not persist data.
         *        </p>
         *        <p>
         *        When the <code>DataRetentionInHours</code> value is 0, consumers can still consume the fragments that
         *        remain in the service host buffer, which has a retention time limit of 5 minutes and a retention
         *        memory limit of 200 MB. Fragments are removed from the buffer when either limit is reached.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataRetentionInHours(Integer dataRetentionInHours);

        /**
         * <p>
         * A list of tags to associate with the specified stream. Each tag is a key-value pair (the value is optional).
         * </p>
         * 
         * @param tags
         *        A list of tags to associate with the specified stream. Each tag is a key-value pair (the value is
         *        optional).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends KinesisVideoRequest.BuilderImpl implements Builder {
        private String deviceName;

        private String streamName;

        private String mediaType;

        private String kmsKeyId;

        private Integer dataRetentionInHours;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateStreamRequest model) {
            super(model);
            deviceName(model.deviceName);
            streamName(model.streamName);
            mediaType(model.mediaType);
            kmsKeyId(model.kmsKeyId);
            dataRetentionInHours(model.dataRetentionInHours);
            tags(model.tags);
        }

        public final String getDeviceName() {
            return deviceName;
        }

        public final void setDeviceName(String deviceName) {
            this.deviceName = deviceName;
        }

        @Override
        public final Builder deviceName(String deviceName) {
            this.deviceName = deviceName;
            return this;
        }

        public final String getStreamName() {
            return streamName;
        }

        public final void setStreamName(String streamName) {
            this.streamName = streamName;
        }

        @Override
        public final Builder streamName(String streamName) {
            this.streamName = streamName;
            return this;
        }

        public final String getMediaType() {
            return mediaType;
        }

        public final void setMediaType(String mediaType) {
            this.mediaType = mediaType;
        }

        @Override
        public final Builder mediaType(String mediaType) {
            this.mediaType = mediaType;
            return this;
        }

        public final String getKmsKeyId() {
            return kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final Integer getDataRetentionInHours() {
            return dataRetentionInHours;
        }

        public final void setDataRetentionInHours(Integer dataRetentionInHours) {
            this.dataRetentionInHours = dataRetentionInHours;
        }

        @Override
        public final Builder dataRetentionInHours(Integer dataRetentionInHours) {
            this.dataRetentionInHours = dataRetentionInHours;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = ResourceTagsCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = ResourceTagsCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateStreamRequest build() {
            return new CreateStreamRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
