/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisvideo.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The structure that contains the information required to deliver images to a customer.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ImageGenerationDestinationConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<ImageGenerationDestinationConfig.Builder, ImageGenerationDestinationConfig> {
    private static final SdkField<String> URI_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Uri")
            .getter(getter(ImageGenerationDestinationConfig::uri)).setter(setter(Builder::uri))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Uri").build()).build();

    private static final SdkField<String> DESTINATION_REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DestinationRegion").getter(getter(ImageGenerationDestinationConfig::destinationRegion))
            .setter(setter(Builder::destinationRegion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationRegion").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(URI_FIELD,
            DESTINATION_REGION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String uri;

    private final String destinationRegion;

    private ImageGenerationDestinationConfig(BuilderImpl builder) {
        this.uri = builder.uri;
        this.destinationRegion = builder.destinationRegion;
    }

    /**
     * <p>
     * The Uniform Resource Identifier (URI) that identifies where the images will be delivered.
     * </p>
     * 
     * @return The Uniform Resource Identifier (URI) that identifies where the images will be delivered.
     */
    public final String uri() {
        return uri;
    }

    /**
     * <p>
     * The AWS Region of the S3 bucket where images will be delivered. This <code>DestinationRegion</code> must match
     * the Region where the stream is located.
     * </p>
     * 
     * @return The AWS Region of the S3 bucket where images will be delivered. This <code>DestinationRegion</code> must
     *         match the Region where the stream is located.
     */
    public final String destinationRegion() {
        return destinationRegion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(uri());
        hashCode = 31 * hashCode + Objects.hashCode(destinationRegion());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImageGenerationDestinationConfig)) {
            return false;
        }
        ImageGenerationDestinationConfig other = (ImageGenerationDestinationConfig) obj;
        return Objects.equals(uri(), other.uri()) && Objects.equals(destinationRegion(), other.destinationRegion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ImageGenerationDestinationConfig").add("Uri", uri())
                .add("DestinationRegion", destinationRegion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Uri":
            return Optional.ofNullable(clazz.cast(uri()));
        case "DestinationRegion":
            return Optional.ofNullable(clazz.cast(destinationRegion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ImageGenerationDestinationConfig, T> g) {
        return obj -> g.apply((ImageGenerationDestinationConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ImageGenerationDestinationConfig> {
        /**
         * <p>
         * The Uniform Resource Identifier (URI) that identifies where the images will be delivered.
         * </p>
         * 
         * @param uri
         *        The Uniform Resource Identifier (URI) that identifies where the images will be delivered.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder uri(String uri);

        /**
         * <p>
         * The AWS Region of the S3 bucket where images will be delivered. This <code>DestinationRegion</code> must
         * match the Region where the stream is located.
         * </p>
         * 
         * @param destinationRegion
         *        The AWS Region of the S3 bucket where images will be delivered. This <code>DestinationRegion</code>
         *        must match the Region where the stream is located.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationRegion(String destinationRegion);
    }

    static final class BuilderImpl implements Builder {
        private String uri;

        private String destinationRegion;

        private BuilderImpl() {
        }

        private BuilderImpl(ImageGenerationDestinationConfig model) {
            uri(model.uri);
            destinationRegion(model.destinationRegion);
        }

        public final String getUri() {
            return uri;
        }

        public final void setUri(String uri) {
            this.uri = uri;
        }

        @Override
        public final Builder uri(String uri) {
            this.uri = uri;
            return this;
        }

        public final String getDestinationRegion() {
            return destinationRegion;
        }

        public final void setDestinationRegion(String destinationRegion) {
            this.destinationRegion = destinationRegion;
        }

        @Override
        public final Builder destinationRegion(String destinationRegion) {
            this.destinationRegion = destinationRegion;
            return this;
        }

        @Override
        public ImageGenerationDestinationConfig build() {
            return new ImageGenerationDestinationConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
