/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisvideo.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that describes the endpoint of the signaling channel returned by the
 * <code>GetSignalingChannelEndpoint</code> API.
 * </p>
 * <p>
 * The media server endpoint will correspond to the <code>WEBRTC</code> Protocol.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ResourceEndpointListItem implements SdkPojo, Serializable,
        ToCopyableBuilder<ResourceEndpointListItem.Builder, ResourceEndpointListItem> {
    private static final SdkField<String> PROTOCOL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Protocol").getter(getter(ResourceEndpointListItem::protocolAsString)).setter(setter(Builder::protocol))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Protocol").build()).build();

    private static final SdkField<String> RESOURCE_ENDPOINT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceEndpoint").getter(getter(ResourceEndpointListItem::resourceEndpoint))
            .setter(setter(Builder::resourceEndpoint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceEndpoint").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROTOCOL_FIELD,
            RESOURCE_ENDPOINT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String protocol;

    private final String resourceEndpoint;

    private ResourceEndpointListItem(BuilderImpl builder) {
        this.protocol = builder.protocol;
        this.resourceEndpoint = builder.resourceEndpoint;
    }

    /**
     * <p>
     * The protocol of the signaling channel returned by the <code>GetSignalingChannelEndpoint</code> API.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #protocol} will
     * return {@link ChannelProtocol#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #protocolAsString}.
     * </p>
     * 
     * @return The protocol of the signaling channel returned by the <code>GetSignalingChannelEndpoint</code> API.
     * @see ChannelProtocol
     */
    public final ChannelProtocol protocol() {
        return ChannelProtocol.fromValue(protocol);
    }

    /**
     * <p>
     * The protocol of the signaling channel returned by the <code>GetSignalingChannelEndpoint</code> API.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #protocol} will
     * return {@link ChannelProtocol#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #protocolAsString}.
     * </p>
     * 
     * @return The protocol of the signaling channel returned by the <code>GetSignalingChannelEndpoint</code> API.
     * @see ChannelProtocol
     */
    public final String protocolAsString() {
        return protocol;
    }

    /**
     * <p>
     * The endpoint of the signaling channel returned by the <code>GetSignalingChannelEndpoint</code> API.
     * </p>
     * 
     * @return The endpoint of the signaling channel returned by the <code>GetSignalingChannelEndpoint</code> API.
     */
    public final String resourceEndpoint() {
        return resourceEndpoint;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(protocolAsString());
        hashCode = 31 * hashCode + Objects.hashCode(resourceEndpoint());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceEndpointListItem)) {
            return false;
        }
        ResourceEndpointListItem other = (ResourceEndpointListItem) obj;
        return Objects.equals(protocolAsString(), other.protocolAsString())
                && Objects.equals(resourceEndpoint(), other.resourceEndpoint());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ResourceEndpointListItem").add("Protocol", protocolAsString())
                .add("ResourceEndpoint", resourceEndpoint()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Protocol":
            return Optional.ofNullable(clazz.cast(protocolAsString()));
        case "ResourceEndpoint":
            return Optional.ofNullable(clazz.cast(resourceEndpoint()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ResourceEndpointListItem, T> g) {
        return obj -> g.apply((ResourceEndpointListItem) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ResourceEndpointListItem> {
        /**
         * <p>
         * The protocol of the signaling channel returned by the <code>GetSignalingChannelEndpoint</code> API.
         * </p>
         * 
         * @param protocol
         *        The protocol of the signaling channel returned by the <code>GetSignalingChannelEndpoint</code> API.
         * @see ChannelProtocol
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChannelProtocol
         */
        Builder protocol(String protocol);

        /**
         * <p>
         * The protocol of the signaling channel returned by the <code>GetSignalingChannelEndpoint</code> API.
         * </p>
         * 
         * @param protocol
         *        The protocol of the signaling channel returned by the <code>GetSignalingChannelEndpoint</code> API.
         * @see ChannelProtocol
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ChannelProtocol
         */
        Builder protocol(ChannelProtocol protocol);

        /**
         * <p>
         * The endpoint of the signaling channel returned by the <code>GetSignalingChannelEndpoint</code> API.
         * </p>
         * 
         * @param resourceEndpoint
         *        The endpoint of the signaling channel returned by the <code>GetSignalingChannelEndpoint</code> API.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceEndpoint(String resourceEndpoint);
    }

    static final class BuilderImpl implements Builder {
        private String protocol;

        private String resourceEndpoint;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceEndpointListItem model) {
            protocol(model.protocol);
            resourceEndpoint(model.resourceEndpoint);
        }

        public final String getProtocol() {
            return protocol;
        }

        public final void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        @Override
        public final Builder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        @Override
        public final Builder protocol(ChannelProtocol protocol) {
            this.protocol(protocol == null ? null : protocol.toString());
            return this;
        }

        public final String getResourceEndpoint() {
            return resourceEndpoint;
        }

        public final void setResourceEndpoint(String resourceEndpoint) {
            this.resourceEndpoint = resourceEndpoint;
        }

        @Override
        public final Builder resourceEndpoint(String resourceEndpoint) {
            this.resourceEndpoint = resourceEndpoint;
            return this;
        }

        @Override
        public ResourceEndpointListItem build() {
            return new ResourceEndpointListItem(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
