/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisvideo.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.kinesisvideo.model.EdgeAgentStatus;
import software.amazon.awssdk.services.kinesisvideo.model.EdgeConfig;
import software.amazon.awssdk.services.kinesisvideo.model.KinesisVideoResponse;
import software.amazon.awssdk.services.kinesisvideo.model.SyncStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeEdgeConfigurationResponse
extends KinesisVideoResponse
implements ToCopyableBuilder<Builder, DescribeEdgeConfigurationResponse> {
    private static final SdkField<String> STREAM_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StreamName").getter(DescribeEdgeConfigurationResponse.getter(DescribeEdgeConfigurationResponse::streamName)).setter(DescribeEdgeConfigurationResponse.setter(Builder::streamName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamName").build()}).build();
    private static final SdkField<String> STREAM_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StreamARN").getter(DescribeEdgeConfigurationResponse.getter(DescribeEdgeConfigurationResponse::streamARN)).setter(DescribeEdgeConfigurationResponse.setter(Builder::streamARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamARN").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(DescribeEdgeConfigurationResponse.getter(DescribeEdgeConfigurationResponse::creationTime)).setter(DescribeEdgeConfigurationResponse.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastUpdatedTime").getter(DescribeEdgeConfigurationResponse.getter(DescribeEdgeConfigurationResponse::lastUpdatedTime)).setter(DescribeEdgeConfigurationResponse.setter(Builder::lastUpdatedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedTime").build()}).build();
    private static final SdkField<String> SYNC_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SyncStatus").getter(DescribeEdgeConfigurationResponse.getter(DescribeEdgeConfigurationResponse::syncStatusAsString)).setter(DescribeEdgeConfigurationResponse.setter(Builder::syncStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SyncStatus").build()}).build();
    private static final SdkField<String> FAILED_STATUS_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FailedStatusDetails").getter(DescribeEdgeConfigurationResponse.getter(DescribeEdgeConfigurationResponse::failedStatusDetails)).setter(DescribeEdgeConfigurationResponse.setter(Builder::failedStatusDetails)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailedStatusDetails").build()}).build();
    private static final SdkField<EdgeConfig> EDGE_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EdgeConfig").getter(DescribeEdgeConfigurationResponse.getter(DescribeEdgeConfigurationResponse::edgeConfig)).setter(DescribeEdgeConfigurationResponse.setter(Builder::edgeConfig)).constructor(EdgeConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EdgeConfig").build()}).build();
    private static final SdkField<EdgeAgentStatus> EDGE_AGENT_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EdgeAgentStatus").getter(DescribeEdgeConfigurationResponse.getter(DescribeEdgeConfigurationResponse::edgeAgentStatus)).setter(DescribeEdgeConfigurationResponse.setter(Builder::edgeAgentStatus)).constructor(EdgeAgentStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EdgeAgentStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STREAM_NAME_FIELD, STREAM_ARN_FIELD, CREATION_TIME_FIELD, LAST_UPDATED_TIME_FIELD, SYNC_STATUS_FIELD, FAILED_STATUS_DETAILS_FIELD, EDGE_CONFIG_FIELD, EDGE_AGENT_STATUS_FIELD));
    private final String streamName;
    private final String streamARN;
    private final Instant creationTime;
    private final Instant lastUpdatedTime;
    private final String syncStatus;
    private final String failedStatusDetails;
    private final EdgeConfig edgeConfig;
    private final EdgeAgentStatus edgeAgentStatus;

    private DescribeEdgeConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.streamName = builder.streamName;
        this.streamARN = builder.streamARN;
        this.creationTime = builder.creationTime;
        this.lastUpdatedTime = builder.lastUpdatedTime;
        this.syncStatus = builder.syncStatus;
        this.failedStatusDetails = builder.failedStatusDetails;
        this.edgeConfig = builder.edgeConfig;
        this.edgeAgentStatus = builder.edgeAgentStatus;
    }

    public final String streamName() {
        return this.streamName;
    }

    public final String streamARN() {
        return this.streamARN;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final Instant lastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    public final SyncStatus syncStatus() {
        return SyncStatus.fromValue(this.syncStatus);
    }

    public final String syncStatusAsString() {
        return this.syncStatus;
    }

    public final String failedStatusDetails() {
        return this.failedStatusDetails;
    }

    public final EdgeConfig edgeConfig() {
        return this.edgeConfig;
    }

    public final EdgeAgentStatus edgeAgentStatus() {
        return this.edgeAgentStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.streamName());
        hashCode = 31 * hashCode + Objects.hashCode(this.streamARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.syncStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.failedStatusDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.edgeConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.edgeAgentStatus());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeEdgeConfigurationResponse)) {
            return false;
        }
        DescribeEdgeConfigurationResponse other = (DescribeEdgeConfigurationResponse)((Object)obj);
        return Objects.equals(this.streamName(), other.streamName()) && Objects.equals(this.streamARN(), other.streamARN()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.lastUpdatedTime(), other.lastUpdatedTime()) && Objects.equals(this.syncStatusAsString(), other.syncStatusAsString()) && Objects.equals(this.failedStatusDetails(), other.failedStatusDetails()) && Objects.equals(this.edgeConfig(), other.edgeConfig()) && Objects.equals(this.edgeAgentStatus(), other.edgeAgentStatus());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeEdgeConfigurationResponse").add("StreamName", (Object)this.streamName()).add("StreamARN", (Object)this.streamARN()).add("CreationTime", (Object)this.creationTime()).add("LastUpdatedTime", (Object)this.lastUpdatedTime()).add("SyncStatus", (Object)this.syncStatusAsString()).add("FailedStatusDetails", (Object)this.failedStatusDetails()).add("EdgeConfig", (Object)this.edgeConfig()).add("EdgeAgentStatus", (Object)this.edgeAgentStatus()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StreamName": {
                return Optional.ofNullable(clazz.cast(this.streamName()));
            }
            case "StreamARN": {
                return Optional.ofNullable(clazz.cast(this.streamARN()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "LastUpdatedTime": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedTime()));
            }
            case "SyncStatus": {
                return Optional.ofNullable(clazz.cast(this.syncStatusAsString()));
            }
            case "FailedStatusDetails": {
                return Optional.ofNullable(clazz.cast(this.failedStatusDetails()));
            }
            case "EdgeConfig": {
                return Optional.ofNullable(clazz.cast(this.edgeConfig()));
            }
            case "EdgeAgentStatus": {
                return Optional.ofNullable(clazz.cast(this.edgeAgentStatus()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeEdgeConfigurationResponse, T> g) {
        return obj -> g.apply((DescribeEdgeConfigurationResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends KinesisVideoResponse.BuilderImpl
    implements Builder {
        private String streamName;
        private String streamARN;
        private Instant creationTime;
        private Instant lastUpdatedTime;
        private String syncStatus;
        private String failedStatusDetails;
        private EdgeConfig edgeConfig;
        private EdgeAgentStatus edgeAgentStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeEdgeConfigurationResponse model) {
            super(model);
            this.streamName(model.streamName);
            this.streamARN(model.streamARN);
            this.creationTime(model.creationTime);
            this.lastUpdatedTime(model.lastUpdatedTime);
            this.syncStatus(model.syncStatus);
            this.failedStatusDetails(model.failedStatusDetails);
            this.edgeConfig(model.edgeConfig);
            this.edgeAgentStatus(model.edgeAgentStatus);
        }

        public final String getStreamName() {
            return this.streamName;
        }

        public final void setStreamName(String streamName) {
            this.streamName = streamName;
        }

        @Override
        public final Builder streamName(String streamName) {
            this.streamName = streamName;
            return this;
        }

        public final String getStreamARN() {
            return this.streamARN;
        }

        public final void setStreamARN(String streamARN) {
            this.streamARN = streamARN;
        }

        @Override
        public final Builder streamARN(String streamARN) {
            this.streamARN = streamARN;
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getLastUpdatedTime() {
            return this.lastUpdatedTime;
        }

        public final void setLastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
        }

        @Override
        public final Builder lastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        public final String getSyncStatus() {
            return this.syncStatus;
        }

        public final void setSyncStatus(String syncStatus) {
            this.syncStatus = syncStatus;
        }

        @Override
        public final Builder syncStatus(String syncStatus) {
            this.syncStatus = syncStatus;
            return this;
        }

        @Override
        public final Builder syncStatus(SyncStatus syncStatus) {
            this.syncStatus(syncStatus == null ? null : syncStatus.toString());
            return this;
        }

        public final String getFailedStatusDetails() {
            return this.failedStatusDetails;
        }

        public final void setFailedStatusDetails(String failedStatusDetails) {
            this.failedStatusDetails = failedStatusDetails;
        }

        @Override
        public final Builder failedStatusDetails(String failedStatusDetails) {
            this.failedStatusDetails = failedStatusDetails;
            return this;
        }

        public final EdgeConfig.Builder getEdgeConfig() {
            return this.edgeConfig != null ? this.edgeConfig.toBuilder() : null;
        }

        public final void setEdgeConfig(EdgeConfig.BuilderImpl edgeConfig) {
            this.edgeConfig = edgeConfig != null ? edgeConfig.build() : null;
        }

        @Override
        public final Builder edgeConfig(EdgeConfig edgeConfig) {
            this.edgeConfig = edgeConfig;
            return this;
        }

        public final EdgeAgentStatus.Builder getEdgeAgentStatus() {
            return this.edgeAgentStatus != null ? this.edgeAgentStatus.toBuilder() : null;
        }

        public final void setEdgeAgentStatus(EdgeAgentStatus.BuilderImpl edgeAgentStatus) {
            this.edgeAgentStatus = edgeAgentStatus != null ? edgeAgentStatus.build() : null;
        }

        @Override
        public final Builder edgeAgentStatus(EdgeAgentStatus edgeAgentStatus) {
            this.edgeAgentStatus = edgeAgentStatus;
            return this;
        }

        @Override
        public DescribeEdgeConfigurationResponse build() {
            return new DescribeEdgeConfigurationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends KinesisVideoResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeEdgeConfigurationResponse> {
        public Builder streamName(String var1);

        public Builder streamARN(String var1);

        public Builder creationTime(Instant var1);

        public Builder lastUpdatedTime(Instant var1);

        public Builder syncStatus(String var1);

        public Builder syncStatus(SyncStatus var1);

        public Builder failedStatusDetails(String var1);

        public Builder edgeConfig(EdgeConfig var1);

        default public Builder edgeConfig(Consumer<EdgeConfig.Builder> edgeConfig) {
            return this.edgeConfig((EdgeConfig)((EdgeConfig.Builder)EdgeConfig.builder().applyMutation(edgeConfig)).build());
        }

        public Builder edgeAgentStatus(EdgeAgentStatus var1);

        default public Builder edgeAgentStatus(Consumer<EdgeAgentStatus.Builder> edgeAgentStatus) {
            return this.edgeAgentStatus((EdgeAgentStatus)((EdgeAgentStatus.Builder)EdgeAgentStatus.builder().applyMutation(edgeAgentStatus)).build());
        }
    }
}

