/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisvideo.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateDataRetentionRequest extends KinesisVideoRequest implements
        ToCopyableBuilder<UpdateDataRetentionRequest.Builder, UpdateDataRetentionRequest> {
    private static final SdkField<String> STREAM_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateDataRetentionRequest::streamName)).setter(setter(Builder::streamName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamName").build()).build();

    private static final SdkField<String> STREAM_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateDataRetentionRequest::streamARN)).setter(setter(Builder::streamARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamARN").build()).build();

    private static final SdkField<String> CURRENT_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateDataRetentionRequest::currentVersion)).setter(setter(Builder::currentVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrentVersion").build()).build();

    private static final SdkField<String> OPERATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateDataRetentionRequest::operationAsString)).setter(setter(Builder::operation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Operation").build()).build();

    private static final SdkField<Integer> DATA_RETENTION_CHANGE_IN_HOURS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(UpdateDataRetentionRequest::dataRetentionChangeInHours))
            .setter(setter(Builder::dataRetentionChangeInHours))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataRetentionChangeInHours").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STREAM_NAME_FIELD,
            STREAM_ARN_FIELD, CURRENT_VERSION_FIELD, OPERATION_FIELD, DATA_RETENTION_CHANGE_IN_HOURS_FIELD));

    private final String streamName;

    private final String streamARN;

    private final String currentVersion;

    private final String operation;

    private final Integer dataRetentionChangeInHours;

    private UpdateDataRetentionRequest(BuilderImpl builder) {
        super(builder);
        this.streamName = builder.streamName;
        this.streamARN = builder.streamARN;
        this.currentVersion = builder.currentVersion;
        this.operation = builder.operation;
        this.dataRetentionChangeInHours = builder.dataRetentionChangeInHours;
    }

    /**
     * <p>
     * The name of the stream whose retention period you want to change.
     * </p>
     * 
     * @return The name of the stream whose retention period you want to change.
     */
    public String streamName() {
        return streamName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the stream whose retention period you want to change.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the stream whose retention period you want to change.
     */
    public String streamARN() {
        return streamARN;
    }

    /**
     * <p>
     * The version of the stream whose retention period you want to change. To get the version, call either the
     * <code>DescribeStream</code> or the <code>ListStreams</code> API.
     * </p>
     * 
     * @return The version of the stream whose retention period you want to change. To get the version, call either the
     *         <code>DescribeStream</code> or the <code>ListStreams</code> API.
     */
    public String currentVersion() {
        return currentVersion;
    }

    /**
     * <p>
     * Indicates whether you want to increase or decrease the retention period.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #operation} will
     * return {@link UpdateDataRetentionOperation#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #operationAsString}.
     * </p>
     * 
     * @return Indicates whether you want to increase or decrease the retention period.
     * @see UpdateDataRetentionOperation
     */
    public UpdateDataRetentionOperation operation() {
        return UpdateDataRetentionOperation.fromValue(operation);
    }

    /**
     * <p>
     * Indicates whether you want to increase or decrease the retention period.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #operation} will
     * return {@link UpdateDataRetentionOperation#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #operationAsString}.
     * </p>
     * 
     * @return Indicates whether you want to increase or decrease the retention period.
     * @see UpdateDataRetentionOperation
     */
    public String operationAsString() {
        return operation;
    }

    /**
     * <p>
     * The retention period, in hours. The value you specify replaces the current value.
     * </p>
     * 
     * @return The retention period, in hours. The value you specify replaces the current value.
     */
    public Integer dataRetentionChangeInHours() {
        return dataRetentionChangeInHours;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(streamName());
        hashCode = 31 * hashCode + Objects.hashCode(streamARN());
        hashCode = 31 * hashCode + Objects.hashCode(currentVersion());
        hashCode = 31 * hashCode + Objects.hashCode(operationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(dataRetentionChangeInHours());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDataRetentionRequest)) {
            return false;
        }
        UpdateDataRetentionRequest other = (UpdateDataRetentionRequest) obj;
        return Objects.equals(streamName(), other.streamName()) && Objects.equals(streamARN(), other.streamARN())
                && Objects.equals(currentVersion(), other.currentVersion())
                && Objects.equals(operationAsString(), other.operationAsString())
                && Objects.equals(dataRetentionChangeInHours(), other.dataRetentionChangeInHours());
    }

    @Override
    public String toString() {
        return ToString.builder("UpdateDataRetentionRequest").add("StreamName", streamName()).add("StreamARN", streamARN())
                .add("CurrentVersion", currentVersion()).add("Operation", operationAsString())
                .add("DataRetentionChangeInHours", dataRetentionChangeInHours()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StreamName":
            return Optional.ofNullable(clazz.cast(streamName()));
        case "StreamARN":
            return Optional.ofNullable(clazz.cast(streamARN()));
        case "CurrentVersion":
            return Optional.ofNullable(clazz.cast(currentVersion()));
        case "Operation":
            return Optional.ofNullable(clazz.cast(operationAsString()));
        case "DataRetentionChangeInHours":
            return Optional.ofNullable(clazz.cast(dataRetentionChangeInHours()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateDataRetentionRequest, T> g) {
        return obj -> g.apply((UpdateDataRetentionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends KinesisVideoRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateDataRetentionRequest> {
        /**
         * <p>
         * The name of the stream whose retention period you want to change.
         * </p>
         * 
         * @param streamName
         *        The name of the stream whose retention period you want to change.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamName(String streamName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the stream whose retention period you want to change.
         * </p>
         * 
         * @param streamARN
         *        The Amazon Resource Name (ARN) of the stream whose retention period you want to change.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamARN(String streamARN);

        /**
         * <p>
         * The version of the stream whose retention period you want to change. To get the version, call either the
         * <code>DescribeStream</code> or the <code>ListStreams</code> API.
         * </p>
         * 
         * @param currentVersion
         *        The version of the stream whose retention period you want to change. To get the version, call either
         *        the <code>DescribeStream</code> or the <code>ListStreams</code> API.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currentVersion(String currentVersion);

        /**
         * <p>
         * Indicates whether you want to increase or decrease the retention period.
         * </p>
         * 
         * @param operation
         *        Indicates whether you want to increase or decrease the retention period.
         * @see UpdateDataRetentionOperation
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UpdateDataRetentionOperation
         */
        Builder operation(String operation);

        /**
         * <p>
         * Indicates whether you want to increase or decrease the retention period.
         * </p>
         * 
         * @param operation
         *        Indicates whether you want to increase or decrease the retention period.
         * @see UpdateDataRetentionOperation
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UpdateDataRetentionOperation
         */
        Builder operation(UpdateDataRetentionOperation operation);

        /**
         * <p>
         * The retention period, in hours. The value you specify replaces the current value.
         * </p>
         * 
         * @param dataRetentionChangeInHours
         *        The retention period, in hours. The value you specify replaces the current value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataRetentionChangeInHours(Integer dataRetentionChangeInHours);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends KinesisVideoRequest.BuilderImpl implements Builder {
        private String streamName;

        private String streamARN;

        private String currentVersion;

        private String operation;

        private Integer dataRetentionChangeInHours;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateDataRetentionRequest model) {
            super(model);
            streamName(model.streamName);
            streamARN(model.streamARN);
            currentVersion(model.currentVersion);
            operation(model.operation);
            dataRetentionChangeInHours(model.dataRetentionChangeInHours);
        }

        public final String getStreamName() {
            return streamName;
        }

        @Override
        public final Builder streamName(String streamName) {
            this.streamName = streamName;
            return this;
        }

        public final void setStreamName(String streamName) {
            this.streamName = streamName;
        }

        public final String getStreamARN() {
            return streamARN;
        }

        @Override
        public final Builder streamARN(String streamARN) {
            this.streamARN = streamARN;
            return this;
        }

        public final void setStreamARN(String streamARN) {
            this.streamARN = streamARN;
        }

        public final String getCurrentVersion() {
            return currentVersion;
        }

        @Override
        public final Builder currentVersion(String currentVersion) {
            this.currentVersion = currentVersion;
            return this;
        }

        public final void setCurrentVersion(String currentVersion) {
            this.currentVersion = currentVersion;
        }

        public final String getOperationAsString() {
            return operation;
        }

        @Override
        public final Builder operation(String operation) {
            this.operation = operation;
            return this;
        }

        @Override
        public final Builder operation(UpdateDataRetentionOperation operation) {
            this.operation(operation.toString());
            return this;
        }

        public final void setOperation(String operation) {
            this.operation = operation;
        }

        public final Integer getDataRetentionChangeInHours() {
            return dataRetentionChangeInHours;
        }

        @Override
        public final Builder dataRetentionChangeInHours(Integer dataRetentionChangeInHours) {
            this.dataRetentionChangeInHours = dataRetentionChangeInHours;
            return this;
        }

        public final void setDataRetentionChangeInHours(Integer dataRetentionChangeInHours) {
            this.dataRetentionChangeInHours = dataRetentionChangeInHours;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateDataRetentionRequest build() {
            return new UpdateDataRetentionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
