/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisvideo.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A description of the stream's edge configuration that will be used to sync with the Edge Agent IoT Greengrass
 * component. The Edge Agent component will run on an IoT Hub Device setup at your premise.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EdgeConfig implements SdkPojo, Serializable, ToCopyableBuilder<EdgeConfig.Builder, EdgeConfig> {
    private static final SdkField<String> HUB_DEVICE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HubDeviceArn").getter(getter(EdgeConfig::hubDeviceArn)).setter(setter(Builder::hubDeviceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HubDeviceArn").build()).build();

    private static final SdkField<RecorderConfig> RECORDER_CONFIG_FIELD = SdkField
            .<RecorderConfig> builder(MarshallingType.SDK_POJO).memberName("RecorderConfig")
            .getter(getter(EdgeConfig::recorderConfig)).setter(setter(Builder::recorderConfig))
            .constructor(RecorderConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecorderConfig").build()).build();

    private static final SdkField<UploaderConfig> UPLOADER_CONFIG_FIELD = SdkField
            .<UploaderConfig> builder(MarshallingType.SDK_POJO).memberName("UploaderConfig")
            .getter(getter(EdgeConfig::uploaderConfig)).setter(setter(Builder::uploaderConfig))
            .constructor(UploaderConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UploaderConfig").build()).build();

    private static final SdkField<DeletionConfig> DELETION_CONFIG_FIELD = SdkField
            .<DeletionConfig> builder(MarshallingType.SDK_POJO).memberName("DeletionConfig")
            .getter(getter(EdgeConfig::deletionConfig)).setter(setter(Builder::deletionConfig))
            .constructor(DeletionConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeletionConfig").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HUB_DEVICE_ARN_FIELD,
            RECORDER_CONFIG_FIELD, UPLOADER_CONFIG_FIELD, DELETION_CONFIG_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String hubDeviceArn;

    private final RecorderConfig recorderConfig;

    private final UploaderConfig uploaderConfig;

    private final DeletionConfig deletionConfig;

    private EdgeConfig(BuilderImpl builder) {
        this.hubDeviceArn = builder.hubDeviceArn;
        this.recorderConfig = builder.recorderConfig;
        this.uploaderConfig = builder.uploaderConfig;
        this.deletionConfig = builder.deletionConfig;
    }

    /**
     * <p>
     * The "<b>Internet of Things (IoT) Thing</b>" Arn of the stream.
     * </p>
     * 
     * @return The "<b>Internet of Things (IoT) Thing</b>" Arn of the stream.
     */
    public final String hubDeviceArn() {
        return hubDeviceArn;
    }

    /**
     * <p>
     * The recorder configuration consists of the local <code>MediaSourceConfig</code> details, that are used as
     * credentials to access the local media files streamed on the camera.
     * </p>
     * 
     * @return The recorder configuration consists of the local <code>MediaSourceConfig</code> details, that are used as
     *         credentials to access the local media files streamed on the camera.
     */
    public final RecorderConfig recorderConfig() {
        return recorderConfig;
    }

    /**
     * <p>
     * The uploader configuration contains the <code>ScheduleExpression</code> details that are used to schedule upload
     * jobs for the recorded media files from the Edge Agent to a Kinesis Video Stream.
     * </p>
     * 
     * @return The uploader configuration contains the <code>ScheduleExpression</code> details that are used to schedule
     *         upload jobs for the recorded media files from the Edge Agent to a Kinesis Video Stream.
     */
    public final UploaderConfig uploaderConfig() {
        return uploaderConfig;
    }

    /**
     * <p>
     * The deletion configuration is made up of the retention time (<code>EdgeRetentionInHours</code>) and local size
     * configuration (<code>LocalSizeConfig</code>) details that are used to make the deletion.
     * </p>
     * 
     * @return The deletion configuration is made up of the retention time (<code>EdgeRetentionInHours</code>) and local
     *         size configuration (<code>LocalSizeConfig</code>) details that are used to make the deletion.
     */
    public final DeletionConfig deletionConfig() {
        return deletionConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hubDeviceArn());
        hashCode = 31 * hashCode + Objects.hashCode(recorderConfig());
        hashCode = 31 * hashCode + Objects.hashCode(uploaderConfig());
        hashCode = 31 * hashCode + Objects.hashCode(deletionConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EdgeConfig)) {
            return false;
        }
        EdgeConfig other = (EdgeConfig) obj;
        return Objects.equals(hubDeviceArn(), other.hubDeviceArn()) && Objects.equals(recorderConfig(), other.recorderConfig())
                && Objects.equals(uploaderConfig(), other.uploaderConfig())
                && Objects.equals(deletionConfig(), other.deletionConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EdgeConfig").add("HubDeviceArn", hubDeviceArn()).add("RecorderConfig", recorderConfig())
                .add("UploaderConfig", uploaderConfig()).add("DeletionConfig", deletionConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "HubDeviceArn":
            return Optional.ofNullable(clazz.cast(hubDeviceArn()));
        case "RecorderConfig":
            return Optional.ofNullable(clazz.cast(recorderConfig()));
        case "UploaderConfig":
            return Optional.ofNullable(clazz.cast(uploaderConfig()));
        case "DeletionConfig":
            return Optional.ofNullable(clazz.cast(deletionConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("HubDeviceArn", HUB_DEVICE_ARN_FIELD);
        map.put("RecorderConfig", RECORDER_CONFIG_FIELD);
        map.put("UploaderConfig", UPLOADER_CONFIG_FIELD);
        map.put("DeletionConfig", DELETION_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EdgeConfig, T> g) {
        return obj -> g.apply((EdgeConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EdgeConfig> {
        /**
         * <p>
         * The "<b>Internet of Things (IoT) Thing</b>" Arn of the stream.
         * </p>
         * 
         * @param hubDeviceArn
         *        The "<b>Internet of Things (IoT) Thing</b>" Arn of the stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hubDeviceArn(String hubDeviceArn);

        /**
         * <p>
         * The recorder configuration consists of the local <code>MediaSourceConfig</code> details, that are used as
         * credentials to access the local media files streamed on the camera.
         * </p>
         * 
         * @param recorderConfig
         *        The recorder configuration consists of the local <code>MediaSourceConfig</code> details, that are used
         *        as credentials to access the local media files streamed on the camera.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recorderConfig(RecorderConfig recorderConfig);

        /**
         * <p>
         * The recorder configuration consists of the local <code>MediaSourceConfig</code> details, that are used as
         * credentials to access the local media files streamed on the camera.
         * </p>
         * This is a convenience method that creates an instance of the {@link RecorderConfig.Builder} avoiding the need
         * to create one manually via {@link RecorderConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RecorderConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #recorderConfig(RecorderConfig)}.
         * 
         * @param recorderConfig
         *        a consumer that will call methods on {@link RecorderConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #recorderConfig(RecorderConfig)
         */
        default Builder recorderConfig(Consumer<RecorderConfig.Builder> recorderConfig) {
            return recorderConfig(RecorderConfig.builder().applyMutation(recorderConfig).build());
        }

        /**
         * <p>
         * The uploader configuration contains the <code>ScheduleExpression</code> details that are used to schedule
         * upload jobs for the recorded media files from the Edge Agent to a Kinesis Video Stream.
         * </p>
         * 
         * @param uploaderConfig
         *        The uploader configuration contains the <code>ScheduleExpression</code> details that are used to
         *        schedule upload jobs for the recorded media files from the Edge Agent to a Kinesis Video Stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder uploaderConfig(UploaderConfig uploaderConfig);

        /**
         * <p>
         * The uploader configuration contains the <code>ScheduleExpression</code> details that are used to schedule
         * upload jobs for the recorded media files from the Edge Agent to a Kinesis Video Stream.
         * </p>
         * This is a convenience method that creates an instance of the {@link UploaderConfig.Builder} avoiding the need
         * to create one manually via {@link UploaderConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UploaderConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #uploaderConfig(UploaderConfig)}.
         * 
         * @param uploaderConfig
         *        a consumer that will call methods on {@link UploaderConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #uploaderConfig(UploaderConfig)
         */
        default Builder uploaderConfig(Consumer<UploaderConfig.Builder> uploaderConfig) {
            return uploaderConfig(UploaderConfig.builder().applyMutation(uploaderConfig).build());
        }

        /**
         * <p>
         * The deletion configuration is made up of the retention time (<code>EdgeRetentionInHours</code>) and local
         * size configuration (<code>LocalSizeConfig</code>) details that are used to make the deletion.
         * </p>
         * 
         * @param deletionConfig
         *        The deletion configuration is made up of the retention time (<code>EdgeRetentionInHours</code>) and
         *        local size configuration (<code>LocalSizeConfig</code>) details that are used to make the deletion.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deletionConfig(DeletionConfig deletionConfig);

        /**
         * <p>
         * The deletion configuration is made up of the retention time (<code>EdgeRetentionInHours</code>) and local
         * size configuration (<code>LocalSizeConfig</code>) details that are used to make the deletion.
         * </p>
         * This is a convenience method that creates an instance of the {@link DeletionConfig.Builder} avoiding the need
         * to create one manually via {@link DeletionConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DeletionConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #deletionConfig(DeletionConfig)}.
         * 
         * @param deletionConfig
         *        a consumer that will call methods on {@link DeletionConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #deletionConfig(DeletionConfig)
         */
        default Builder deletionConfig(Consumer<DeletionConfig.Builder> deletionConfig) {
            return deletionConfig(DeletionConfig.builder().applyMutation(deletionConfig).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String hubDeviceArn;

        private RecorderConfig recorderConfig;

        private UploaderConfig uploaderConfig;

        private DeletionConfig deletionConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(EdgeConfig model) {
            hubDeviceArn(model.hubDeviceArn);
            recorderConfig(model.recorderConfig);
            uploaderConfig(model.uploaderConfig);
            deletionConfig(model.deletionConfig);
        }

        public final String getHubDeviceArn() {
            return hubDeviceArn;
        }

        public final void setHubDeviceArn(String hubDeviceArn) {
            this.hubDeviceArn = hubDeviceArn;
        }

        @Override
        public final Builder hubDeviceArn(String hubDeviceArn) {
            this.hubDeviceArn = hubDeviceArn;
            return this;
        }

        public final RecorderConfig.Builder getRecorderConfig() {
            return recorderConfig != null ? recorderConfig.toBuilder() : null;
        }

        public final void setRecorderConfig(RecorderConfig.BuilderImpl recorderConfig) {
            this.recorderConfig = recorderConfig != null ? recorderConfig.build() : null;
        }

        @Override
        public final Builder recorderConfig(RecorderConfig recorderConfig) {
            this.recorderConfig = recorderConfig;
            return this;
        }

        public final UploaderConfig.Builder getUploaderConfig() {
            return uploaderConfig != null ? uploaderConfig.toBuilder() : null;
        }

        public final void setUploaderConfig(UploaderConfig.BuilderImpl uploaderConfig) {
            this.uploaderConfig = uploaderConfig != null ? uploaderConfig.build() : null;
        }

        @Override
        public final Builder uploaderConfig(UploaderConfig uploaderConfig) {
            this.uploaderConfig = uploaderConfig;
            return this;
        }

        public final DeletionConfig.Builder getDeletionConfig() {
            return deletionConfig != null ? deletionConfig.toBuilder() : null;
        }

        public final void setDeletionConfig(DeletionConfig.BuilderImpl deletionConfig) {
            this.deletionConfig = deletionConfig != null ? deletionConfig.build() : null;
        }

        @Override
        public final Builder deletionConfig(DeletionConfig deletionConfig) {
            this.deletionConfig = deletionConfig;
            return this;
        }

        @Override
        public EdgeConfig build() {
            return new EdgeConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
