/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisvideo.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListEdgeAgentConfigurationsResponse extends KinesisVideoResponse implements
        ToCopyableBuilder<ListEdgeAgentConfigurationsResponse.Builder, ListEdgeAgentConfigurationsResponse> {
    private static final SdkField<List<ListEdgeAgentConfigurationsEdgeConfig>> EDGE_CONFIGS_FIELD = SdkField
            .<List<ListEdgeAgentConfigurationsEdgeConfig>> builder(MarshallingType.LIST)
            .memberName("EdgeConfigs")
            .getter(getter(ListEdgeAgentConfigurationsResponse::edgeConfigs))
            .setter(setter(Builder::edgeConfigs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EdgeConfigs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ListEdgeAgentConfigurationsEdgeConfig> builder(MarshallingType.SDK_POJO)
                                            .constructor(ListEdgeAgentConfigurationsEdgeConfig::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListEdgeAgentConfigurationsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EDGE_CONFIGS_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<ListEdgeAgentConfigurationsEdgeConfig> edgeConfigs;

    private final String nextToken;

    private ListEdgeAgentConfigurationsResponse(BuilderImpl builder) {
        super(builder);
        this.edgeConfigs = builder.edgeConfigs;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the EdgeConfigs property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasEdgeConfigs() {
        return edgeConfigs != null && !(edgeConfigs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A description of a single stream's edge configuration.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEdgeConfigs} method.
     * </p>
     * 
     * @return A description of a single stream's edge configuration.
     */
    public final List<ListEdgeAgentConfigurationsEdgeConfig> edgeConfigs() {
        return edgeConfigs;
    }

    /**
     * <p>
     * If the response is truncated, the call returns this element with a given token. To get the next batch of edge
     * configurations, use this token in your next request.
     * </p>
     * 
     * @return If the response is truncated, the call returns this element with a given token. To get the next batch of
     *         edge configurations, use this token in your next request.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasEdgeConfigs() ? edgeConfigs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListEdgeAgentConfigurationsResponse)) {
            return false;
        }
        ListEdgeAgentConfigurationsResponse other = (ListEdgeAgentConfigurationsResponse) obj;
        return hasEdgeConfigs() == other.hasEdgeConfigs() && Objects.equals(edgeConfigs(), other.edgeConfigs())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListEdgeAgentConfigurationsResponse")
                .add("EdgeConfigs", hasEdgeConfigs() ? edgeConfigs() : null).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EdgeConfigs":
            return Optional.ofNullable(clazz.cast(edgeConfigs()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("EdgeConfigs", EDGE_CONFIGS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListEdgeAgentConfigurationsResponse, T> g) {
        return obj -> g.apply((ListEdgeAgentConfigurationsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends KinesisVideoResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListEdgeAgentConfigurationsResponse> {
        /**
         * <p>
         * A description of a single stream's edge configuration.
         * </p>
         * 
         * @param edgeConfigs
         *        A description of a single stream's edge configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder edgeConfigs(Collection<ListEdgeAgentConfigurationsEdgeConfig> edgeConfigs);

        /**
         * <p>
         * A description of a single stream's edge configuration.
         * </p>
         * 
         * @param edgeConfigs
         *        A description of a single stream's edge configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder edgeConfigs(ListEdgeAgentConfigurationsEdgeConfig... edgeConfigs);

        /**
         * <p>
         * A description of a single stream's edge configuration.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.kinesisvideo.model.ListEdgeAgentConfigurationsEdgeConfig.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.kinesisvideo.model.ListEdgeAgentConfigurationsEdgeConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.kinesisvideo.model.ListEdgeAgentConfigurationsEdgeConfig.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #edgeConfigs(List<ListEdgeAgentConfigurationsEdgeConfig>)}.
         * 
         * @param edgeConfigs
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.kinesisvideo.model.ListEdgeAgentConfigurationsEdgeConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #edgeConfigs(java.util.Collection<ListEdgeAgentConfigurationsEdgeConfig>)
         */
        Builder edgeConfigs(Consumer<ListEdgeAgentConfigurationsEdgeConfig.Builder>... edgeConfigs);

        /**
         * <p>
         * If the response is truncated, the call returns this element with a given token. To get the next batch of edge
         * configurations, use this token in your next request.
         * </p>
         * 
         * @param nextToken
         *        If the response is truncated, the call returns this element with a given token. To get the next batch
         *        of edge configurations, use this token in your next request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends KinesisVideoResponse.BuilderImpl implements Builder {
        private List<ListEdgeAgentConfigurationsEdgeConfig> edgeConfigs = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListEdgeAgentConfigurationsResponse model) {
            super(model);
            edgeConfigs(model.edgeConfigs);
            nextToken(model.nextToken);
        }

        public final List<ListEdgeAgentConfigurationsEdgeConfig.Builder> getEdgeConfigs() {
            List<ListEdgeAgentConfigurationsEdgeConfig.Builder> result = ListEdgeAgentConfigurationsEdgeConfigListCopier
                    .copyToBuilder(this.edgeConfigs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEdgeConfigs(Collection<ListEdgeAgentConfigurationsEdgeConfig.BuilderImpl> edgeConfigs) {
            this.edgeConfigs = ListEdgeAgentConfigurationsEdgeConfigListCopier.copyFromBuilder(edgeConfigs);
        }

        @Override
        public final Builder edgeConfigs(Collection<ListEdgeAgentConfigurationsEdgeConfig> edgeConfigs) {
            this.edgeConfigs = ListEdgeAgentConfigurationsEdgeConfigListCopier.copy(edgeConfigs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder edgeConfigs(ListEdgeAgentConfigurationsEdgeConfig... edgeConfigs) {
            edgeConfigs(Arrays.asList(edgeConfigs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder edgeConfigs(Consumer<ListEdgeAgentConfigurationsEdgeConfig.Builder>... edgeConfigs) {
            edgeConfigs(Stream.of(edgeConfigs).map(c -> ListEdgeAgentConfigurationsEdgeConfig.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListEdgeAgentConfigurationsResponse build() {
            return new ListEdgeAgentConfigurationsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
