/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisvideo.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartEdgeConfigurationUpdateRequest extends KinesisVideoRequest implements
        ToCopyableBuilder<StartEdgeConfigurationUpdateRequest.Builder, StartEdgeConfigurationUpdateRequest> {
    private static final SdkField<String> STREAM_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StreamName").getter(getter(StartEdgeConfigurationUpdateRequest::streamName))
            .setter(setter(Builder::streamName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamName").build()).build();

    private static final SdkField<String> STREAM_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StreamARN").getter(getter(StartEdgeConfigurationUpdateRequest::streamARN))
            .setter(setter(Builder::streamARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamARN").build()).build();

    private static final SdkField<EdgeConfig> EDGE_CONFIG_FIELD = SdkField.<EdgeConfig> builder(MarshallingType.SDK_POJO)
            .memberName("EdgeConfig").getter(getter(StartEdgeConfigurationUpdateRequest::edgeConfig))
            .setter(setter(Builder::edgeConfig)).constructor(EdgeConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EdgeConfig").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STREAM_NAME_FIELD,
            STREAM_ARN_FIELD, EDGE_CONFIG_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String streamName;

    private final String streamARN;

    private final EdgeConfig edgeConfig;

    private StartEdgeConfigurationUpdateRequest(BuilderImpl builder) {
        super(builder);
        this.streamName = builder.streamName;
        this.streamARN = builder.streamARN;
        this.edgeConfig = builder.edgeConfig;
    }

    /**
     * <p>
     * The name of the stream whose edge configuration you want to update. Specify either the <code>StreamName</code> or
     * the <code>StreamARN</code>.
     * </p>
     * 
     * @return The name of the stream whose edge configuration you want to update. Specify either the
     *         <code>StreamName</code> or the <code>StreamARN</code>.
     */
    public final String streamName() {
        return streamName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the stream. Specify either the <code>StreamName</code> or the
     * <code>StreamARN</code>.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the stream. Specify either the <code>StreamName</code> or the
     *         <code>StreamARN</code>.
     */
    public final String streamARN() {
        return streamARN;
    }

    /**
     * <p>
     * The edge configuration details required to invoke the update process.
     * </p>
     * 
     * @return The edge configuration details required to invoke the update process.
     */
    public final EdgeConfig edgeConfig() {
        return edgeConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(streamName());
        hashCode = 31 * hashCode + Objects.hashCode(streamARN());
        hashCode = 31 * hashCode + Objects.hashCode(edgeConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartEdgeConfigurationUpdateRequest)) {
            return false;
        }
        StartEdgeConfigurationUpdateRequest other = (StartEdgeConfigurationUpdateRequest) obj;
        return Objects.equals(streamName(), other.streamName()) && Objects.equals(streamARN(), other.streamARN())
                && Objects.equals(edgeConfig(), other.edgeConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartEdgeConfigurationUpdateRequest").add("StreamName", streamName())
                .add("StreamARN", streamARN()).add("EdgeConfig", edgeConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StreamName":
            return Optional.ofNullable(clazz.cast(streamName()));
        case "StreamARN":
            return Optional.ofNullable(clazz.cast(streamARN()));
        case "EdgeConfig":
            return Optional.ofNullable(clazz.cast(edgeConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("StreamName", STREAM_NAME_FIELD);
        map.put("StreamARN", STREAM_ARN_FIELD);
        map.put("EdgeConfig", EDGE_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartEdgeConfigurationUpdateRequest, T> g) {
        return obj -> g.apply((StartEdgeConfigurationUpdateRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends KinesisVideoRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, StartEdgeConfigurationUpdateRequest> {
        /**
         * <p>
         * The name of the stream whose edge configuration you want to update. Specify either the
         * <code>StreamName</code> or the <code>StreamARN</code>.
         * </p>
         * 
         * @param streamName
         *        The name of the stream whose edge configuration you want to update. Specify either the
         *        <code>StreamName</code> or the <code>StreamARN</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamName(String streamName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the stream. Specify either the <code>StreamName</code> or the
         * <code>StreamARN</code>.
         * </p>
         * 
         * @param streamARN
         *        The Amazon Resource Name (ARN) of the stream. Specify either the <code>StreamName</code> or the
         *        <code>StreamARN</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamARN(String streamARN);

        /**
         * <p>
         * The edge configuration details required to invoke the update process.
         * </p>
         * 
         * @param edgeConfig
         *        The edge configuration details required to invoke the update process.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder edgeConfig(EdgeConfig edgeConfig);

        /**
         * <p>
         * The edge configuration details required to invoke the update process.
         * </p>
         * This is a convenience method that creates an instance of the {@link EdgeConfig.Builder} avoiding the need to
         * create one manually via {@link EdgeConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EdgeConfig.Builder#build()} is called immediately and its result
         * is passed to {@link #edgeConfig(EdgeConfig)}.
         * 
         * @param edgeConfig
         *        a consumer that will call methods on {@link EdgeConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #edgeConfig(EdgeConfig)
         */
        default Builder edgeConfig(Consumer<EdgeConfig.Builder> edgeConfig) {
            return edgeConfig(EdgeConfig.builder().applyMutation(edgeConfig).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends KinesisVideoRequest.BuilderImpl implements Builder {
        private String streamName;

        private String streamARN;

        private EdgeConfig edgeConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(StartEdgeConfigurationUpdateRequest model) {
            super(model);
            streamName(model.streamName);
            streamARN(model.streamARN);
            edgeConfig(model.edgeConfig);
        }

        public final String getStreamName() {
            return streamName;
        }

        public final void setStreamName(String streamName) {
            this.streamName = streamName;
        }

        @Override
        public final Builder streamName(String streamName) {
            this.streamName = streamName;
            return this;
        }

        public final String getStreamARN() {
            return streamARN;
        }

        public final void setStreamARN(String streamARN) {
            this.streamARN = streamARN;
        }

        @Override
        public final Builder streamARN(String streamARN) {
            this.streamARN = streamARN;
            return this;
        }

        public final EdgeConfig.Builder getEdgeConfig() {
            return edgeConfig != null ? edgeConfig.toBuilder() : null;
        }

        public final void setEdgeConfig(EdgeConfig.BuilderImpl edgeConfig) {
            this.edgeConfig = edgeConfig != null ? edgeConfig.build() : null;
        }

        @Override
        public final Builder edgeConfig(EdgeConfig edgeConfig) {
            this.edgeConfig = edgeConfig;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartEdgeConfigurationUpdateRequest build() {
            return new StartEdgeConfigurationUpdateRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
