/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisvideo.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListSignalingChannelsResponse extends KinesisVideoResponse implements
        ToCopyableBuilder<ListSignalingChannelsResponse.Builder, ListSignalingChannelsResponse> {
    private static final SdkField<List<ChannelInfo>> CHANNEL_INFO_LIST_FIELD = SdkField
            .<List<ChannelInfo>> builder(MarshallingType.LIST)
            .memberName("ChannelInfoList")
            .getter(getter(ListSignalingChannelsResponse::channelInfoList))
            .setter(setter(Builder::channelInfoList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChannelInfoList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ChannelInfo> builder(MarshallingType.SDK_POJO)
                                            .constructor(ChannelInfo::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListSignalingChannelsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANNEL_INFO_LIST_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<ChannelInfo> channelInfoList;

    private final String nextToken;

    private ListSignalingChannelsResponse(BuilderImpl builder) {
        super(builder);
        this.channelInfoList = builder.channelInfoList;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the ChannelInfoList property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasChannelInfoList() {
        return channelInfoList != null && !(channelInfoList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of <code>ChannelInfo</code> objects.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasChannelInfoList} method.
     * </p>
     * 
     * @return An array of <code>ChannelInfo</code> objects.
     */
    public final List<ChannelInfo> channelInfoList() {
        return channelInfoList;
    }

    /**
     * <p>
     * If the response is truncated, the call returns this element with a token. To get the next batch of streams, use
     * this token in your next request.
     * </p>
     * 
     * @return If the response is truncated, the call returns this element with a token. To get the next batch of
     *         streams, use this token in your next request.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasChannelInfoList() ? channelInfoList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSignalingChannelsResponse)) {
            return false;
        }
        ListSignalingChannelsResponse other = (ListSignalingChannelsResponse) obj;
        return hasChannelInfoList() == other.hasChannelInfoList() && Objects.equals(channelInfoList(), other.channelInfoList())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListSignalingChannelsResponse")
                .add("ChannelInfoList", hasChannelInfoList() ? channelInfoList() : null).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ChannelInfoList":
            return Optional.ofNullable(clazz.cast(channelInfoList()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ChannelInfoList", CHANNEL_INFO_LIST_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListSignalingChannelsResponse, T> g) {
        return obj -> g.apply((ListSignalingChannelsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends KinesisVideoResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListSignalingChannelsResponse> {
        /**
         * <p>
         * An array of <code>ChannelInfo</code> objects.
         * </p>
         * 
         * @param channelInfoList
         *        An array of <code>ChannelInfo</code> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channelInfoList(Collection<ChannelInfo> channelInfoList);

        /**
         * <p>
         * An array of <code>ChannelInfo</code> objects.
         * </p>
         * 
         * @param channelInfoList
         *        An array of <code>ChannelInfo</code> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channelInfoList(ChannelInfo... channelInfoList);

        /**
         * <p>
         * An array of <code>ChannelInfo</code> objects.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.kinesisvideo.model.ChannelInfo.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.kinesisvideo.model.ChannelInfo#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.kinesisvideo.model.ChannelInfo.Builder#build()} is called immediately
         * and its result is passed to {@link #channelInfoList(List<ChannelInfo>)}.
         * 
         * @param channelInfoList
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.kinesisvideo.model.ChannelInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #channelInfoList(java.util.Collection<ChannelInfo>)
         */
        Builder channelInfoList(Consumer<ChannelInfo.Builder>... channelInfoList);

        /**
         * <p>
         * If the response is truncated, the call returns this element with a token. To get the next batch of streams,
         * use this token in your next request.
         * </p>
         * 
         * @param nextToken
         *        If the response is truncated, the call returns this element with a token. To get the next batch of
         *        streams, use this token in your next request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends KinesisVideoResponse.BuilderImpl implements Builder {
        private List<ChannelInfo> channelInfoList = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListSignalingChannelsResponse model) {
            super(model);
            channelInfoList(model.channelInfoList);
            nextToken(model.nextToken);
        }

        public final List<ChannelInfo.Builder> getChannelInfoList() {
            List<ChannelInfo.Builder> result = ChannelInfoListCopier.copyToBuilder(this.channelInfoList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setChannelInfoList(Collection<ChannelInfo.BuilderImpl> channelInfoList) {
            this.channelInfoList = ChannelInfoListCopier.copyFromBuilder(channelInfoList);
        }

        @Override
        public final Builder channelInfoList(Collection<ChannelInfo> channelInfoList) {
            this.channelInfoList = ChannelInfoListCopier.copy(channelInfoList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder channelInfoList(ChannelInfo... channelInfoList) {
            channelInfoList(Arrays.asList(channelInfoList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder channelInfoList(Consumer<ChannelInfo.Builder>... channelInfoList) {
            channelInfoList(Stream.of(channelInfoList).map(c -> ChannelInfo.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListSignalingChannelsResponse build() {
            return new ListSignalingChannelsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
