/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisvideo.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration details that consist of the credentials required (<code>MediaUriSecretArn</code> and
 * <code>MediaUriType</code>) to access the media files that are streamed to the camera.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MediaSourceConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<MediaSourceConfig.Builder, MediaSourceConfig> {
    private static final SdkField<String> MEDIA_URI_SECRET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MediaUriSecretArn").getter(getter(MediaSourceConfig::mediaUriSecretArn))
            .setter(setter(Builder::mediaUriSecretArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MediaUriSecretArn").build()).build();

    private static final SdkField<String> MEDIA_URI_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MediaUriType").getter(getter(MediaSourceConfig::mediaUriTypeAsString))
            .setter(setter(Builder::mediaUriType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MediaUriType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MEDIA_URI_SECRET_ARN_FIELD,
            MEDIA_URI_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String mediaUriSecretArn;

    private final String mediaUriType;

    private MediaSourceConfig(BuilderImpl builder) {
        this.mediaUriSecretArn = builder.mediaUriSecretArn;
        this.mediaUriType = builder.mediaUriType;
    }

    /**
     * <p>
     * The Amazon Web Services Secrets Manager ARN for the username and password of the camera, or a local media file
     * location.
     * </p>
     * 
     * @return The Amazon Web Services Secrets Manager ARN for the username and password of the camera, or a local media
     *         file location.
     */
    public final String mediaUriSecretArn() {
        return mediaUriSecretArn;
    }

    /**
     * <p>
     * The Uniform Resource Identifier (URI) type. The <code>FILE_URI</code> value can be used to stream local media
     * files.
     * </p>
     * <note>
     * <p>
     * Preview only supports the <code>RTSP_URI</code> media source URI format .
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #mediaUriType} will
     * return {@link MediaUriType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #mediaUriTypeAsString}.
     * </p>
     * 
     * @return The Uniform Resource Identifier (URI) type. The <code>FILE_URI</code> value can be used to stream local
     *         media files.</p> <note>
     *         <p>
     *         Preview only supports the <code>RTSP_URI</code> media source URI format .
     *         </p>
     * @see MediaUriType
     */
    public final MediaUriType mediaUriType() {
        return MediaUriType.fromValue(mediaUriType);
    }

    /**
     * <p>
     * The Uniform Resource Identifier (URI) type. The <code>FILE_URI</code> value can be used to stream local media
     * files.
     * </p>
     * <note>
     * <p>
     * Preview only supports the <code>RTSP_URI</code> media source URI format .
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #mediaUriType} will
     * return {@link MediaUriType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #mediaUriTypeAsString}.
     * </p>
     * 
     * @return The Uniform Resource Identifier (URI) type. The <code>FILE_URI</code> value can be used to stream local
     *         media files.</p> <note>
     *         <p>
     *         Preview only supports the <code>RTSP_URI</code> media source URI format .
     *         </p>
     * @see MediaUriType
     */
    public final String mediaUriTypeAsString() {
        return mediaUriType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(mediaUriSecretArn());
        hashCode = 31 * hashCode + Objects.hashCode(mediaUriTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MediaSourceConfig)) {
            return false;
        }
        MediaSourceConfig other = (MediaSourceConfig) obj;
        return Objects.equals(mediaUriSecretArn(), other.mediaUriSecretArn())
                && Objects.equals(mediaUriTypeAsString(), other.mediaUriTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MediaSourceConfig")
                .add("MediaUriSecretArn", mediaUriSecretArn() == null ? null : "*** Sensitive Data Redacted ***")
                .add("MediaUriType", mediaUriTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MediaUriSecretArn":
            return Optional.ofNullable(clazz.cast(mediaUriSecretArn()));
        case "MediaUriType":
            return Optional.ofNullable(clazz.cast(mediaUriTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("MediaUriSecretArn", MEDIA_URI_SECRET_ARN_FIELD);
        map.put("MediaUriType", MEDIA_URI_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MediaSourceConfig, T> g) {
        return obj -> g.apply((MediaSourceConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MediaSourceConfig> {
        /**
         * <p>
         * The Amazon Web Services Secrets Manager ARN for the username and password of the camera, or a local media
         * file location.
         * </p>
         * 
         * @param mediaUriSecretArn
         *        The Amazon Web Services Secrets Manager ARN for the username and password of the camera, or a local
         *        media file location.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mediaUriSecretArn(String mediaUriSecretArn);

        /**
         * <p>
         * The Uniform Resource Identifier (URI) type. The <code>FILE_URI</code> value can be used to stream local media
         * files.
         * </p>
         * <note>
         * <p>
         * Preview only supports the <code>RTSP_URI</code> media source URI format .
         * </p>
         * </note>
         * 
         * @param mediaUriType
         *        The Uniform Resource Identifier (URI) type. The <code>FILE_URI</code> value can be used to stream
         *        local media files.</p> <note>
         *        <p>
         *        Preview only supports the <code>RTSP_URI</code> media source URI format .
         *        </p>
         * @see MediaUriType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MediaUriType
         */
        Builder mediaUriType(String mediaUriType);

        /**
         * <p>
         * The Uniform Resource Identifier (URI) type. The <code>FILE_URI</code> value can be used to stream local media
         * files.
         * </p>
         * <note>
         * <p>
         * Preview only supports the <code>RTSP_URI</code> media source URI format .
         * </p>
         * </note>
         * 
         * @param mediaUriType
         *        The Uniform Resource Identifier (URI) type. The <code>FILE_URI</code> value can be used to stream
         *        local media files.</p> <note>
         *        <p>
         *        Preview only supports the <code>RTSP_URI</code> media source URI format .
         *        </p>
         * @see MediaUriType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MediaUriType
         */
        Builder mediaUriType(MediaUriType mediaUriType);
    }

    static final class BuilderImpl implements Builder {
        private String mediaUriSecretArn;

        private String mediaUriType;

        private BuilderImpl() {
        }

        private BuilderImpl(MediaSourceConfig model) {
            mediaUriSecretArn(model.mediaUriSecretArn);
            mediaUriType(model.mediaUriType);
        }

        public final String getMediaUriSecretArn() {
            return mediaUriSecretArn;
        }

        public final void setMediaUriSecretArn(String mediaUriSecretArn) {
            this.mediaUriSecretArn = mediaUriSecretArn;
        }

        @Override
        public final Builder mediaUriSecretArn(String mediaUriSecretArn) {
            this.mediaUriSecretArn = mediaUriSecretArn;
            return this;
        }

        public final String getMediaUriType() {
            return mediaUriType;
        }

        public final void setMediaUriType(String mediaUriType) {
            this.mediaUriType = mediaUriType;
        }

        @Override
        public final Builder mediaUriType(String mediaUriType) {
            this.mediaUriType = mediaUriType;
            return this;
        }

        @Override
        public final Builder mediaUriType(MediaUriType mediaUriType) {
            this.mediaUriType(mediaUriType == null ? null : mediaUriType.toString());
            return this;
        }

        @Override
        public MediaSourceConfig build() {
            return new MediaSourceConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
