/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisvideo.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The structure that contains the notification information for the KVS images delivery. If this parameter is null, the
 * configuration will be deleted from the stream.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class NotificationConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<NotificationConfiguration.Builder, NotificationConfiguration> {
    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(NotificationConfiguration::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<NotificationDestinationConfig> DESTINATION_CONFIG_FIELD = SdkField
            .<NotificationDestinationConfig> builder(MarshallingType.SDK_POJO).memberName("DestinationConfig")
            .getter(getter(NotificationConfiguration::destinationConfig)).setter(setter(Builder::destinationConfig))
            .constructor(NotificationDestinationConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationConfig").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD,
            DESTINATION_CONFIG_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String status;

    private final NotificationDestinationConfig destinationConfig;

    private NotificationConfiguration(BuilderImpl builder) {
        this.status = builder.status;
        this.destinationConfig = builder.destinationConfig;
    }

    /**
     * <p>
     * Indicates if a notification configuration is enabled or disabled.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ConfigurationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return Indicates if a notification configuration is enabled or disabled.
     * @see ConfigurationStatus
     */
    public final ConfigurationStatus status() {
        return ConfigurationStatus.fromValue(status);
    }

    /**
     * <p>
     * Indicates if a notification configuration is enabled or disabled.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ConfigurationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return Indicates if a notification configuration is enabled or disabled.
     * @see ConfigurationStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The destination information required to deliver a notification to a customer.
     * </p>
     * 
     * @return The destination information required to deliver a notification to a customer.
     */
    public final NotificationDestinationConfig destinationConfig() {
        return destinationConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(destinationConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NotificationConfiguration)) {
            return false;
        }
        NotificationConfiguration other = (NotificationConfiguration) obj;
        return Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(destinationConfig(), other.destinationConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("NotificationConfiguration").add("Status", statusAsString())
                .add("DestinationConfig", destinationConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "DestinationConfig":
            return Optional.ofNullable(clazz.cast(destinationConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Status", STATUS_FIELD);
        map.put("DestinationConfig", DESTINATION_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<NotificationConfiguration, T> g) {
        return obj -> g.apply((NotificationConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, NotificationConfiguration> {
        /**
         * <p>
         * Indicates if a notification configuration is enabled or disabled.
         * </p>
         * 
         * @param status
         *        Indicates if a notification configuration is enabled or disabled.
         * @see ConfigurationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConfigurationStatus
         */
        Builder status(String status);

        /**
         * <p>
         * Indicates if a notification configuration is enabled or disabled.
         * </p>
         * 
         * @param status
         *        Indicates if a notification configuration is enabled or disabled.
         * @see ConfigurationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConfigurationStatus
         */
        Builder status(ConfigurationStatus status);

        /**
         * <p>
         * The destination information required to deliver a notification to a customer.
         * </p>
         * 
         * @param destinationConfig
         *        The destination information required to deliver a notification to a customer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationConfig(NotificationDestinationConfig destinationConfig);

        /**
         * <p>
         * The destination information required to deliver a notification to a customer.
         * </p>
         * This is a convenience method that creates an instance of the {@link NotificationDestinationConfig.Builder}
         * avoiding the need to create one manually via {@link NotificationDestinationConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link NotificationDestinationConfig.Builder#build()} is called
         * immediately and its result is passed to {@link #destinationConfig(NotificationDestinationConfig)}.
         * 
         * @param destinationConfig
         *        a consumer that will call methods on {@link NotificationDestinationConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #destinationConfig(NotificationDestinationConfig)
         */
        default Builder destinationConfig(Consumer<NotificationDestinationConfig.Builder> destinationConfig) {
            return destinationConfig(NotificationDestinationConfig.builder().applyMutation(destinationConfig).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String status;

        private NotificationDestinationConfig destinationConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(NotificationConfiguration model) {
            status(model.status);
            destinationConfig(model.destinationConfig);
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ConfigurationStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final NotificationDestinationConfig.Builder getDestinationConfig() {
            return destinationConfig != null ? destinationConfig.toBuilder() : null;
        }

        public final void setDestinationConfig(NotificationDestinationConfig.BuilderImpl destinationConfig) {
            this.destinationConfig = destinationConfig != null ? destinationConfig.build() : null;
        }

        @Override
        public final Builder destinationConfig(NotificationDestinationConfig destinationConfig) {
            this.destinationConfig = destinationConfig;
            return this;
        }

        @Override
        public NotificationConfiguration build() {
            return new NotificationConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
