/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisvideo.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object describing a Kinesis video stream.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StreamInfo implements SdkPojo, Serializable, ToCopyableBuilder<StreamInfo.Builder, StreamInfo> {
    private static final SdkField<String> DEVICE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DeviceName").getter(getter(StreamInfo::deviceName)).setter(setter(Builder::deviceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceName").build()).build();

    private static final SdkField<String> STREAM_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StreamName").getter(getter(StreamInfo::streamName)).setter(setter(Builder::streamName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamName").build()).build();

    private static final SdkField<String> STREAM_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StreamARN").getter(getter(StreamInfo::streamARN)).setter(setter(Builder::streamARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamARN").build()).build();

    private static final SdkField<String> MEDIA_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MediaType").getter(getter(StreamInfo::mediaType)).setter(setter(Builder::mediaType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MediaType").build()).build();

    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KmsKeyId").getter(getter(StreamInfo::kmsKeyId)).setter(setter(Builder::kmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()).build();

    private static final SdkField<String> VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Version")
            .getter(getter(StreamInfo::version)).setter(setter(Builder::version))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Version").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(StreamInfo::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime").getter(getter(StreamInfo::creationTime)).setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<Integer> DATA_RETENTION_IN_HOURS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("DataRetentionInHours").getter(getter(StreamInfo::dataRetentionInHours))
            .setter(setter(Builder::dataRetentionInHours))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataRetentionInHours").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEVICE_NAME_FIELD,
            STREAM_NAME_FIELD, STREAM_ARN_FIELD, MEDIA_TYPE_FIELD, KMS_KEY_ID_FIELD, VERSION_FIELD, STATUS_FIELD,
            CREATION_TIME_FIELD, DATA_RETENTION_IN_HOURS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String deviceName;

    private final String streamName;

    private final String streamARN;

    private final String mediaType;

    private final String kmsKeyId;

    private final String version;

    private final String status;

    private final Instant creationTime;

    private final Integer dataRetentionInHours;

    private StreamInfo(BuilderImpl builder) {
        this.deviceName = builder.deviceName;
        this.streamName = builder.streamName;
        this.streamARN = builder.streamARN;
        this.mediaType = builder.mediaType;
        this.kmsKeyId = builder.kmsKeyId;
        this.version = builder.version;
        this.status = builder.status;
        this.creationTime = builder.creationTime;
        this.dataRetentionInHours = builder.dataRetentionInHours;
    }

    /**
     * <p>
     * The name of the device that is associated with the stream.
     * </p>
     * 
     * @return The name of the device that is associated with the stream.
     */
    public final String deviceName() {
        return deviceName;
    }

    /**
     * <p>
     * The name of the stream.
     * </p>
     * 
     * @return The name of the stream.
     */
    public final String streamName() {
        return streamName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the stream.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the stream.
     */
    public final String streamARN() {
        return streamARN;
    }

    /**
     * <p>
     * The <code>MediaType</code> of the stream.
     * </p>
     * 
     * @return The <code>MediaType</code> of the stream.
     */
    public final String mediaType() {
        return mediaType;
    }

    /**
     * <p>
     * The ID of the Key Management Service (KMS) key that Kinesis Video Streams uses to encrypt data on the stream.
     * </p>
     * 
     * @return The ID of the Key Management Service (KMS) key that Kinesis Video Streams uses to encrypt data on the
     *         stream.
     */
    public final String kmsKeyId() {
        return kmsKeyId;
    }

    /**
     * <p>
     * The version of the stream.
     * </p>
     * 
     * @return The version of the stream.
     */
    public final String version() {
        return version;
    }

    /**
     * <p>
     * The status of the stream.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link Status#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the stream.
     * @see Status
     */
    public final Status status() {
        return Status.fromValue(status);
    }

    /**
     * <p>
     * The status of the stream.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link Status#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the stream.
     * @see Status
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * A time stamp that indicates when the stream was created.
     * </p>
     * 
     * @return A time stamp that indicates when the stream was created.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * How long the stream retains data, in hours.
     * </p>
     * 
     * @return How long the stream retains data, in hours.
     */
    public final Integer dataRetentionInHours() {
        return dataRetentionInHours;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(deviceName());
        hashCode = 31 * hashCode + Objects.hashCode(streamName());
        hashCode = 31 * hashCode + Objects.hashCode(streamARN());
        hashCode = 31 * hashCode + Objects.hashCode(mediaType());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(version());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(dataRetentionInHours());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StreamInfo)) {
            return false;
        }
        StreamInfo other = (StreamInfo) obj;
        return Objects.equals(deviceName(), other.deviceName()) && Objects.equals(streamName(), other.streamName())
                && Objects.equals(streamARN(), other.streamARN()) && Objects.equals(mediaType(), other.mediaType())
                && Objects.equals(kmsKeyId(), other.kmsKeyId()) && Objects.equals(version(), other.version())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(dataRetentionInHours(), other.dataRetentionInHours());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StreamInfo").add("DeviceName", deviceName()).add("StreamName", streamName())
                .add("StreamARN", streamARN()).add("MediaType", mediaType()).add("KmsKeyId", kmsKeyId())
                .add("Version", version()).add("Status", statusAsString()).add("CreationTime", creationTime())
                .add("DataRetentionInHours", dataRetentionInHours()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DeviceName":
            return Optional.ofNullable(clazz.cast(deviceName()));
        case "StreamName":
            return Optional.ofNullable(clazz.cast(streamName()));
        case "StreamARN":
            return Optional.ofNullable(clazz.cast(streamARN()));
        case "MediaType":
            return Optional.ofNullable(clazz.cast(mediaType()));
        case "KmsKeyId":
            return Optional.ofNullable(clazz.cast(kmsKeyId()));
        case "Version":
            return Optional.ofNullable(clazz.cast(version()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "DataRetentionInHours":
            return Optional.ofNullable(clazz.cast(dataRetentionInHours()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DeviceName", DEVICE_NAME_FIELD);
        map.put("StreamName", STREAM_NAME_FIELD);
        map.put("StreamARN", STREAM_ARN_FIELD);
        map.put("MediaType", MEDIA_TYPE_FIELD);
        map.put("KmsKeyId", KMS_KEY_ID_FIELD);
        map.put("Version", VERSION_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("CreationTime", CREATION_TIME_FIELD);
        map.put("DataRetentionInHours", DATA_RETENTION_IN_HOURS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StreamInfo, T> g) {
        return obj -> g.apply((StreamInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, StreamInfo> {
        /**
         * <p>
         * The name of the device that is associated with the stream.
         * </p>
         * 
         * @param deviceName
         *        The name of the device that is associated with the stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceName(String deviceName);

        /**
         * <p>
         * The name of the stream.
         * </p>
         * 
         * @param streamName
         *        The name of the stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamName(String streamName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the stream.
         * </p>
         * 
         * @param streamARN
         *        The Amazon Resource Name (ARN) of the stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamARN(String streamARN);

        /**
         * <p>
         * The <code>MediaType</code> of the stream.
         * </p>
         * 
         * @param mediaType
         *        The <code>MediaType</code> of the stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mediaType(String mediaType);

        /**
         * <p>
         * The ID of the Key Management Service (KMS) key that Kinesis Video Streams uses to encrypt data on the stream.
         * </p>
         * 
         * @param kmsKeyId
         *        The ID of the Key Management Service (KMS) key that Kinesis Video Streams uses to encrypt data on the
         *        stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyId(String kmsKeyId);

        /**
         * <p>
         * The version of the stream.
         * </p>
         * 
         * @param version
         *        The version of the stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder version(String version);

        /**
         * <p>
         * The status of the stream.
         * </p>
         * 
         * @param status
         *        The status of the stream.
         * @see Status
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Status
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the stream.
         * </p>
         * 
         * @param status
         *        The status of the stream.
         * @see Status
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Status
         */
        Builder status(Status status);

        /**
         * <p>
         * A time stamp that indicates when the stream was created.
         * </p>
         * 
         * @param creationTime
         *        A time stamp that indicates when the stream was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * How long the stream retains data, in hours.
         * </p>
         * 
         * @param dataRetentionInHours
         *        How long the stream retains data, in hours.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataRetentionInHours(Integer dataRetentionInHours);
    }

    static final class BuilderImpl implements Builder {
        private String deviceName;

        private String streamName;

        private String streamARN;

        private String mediaType;

        private String kmsKeyId;

        private String version;

        private String status;

        private Instant creationTime;

        private Integer dataRetentionInHours;

        private BuilderImpl() {
        }

        private BuilderImpl(StreamInfo model) {
            deviceName(model.deviceName);
            streamName(model.streamName);
            streamARN(model.streamARN);
            mediaType(model.mediaType);
            kmsKeyId(model.kmsKeyId);
            version(model.version);
            status(model.status);
            creationTime(model.creationTime);
            dataRetentionInHours(model.dataRetentionInHours);
        }

        public final String getDeviceName() {
            return deviceName;
        }

        public final void setDeviceName(String deviceName) {
            this.deviceName = deviceName;
        }

        @Override
        public final Builder deviceName(String deviceName) {
            this.deviceName = deviceName;
            return this;
        }

        public final String getStreamName() {
            return streamName;
        }

        public final void setStreamName(String streamName) {
            this.streamName = streamName;
        }

        @Override
        public final Builder streamName(String streamName) {
            this.streamName = streamName;
            return this;
        }

        public final String getStreamARN() {
            return streamARN;
        }

        public final void setStreamARN(String streamARN) {
            this.streamARN = streamARN;
        }

        @Override
        public final Builder streamARN(String streamARN) {
            this.streamARN = streamARN;
            return this;
        }

        public final String getMediaType() {
            return mediaType;
        }

        public final void setMediaType(String mediaType) {
            this.mediaType = mediaType;
        }

        @Override
        public final Builder mediaType(String mediaType) {
            this.mediaType = mediaType;
            return this;
        }

        public final String getKmsKeyId() {
            return kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final String getVersion() {
            return version;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(Status status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Integer getDataRetentionInHours() {
            return dataRetentionInHours;
        }

        public final void setDataRetentionInHours(Integer dataRetentionInHours) {
            this.dataRetentionInHours = dataRetentionInHours;
        }

        @Override
        public final Builder dataRetentionInHours(Integer dataRetentionInHours) {
            this.dataRetentionInHours = dataRetentionInHours;
            return this;
        }

        @Override
        public StreamInfo build() {
            return new StreamInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
