/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisvideo.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.kinesisvideo.model.MediaSourceConfig;
import software.amazon.awssdk.services.kinesisvideo.model.ScheduleConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RecorderConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RecorderConfig> {
    private static final SdkField<MediaSourceConfig> MEDIA_SOURCE_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MediaSourceConfig").getter(RecorderConfig.getter(RecorderConfig::mediaSourceConfig)).setter(RecorderConfig.setter(Builder::mediaSourceConfig)).constructor(MediaSourceConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MediaSourceConfig").build()}).build();
    private static final SdkField<ScheduleConfig> SCHEDULE_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ScheduleConfig").getter(RecorderConfig.getter(RecorderConfig::scheduleConfig)).setter(RecorderConfig.setter(Builder::scheduleConfig)).constructor(ScheduleConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScheduleConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MEDIA_SOURCE_CONFIG_FIELD, SCHEDULE_CONFIG_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RecorderConfig.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final MediaSourceConfig mediaSourceConfig;
    private final ScheduleConfig scheduleConfig;

    private RecorderConfig(BuilderImpl builder) {
        this.mediaSourceConfig = builder.mediaSourceConfig;
        this.scheduleConfig = builder.scheduleConfig;
    }

    public final MediaSourceConfig mediaSourceConfig() {
        return this.mediaSourceConfig;
    }

    public final ScheduleConfig scheduleConfig() {
        return this.scheduleConfig;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.mediaSourceConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.scheduleConfig());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RecorderConfig)) {
            return false;
        }
        RecorderConfig other = (RecorderConfig)obj;
        return Objects.equals(this.mediaSourceConfig(), other.mediaSourceConfig()) && Objects.equals(this.scheduleConfig(), other.scheduleConfig());
    }

    public final String toString() {
        return ToString.builder((String)"RecorderConfig").add("MediaSourceConfig", (Object)this.mediaSourceConfig()).add("ScheduleConfig", (Object)this.scheduleConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MediaSourceConfig": {
                return Optional.ofNullable(clazz.cast(this.mediaSourceConfig()));
            }
            case "ScheduleConfig": {
                return Optional.ofNullable(clazz.cast(this.scheduleConfig()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("MediaSourceConfig", MEDIA_SOURCE_CONFIG_FIELD);
        map.put("ScheduleConfig", SCHEDULE_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RecorderConfig, T> g) {
        return obj -> g.apply((RecorderConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private MediaSourceConfig mediaSourceConfig;
        private ScheduleConfig scheduleConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(RecorderConfig model) {
            this.mediaSourceConfig(model.mediaSourceConfig);
            this.scheduleConfig(model.scheduleConfig);
        }

        public final MediaSourceConfig.Builder getMediaSourceConfig() {
            return this.mediaSourceConfig != null ? this.mediaSourceConfig.toBuilder() : null;
        }

        public final void setMediaSourceConfig(MediaSourceConfig.BuilderImpl mediaSourceConfig) {
            this.mediaSourceConfig = mediaSourceConfig != null ? mediaSourceConfig.build() : null;
        }

        @Override
        public final Builder mediaSourceConfig(MediaSourceConfig mediaSourceConfig) {
            this.mediaSourceConfig = mediaSourceConfig;
            return this;
        }

        public final ScheduleConfig.Builder getScheduleConfig() {
            return this.scheduleConfig != null ? this.scheduleConfig.toBuilder() : null;
        }

        public final void setScheduleConfig(ScheduleConfig.BuilderImpl scheduleConfig) {
            this.scheduleConfig = scheduleConfig != null ? scheduleConfig.build() : null;
        }

        @Override
        public final Builder scheduleConfig(ScheduleConfig scheduleConfig) {
            this.scheduleConfig = scheduleConfig;
            return this;
        }

        public RecorderConfig build() {
            return new RecorderConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RecorderConfig> {
        public Builder mediaSourceConfig(MediaSourceConfig var1);

        default public Builder mediaSourceConfig(Consumer<MediaSourceConfig.Builder> mediaSourceConfig) {
            return this.mediaSourceConfig((MediaSourceConfig)((MediaSourceConfig.Builder)MediaSourceConfig.builder().applyMutation(mediaSourceConfig)).build());
        }

        public Builder scheduleConfig(ScheduleConfig var1);

        default public Builder scheduleConfig(Consumer<ScheduleConfig.Builder> scheduleConfig) {
            return this.scheduleConfig((ScheduleConfig)((ScheduleConfig.Builder)ScheduleConfig.builder().applyMutation(scheduleConfig)).build());
        }
    }
}

