/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisvideo;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Consumer;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkProtocolMetadata;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.SdkServiceClientConfiguration;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.kinesisvideo.KinesisVideoAsyncClient;
import software.amazon.awssdk.services.kinesisvideo.KinesisVideoServiceClientConfiguration;
import software.amazon.awssdk.services.kinesisvideo.internal.KinesisVideoServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.kinesisvideo.model.AccessDeniedException;
import software.amazon.awssdk.services.kinesisvideo.model.AccountChannelLimitExceededException;
import software.amazon.awssdk.services.kinesisvideo.model.AccountStreamLimitExceededException;
import software.amazon.awssdk.services.kinesisvideo.model.ClientLimitExceededException;
import software.amazon.awssdk.services.kinesisvideo.model.CreateSignalingChannelRequest;
import software.amazon.awssdk.services.kinesisvideo.model.CreateSignalingChannelResponse;
import software.amazon.awssdk.services.kinesisvideo.model.CreateStreamRequest;
import software.amazon.awssdk.services.kinesisvideo.model.CreateStreamResponse;
import software.amazon.awssdk.services.kinesisvideo.model.DeleteEdgeConfigurationRequest;
import software.amazon.awssdk.services.kinesisvideo.model.DeleteEdgeConfigurationResponse;
import software.amazon.awssdk.services.kinesisvideo.model.DeleteSignalingChannelRequest;
import software.amazon.awssdk.services.kinesisvideo.model.DeleteSignalingChannelResponse;
import software.amazon.awssdk.services.kinesisvideo.model.DeleteStreamRequest;
import software.amazon.awssdk.services.kinesisvideo.model.DeleteStreamResponse;
import software.amazon.awssdk.services.kinesisvideo.model.DescribeEdgeConfigurationRequest;
import software.amazon.awssdk.services.kinesisvideo.model.DescribeEdgeConfigurationResponse;
import software.amazon.awssdk.services.kinesisvideo.model.DescribeImageGenerationConfigurationRequest;
import software.amazon.awssdk.services.kinesisvideo.model.DescribeImageGenerationConfigurationResponse;
import software.amazon.awssdk.services.kinesisvideo.model.DescribeMappedResourceConfigurationRequest;
import software.amazon.awssdk.services.kinesisvideo.model.DescribeMappedResourceConfigurationResponse;
import software.amazon.awssdk.services.kinesisvideo.model.DescribeMediaStorageConfigurationRequest;
import software.amazon.awssdk.services.kinesisvideo.model.DescribeMediaStorageConfigurationResponse;
import software.amazon.awssdk.services.kinesisvideo.model.DescribeNotificationConfigurationRequest;
import software.amazon.awssdk.services.kinesisvideo.model.DescribeNotificationConfigurationResponse;
import software.amazon.awssdk.services.kinesisvideo.model.DescribeSignalingChannelRequest;
import software.amazon.awssdk.services.kinesisvideo.model.DescribeSignalingChannelResponse;
import software.amazon.awssdk.services.kinesisvideo.model.DescribeStreamRequest;
import software.amazon.awssdk.services.kinesisvideo.model.DescribeStreamResponse;
import software.amazon.awssdk.services.kinesisvideo.model.DeviceStreamLimitExceededException;
import software.amazon.awssdk.services.kinesisvideo.model.GetDataEndpointRequest;
import software.amazon.awssdk.services.kinesisvideo.model.GetDataEndpointResponse;
import software.amazon.awssdk.services.kinesisvideo.model.GetSignalingChannelEndpointRequest;
import software.amazon.awssdk.services.kinesisvideo.model.GetSignalingChannelEndpointResponse;
import software.amazon.awssdk.services.kinesisvideo.model.InvalidArgumentException;
import software.amazon.awssdk.services.kinesisvideo.model.InvalidDeviceException;
import software.amazon.awssdk.services.kinesisvideo.model.InvalidResourceFormatException;
import software.amazon.awssdk.services.kinesisvideo.model.KinesisVideoException;
import software.amazon.awssdk.services.kinesisvideo.model.ListEdgeAgentConfigurationsRequest;
import software.amazon.awssdk.services.kinesisvideo.model.ListEdgeAgentConfigurationsResponse;
import software.amazon.awssdk.services.kinesisvideo.model.ListSignalingChannelsRequest;
import software.amazon.awssdk.services.kinesisvideo.model.ListSignalingChannelsResponse;
import software.amazon.awssdk.services.kinesisvideo.model.ListStreamsRequest;
import software.amazon.awssdk.services.kinesisvideo.model.ListStreamsResponse;
import software.amazon.awssdk.services.kinesisvideo.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.kinesisvideo.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.kinesisvideo.model.ListTagsForStreamRequest;
import software.amazon.awssdk.services.kinesisvideo.model.ListTagsForStreamResponse;
import software.amazon.awssdk.services.kinesisvideo.model.NoDataRetentionException;
import software.amazon.awssdk.services.kinesisvideo.model.NotAuthorizedException;
import software.amazon.awssdk.services.kinesisvideo.model.ResourceInUseException;
import software.amazon.awssdk.services.kinesisvideo.model.ResourceNotFoundException;
import software.amazon.awssdk.services.kinesisvideo.model.StartEdgeConfigurationUpdateRequest;
import software.amazon.awssdk.services.kinesisvideo.model.StartEdgeConfigurationUpdateResponse;
import software.amazon.awssdk.services.kinesisvideo.model.StreamEdgeConfigurationNotFoundException;
import software.amazon.awssdk.services.kinesisvideo.model.TagResourceRequest;
import software.amazon.awssdk.services.kinesisvideo.model.TagResourceResponse;
import software.amazon.awssdk.services.kinesisvideo.model.TagStreamRequest;
import software.amazon.awssdk.services.kinesisvideo.model.TagStreamResponse;
import software.amazon.awssdk.services.kinesisvideo.model.TagsPerResourceExceededLimitException;
import software.amazon.awssdk.services.kinesisvideo.model.UntagResourceRequest;
import software.amazon.awssdk.services.kinesisvideo.model.UntagResourceResponse;
import software.amazon.awssdk.services.kinesisvideo.model.UntagStreamRequest;
import software.amazon.awssdk.services.kinesisvideo.model.UntagStreamResponse;
import software.amazon.awssdk.services.kinesisvideo.model.UpdateDataRetentionRequest;
import software.amazon.awssdk.services.kinesisvideo.model.UpdateDataRetentionResponse;
import software.amazon.awssdk.services.kinesisvideo.model.UpdateImageGenerationConfigurationRequest;
import software.amazon.awssdk.services.kinesisvideo.model.UpdateImageGenerationConfigurationResponse;
import software.amazon.awssdk.services.kinesisvideo.model.UpdateMediaStorageConfigurationRequest;
import software.amazon.awssdk.services.kinesisvideo.model.UpdateMediaStorageConfigurationResponse;
import software.amazon.awssdk.services.kinesisvideo.model.UpdateNotificationConfigurationRequest;
import software.amazon.awssdk.services.kinesisvideo.model.UpdateNotificationConfigurationResponse;
import software.amazon.awssdk.services.kinesisvideo.model.UpdateSignalingChannelRequest;
import software.amazon.awssdk.services.kinesisvideo.model.UpdateSignalingChannelResponse;
import software.amazon.awssdk.services.kinesisvideo.model.UpdateStreamRequest;
import software.amazon.awssdk.services.kinesisvideo.model.UpdateStreamResponse;
import software.amazon.awssdk.services.kinesisvideo.model.VersionMismatchException;
import software.amazon.awssdk.services.kinesisvideo.transform.CreateSignalingChannelRequestMarshaller;
import software.amazon.awssdk.services.kinesisvideo.transform.CreateStreamRequestMarshaller;
import software.amazon.awssdk.services.kinesisvideo.transform.DeleteEdgeConfigurationRequestMarshaller;
import software.amazon.awssdk.services.kinesisvideo.transform.DeleteSignalingChannelRequestMarshaller;
import software.amazon.awssdk.services.kinesisvideo.transform.DeleteStreamRequestMarshaller;
import software.amazon.awssdk.services.kinesisvideo.transform.DescribeEdgeConfigurationRequestMarshaller;
import software.amazon.awssdk.services.kinesisvideo.transform.DescribeImageGenerationConfigurationRequestMarshaller;
import software.amazon.awssdk.services.kinesisvideo.transform.DescribeMappedResourceConfigurationRequestMarshaller;
import software.amazon.awssdk.services.kinesisvideo.transform.DescribeMediaStorageConfigurationRequestMarshaller;
import software.amazon.awssdk.services.kinesisvideo.transform.DescribeNotificationConfigurationRequestMarshaller;
import software.amazon.awssdk.services.kinesisvideo.transform.DescribeSignalingChannelRequestMarshaller;
import software.amazon.awssdk.services.kinesisvideo.transform.DescribeStreamRequestMarshaller;
import software.amazon.awssdk.services.kinesisvideo.transform.GetDataEndpointRequestMarshaller;
import software.amazon.awssdk.services.kinesisvideo.transform.GetSignalingChannelEndpointRequestMarshaller;
import software.amazon.awssdk.services.kinesisvideo.transform.ListEdgeAgentConfigurationsRequestMarshaller;
import software.amazon.awssdk.services.kinesisvideo.transform.ListSignalingChannelsRequestMarshaller;
import software.amazon.awssdk.services.kinesisvideo.transform.ListStreamsRequestMarshaller;
import software.amazon.awssdk.services.kinesisvideo.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.kinesisvideo.transform.ListTagsForStreamRequestMarshaller;
import software.amazon.awssdk.services.kinesisvideo.transform.StartEdgeConfigurationUpdateRequestMarshaller;
import software.amazon.awssdk.services.kinesisvideo.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.kinesisvideo.transform.TagStreamRequestMarshaller;
import software.amazon.awssdk.services.kinesisvideo.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.kinesisvideo.transform.UntagStreamRequestMarshaller;
import software.amazon.awssdk.services.kinesisvideo.transform.UpdateDataRetentionRequestMarshaller;
import software.amazon.awssdk.services.kinesisvideo.transform.UpdateImageGenerationConfigurationRequestMarshaller;
import software.amazon.awssdk.services.kinesisvideo.transform.UpdateMediaStorageConfigurationRequestMarshaller;
import software.amazon.awssdk.services.kinesisvideo.transform.UpdateNotificationConfigurationRequestMarshaller;
import software.amazon.awssdk.services.kinesisvideo.transform.UpdateSignalingChannelRequestMarshaller;
import software.amazon.awssdk.services.kinesisvideo.transform.UpdateStreamRequestMarshaller;
import software.amazon.awssdk.utils.CompletableFutureUtils;

@SdkInternalApi
final class DefaultKinesisVideoAsyncClient
implements KinesisVideoAsyncClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultKinesisVideoAsyncClient.class);
    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder().serviceProtocol(AwsServiceProtocol.REST_JSON).build();
    private final AsyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultKinesisVideoAsyncClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option((ClientOption)SdkClientOption.SDK_CLIENT, (Object)this).build();
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    @Override
    public CompletableFuture<CreateSignalingChannelResponse> createSignalingChannel(CreateSignalingChannelRequest createSignalingChannelRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createSignalingChannelRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKinesisVideoAsyncClient.resolveMetricPublishers(clientConfiguration, createSignalingChannelRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Kinesis Video");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateSignalingChannel");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateSignalingChannelResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "AccountStreamLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountStreamLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountStreamLimitExceededException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "VersionMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("VersionMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(VersionMismatchException::builder).build());
                    }
                    case "AccountChannelLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountChannelLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountChannelLimitExceededException::builder).build());
                    }
                    case "ClientLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClientLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientLimitExceededException::builder).build());
                    }
                    case "StreamEdgeConfigurationNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StreamEdgeConfigurationNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(StreamEdgeConfigurationNotFoundException::builder).build());
                    }
                    case "InvalidResourceFormatException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceFormatException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceFormatException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "InvalidArgumentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                    }
                    case "NoDataRetentionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoDataRetentionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoDataRetentionException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "InvalidDeviceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeviceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDeviceException::builder).build());
                    }
                    case "TagsPerResourceExceededLimitException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagsPerResourceExceededLimitException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagsPerResourceExceededLimitException::builder).build());
                    }
                    case "DeviceStreamLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DeviceStreamLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DeviceStreamLimitExceededException::builder).build());
                    }
                    case "NotAuthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotAuthorizedException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(NotAuthorizedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateSignalingChannel").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateSignalingChannelRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createSignalingChannelRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultKinesisVideoAsyncClient.lambda$createSignalingChannel$2(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultKinesisVideoAsyncClient.lambda$createSignalingChannel$3((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateStreamResponse> createStream(CreateStreamRequest createStreamRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createStreamRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKinesisVideoAsyncClient.resolveMetricPublishers(clientConfiguration, createStreamRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Kinesis Video");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateStream");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateStreamResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "AccountStreamLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountStreamLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountStreamLimitExceededException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "VersionMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("VersionMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(VersionMismatchException::builder).build());
                    }
                    case "AccountChannelLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountChannelLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountChannelLimitExceededException::builder).build());
                    }
                    case "ClientLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClientLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientLimitExceededException::builder).build());
                    }
                    case "StreamEdgeConfigurationNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StreamEdgeConfigurationNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(StreamEdgeConfigurationNotFoundException::builder).build());
                    }
                    case "InvalidResourceFormatException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceFormatException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceFormatException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "InvalidArgumentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                    }
                    case "NoDataRetentionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoDataRetentionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoDataRetentionException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "InvalidDeviceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeviceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDeviceException::builder).build());
                    }
                    case "TagsPerResourceExceededLimitException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagsPerResourceExceededLimitException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagsPerResourceExceededLimitException::builder).build());
                    }
                    case "DeviceStreamLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DeviceStreamLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DeviceStreamLimitExceededException::builder).build());
                    }
                    case "NotAuthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotAuthorizedException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(NotAuthorizedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateStream").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateStreamRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createStreamRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultKinesisVideoAsyncClient.lambda$createStream$6(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultKinesisVideoAsyncClient.lambda$createStream$7((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteEdgeConfigurationResponse> deleteEdgeConfiguration(DeleteEdgeConfigurationRequest deleteEdgeConfigurationRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteEdgeConfigurationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKinesisVideoAsyncClient.resolveMetricPublishers(clientConfiguration, deleteEdgeConfigurationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Kinesis Video");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteEdgeConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteEdgeConfigurationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "AccountStreamLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountStreamLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountStreamLimitExceededException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "VersionMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("VersionMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(VersionMismatchException::builder).build());
                    }
                    case "AccountChannelLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountChannelLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountChannelLimitExceededException::builder).build());
                    }
                    case "ClientLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClientLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientLimitExceededException::builder).build());
                    }
                    case "StreamEdgeConfigurationNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StreamEdgeConfigurationNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(StreamEdgeConfigurationNotFoundException::builder).build());
                    }
                    case "InvalidResourceFormatException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceFormatException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceFormatException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "InvalidArgumentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                    }
                    case "NoDataRetentionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoDataRetentionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoDataRetentionException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "InvalidDeviceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeviceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDeviceException::builder).build());
                    }
                    case "TagsPerResourceExceededLimitException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagsPerResourceExceededLimitException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagsPerResourceExceededLimitException::builder).build());
                    }
                    case "DeviceStreamLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DeviceStreamLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DeviceStreamLimitExceededException::builder).build());
                    }
                    case "NotAuthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotAuthorizedException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(NotAuthorizedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteEdgeConfiguration").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteEdgeConfigurationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteEdgeConfigurationRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultKinesisVideoAsyncClient.lambda$deleteEdgeConfiguration$10(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultKinesisVideoAsyncClient.lambda$deleteEdgeConfiguration$11((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteSignalingChannelResponse> deleteSignalingChannel(DeleteSignalingChannelRequest deleteSignalingChannelRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteSignalingChannelRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKinesisVideoAsyncClient.resolveMetricPublishers(clientConfiguration, deleteSignalingChannelRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Kinesis Video");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteSignalingChannel");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteSignalingChannelResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "AccountStreamLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountStreamLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountStreamLimitExceededException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "VersionMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("VersionMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(VersionMismatchException::builder).build());
                    }
                    case "AccountChannelLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountChannelLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountChannelLimitExceededException::builder).build());
                    }
                    case "ClientLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClientLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientLimitExceededException::builder).build());
                    }
                    case "StreamEdgeConfigurationNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StreamEdgeConfigurationNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(StreamEdgeConfigurationNotFoundException::builder).build());
                    }
                    case "InvalidResourceFormatException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceFormatException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceFormatException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "InvalidArgumentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                    }
                    case "NoDataRetentionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoDataRetentionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoDataRetentionException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "InvalidDeviceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeviceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDeviceException::builder).build());
                    }
                    case "TagsPerResourceExceededLimitException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagsPerResourceExceededLimitException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagsPerResourceExceededLimitException::builder).build());
                    }
                    case "DeviceStreamLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DeviceStreamLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DeviceStreamLimitExceededException::builder).build());
                    }
                    case "NotAuthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotAuthorizedException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(NotAuthorizedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteSignalingChannel").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteSignalingChannelRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteSignalingChannelRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultKinesisVideoAsyncClient.lambda$deleteSignalingChannel$14(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultKinesisVideoAsyncClient.lambda$deleteSignalingChannel$15((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteStreamResponse> deleteStream(DeleteStreamRequest deleteStreamRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteStreamRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKinesisVideoAsyncClient.resolveMetricPublishers(clientConfiguration, deleteStreamRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Kinesis Video");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteStream");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteStreamResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "AccountStreamLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountStreamLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountStreamLimitExceededException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "VersionMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("VersionMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(VersionMismatchException::builder).build());
                    }
                    case "AccountChannelLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountChannelLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountChannelLimitExceededException::builder).build());
                    }
                    case "ClientLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClientLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientLimitExceededException::builder).build());
                    }
                    case "StreamEdgeConfigurationNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StreamEdgeConfigurationNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(StreamEdgeConfigurationNotFoundException::builder).build());
                    }
                    case "InvalidResourceFormatException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceFormatException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceFormatException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "InvalidArgumentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                    }
                    case "NoDataRetentionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoDataRetentionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoDataRetentionException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "InvalidDeviceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeviceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDeviceException::builder).build());
                    }
                    case "TagsPerResourceExceededLimitException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagsPerResourceExceededLimitException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagsPerResourceExceededLimitException::builder).build());
                    }
                    case "DeviceStreamLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DeviceStreamLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DeviceStreamLimitExceededException::builder).build());
                    }
                    case "NotAuthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotAuthorizedException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(NotAuthorizedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteStream").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteStreamRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteStreamRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultKinesisVideoAsyncClient.lambda$deleteStream$18(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultKinesisVideoAsyncClient.lambda$deleteStream$19((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeEdgeConfigurationResponse> describeEdgeConfiguration(DescribeEdgeConfigurationRequest describeEdgeConfigurationRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeEdgeConfigurationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKinesisVideoAsyncClient.resolveMetricPublishers(clientConfiguration, describeEdgeConfigurationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Kinesis Video");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeEdgeConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeEdgeConfigurationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "AccountStreamLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountStreamLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountStreamLimitExceededException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "VersionMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("VersionMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(VersionMismatchException::builder).build());
                    }
                    case "AccountChannelLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountChannelLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountChannelLimitExceededException::builder).build());
                    }
                    case "ClientLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClientLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientLimitExceededException::builder).build());
                    }
                    case "StreamEdgeConfigurationNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StreamEdgeConfigurationNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(StreamEdgeConfigurationNotFoundException::builder).build());
                    }
                    case "InvalidResourceFormatException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceFormatException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceFormatException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "InvalidArgumentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                    }
                    case "NoDataRetentionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoDataRetentionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoDataRetentionException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "InvalidDeviceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeviceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDeviceException::builder).build());
                    }
                    case "TagsPerResourceExceededLimitException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagsPerResourceExceededLimitException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagsPerResourceExceededLimitException::builder).build());
                    }
                    case "DeviceStreamLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DeviceStreamLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DeviceStreamLimitExceededException::builder).build());
                    }
                    case "NotAuthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotAuthorizedException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(NotAuthorizedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeEdgeConfiguration").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeEdgeConfigurationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeEdgeConfigurationRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultKinesisVideoAsyncClient.lambda$describeEdgeConfiguration$22(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultKinesisVideoAsyncClient.lambda$describeEdgeConfiguration$23((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeImageGenerationConfigurationResponse> describeImageGenerationConfiguration(DescribeImageGenerationConfigurationRequest describeImageGenerationConfigurationRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeImageGenerationConfigurationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKinesisVideoAsyncClient.resolveMetricPublishers(clientConfiguration, describeImageGenerationConfigurationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Kinesis Video");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeImageGenerationConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeImageGenerationConfigurationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "AccountStreamLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountStreamLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountStreamLimitExceededException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "VersionMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("VersionMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(VersionMismatchException::builder).build());
                    }
                    case "AccountChannelLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountChannelLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountChannelLimitExceededException::builder).build());
                    }
                    case "ClientLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClientLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientLimitExceededException::builder).build());
                    }
                    case "StreamEdgeConfigurationNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StreamEdgeConfigurationNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(StreamEdgeConfigurationNotFoundException::builder).build());
                    }
                    case "InvalidResourceFormatException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceFormatException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceFormatException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "InvalidArgumentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                    }
                    case "NoDataRetentionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoDataRetentionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoDataRetentionException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "InvalidDeviceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeviceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDeviceException::builder).build());
                    }
                    case "TagsPerResourceExceededLimitException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagsPerResourceExceededLimitException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagsPerResourceExceededLimitException::builder).build());
                    }
                    case "DeviceStreamLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DeviceStreamLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DeviceStreamLimitExceededException::builder).build());
                    }
                    case "NotAuthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotAuthorizedException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(NotAuthorizedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeImageGenerationConfiguration").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeImageGenerationConfigurationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeImageGenerationConfigurationRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultKinesisVideoAsyncClient.lambda$describeImageGenerationConfiguration$26(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultKinesisVideoAsyncClient.lambda$describeImageGenerationConfiguration$27((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeMappedResourceConfigurationResponse> describeMappedResourceConfiguration(DescribeMappedResourceConfigurationRequest describeMappedResourceConfigurationRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeMappedResourceConfigurationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKinesisVideoAsyncClient.resolveMetricPublishers(clientConfiguration, describeMappedResourceConfigurationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Kinesis Video");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeMappedResourceConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeMappedResourceConfigurationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "AccountStreamLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountStreamLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountStreamLimitExceededException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "VersionMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("VersionMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(VersionMismatchException::builder).build());
                    }
                    case "AccountChannelLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountChannelLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountChannelLimitExceededException::builder).build());
                    }
                    case "ClientLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClientLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientLimitExceededException::builder).build());
                    }
                    case "StreamEdgeConfigurationNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StreamEdgeConfigurationNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(StreamEdgeConfigurationNotFoundException::builder).build());
                    }
                    case "InvalidResourceFormatException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceFormatException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceFormatException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "InvalidArgumentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                    }
                    case "NoDataRetentionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoDataRetentionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoDataRetentionException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "InvalidDeviceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeviceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDeviceException::builder).build());
                    }
                    case "TagsPerResourceExceededLimitException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagsPerResourceExceededLimitException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagsPerResourceExceededLimitException::builder).build());
                    }
                    case "DeviceStreamLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DeviceStreamLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DeviceStreamLimitExceededException::builder).build());
                    }
                    case "NotAuthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotAuthorizedException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(NotAuthorizedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeMappedResourceConfiguration").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeMappedResourceConfigurationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeMappedResourceConfigurationRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultKinesisVideoAsyncClient.lambda$describeMappedResourceConfiguration$30(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultKinesisVideoAsyncClient.lambda$describeMappedResourceConfiguration$31((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeMediaStorageConfigurationResponse> describeMediaStorageConfiguration(DescribeMediaStorageConfigurationRequest describeMediaStorageConfigurationRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeMediaStorageConfigurationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKinesisVideoAsyncClient.resolveMetricPublishers(clientConfiguration, describeMediaStorageConfigurationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Kinesis Video");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeMediaStorageConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeMediaStorageConfigurationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "AccountStreamLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountStreamLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountStreamLimitExceededException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "VersionMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("VersionMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(VersionMismatchException::builder).build());
                    }
                    case "AccountChannelLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountChannelLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountChannelLimitExceededException::builder).build());
                    }
                    case "ClientLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClientLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientLimitExceededException::builder).build());
                    }
                    case "StreamEdgeConfigurationNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StreamEdgeConfigurationNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(StreamEdgeConfigurationNotFoundException::builder).build());
                    }
                    case "InvalidResourceFormatException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceFormatException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceFormatException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "InvalidArgumentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                    }
                    case "NoDataRetentionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoDataRetentionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoDataRetentionException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "InvalidDeviceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeviceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDeviceException::builder).build());
                    }
                    case "TagsPerResourceExceededLimitException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagsPerResourceExceededLimitException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagsPerResourceExceededLimitException::builder).build());
                    }
                    case "DeviceStreamLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DeviceStreamLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DeviceStreamLimitExceededException::builder).build());
                    }
                    case "NotAuthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotAuthorizedException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(NotAuthorizedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeMediaStorageConfiguration").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeMediaStorageConfigurationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeMediaStorageConfigurationRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultKinesisVideoAsyncClient.lambda$describeMediaStorageConfiguration$34(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultKinesisVideoAsyncClient.lambda$describeMediaStorageConfiguration$35((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeNotificationConfigurationResponse> describeNotificationConfiguration(DescribeNotificationConfigurationRequest describeNotificationConfigurationRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeNotificationConfigurationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKinesisVideoAsyncClient.resolveMetricPublishers(clientConfiguration, describeNotificationConfigurationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Kinesis Video");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeNotificationConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeNotificationConfigurationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "AccountStreamLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountStreamLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountStreamLimitExceededException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "VersionMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("VersionMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(VersionMismatchException::builder).build());
                    }
                    case "AccountChannelLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountChannelLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountChannelLimitExceededException::builder).build());
                    }
                    case "ClientLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClientLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientLimitExceededException::builder).build());
                    }
                    case "StreamEdgeConfigurationNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StreamEdgeConfigurationNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(StreamEdgeConfigurationNotFoundException::builder).build());
                    }
                    case "InvalidResourceFormatException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceFormatException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceFormatException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "InvalidArgumentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                    }
                    case "NoDataRetentionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoDataRetentionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoDataRetentionException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "InvalidDeviceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeviceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDeviceException::builder).build());
                    }
                    case "TagsPerResourceExceededLimitException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagsPerResourceExceededLimitException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagsPerResourceExceededLimitException::builder).build());
                    }
                    case "DeviceStreamLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DeviceStreamLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DeviceStreamLimitExceededException::builder).build());
                    }
                    case "NotAuthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotAuthorizedException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(NotAuthorizedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeNotificationConfiguration").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeNotificationConfigurationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeNotificationConfigurationRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultKinesisVideoAsyncClient.lambda$describeNotificationConfiguration$38(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultKinesisVideoAsyncClient.lambda$describeNotificationConfiguration$39((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeSignalingChannelResponse> describeSignalingChannel(DescribeSignalingChannelRequest describeSignalingChannelRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeSignalingChannelRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKinesisVideoAsyncClient.resolveMetricPublishers(clientConfiguration, describeSignalingChannelRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Kinesis Video");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeSignalingChannel");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeSignalingChannelResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "AccountStreamLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountStreamLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountStreamLimitExceededException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "VersionMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("VersionMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(VersionMismatchException::builder).build());
                    }
                    case "AccountChannelLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountChannelLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountChannelLimitExceededException::builder).build());
                    }
                    case "ClientLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClientLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientLimitExceededException::builder).build());
                    }
                    case "StreamEdgeConfigurationNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StreamEdgeConfigurationNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(StreamEdgeConfigurationNotFoundException::builder).build());
                    }
                    case "InvalidResourceFormatException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceFormatException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceFormatException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "InvalidArgumentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                    }
                    case "NoDataRetentionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoDataRetentionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoDataRetentionException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "InvalidDeviceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeviceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDeviceException::builder).build());
                    }
                    case "TagsPerResourceExceededLimitException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagsPerResourceExceededLimitException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagsPerResourceExceededLimitException::builder).build());
                    }
                    case "DeviceStreamLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DeviceStreamLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DeviceStreamLimitExceededException::builder).build());
                    }
                    case "NotAuthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotAuthorizedException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(NotAuthorizedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeSignalingChannel").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeSignalingChannelRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeSignalingChannelRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultKinesisVideoAsyncClient.lambda$describeSignalingChannel$42(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultKinesisVideoAsyncClient.lambda$describeSignalingChannel$43((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeStreamResponse> describeStream(DescribeStreamRequest describeStreamRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeStreamRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKinesisVideoAsyncClient.resolveMetricPublishers(clientConfiguration, describeStreamRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Kinesis Video");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeStream");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeStreamResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "AccountStreamLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountStreamLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountStreamLimitExceededException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "VersionMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("VersionMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(VersionMismatchException::builder).build());
                    }
                    case "AccountChannelLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountChannelLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountChannelLimitExceededException::builder).build());
                    }
                    case "ClientLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClientLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientLimitExceededException::builder).build());
                    }
                    case "StreamEdgeConfigurationNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StreamEdgeConfigurationNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(StreamEdgeConfigurationNotFoundException::builder).build());
                    }
                    case "InvalidResourceFormatException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceFormatException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceFormatException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "InvalidArgumentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                    }
                    case "NoDataRetentionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoDataRetentionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoDataRetentionException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "InvalidDeviceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeviceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDeviceException::builder).build());
                    }
                    case "TagsPerResourceExceededLimitException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagsPerResourceExceededLimitException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagsPerResourceExceededLimitException::builder).build());
                    }
                    case "DeviceStreamLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DeviceStreamLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DeviceStreamLimitExceededException::builder).build());
                    }
                    case "NotAuthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotAuthorizedException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(NotAuthorizedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeStream").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeStreamRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeStreamRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultKinesisVideoAsyncClient.lambda$describeStream$46(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultKinesisVideoAsyncClient.lambda$describeStream$47((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetDataEndpointResponse> getDataEndpoint(GetDataEndpointRequest getDataEndpointRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getDataEndpointRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKinesisVideoAsyncClient.resolveMetricPublishers(clientConfiguration, getDataEndpointRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Kinesis Video");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetDataEndpoint");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetDataEndpointResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "AccountStreamLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountStreamLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountStreamLimitExceededException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "VersionMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("VersionMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(VersionMismatchException::builder).build());
                    }
                    case "AccountChannelLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountChannelLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountChannelLimitExceededException::builder).build());
                    }
                    case "ClientLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClientLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientLimitExceededException::builder).build());
                    }
                    case "StreamEdgeConfigurationNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StreamEdgeConfigurationNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(StreamEdgeConfigurationNotFoundException::builder).build());
                    }
                    case "InvalidResourceFormatException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceFormatException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceFormatException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "InvalidArgumentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                    }
                    case "NoDataRetentionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoDataRetentionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoDataRetentionException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "InvalidDeviceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeviceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDeviceException::builder).build());
                    }
                    case "TagsPerResourceExceededLimitException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagsPerResourceExceededLimitException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagsPerResourceExceededLimitException::builder).build());
                    }
                    case "DeviceStreamLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DeviceStreamLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DeviceStreamLimitExceededException::builder).build());
                    }
                    case "NotAuthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotAuthorizedException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(NotAuthorizedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetDataEndpoint").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetDataEndpointRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getDataEndpointRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultKinesisVideoAsyncClient.lambda$getDataEndpoint$50(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultKinesisVideoAsyncClient.lambda$getDataEndpoint$51((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetSignalingChannelEndpointResponse> getSignalingChannelEndpoint(GetSignalingChannelEndpointRequest getSignalingChannelEndpointRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getSignalingChannelEndpointRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKinesisVideoAsyncClient.resolveMetricPublishers(clientConfiguration, getSignalingChannelEndpointRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Kinesis Video");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetSignalingChannelEndpoint");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetSignalingChannelEndpointResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "AccountStreamLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountStreamLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountStreamLimitExceededException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "VersionMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("VersionMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(VersionMismatchException::builder).build());
                    }
                    case "AccountChannelLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountChannelLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountChannelLimitExceededException::builder).build());
                    }
                    case "ClientLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClientLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientLimitExceededException::builder).build());
                    }
                    case "StreamEdgeConfigurationNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StreamEdgeConfigurationNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(StreamEdgeConfigurationNotFoundException::builder).build());
                    }
                    case "InvalidResourceFormatException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceFormatException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceFormatException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "InvalidArgumentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                    }
                    case "NoDataRetentionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoDataRetentionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoDataRetentionException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "InvalidDeviceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeviceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDeviceException::builder).build());
                    }
                    case "TagsPerResourceExceededLimitException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagsPerResourceExceededLimitException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagsPerResourceExceededLimitException::builder).build());
                    }
                    case "DeviceStreamLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DeviceStreamLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DeviceStreamLimitExceededException::builder).build());
                    }
                    case "NotAuthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotAuthorizedException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(NotAuthorizedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetSignalingChannelEndpoint").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetSignalingChannelEndpointRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getSignalingChannelEndpointRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultKinesisVideoAsyncClient.lambda$getSignalingChannelEndpoint$54(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultKinesisVideoAsyncClient.lambda$getSignalingChannelEndpoint$55((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListEdgeAgentConfigurationsResponse> listEdgeAgentConfigurations(ListEdgeAgentConfigurationsRequest listEdgeAgentConfigurationsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listEdgeAgentConfigurationsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKinesisVideoAsyncClient.resolveMetricPublishers(clientConfiguration, listEdgeAgentConfigurationsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Kinesis Video");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListEdgeAgentConfigurations");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListEdgeAgentConfigurationsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "AccountStreamLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountStreamLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountStreamLimitExceededException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "VersionMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("VersionMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(VersionMismatchException::builder).build());
                    }
                    case "AccountChannelLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountChannelLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountChannelLimitExceededException::builder).build());
                    }
                    case "ClientLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClientLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientLimitExceededException::builder).build());
                    }
                    case "StreamEdgeConfigurationNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StreamEdgeConfigurationNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(StreamEdgeConfigurationNotFoundException::builder).build());
                    }
                    case "InvalidResourceFormatException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceFormatException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceFormatException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "InvalidArgumentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                    }
                    case "NoDataRetentionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoDataRetentionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoDataRetentionException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "InvalidDeviceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeviceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDeviceException::builder).build());
                    }
                    case "TagsPerResourceExceededLimitException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagsPerResourceExceededLimitException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagsPerResourceExceededLimitException::builder).build());
                    }
                    case "DeviceStreamLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DeviceStreamLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DeviceStreamLimitExceededException::builder).build());
                    }
                    case "NotAuthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotAuthorizedException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(NotAuthorizedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListEdgeAgentConfigurations").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListEdgeAgentConfigurationsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listEdgeAgentConfigurationsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultKinesisVideoAsyncClient.lambda$listEdgeAgentConfigurations$58(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultKinesisVideoAsyncClient.lambda$listEdgeAgentConfigurations$59((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListSignalingChannelsResponse> listSignalingChannels(ListSignalingChannelsRequest listSignalingChannelsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listSignalingChannelsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKinesisVideoAsyncClient.resolveMetricPublishers(clientConfiguration, listSignalingChannelsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Kinesis Video");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListSignalingChannels");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListSignalingChannelsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "AccountStreamLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountStreamLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountStreamLimitExceededException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "VersionMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("VersionMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(VersionMismatchException::builder).build());
                    }
                    case "AccountChannelLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountChannelLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountChannelLimitExceededException::builder).build());
                    }
                    case "ClientLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClientLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientLimitExceededException::builder).build());
                    }
                    case "StreamEdgeConfigurationNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StreamEdgeConfigurationNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(StreamEdgeConfigurationNotFoundException::builder).build());
                    }
                    case "InvalidResourceFormatException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceFormatException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceFormatException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "InvalidArgumentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                    }
                    case "NoDataRetentionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoDataRetentionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoDataRetentionException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "InvalidDeviceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeviceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDeviceException::builder).build());
                    }
                    case "TagsPerResourceExceededLimitException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagsPerResourceExceededLimitException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagsPerResourceExceededLimitException::builder).build());
                    }
                    case "DeviceStreamLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DeviceStreamLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DeviceStreamLimitExceededException::builder).build());
                    }
                    case "NotAuthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotAuthorizedException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(NotAuthorizedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListSignalingChannels").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListSignalingChannelsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listSignalingChannelsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultKinesisVideoAsyncClient.lambda$listSignalingChannels$62(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultKinesisVideoAsyncClient.lambda$listSignalingChannels$63((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListStreamsResponse> listStreams(ListStreamsRequest listStreamsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listStreamsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKinesisVideoAsyncClient.resolveMetricPublishers(clientConfiguration, listStreamsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Kinesis Video");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListStreams");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListStreamsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "AccountStreamLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountStreamLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountStreamLimitExceededException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "VersionMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("VersionMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(VersionMismatchException::builder).build());
                    }
                    case "AccountChannelLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountChannelLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountChannelLimitExceededException::builder).build());
                    }
                    case "ClientLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClientLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientLimitExceededException::builder).build());
                    }
                    case "StreamEdgeConfigurationNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StreamEdgeConfigurationNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(StreamEdgeConfigurationNotFoundException::builder).build());
                    }
                    case "InvalidResourceFormatException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceFormatException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceFormatException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "InvalidArgumentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                    }
                    case "NoDataRetentionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoDataRetentionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoDataRetentionException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "InvalidDeviceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeviceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDeviceException::builder).build());
                    }
                    case "TagsPerResourceExceededLimitException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagsPerResourceExceededLimitException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagsPerResourceExceededLimitException::builder).build());
                    }
                    case "DeviceStreamLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DeviceStreamLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DeviceStreamLimitExceededException::builder).build());
                    }
                    case "NotAuthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotAuthorizedException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(NotAuthorizedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListStreams").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListStreamsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listStreamsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultKinesisVideoAsyncClient.lambda$listStreams$66(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultKinesisVideoAsyncClient.lambda$listStreams$67((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListTagsForResourceResponse> listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listTagsForResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKinesisVideoAsyncClient.resolveMetricPublishers(clientConfiguration, listTagsForResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Kinesis Video");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTagsForResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTagsForResourceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "AccountStreamLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountStreamLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountStreamLimitExceededException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "VersionMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("VersionMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(VersionMismatchException::builder).build());
                    }
                    case "AccountChannelLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountChannelLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountChannelLimitExceededException::builder).build());
                    }
                    case "ClientLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClientLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientLimitExceededException::builder).build());
                    }
                    case "StreamEdgeConfigurationNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StreamEdgeConfigurationNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(StreamEdgeConfigurationNotFoundException::builder).build());
                    }
                    case "InvalidResourceFormatException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceFormatException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceFormatException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "InvalidArgumentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                    }
                    case "NoDataRetentionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoDataRetentionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoDataRetentionException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "InvalidDeviceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeviceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDeviceException::builder).build());
                    }
                    case "TagsPerResourceExceededLimitException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagsPerResourceExceededLimitException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagsPerResourceExceededLimitException::builder).build());
                    }
                    case "DeviceStreamLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DeviceStreamLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DeviceStreamLimitExceededException::builder).build());
                    }
                    case "NotAuthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotAuthorizedException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(NotAuthorizedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTagsForResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListTagsForResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listTagsForResourceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultKinesisVideoAsyncClient.lambda$listTagsForResource$70(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultKinesisVideoAsyncClient.lambda$listTagsForResource$71((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListTagsForStreamResponse> listTagsForStream(ListTagsForStreamRequest listTagsForStreamRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listTagsForStreamRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKinesisVideoAsyncClient.resolveMetricPublishers(clientConfiguration, listTagsForStreamRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Kinesis Video");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTagsForStream");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTagsForStreamResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "AccountStreamLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountStreamLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountStreamLimitExceededException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "VersionMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("VersionMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(VersionMismatchException::builder).build());
                    }
                    case "AccountChannelLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountChannelLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountChannelLimitExceededException::builder).build());
                    }
                    case "ClientLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClientLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientLimitExceededException::builder).build());
                    }
                    case "StreamEdgeConfigurationNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StreamEdgeConfigurationNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(StreamEdgeConfigurationNotFoundException::builder).build());
                    }
                    case "InvalidResourceFormatException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceFormatException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceFormatException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "InvalidArgumentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                    }
                    case "NoDataRetentionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoDataRetentionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoDataRetentionException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "InvalidDeviceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeviceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDeviceException::builder).build());
                    }
                    case "TagsPerResourceExceededLimitException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagsPerResourceExceededLimitException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagsPerResourceExceededLimitException::builder).build());
                    }
                    case "DeviceStreamLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DeviceStreamLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DeviceStreamLimitExceededException::builder).build());
                    }
                    case "NotAuthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotAuthorizedException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(NotAuthorizedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTagsForStream").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListTagsForStreamRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listTagsForStreamRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultKinesisVideoAsyncClient.lambda$listTagsForStream$74(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultKinesisVideoAsyncClient.lambda$listTagsForStream$75((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<StartEdgeConfigurationUpdateResponse> startEdgeConfigurationUpdate(StartEdgeConfigurationUpdateRequest startEdgeConfigurationUpdateRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)startEdgeConfigurationUpdateRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKinesisVideoAsyncClient.resolveMetricPublishers(clientConfiguration, startEdgeConfigurationUpdateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Kinesis Video");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartEdgeConfigurationUpdate");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartEdgeConfigurationUpdateResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "AccountStreamLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountStreamLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountStreamLimitExceededException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "VersionMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("VersionMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(VersionMismatchException::builder).build());
                    }
                    case "AccountChannelLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountChannelLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountChannelLimitExceededException::builder).build());
                    }
                    case "ClientLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClientLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientLimitExceededException::builder).build());
                    }
                    case "StreamEdgeConfigurationNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StreamEdgeConfigurationNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(StreamEdgeConfigurationNotFoundException::builder).build());
                    }
                    case "InvalidResourceFormatException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceFormatException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceFormatException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "InvalidArgumentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                    }
                    case "NoDataRetentionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoDataRetentionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoDataRetentionException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "InvalidDeviceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeviceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDeviceException::builder).build());
                    }
                    case "TagsPerResourceExceededLimitException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagsPerResourceExceededLimitException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagsPerResourceExceededLimitException::builder).build());
                    }
                    case "DeviceStreamLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DeviceStreamLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DeviceStreamLimitExceededException::builder).build());
                    }
                    case "NotAuthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotAuthorizedException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(NotAuthorizedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartEdgeConfigurationUpdate").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new StartEdgeConfigurationUpdateRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)startEdgeConfigurationUpdateRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultKinesisVideoAsyncClient.lambda$startEdgeConfigurationUpdate$78(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultKinesisVideoAsyncClient.lambda$startEdgeConfigurationUpdate$79((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)tagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKinesisVideoAsyncClient.resolveMetricPublishers(clientConfiguration, tagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Kinesis Video");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TagResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TagResourceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "AccountStreamLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountStreamLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountStreamLimitExceededException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "VersionMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("VersionMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(VersionMismatchException::builder).build());
                    }
                    case "AccountChannelLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountChannelLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountChannelLimitExceededException::builder).build());
                    }
                    case "ClientLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClientLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientLimitExceededException::builder).build());
                    }
                    case "StreamEdgeConfigurationNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StreamEdgeConfigurationNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(StreamEdgeConfigurationNotFoundException::builder).build());
                    }
                    case "InvalidResourceFormatException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceFormatException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceFormatException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "InvalidArgumentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                    }
                    case "NoDataRetentionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoDataRetentionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoDataRetentionException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "InvalidDeviceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeviceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDeviceException::builder).build());
                    }
                    case "TagsPerResourceExceededLimitException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagsPerResourceExceededLimitException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagsPerResourceExceededLimitException::builder).build());
                    }
                    case "DeviceStreamLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DeviceStreamLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DeviceStreamLimitExceededException::builder).build());
                    }
                    case "NotAuthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotAuthorizedException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(NotAuthorizedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("TagResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new TagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)tagResourceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultKinesisVideoAsyncClient.lambda$tagResource$82(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultKinesisVideoAsyncClient.lambda$tagResource$83((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<TagStreamResponse> tagStream(TagStreamRequest tagStreamRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)tagStreamRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKinesisVideoAsyncClient.resolveMetricPublishers(clientConfiguration, tagStreamRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Kinesis Video");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TagStream");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TagStreamResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "AccountStreamLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountStreamLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountStreamLimitExceededException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "VersionMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("VersionMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(VersionMismatchException::builder).build());
                    }
                    case "AccountChannelLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountChannelLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountChannelLimitExceededException::builder).build());
                    }
                    case "ClientLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClientLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientLimitExceededException::builder).build());
                    }
                    case "StreamEdgeConfigurationNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StreamEdgeConfigurationNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(StreamEdgeConfigurationNotFoundException::builder).build());
                    }
                    case "InvalidResourceFormatException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceFormatException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceFormatException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "InvalidArgumentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                    }
                    case "NoDataRetentionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoDataRetentionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoDataRetentionException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "InvalidDeviceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeviceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDeviceException::builder).build());
                    }
                    case "TagsPerResourceExceededLimitException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagsPerResourceExceededLimitException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagsPerResourceExceededLimitException::builder).build());
                    }
                    case "DeviceStreamLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DeviceStreamLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DeviceStreamLimitExceededException::builder).build());
                    }
                    case "NotAuthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotAuthorizedException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(NotAuthorizedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("TagStream").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new TagStreamRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)tagStreamRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultKinesisVideoAsyncClient.lambda$tagStream$86(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultKinesisVideoAsyncClient.lambda$tagStream$87((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)untagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKinesisVideoAsyncClient.resolveMetricPublishers(clientConfiguration, untagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Kinesis Video");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UntagResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UntagResourceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "AccountStreamLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountStreamLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountStreamLimitExceededException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "VersionMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("VersionMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(VersionMismatchException::builder).build());
                    }
                    case "AccountChannelLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountChannelLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountChannelLimitExceededException::builder).build());
                    }
                    case "ClientLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClientLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientLimitExceededException::builder).build());
                    }
                    case "StreamEdgeConfigurationNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StreamEdgeConfigurationNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(StreamEdgeConfigurationNotFoundException::builder).build());
                    }
                    case "InvalidResourceFormatException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceFormatException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceFormatException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "InvalidArgumentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                    }
                    case "NoDataRetentionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoDataRetentionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoDataRetentionException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "InvalidDeviceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeviceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDeviceException::builder).build());
                    }
                    case "TagsPerResourceExceededLimitException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagsPerResourceExceededLimitException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagsPerResourceExceededLimitException::builder).build());
                    }
                    case "DeviceStreamLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DeviceStreamLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DeviceStreamLimitExceededException::builder).build());
                    }
                    case "NotAuthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotAuthorizedException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(NotAuthorizedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UntagResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UntagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)untagResourceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultKinesisVideoAsyncClient.lambda$untagResource$90(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultKinesisVideoAsyncClient.lambda$untagResource$91((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UntagStreamResponse> untagStream(UntagStreamRequest untagStreamRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)untagStreamRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKinesisVideoAsyncClient.resolveMetricPublishers(clientConfiguration, untagStreamRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Kinesis Video");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UntagStream");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UntagStreamResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "AccountStreamLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountStreamLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountStreamLimitExceededException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "VersionMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("VersionMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(VersionMismatchException::builder).build());
                    }
                    case "AccountChannelLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountChannelLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountChannelLimitExceededException::builder).build());
                    }
                    case "ClientLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClientLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientLimitExceededException::builder).build());
                    }
                    case "StreamEdgeConfigurationNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StreamEdgeConfigurationNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(StreamEdgeConfigurationNotFoundException::builder).build());
                    }
                    case "InvalidResourceFormatException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceFormatException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceFormatException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "InvalidArgumentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                    }
                    case "NoDataRetentionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoDataRetentionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoDataRetentionException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "InvalidDeviceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeviceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDeviceException::builder).build());
                    }
                    case "TagsPerResourceExceededLimitException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagsPerResourceExceededLimitException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagsPerResourceExceededLimitException::builder).build());
                    }
                    case "DeviceStreamLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DeviceStreamLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DeviceStreamLimitExceededException::builder).build());
                    }
                    case "NotAuthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotAuthorizedException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(NotAuthorizedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UntagStream").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UntagStreamRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)untagStreamRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultKinesisVideoAsyncClient.lambda$untagStream$94(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultKinesisVideoAsyncClient.lambda$untagStream$95((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateDataRetentionResponse> updateDataRetention(UpdateDataRetentionRequest updateDataRetentionRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateDataRetentionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKinesisVideoAsyncClient.resolveMetricPublishers(clientConfiguration, updateDataRetentionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Kinesis Video");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateDataRetention");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateDataRetentionResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "AccountStreamLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountStreamLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountStreamLimitExceededException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "VersionMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("VersionMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(VersionMismatchException::builder).build());
                    }
                    case "AccountChannelLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountChannelLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountChannelLimitExceededException::builder).build());
                    }
                    case "ClientLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClientLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientLimitExceededException::builder).build());
                    }
                    case "StreamEdgeConfigurationNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StreamEdgeConfigurationNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(StreamEdgeConfigurationNotFoundException::builder).build());
                    }
                    case "InvalidResourceFormatException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceFormatException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceFormatException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "InvalidArgumentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                    }
                    case "NoDataRetentionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoDataRetentionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoDataRetentionException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "InvalidDeviceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeviceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDeviceException::builder).build());
                    }
                    case "TagsPerResourceExceededLimitException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagsPerResourceExceededLimitException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagsPerResourceExceededLimitException::builder).build());
                    }
                    case "DeviceStreamLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DeviceStreamLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DeviceStreamLimitExceededException::builder).build());
                    }
                    case "NotAuthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotAuthorizedException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(NotAuthorizedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateDataRetention").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UpdateDataRetentionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateDataRetentionRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultKinesisVideoAsyncClient.lambda$updateDataRetention$98(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultKinesisVideoAsyncClient.lambda$updateDataRetention$99((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateImageGenerationConfigurationResponse> updateImageGenerationConfiguration(UpdateImageGenerationConfigurationRequest updateImageGenerationConfigurationRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateImageGenerationConfigurationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKinesisVideoAsyncClient.resolveMetricPublishers(clientConfiguration, updateImageGenerationConfigurationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Kinesis Video");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateImageGenerationConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateImageGenerationConfigurationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "AccountStreamLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountStreamLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountStreamLimitExceededException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "VersionMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("VersionMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(VersionMismatchException::builder).build());
                    }
                    case "AccountChannelLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountChannelLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountChannelLimitExceededException::builder).build());
                    }
                    case "ClientLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClientLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientLimitExceededException::builder).build());
                    }
                    case "StreamEdgeConfigurationNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StreamEdgeConfigurationNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(StreamEdgeConfigurationNotFoundException::builder).build());
                    }
                    case "InvalidResourceFormatException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceFormatException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceFormatException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "InvalidArgumentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                    }
                    case "NoDataRetentionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoDataRetentionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoDataRetentionException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "InvalidDeviceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeviceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDeviceException::builder).build());
                    }
                    case "TagsPerResourceExceededLimitException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagsPerResourceExceededLimitException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagsPerResourceExceededLimitException::builder).build());
                    }
                    case "DeviceStreamLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DeviceStreamLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DeviceStreamLimitExceededException::builder).build());
                    }
                    case "NotAuthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotAuthorizedException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(NotAuthorizedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateImageGenerationConfiguration").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UpdateImageGenerationConfigurationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateImageGenerationConfigurationRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultKinesisVideoAsyncClient.lambda$updateImageGenerationConfiguration$102(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultKinesisVideoAsyncClient.lambda$updateImageGenerationConfiguration$103((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateMediaStorageConfigurationResponse> updateMediaStorageConfiguration(UpdateMediaStorageConfigurationRequest updateMediaStorageConfigurationRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateMediaStorageConfigurationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKinesisVideoAsyncClient.resolveMetricPublishers(clientConfiguration, updateMediaStorageConfigurationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Kinesis Video");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateMediaStorageConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateMediaStorageConfigurationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "AccountStreamLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountStreamLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountStreamLimitExceededException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "VersionMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("VersionMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(VersionMismatchException::builder).build());
                    }
                    case "AccountChannelLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountChannelLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountChannelLimitExceededException::builder).build());
                    }
                    case "ClientLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClientLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientLimitExceededException::builder).build());
                    }
                    case "StreamEdgeConfigurationNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StreamEdgeConfigurationNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(StreamEdgeConfigurationNotFoundException::builder).build());
                    }
                    case "InvalidResourceFormatException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceFormatException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceFormatException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "InvalidArgumentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                    }
                    case "NoDataRetentionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoDataRetentionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoDataRetentionException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "InvalidDeviceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeviceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDeviceException::builder).build());
                    }
                    case "TagsPerResourceExceededLimitException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagsPerResourceExceededLimitException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagsPerResourceExceededLimitException::builder).build());
                    }
                    case "DeviceStreamLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DeviceStreamLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DeviceStreamLimitExceededException::builder).build());
                    }
                    case "NotAuthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotAuthorizedException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(NotAuthorizedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateMediaStorageConfiguration").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UpdateMediaStorageConfigurationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateMediaStorageConfigurationRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultKinesisVideoAsyncClient.lambda$updateMediaStorageConfiguration$106(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultKinesisVideoAsyncClient.lambda$updateMediaStorageConfiguration$107((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateNotificationConfigurationResponse> updateNotificationConfiguration(UpdateNotificationConfigurationRequest updateNotificationConfigurationRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateNotificationConfigurationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKinesisVideoAsyncClient.resolveMetricPublishers(clientConfiguration, updateNotificationConfigurationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Kinesis Video");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateNotificationConfiguration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateNotificationConfigurationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "AccountStreamLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountStreamLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountStreamLimitExceededException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "VersionMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("VersionMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(VersionMismatchException::builder).build());
                    }
                    case "AccountChannelLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountChannelLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountChannelLimitExceededException::builder).build());
                    }
                    case "ClientLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClientLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientLimitExceededException::builder).build());
                    }
                    case "StreamEdgeConfigurationNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StreamEdgeConfigurationNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(StreamEdgeConfigurationNotFoundException::builder).build());
                    }
                    case "InvalidResourceFormatException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceFormatException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceFormatException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "InvalidArgumentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                    }
                    case "NoDataRetentionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoDataRetentionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoDataRetentionException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "InvalidDeviceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeviceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDeviceException::builder).build());
                    }
                    case "TagsPerResourceExceededLimitException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagsPerResourceExceededLimitException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagsPerResourceExceededLimitException::builder).build());
                    }
                    case "DeviceStreamLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DeviceStreamLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DeviceStreamLimitExceededException::builder).build());
                    }
                    case "NotAuthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotAuthorizedException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(NotAuthorizedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateNotificationConfiguration").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UpdateNotificationConfigurationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateNotificationConfigurationRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultKinesisVideoAsyncClient.lambda$updateNotificationConfiguration$110(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultKinesisVideoAsyncClient.lambda$updateNotificationConfiguration$111((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateSignalingChannelResponse> updateSignalingChannel(UpdateSignalingChannelRequest updateSignalingChannelRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateSignalingChannelRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKinesisVideoAsyncClient.resolveMetricPublishers(clientConfiguration, updateSignalingChannelRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Kinesis Video");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateSignalingChannel");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateSignalingChannelResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "AccountStreamLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountStreamLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountStreamLimitExceededException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "VersionMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("VersionMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(VersionMismatchException::builder).build());
                    }
                    case "AccountChannelLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountChannelLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountChannelLimitExceededException::builder).build());
                    }
                    case "ClientLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClientLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientLimitExceededException::builder).build());
                    }
                    case "StreamEdgeConfigurationNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StreamEdgeConfigurationNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(StreamEdgeConfigurationNotFoundException::builder).build());
                    }
                    case "InvalidResourceFormatException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceFormatException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceFormatException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "InvalidArgumentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                    }
                    case "NoDataRetentionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoDataRetentionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoDataRetentionException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "InvalidDeviceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeviceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDeviceException::builder).build());
                    }
                    case "TagsPerResourceExceededLimitException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagsPerResourceExceededLimitException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagsPerResourceExceededLimitException::builder).build());
                    }
                    case "DeviceStreamLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DeviceStreamLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DeviceStreamLimitExceededException::builder).build());
                    }
                    case "NotAuthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotAuthorizedException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(NotAuthorizedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateSignalingChannel").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UpdateSignalingChannelRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateSignalingChannelRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultKinesisVideoAsyncClient.lambda$updateSignalingChannel$114(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultKinesisVideoAsyncClient.lambda$updateSignalingChannel$115((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateStreamResponse> updateStream(UpdateStreamRequest updateStreamRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateStreamRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKinesisVideoAsyncClient.resolveMetricPublishers(clientConfiguration, updateStreamRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Kinesis Video");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateStream");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateStreamResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "AccountStreamLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountStreamLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountStreamLimitExceededException::builder).build());
                    }
                    case "ResourceInUseException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceInUseException::builder).build());
                    }
                    case "VersionMismatchException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("VersionMismatchException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(VersionMismatchException::builder).build());
                    }
                    case "AccountChannelLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccountChannelLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountChannelLimitExceededException::builder).build());
                    }
                    case "ClientLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ClientLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientLimitExceededException::builder).build());
                    }
                    case "StreamEdgeConfigurationNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("StreamEdgeConfigurationNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(StreamEdgeConfigurationNotFoundException::builder).build());
                    }
                    case "InvalidResourceFormatException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidResourceFormatException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidResourceFormatException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "InvalidArgumentException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                    }
                    case "NoDataRetentionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NoDataRetentionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoDataRetentionException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "InvalidDeviceException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDeviceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDeviceException::builder).build());
                    }
                    case "TagsPerResourceExceededLimitException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TagsPerResourceExceededLimitException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagsPerResourceExceededLimitException::builder).build());
                    }
                    case "DeviceStreamLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DeviceStreamLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DeviceStreamLimitExceededException::builder).build());
                    }
                    case "NotAuthorizedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("NotAuthorizedException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(NotAuthorizedException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateStream").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UpdateStreamRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateStreamRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultKinesisVideoAsyncClient.lambda$updateStream$118(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultKinesisVideoAsyncClient.lambda$updateStream$119((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public final KinesisVideoServiceClientConfiguration serviceClientConfiguration() {
        return new KinesisVideoServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    public final String serviceName() {
        return "kinesisvideo";
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(KinesisVideoException::builder).protocol(AwsJsonProtocol.REST_JSON).protocolVersion("1.1");
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private void updateRetryStrategyClientConfiguration(SdkClientConfiguration.Builder configuration) {
        ClientOverrideConfiguration.Builder builder = configuration.asOverrideConfigurationBuilder();
        RetryMode retryMode = builder.retryMode();
        if (retryMode != null) {
            configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)AwsRetryStrategy.forRetryMode((RetryMode)retryMode));
        } else {
            Consumer configurator = builder.retryStrategyConfigurator();
            if (configurator != null) {
                RetryStrategy.Builder defaultBuilder = AwsRetryStrategy.defaultRetryStrategy().toBuilder();
                configurator.accept(defaultBuilder);
                configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)defaultBuilder.build());
            } else {
                RetryStrategy retryStrategy = builder.retryStrategy();
                if (retryStrategy != null) {
                    configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)retryStrategy);
                }
            }
        }
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_MODE, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_STRATEGY, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_CONFIGURATOR, null);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        if (plugins.isEmpty()) {
            return configuration.build();
        }
        KinesisVideoServiceClientConfigurationBuilder serviceConfigBuilder = new KinesisVideoServiceClientConfigurationBuilder(configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient((SdkServiceClientConfiguration.Builder)serviceConfigBuilder);
        }
        this.updateRetryStrategyClientConfiguration(configuration);
        return configuration.build();
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata, Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper) {
        return protocolFactory.createErrorResponseHandler(operationMetadata, exceptionMetadataMapper);
    }

    public void close() {
        this.clientHandler.close();
    }

    private static /* synthetic */ void lambda$updateStream$119(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateStream$118(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateStreamResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updateSignalingChannel$115(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateSignalingChannel$114(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateSignalingChannelResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updateNotificationConfiguration$111(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateNotificationConfiguration$110(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateNotificationConfigurationResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updateMediaStorageConfiguration$107(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateMediaStorageConfiguration$106(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateMediaStorageConfigurationResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updateImageGenerationConfiguration$103(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateImageGenerationConfiguration$102(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateImageGenerationConfigurationResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updateDataRetention$99(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateDataRetention$98(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateDataRetentionResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$untagStream$95(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$untagStream$94(List metricPublishers, MetricCollector apiCallMetricCollector, UntagStreamResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$untagResource$91(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$untagResource$90(List metricPublishers, MetricCollector apiCallMetricCollector, UntagResourceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$tagStream$87(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$tagStream$86(List metricPublishers, MetricCollector apiCallMetricCollector, TagStreamResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$tagResource$83(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$tagResource$82(List metricPublishers, MetricCollector apiCallMetricCollector, TagResourceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$startEdgeConfigurationUpdate$79(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startEdgeConfigurationUpdate$78(List metricPublishers, MetricCollector apiCallMetricCollector, StartEdgeConfigurationUpdateResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listTagsForStream$75(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTagsForStream$74(List metricPublishers, MetricCollector apiCallMetricCollector, ListTagsForStreamResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listTagsForResource$71(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTagsForResource$70(List metricPublishers, MetricCollector apiCallMetricCollector, ListTagsForResourceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listStreams$67(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listStreams$66(List metricPublishers, MetricCollector apiCallMetricCollector, ListStreamsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listSignalingChannels$63(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listSignalingChannels$62(List metricPublishers, MetricCollector apiCallMetricCollector, ListSignalingChannelsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listEdgeAgentConfigurations$59(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listEdgeAgentConfigurations$58(List metricPublishers, MetricCollector apiCallMetricCollector, ListEdgeAgentConfigurationsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getSignalingChannelEndpoint$55(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getSignalingChannelEndpoint$54(List metricPublishers, MetricCollector apiCallMetricCollector, GetSignalingChannelEndpointResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getDataEndpoint$51(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getDataEndpoint$50(List metricPublishers, MetricCollector apiCallMetricCollector, GetDataEndpointResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeStream$47(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeStream$46(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeStreamResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeSignalingChannel$43(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeSignalingChannel$42(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeSignalingChannelResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeNotificationConfiguration$39(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeNotificationConfiguration$38(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeNotificationConfigurationResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeMediaStorageConfiguration$35(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeMediaStorageConfiguration$34(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeMediaStorageConfigurationResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeMappedResourceConfiguration$31(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeMappedResourceConfiguration$30(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeMappedResourceConfigurationResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeImageGenerationConfiguration$27(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeImageGenerationConfiguration$26(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeImageGenerationConfigurationResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeEdgeConfiguration$23(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeEdgeConfiguration$22(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeEdgeConfigurationResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteStream$19(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteStream$18(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteStreamResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteSignalingChannel$15(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteSignalingChannel$14(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteSignalingChannelResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteEdgeConfiguration$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteEdgeConfiguration$10(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteEdgeConfigurationResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createStream$7(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createStream$6(List metricPublishers, MetricCollector apiCallMetricCollector, CreateStreamResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createSignalingChannel$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createSignalingChannel$2(List metricPublishers, MetricCollector apiCallMetricCollector, CreateSignalingChannelResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }
}

