/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisvideo.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeMediaStorageConfigurationResponse extends KinesisVideoResponse implements
        ToCopyableBuilder<DescribeMediaStorageConfigurationResponse.Builder, DescribeMediaStorageConfigurationResponse> {
    private static final SdkField<MediaStorageConfiguration> MEDIA_STORAGE_CONFIGURATION_FIELD = SdkField
            .<MediaStorageConfiguration> builder(MarshallingType.SDK_POJO).memberName("MediaStorageConfiguration")
            .getter(getter(DescribeMediaStorageConfigurationResponse::mediaStorageConfiguration))
            .setter(setter(Builder::mediaStorageConfiguration)).constructor(MediaStorageConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MediaStorageConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(MEDIA_STORAGE_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final MediaStorageConfiguration mediaStorageConfiguration;

    private DescribeMediaStorageConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.mediaStorageConfiguration = builder.mediaStorageConfiguration;
    }

    /**
     * <p>
     * A structure that encapsulates, or contains, the media storage configuration properties.
     * </p>
     * 
     * @return A structure that encapsulates, or contains, the media storage configuration properties.
     */
    public final MediaStorageConfiguration mediaStorageConfiguration() {
        return mediaStorageConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(mediaStorageConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeMediaStorageConfigurationResponse)) {
            return false;
        }
        DescribeMediaStorageConfigurationResponse other = (DescribeMediaStorageConfigurationResponse) obj;
        return Objects.equals(mediaStorageConfiguration(), other.mediaStorageConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeMediaStorageConfigurationResponse")
                .add("MediaStorageConfiguration", mediaStorageConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MediaStorageConfiguration":
            return Optional.ofNullable(clazz.cast(mediaStorageConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("MediaStorageConfiguration", MEDIA_STORAGE_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeMediaStorageConfigurationResponse, T> g) {
        return obj -> g.apply((DescribeMediaStorageConfigurationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends KinesisVideoResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeMediaStorageConfigurationResponse> {
        /**
         * <p>
         * A structure that encapsulates, or contains, the media storage configuration properties.
         * </p>
         * 
         * @param mediaStorageConfiguration
         *        A structure that encapsulates, or contains, the media storage configuration properties.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mediaStorageConfiguration(MediaStorageConfiguration mediaStorageConfiguration);

        /**
         * <p>
         * A structure that encapsulates, or contains, the media storage configuration properties.
         * </p>
         * This is a convenience method that creates an instance of the {@link MediaStorageConfiguration.Builder}
         * avoiding the need to create one manually via {@link MediaStorageConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MediaStorageConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #mediaStorageConfiguration(MediaStorageConfiguration)}.
         * 
         * @param mediaStorageConfiguration
         *        a consumer that will call methods on {@link MediaStorageConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #mediaStorageConfiguration(MediaStorageConfiguration)
         */
        default Builder mediaStorageConfiguration(Consumer<MediaStorageConfiguration.Builder> mediaStorageConfiguration) {
            return mediaStorageConfiguration(MediaStorageConfiguration.builder().applyMutation(mediaStorageConfiguration).build());
        }
    }

    static final class BuilderImpl extends KinesisVideoResponse.BuilderImpl implements Builder {
        private MediaStorageConfiguration mediaStorageConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeMediaStorageConfigurationResponse model) {
            super(model);
            mediaStorageConfiguration(model.mediaStorageConfiguration);
        }

        public final MediaStorageConfiguration.Builder getMediaStorageConfiguration() {
            return mediaStorageConfiguration != null ? mediaStorageConfiguration.toBuilder() : null;
        }

        public final void setMediaStorageConfiguration(MediaStorageConfiguration.BuilderImpl mediaStorageConfiguration) {
            this.mediaStorageConfiguration = mediaStorageConfiguration != null ? mediaStorageConfiguration.build() : null;
        }

        @Override
        public final Builder mediaStorageConfiguration(MediaStorageConfiguration mediaStorageConfiguration) {
            this.mediaStorageConfiguration = mediaStorageConfiguration;
            return this;
        }

        @Override
        public DescribeMediaStorageConfigurationResponse build() {
            return new DescribeMediaStorageConfigurationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
