/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisvideo.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetDataEndpointResponse extends KinesisVideoResponse implements
        ToCopyableBuilder<GetDataEndpointResponse.Builder, GetDataEndpointResponse> {
    private static final SdkField<String> DATA_ENDPOINT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DataEndpoint").getter(getter(GetDataEndpointResponse::dataEndpoint))
            .setter(setter(Builder::dataEndpoint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataEndpoint").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_ENDPOINT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String dataEndpoint;

    private GetDataEndpointResponse(BuilderImpl builder) {
        super(builder);
        this.dataEndpoint = builder.dataEndpoint;
    }

    /**
     * <p>
     * The endpoint value. To read data from the stream or to write data to it, specify this endpoint in your
     * application.
     * </p>
     * 
     * @return The endpoint value. To read data from the stream or to write data to it, specify this endpoint in your
     *         application.
     */
    public final String dataEndpoint() {
        return dataEndpoint;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(dataEndpoint());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDataEndpointResponse)) {
            return false;
        }
        GetDataEndpointResponse other = (GetDataEndpointResponse) obj;
        return Objects.equals(dataEndpoint(), other.dataEndpoint());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetDataEndpointResponse").add("DataEndpoint", dataEndpoint()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DataEndpoint":
            return Optional.ofNullable(clazz.cast(dataEndpoint()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DataEndpoint", DATA_ENDPOINT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetDataEndpointResponse, T> g) {
        return obj -> g.apply((GetDataEndpointResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends KinesisVideoResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetDataEndpointResponse> {
        /**
         * <p>
         * The endpoint value. To read data from the stream or to write data to it, specify this endpoint in your
         * application.
         * </p>
         * 
         * @param dataEndpoint
         *        The endpoint value. To read data from the stream or to write data to it, specify this endpoint in your
         *        application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataEndpoint(String dataEndpoint);
    }

    static final class BuilderImpl extends KinesisVideoResponse.BuilderImpl implements Builder {
        private String dataEndpoint;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDataEndpointResponse model) {
            super(model);
            dataEndpoint(model.dataEndpoint);
        }

        public final String getDataEndpoint() {
            return dataEndpoint;
        }

        public final void setDataEndpoint(String dataEndpoint) {
            this.dataEndpoint = dataEndpoint;
        }

        @Override
        public final Builder dataEndpoint(String dataEndpoint) {
            this.dataEndpoint = dataEndpoint;
            return this;
        }

        @Override
        public GetDataEndpointResponse build() {
            return new GetDataEndpointResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
