/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisvideo.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetSignalingChannelEndpointResponse extends KinesisVideoResponse implements
        ToCopyableBuilder<GetSignalingChannelEndpointResponse.Builder, GetSignalingChannelEndpointResponse> {
    private static final SdkField<List<ResourceEndpointListItem>> RESOURCE_ENDPOINT_LIST_FIELD = SdkField
            .<List<ResourceEndpointListItem>> builder(MarshallingType.LIST)
            .memberName("ResourceEndpointList")
            .getter(getter(GetSignalingChannelEndpointResponse::resourceEndpointList))
            .setter(setter(Builder::resourceEndpointList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceEndpointList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ResourceEndpointListItem> builder(MarshallingType.SDK_POJO)
                                            .constructor(ResourceEndpointListItem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_ENDPOINT_LIST_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<ResourceEndpointListItem> resourceEndpointList;

    private GetSignalingChannelEndpointResponse(BuilderImpl builder) {
        super(builder);
        this.resourceEndpointList = builder.resourceEndpointList;
    }

    /**
     * For responses, this returns true if the service returned a value for the ResourceEndpointList property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasResourceEndpointList() {
        return resourceEndpointList != null && !(resourceEndpointList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of endpoints for the specified signaling channel.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasResourceEndpointList} method.
     * </p>
     * 
     * @return A list of endpoints for the specified signaling channel.
     */
    public final List<ResourceEndpointListItem> resourceEndpointList() {
        return resourceEndpointList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasResourceEndpointList() ? resourceEndpointList() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSignalingChannelEndpointResponse)) {
            return false;
        }
        GetSignalingChannelEndpointResponse other = (GetSignalingChannelEndpointResponse) obj;
        return hasResourceEndpointList() == other.hasResourceEndpointList()
                && Objects.equals(resourceEndpointList(), other.resourceEndpointList());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetSignalingChannelEndpointResponse")
                .add("ResourceEndpointList", hasResourceEndpointList() ? resourceEndpointList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ResourceEndpointList":
            return Optional.ofNullable(clazz.cast(resourceEndpointList()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ResourceEndpointList", RESOURCE_ENDPOINT_LIST_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetSignalingChannelEndpointResponse, T> g) {
        return obj -> g.apply((GetSignalingChannelEndpointResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends KinesisVideoResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetSignalingChannelEndpointResponse> {
        /**
         * <p>
         * A list of endpoints for the specified signaling channel.
         * </p>
         * 
         * @param resourceEndpointList
         *        A list of endpoints for the specified signaling channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceEndpointList(Collection<ResourceEndpointListItem> resourceEndpointList);

        /**
         * <p>
         * A list of endpoints for the specified signaling channel.
         * </p>
         * 
         * @param resourceEndpointList
         *        A list of endpoints for the specified signaling channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceEndpointList(ResourceEndpointListItem... resourceEndpointList);

        /**
         * <p>
         * A list of endpoints for the specified signaling channel.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.kinesisvideo.model.ResourceEndpointListItem.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.kinesisvideo.model.ResourceEndpointListItem#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.kinesisvideo.model.ResourceEndpointListItem.Builder#build()} is called
         * immediately and its result is passed to {@link #resourceEndpointList(List<ResourceEndpointListItem>)}.
         * 
         * @param resourceEndpointList
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.kinesisvideo.model.ResourceEndpointListItem.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceEndpointList(java.util.Collection<ResourceEndpointListItem>)
         */
        Builder resourceEndpointList(Consumer<ResourceEndpointListItem.Builder>... resourceEndpointList);
    }

    static final class BuilderImpl extends KinesisVideoResponse.BuilderImpl implements Builder {
        private List<ResourceEndpointListItem> resourceEndpointList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetSignalingChannelEndpointResponse model) {
            super(model);
            resourceEndpointList(model.resourceEndpointList);
        }

        public final List<ResourceEndpointListItem.Builder> getResourceEndpointList() {
            List<ResourceEndpointListItem.Builder> result = ResourceEndpointListCopier.copyToBuilder(this.resourceEndpointList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResourceEndpointList(Collection<ResourceEndpointListItem.BuilderImpl> resourceEndpointList) {
            this.resourceEndpointList = ResourceEndpointListCopier.copyFromBuilder(resourceEndpointList);
        }

        @Override
        public final Builder resourceEndpointList(Collection<ResourceEndpointListItem> resourceEndpointList) {
            this.resourceEndpointList = ResourceEndpointListCopier.copy(resourceEndpointList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceEndpointList(ResourceEndpointListItem... resourceEndpointList) {
            resourceEndpointList(Arrays.asList(resourceEndpointList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceEndpointList(Consumer<ResourceEndpointListItem.Builder>... resourceEndpointList) {
            resourceEndpointList(Stream.of(resourceEndpointList)
                    .map(c -> ResourceEndpointListItem.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public GetSignalingChannelEndpointResponse build() {
            return new GetSignalingChannelEndpointResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
