/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisvideo.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The latest status of a stream's edge recording job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LastRecorderStatus implements SdkPojo, Serializable,
        ToCopyableBuilder<LastRecorderStatus.Builder, LastRecorderStatus> {
    private static final SdkField<String> JOB_STATUS_DETAILS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("JobStatusDetails").getter(getter(LastRecorderStatus::jobStatusDetails))
            .setter(setter(Builder::jobStatusDetails))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobStatusDetails").build()).build();

    private static final SdkField<Instant> LAST_COLLECTED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastCollectedTime").getter(getter(LastRecorderStatus::lastCollectedTime))
            .setter(setter(Builder::lastCollectedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastCollectedTime").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastUpdatedTime").getter(getter(LastRecorderStatus::lastUpdatedTime))
            .setter(setter(Builder::lastUpdatedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedTime").build()).build();

    private static final SdkField<String> RECORDER_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RecorderStatus").getter(getter(LastRecorderStatus::recorderStatusAsString))
            .setter(setter(Builder::recorderStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecorderStatus").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_STATUS_DETAILS_FIELD,
            LAST_COLLECTED_TIME_FIELD, LAST_UPDATED_TIME_FIELD, RECORDER_STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String jobStatusDetails;

    private final Instant lastCollectedTime;

    private final Instant lastUpdatedTime;

    private final String recorderStatus;

    private LastRecorderStatus(BuilderImpl builder) {
        this.jobStatusDetails = builder.jobStatusDetails;
        this.lastCollectedTime = builder.lastCollectedTime;
        this.lastUpdatedTime = builder.lastUpdatedTime;
        this.recorderStatus = builder.recorderStatus;
    }

    /**
     * <p>
     * A description of a recorder job’s latest status.
     * </p>
     * 
     * @return A description of a recorder job’s latest status.
     */
    public final String jobStatusDetails() {
        return jobStatusDetails;
    }

    /**
     * <p>
     * The timestamp at which the recorder job was last executed and media stored to local disk.
     * </p>
     * 
     * @return The timestamp at which the recorder job was last executed and media stored to local disk.
     */
    public final Instant lastCollectedTime() {
        return lastCollectedTime;
    }

    /**
     * <p>
     * The timestamp at which the recorder status was last updated.
     * </p>
     * 
     * @return The timestamp at which the recorder status was last updated.
     */
    public final Instant lastUpdatedTime() {
        return lastUpdatedTime;
    }

    /**
     * <p>
     * The status of the latest recorder job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #recorderStatus}
     * will return {@link RecorderStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #recorderStatusAsString}.
     * </p>
     * 
     * @return The status of the latest recorder job.
     * @see RecorderStatus
     */
    public final RecorderStatus recorderStatus() {
        return RecorderStatus.fromValue(recorderStatus);
    }

    /**
     * <p>
     * The status of the latest recorder job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #recorderStatus}
     * will return {@link RecorderStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #recorderStatusAsString}.
     * </p>
     * 
     * @return The status of the latest recorder job.
     * @see RecorderStatus
     */
    public final String recorderStatusAsString() {
        return recorderStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(jobStatusDetails());
        hashCode = 31 * hashCode + Objects.hashCode(lastCollectedTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedTime());
        hashCode = 31 * hashCode + Objects.hashCode(recorderStatusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LastRecorderStatus)) {
            return false;
        }
        LastRecorderStatus other = (LastRecorderStatus) obj;
        return Objects.equals(jobStatusDetails(), other.jobStatusDetails())
                && Objects.equals(lastCollectedTime(), other.lastCollectedTime())
                && Objects.equals(lastUpdatedTime(), other.lastUpdatedTime())
                && Objects.equals(recorderStatusAsString(), other.recorderStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LastRecorderStatus").add("JobStatusDetails", jobStatusDetails())
                .add("LastCollectedTime", lastCollectedTime()).add("LastUpdatedTime", lastUpdatedTime())
                .add("RecorderStatus", recorderStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "JobStatusDetails":
            return Optional.ofNullable(clazz.cast(jobStatusDetails()));
        case "LastCollectedTime":
            return Optional.ofNullable(clazz.cast(lastCollectedTime()));
        case "LastUpdatedTime":
            return Optional.ofNullable(clazz.cast(lastUpdatedTime()));
        case "RecorderStatus":
            return Optional.ofNullable(clazz.cast(recorderStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("JobStatusDetails", JOB_STATUS_DETAILS_FIELD);
        map.put("LastCollectedTime", LAST_COLLECTED_TIME_FIELD);
        map.put("LastUpdatedTime", LAST_UPDATED_TIME_FIELD);
        map.put("RecorderStatus", RECORDER_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LastRecorderStatus, T> g) {
        return obj -> g.apply((LastRecorderStatus) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LastRecorderStatus> {
        /**
         * <p>
         * A description of a recorder job’s latest status.
         * </p>
         * 
         * @param jobStatusDetails
         *        A description of a recorder job’s latest status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobStatusDetails(String jobStatusDetails);

        /**
         * <p>
         * The timestamp at which the recorder job was last executed and media stored to local disk.
         * </p>
         * 
         * @param lastCollectedTime
         *        The timestamp at which the recorder job was last executed and media stored to local disk.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastCollectedTime(Instant lastCollectedTime);

        /**
         * <p>
         * The timestamp at which the recorder status was last updated.
         * </p>
         * 
         * @param lastUpdatedTime
         *        The timestamp at which the recorder status was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedTime(Instant lastUpdatedTime);

        /**
         * <p>
         * The status of the latest recorder job.
         * </p>
         * 
         * @param recorderStatus
         *        The status of the latest recorder job.
         * @see RecorderStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RecorderStatus
         */
        Builder recorderStatus(String recorderStatus);

        /**
         * <p>
         * The status of the latest recorder job.
         * </p>
         * 
         * @param recorderStatus
         *        The status of the latest recorder job.
         * @see RecorderStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RecorderStatus
         */
        Builder recorderStatus(RecorderStatus recorderStatus);
    }

    static final class BuilderImpl implements Builder {
        private String jobStatusDetails;

        private Instant lastCollectedTime;

        private Instant lastUpdatedTime;

        private String recorderStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(LastRecorderStatus model) {
            jobStatusDetails(model.jobStatusDetails);
            lastCollectedTime(model.lastCollectedTime);
            lastUpdatedTime(model.lastUpdatedTime);
            recorderStatus(model.recorderStatus);
        }

        public final String getJobStatusDetails() {
            return jobStatusDetails;
        }

        public final void setJobStatusDetails(String jobStatusDetails) {
            this.jobStatusDetails = jobStatusDetails;
        }

        @Override
        public final Builder jobStatusDetails(String jobStatusDetails) {
            this.jobStatusDetails = jobStatusDetails;
            return this;
        }

        public final Instant getLastCollectedTime() {
            return lastCollectedTime;
        }

        public final void setLastCollectedTime(Instant lastCollectedTime) {
            this.lastCollectedTime = lastCollectedTime;
        }

        @Override
        public final Builder lastCollectedTime(Instant lastCollectedTime) {
            this.lastCollectedTime = lastCollectedTime;
            return this;
        }

        public final Instant getLastUpdatedTime() {
            return lastUpdatedTime;
        }

        public final void setLastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
        }

        @Override
        public final Builder lastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        public final String getRecorderStatus() {
            return recorderStatus;
        }

        public final void setRecorderStatus(String recorderStatus) {
            this.recorderStatus = recorderStatus;
        }

        @Override
        public final Builder recorderStatus(String recorderStatus) {
            this.recorderStatus = recorderStatus;
            return this;
        }

        @Override
        public final Builder recorderStatus(RecorderStatus recorderStatus) {
            this.recorderStatus(recorderStatus == null ? null : recorderStatus.toString());
            return this;
        }

        @Override
        public LastRecorderStatus build() {
            return new LastRecorderStatus(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
