/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisvideo.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListEdgeAgentConfigurationsRequest extends KinesisVideoRequest implements
        ToCopyableBuilder<ListEdgeAgentConfigurationsRequest.Builder, ListEdgeAgentConfigurationsRequest> {
    private static final SdkField<String> HUB_DEVICE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HubDeviceArn").getter(getter(ListEdgeAgentConfigurationsRequest::hubDeviceArn))
            .setter(setter(Builder::hubDeviceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HubDeviceArn").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(ListEdgeAgentConfigurationsRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListEdgeAgentConfigurationsRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HUB_DEVICE_ARN_FIELD,
            MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String hubDeviceArn;

    private final Integer maxResults;

    private final String nextToken;

    private ListEdgeAgentConfigurationsRequest(BuilderImpl builder) {
        super(builder);
        this.hubDeviceArn = builder.hubDeviceArn;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The "Internet of Things (IoT) Thing" Arn of the edge agent.
     * </p>
     * 
     * @return The "Internet of Things (IoT) Thing" Arn of the edge agent.
     */
    public final String hubDeviceArn() {
        return hubDeviceArn;
    }

    /**
     * <p>
     * The maximum number of edge configurations to return in the response. The default is 5.
     * </p>
     * 
     * @return The maximum number of edge configurations to return in the response. The default is 5.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * If you specify this parameter, when the result of a <code>ListEdgeAgentConfigurations</code> operation is
     * truncated, the call returns the <code>NextToken</code> in the response. To get another batch of edge
     * configurations, provide this token in your next request.
     * </p>
     * 
     * @return If you specify this parameter, when the result of a <code>ListEdgeAgentConfigurations</code> operation is
     *         truncated, the call returns the <code>NextToken</code> in the response. To get another batch of edge
     *         configurations, provide this token in your next request.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hubDeviceArn());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListEdgeAgentConfigurationsRequest)) {
            return false;
        }
        ListEdgeAgentConfigurationsRequest other = (ListEdgeAgentConfigurationsRequest) obj;
        return Objects.equals(hubDeviceArn(), other.hubDeviceArn()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListEdgeAgentConfigurationsRequest").add("HubDeviceArn", hubDeviceArn())
                .add("MaxResults", maxResults()).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "HubDeviceArn":
            return Optional.ofNullable(clazz.cast(hubDeviceArn()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("HubDeviceArn", HUB_DEVICE_ARN_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListEdgeAgentConfigurationsRequest, T> g) {
        return obj -> g.apply((ListEdgeAgentConfigurationsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends KinesisVideoRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ListEdgeAgentConfigurationsRequest> {
        /**
         * <p>
         * The "Internet of Things (IoT) Thing" Arn of the edge agent.
         * </p>
         * 
         * @param hubDeviceArn
         *        The "Internet of Things (IoT) Thing" Arn of the edge agent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hubDeviceArn(String hubDeviceArn);

        /**
         * <p>
         * The maximum number of edge configurations to return in the response. The default is 5.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of edge configurations to return in the response. The default is 5.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * If you specify this parameter, when the result of a <code>ListEdgeAgentConfigurations</code> operation is
         * truncated, the call returns the <code>NextToken</code> in the response. To get another batch of edge
         * configurations, provide this token in your next request.
         * </p>
         * 
         * @param nextToken
         *        If you specify this parameter, when the result of a <code>ListEdgeAgentConfigurations</code> operation
         *        is truncated, the call returns the <code>NextToken</code> in the response. To get another batch of
         *        edge configurations, provide this token in your next request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends KinesisVideoRequest.BuilderImpl implements Builder {
        private String hubDeviceArn;

        private Integer maxResults;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListEdgeAgentConfigurationsRequest model) {
            super(model);
            hubDeviceArn(model.hubDeviceArn);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
        }

        public final String getHubDeviceArn() {
            return hubDeviceArn;
        }

        public final void setHubDeviceArn(String hubDeviceArn) {
            this.hubDeviceArn = hubDeviceArn;
        }

        @Override
        public final Builder hubDeviceArn(String hubDeviceArn) {
            this.hubDeviceArn = hubDeviceArn;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListEdgeAgentConfigurationsRequest build() {
            return new ListEdgeAgentConfigurationsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
