/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisvideo.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The recorder configuration consists of the local <code>MediaSourceConfig</code> details that are used as credentials
 * to accesss the local media files streamed on the camera.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RecorderConfig implements SdkPojo, Serializable, ToCopyableBuilder<RecorderConfig.Builder, RecorderConfig> {
    private static final SdkField<MediaSourceConfig> MEDIA_SOURCE_CONFIG_FIELD = SdkField
            .<MediaSourceConfig> builder(MarshallingType.SDK_POJO).memberName("MediaSourceConfig")
            .getter(getter(RecorderConfig::mediaSourceConfig)).setter(setter(Builder::mediaSourceConfig))
            .constructor(MediaSourceConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MediaSourceConfig").build()).build();

    private static final SdkField<ScheduleConfig> SCHEDULE_CONFIG_FIELD = SdkField
            .<ScheduleConfig> builder(MarshallingType.SDK_POJO).memberName("ScheduleConfig")
            .getter(getter(RecorderConfig::scheduleConfig)).setter(setter(Builder::scheduleConfig))
            .constructor(ScheduleConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScheduleConfig").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MEDIA_SOURCE_CONFIG_FIELD,
            SCHEDULE_CONFIG_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final MediaSourceConfig mediaSourceConfig;

    private final ScheduleConfig scheduleConfig;

    private RecorderConfig(BuilderImpl builder) {
        this.mediaSourceConfig = builder.mediaSourceConfig;
        this.scheduleConfig = builder.scheduleConfig;
    }

    /**
     * <p>
     * The configuration details that consist of the credentials required (<code>MediaUriSecretArn</code> and
     * <code>MediaUriType</code>) to access the media files streamed to the camera.
     * </p>
     * 
     * @return The configuration details that consist of the credentials required (<code>MediaUriSecretArn</code> and
     *         <code>MediaUriType</code>) to access the media files streamed to the camera.
     */
    public final MediaSourceConfig mediaSourceConfig() {
        return mediaSourceConfig;
    }

    /**
     * <p>
     * The configuration that consists of the <code>ScheduleExpression</code> and the <code>DurationInMinutes</code>
     * details that specify the scheduling to record from a camera, or local media file, onto the Edge Agent. If the
     * <code>ScheduleExpression</code> attribute is not provided, then the Edge Agent will always be set to recording
     * mode.
     * </p>
     * 
     * @return The configuration that consists of the <code>ScheduleExpression</code> and the
     *         <code>DurationInMinutes</code> details that specify the scheduling to record from a camera, or local
     *         media file, onto the Edge Agent. If the <code>ScheduleExpression</code> attribute is not provided, then
     *         the Edge Agent will always be set to recording mode.
     */
    public final ScheduleConfig scheduleConfig() {
        return scheduleConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(mediaSourceConfig());
        hashCode = 31 * hashCode + Objects.hashCode(scheduleConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RecorderConfig)) {
            return false;
        }
        RecorderConfig other = (RecorderConfig) obj;
        return Objects.equals(mediaSourceConfig(), other.mediaSourceConfig())
                && Objects.equals(scheduleConfig(), other.scheduleConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RecorderConfig").add("MediaSourceConfig", mediaSourceConfig())
                .add("ScheduleConfig", scheduleConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MediaSourceConfig":
            return Optional.ofNullable(clazz.cast(mediaSourceConfig()));
        case "ScheduleConfig":
            return Optional.ofNullable(clazz.cast(scheduleConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("MediaSourceConfig", MEDIA_SOURCE_CONFIG_FIELD);
        map.put("ScheduleConfig", SCHEDULE_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RecorderConfig, T> g) {
        return obj -> g.apply((RecorderConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RecorderConfig> {
        /**
         * <p>
         * The configuration details that consist of the credentials required (<code>MediaUriSecretArn</code> and
         * <code>MediaUriType</code>) to access the media files streamed to the camera.
         * </p>
         * 
         * @param mediaSourceConfig
         *        The configuration details that consist of the credentials required (<code>MediaUriSecretArn</code> and
         *        <code>MediaUriType</code>) to access the media files streamed to the camera.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mediaSourceConfig(MediaSourceConfig mediaSourceConfig);

        /**
         * <p>
         * The configuration details that consist of the credentials required (<code>MediaUriSecretArn</code> and
         * <code>MediaUriType</code>) to access the media files streamed to the camera.
         * </p>
         * This is a convenience method that creates an instance of the {@link MediaSourceConfig.Builder} avoiding the
         * need to create one manually via {@link MediaSourceConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MediaSourceConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #mediaSourceConfig(MediaSourceConfig)}.
         * 
         * @param mediaSourceConfig
         *        a consumer that will call methods on {@link MediaSourceConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #mediaSourceConfig(MediaSourceConfig)
         */
        default Builder mediaSourceConfig(Consumer<MediaSourceConfig.Builder> mediaSourceConfig) {
            return mediaSourceConfig(MediaSourceConfig.builder().applyMutation(mediaSourceConfig).build());
        }

        /**
         * <p>
         * The configuration that consists of the <code>ScheduleExpression</code> and the <code>DurationInMinutes</code>
         * details that specify the scheduling to record from a camera, or local media file, onto the Edge Agent. If the
         * <code>ScheduleExpression</code> attribute is not provided, then the Edge Agent will always be set to
         * recording mode.
         * </p>
         * 
         * @param scheduleConfig
         *        The configuration that consists of the <code>ScheduleExpression</code> and the
         *        <code>DurationInMinutes</code> details that specify the scheduling to record from a camera, or local
         *        media file, onto the Edge Agent. If the <code>ScheduleExpression</code> attribute is not provided,
         *        then the Edge Agent will always be set to recording mode.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scheduleConfig(ScheduleConfig scheduleConfig);

        /**
         * <p>
         * The configuration that consists of the <code>ScheduleExpression</code> and the <code>DurationInMinutes</code>
         * details that specify the scheduling to record from a camera, or local media file, onto the Edge Agent. If the
         * <code>ScheduleExpression</code> attribute is not provided, then the Edge Agent will always be set to
         * recording mode.
         * </p>
         * This is a convenience method that creates an instance of the {@link ScheduleConfig.Builder} avoiding the need
         * to create one manually via {@link ScheduleConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ScheduleConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #scheduleConfig(ScheduleConfig)}.
         * 
         * @param scheduleConfig
         *        a consumer that will call methods on {@link ScheduleConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #scheduleConfig(ScheduleConfig)
         */
        default Builder scheduleConfig(Consumer<ScheduleConfig.Builder> scheduleConfig) {
            return scheduleConfig(ScheduleConfig.builder().applyMutation(scheduleConfig).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private MediaSourceConfig mediaSourceConfig;

        private ScheduleConfig scheduleConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(RecorderConfig model) {
            mediaSourceConfig(model.mediaSourceConfig);
            scheduleConfig(model.scheduleConfig);
        }

        public final MediaSourceConfig.Builder getMediaSourceConfig() {
            return mediaSourceConfig != null ? mediaSourceConfig.toBuilder() : null;
        }

        public final void setMediaSourceConfig(MediaSourceConfig.BuilderImpl mediaSourceConfig) {
            this.mediaSourceConfig = mediaSourceConfig != null ? mediaSourceConfig.build() : null;
        }

        @Override
        public final Builder mediaSourceConfig(MediaSourceConfig mediaSourceConfig) {
            this.mediaSourceConfig = mediaSourceConfig;
            return this;
        }

        public final ScheduleConfig.Builder getScheduleConfig() {
            return scheduleConfig != null ? scheduleConfig.toBuilder() : null;
        }

        public final void setScheduleConfig(ScheduleConfig.BuilderImpl scheduleConfig) {
            this.scheduleConfig = scheduleConfig != null ? scheduleConfig.build() : null;
        }

        @Override
        public final Builder scheduleConfig(ScheduleConfig scheduleConfig) {
            this.scheduleConfig = scheduleConfig;
            return this;
        }

        @Override
        public RecorderConfig build() {
            return new RecorderConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
