/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisvideo.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the condition that streams must satisfy to be returned when you list streams (see the
 * <code>ListStreams</code> API). A condition has a comparison operation and a value. Currently, you can specify only
 * the <code>BEGINS_WITH</code> operator, which finds streams whose names start with a given prefix.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StreamNameCondition implements SdkPojo, Serializable,
        ToCopyableBuilder<StreamNameCondition.Builder, StreamNameCondition> {
    private static final SdkField<String> COMPARISON_OPERATOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ComparisonOperator").getter(getter(StreamNameCondition::comparisonOperatorAsString))
            .setter(setter(Builder::comparisonOperator))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComparisonOperator").build())
            .build();

    private static final SdkField<String> COMPARISON_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ComparisonValue").getter(getter(StreamNameCondition::comparisonValue))
            .setter(setter(Builder::comparisonValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComparisonValue").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPARISON_OPERATOR_FIELD,
            COMPARISON_VALUE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String comparisonOperator;

    private final String comparisonValue;

    private StreamNameCondition(BuilderImpl builder) {
        this.comparisonOperator = builder.comparisonOperator;
        this.comparisonValue = builder.comparisonValue;
    }

    /**
     * <p>
     * A comparison operator. Currently, you can specify only the <code>BEGINS_WITH</code> operator, which finds streams
     * whose names start with a given prefix.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #comparisonOperator} will return {@link ComparisonOperator#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #comparisonOperatorAsString}.
     * </p>
     * 
     * @return A comparison operator. Currently, you can specify only the <code>BEGINS_WITH</code> operator, which finds
     *         streams whose names start with a given prefix.
     * @see ComparisonOperator
     */
    public final ComparisonOperator comparisonOperator() {
        return ComparisonOperator.fromValue(comparisonOperator);
    }

    /**
     * <p>
     * A comparison operator. Currently, you can specify only the <code>BEGINS_WITH</code> operator, which finds streams
     * whose names start with a given prefix.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #comparisonOperator} will return {@link ComparisonOperator#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #comparisonOperatorAsString}.
     * </p>
     * 
     * @return A comparison operator. Currently, you can specify only the <code>BEGINS_WITH</code> operator, which finds
     *         streams whose names start with a given prefix.
     * @see ComparisonOperator
     */
    public final String comparisonOperatorAsString() {
        return comparisonOperator;
    }

    /**
     * <p>
     * A value to compare.
     * </p>
     * 
     * @return A value to compare.
     */
    public final String comparisonValue() {
        return comparisonValue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(comparisonOperatorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(comparisonValue());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StreamNameCondition)) {
            return false;
        }
        StreamNameCondition other = (StreamNameCondition) obj;
        return Objects.equals(comparisonOperatorAsString(), other.comparisonOperatorAsString())
                && Objects.equals(comparisonValue(), other.comparisonValue());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StreamNameCondition").add("ComparisonOperator", comparisonOperatorAsString())
                .add("ComparisonValue", comparisonValue()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ComparisonOperator":
            return Optional.ofNullable(clazz.cast(comparisonOperatorAsString()));
        case "ComparisonValue":
            return Optional.ofNullable(clazz.cast(comparisonValue()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ComparisonOperator", COMPARISON_OPERATOR_FIELD);
        map.put("ComparisonValue", COMPARISON_VALUE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StreamNameCondition, T> g) {
        return obj -> g.apply((StreamNameCondition) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, StreamNameCondition> {
        /**
         * <p>
         * A comparison operator. Currently, you can specify only the <code>BEGINS_WITH</code> operator, which finds
         * streams whose names start with a given prefix.
         * </p>
         * 
         * @param comparisonOperator
         *        A comparison operator. Currently, you can specify only the <code>BEGINS_WITH</code> operator, which
         *        finds streams whose names start with a given prefix.
         * @see ComparisonOperator
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ComparisonOperator
         */
        Builder comparisonOperator(String comparisonOperator);

        /**
         * <p>
         * A comparison operator. Currently, you can specify only the <code>BEGINS_WITH</code> operator, which finds
         * streams whose names start with a given prefix.
         * </p>
         * 
         * @param comparisonOperator
         *        A comparison operator. Currently, you can specify only the <code>BEGINS_WITH</code> operator, which
         *        finds streams whose names start with a given prefix.
         * @see ComparisonOperator
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ComparisonOperator
         */
        Builder comparisonOperator(ComparisonOperator comparisonOperator);

        /**
         * <p>
         * A value to compare.
         * </p>
         * 
         * @param comparisonValue
         *        A value to compare.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder comparisonValue(String comparisonValue);
    }

    static final class BuilderImpl implements Builder {
        private String comparisonOperator;

        private String comparisonValue;

        private BuilderImpl() {
        }

        private BuilderImpl(StreamNameCondition model) {
            comparisonOperator(model.comparisonOperator);
            comparisonValue(model.comparisonValue);
        }

        public final String getComparisonOperator() {
            return comparisonOperator;
        }

        public final void setComparisonOperator(String comparisonOperator) {
            this.comparisonOperator = comparisonOperator;
        }

        @Override
        public final Builder comparisonOperator(String comparisonOperator) {
            this.comparisonOperator = comparisonOperator;
            return this;
        }

        @Override
        public final Builder comparisonOperator(ComparisonOperator comparisonOperator) {
            this.comparisonOperator(comparisonOperator == null ? null : comparisonOperator.toString());
            return this;
        }

        public final String getComparisonValue() {
            return comparisonValue;
        }

        public final void setComparisonValue(String comparisonValue) {
            this.comparisonValue = comparisonValue;
        }

        @Override
        public final Builder comparisonValue(String comparisonValue) {
            this.comparisonValue = comparisonValue;
            return this;
        }

        @Override
        public StreamNameCondition build() {
            return new StreamNameCondition(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
