/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisvideo.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.kinesisvideo.model.KinesisVideoRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteSignalingChannelRequest
extends KinesisVideoRequest
implements ToCopyableBuilder<Builder, DeleteSignalingChannelRequest> {
    private static final SdkField<String> CHANNEL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ChannelARN").getter(DeleteSignalingChannelRequest.getter(DeleteSignalingChannelRequest::channelARN)).setter(DeleteSignalingChannelRequest.setter(Builder::channelARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChannelARN").build()}).build();
    private static final SdkField<String> CURRENT_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CurrentVersion").getter(DeleteSignalingChannelRequest.getter(DeleteSignalingChannelRequest::currentVersion)).setter(DeleteSignalingChannelRequest.setter(Builder::currentVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrentVersion").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANNEL_ARN_FIELD, CURRENT_VERSION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DeleteSignalingChannelRequest.memberNameToFieldInitializer();
    private final String channelARN;
    private final String currentVersion;

    private DeleteSignalingChannelRequest(BuilderImpl builder) {
        super(builder);
        this.channelARN = builder.channelARN;
        this.currentVersion = builder.currentVersion;
    }

    public final String channelARN() {
        return this.channelARN;
    }

    public final String currentVersion() {
        return this.currentVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.channelARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.currentVersion());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteSignalingChannelRequest)) {
            return false;
        }
        DeleteSignalingChannelRequest other = (DeleteSignalingChannelRequest)((Object)obj);
        return Objects.equals(this.channelARN(), other.channelARN()) && Objects.equals(this.currentVersion(), other.currentVersion());
    }

    public final String toString() {
        return ToString.builder((String)"DeleteSignalingChannelRequest").add("ChannelARN", (Object)this.channelARN()).add("CurrentVersion", (Object)this.currentVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ChannelARN": {
                return Optional.ofNullable(clazz.cast(this.channelARN()));
            }
            case "CurrentVersion": {
                return Optional.ofNullable(clazz.cast(this.currentVersion()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("ChannelARN", CHANNEL_ARN_FIELD);
        map.put("CurrentVersion", CURRENT_VERSION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteSignalingChannelRequest, T> g) {
        return obj -> g.apply((DeleteSignalingChannelRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends KinesisVideoRequest.BuilderImpl
    implements Builder {
        private String channelARN;
        private String currentVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteSignalingChannelRequest model) {
            super(model);
            this.channelARN(model.channelARN);
            this.currentVersion(model.currentVersion);
        }

        public final String getChannelARN() {
            return this.channelARN;
        }

        public final void setChannelARN(String channelARN) {
            this.channelARN = channelARN;
        }

        @Override
        public final Builder channelARN(String channelARN) {
            this.channelARN = channelARN;
            return this;
        }

        public final String getCurrentVersion() {
            return this.currentVersion;
        }

        public final void setCurrentVersion(String currentVersion) {
            this.currentVersion = currentVersion;
        }

        @Override
        public final Builder currentVersion(String currentVersion) {
            this.currentVersion = currentVersion;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteSignalingChannelRequest build() {
            return new DeleteSignalingChannelRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends KinesisVideoRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteSignalingChannelRequest> {
        public Builder channelARN(String var1);

        public Builder currentVersion(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

