/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisvideo.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.kinesisvideo.model.KinesisVideoRequest;
import software.amazon.awssdk.services.kinesisvideo.model.UpdateDataRetentionOperation;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateDataRetentionRequest
extends KinesisVideoRequest
implements ToCopyableBuilder<Builder, UpdateDataRetentionRequest> {
    private static final SdkField<String> STREAM_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateDataRetentionRequest.getter(UpdateDataRetentionRequest::streamName)).setter(UpdateDataRetentionRequest.setter(Builder::streamName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamName").build()}).build();
    private static final SdkField<String> STREAM_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateDataRetentionRequest.getter(UpdateDataRetentionRequest::streamARN)).setter(UpdateDataRetentionRequest.setter(Builder::streamARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamARN").build()}).build();
    private static final SdkField<String> CURRENT_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateDataRetentionRequest.getter(UpdateDataRetentionRequest::currentVersion)).setter(UpdateDataRetentionRequest.setter(Builder::currentVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrentVersion").build()}).build();
    private static final SdkField<String> OPERATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateDataRetentionRequest.getter(UpdateDataRetentionRequest::operationAsString)).setter(UpdateDataRetentionRequest.setter(Builder::operation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Operation").build()}).build();
    private static final SdkField<Integer> DATA_RETENTION_CHANGE_IN_HOURS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(UpdateDataRetentionRequest.getter(UpdateDataRetentionRequest::dataRetentionChangeInHours)).setter(UpdateDataRetentionRequest.setter(Builder::dataRetentionChangeInHours)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataRetentionChangeInHours").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STREAM_NAME_FIELD, STREAM_ARN_FIELD, CURRENT_VERSION_FIELD, OPERATION_FIELD, DATA_RETENTION_CHANGE_IN_HOURS_FIELD));
    private final String streamName;
    private final String streamARN;
    private final String currentVersion;
    private final String operation;
    private final Integer dataRetentionChangeInHours;

    private UpdateDataRetentionRequest(BuilderImpl builder) {
        super(builder);
        this.streamName = builder.streamName;
        this.streamARN = builder.streamARN;
        this.currentVersion = builder.currentVersion;
        this.operation = builder.operation;
        this.dataRetentionChangeInHours = builder.dataRetentionChangeInHours;
    }

    public String streamName() {
        return this.streamName;
    }

    public String streamARN() {
        return this.streamARN;
    }

    public String currentVersion() {
        return this.currentVersion;
    }

    public UpdateDataRetentionOperation operation() {
        return UpdateDataRetentionOperation.fromValue(this.operation);
    }

    public String operationAsString() {
        return this.operation;
    }

    public Integer dataRetentionChangeInHours() {
        return this.dataRetentionChangeInHours;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.streamName());
        hashCode = 31 * hashCode + Objects.hashCode(this.streamARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.currentVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.operationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataRetentionChangeInHours());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDataRetentionRequest)) {
            return false;
        }
        UpdateDataRetentionRequest other = (UpdateDataRetentionRequest)((Object)obj);
        return Objects.equals(this.streamName(), other.streamName()) && Objects.equals(this.streamARN(), other.streamARN()) && Objects.equals(this.currentVersion(), other.currentVersion()) && Objects.equals(this.operationAsString(), other.operationAsString()) && Objects.equals(this.dataRetentionChangeInHours(), other.dataRetentionChangeInHours());
    }

    public String toString() {
        return ToString.builder((String)"UpdateDataRetentionRequest").add("StreamName", (Object)this.streamName()).add("StreamARN", (Object)this.streamARN()).add("CurrentVersion", (Object)this.currentVersion()).add("Operation", (Object)this.operationAsString()).add("DataRetentionChangeInHours", (Object)this.dataRetentionChangeInHours()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StreamName": {
                return Optional.ofNullable(clazz.cast(this.streamName()));
            }
            case "StreamARN": {
                return Optional.ofNullable(clazz.cast(this.streamARN()));
            }
            case "CurrentVersion": {
                return Optional.ofNullable(clazz.cast(this.currentVersion()));
            }
            case "Operation": {
                return Optional.ofNullable(clazz.cast(this.operationAsString()));
            }
            case "DataRetentionChangeInHours": {
                return Optional.ofNullable(clazz.cast(this.dataRetentionChangeInHours()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateDataRetentionRequest, T> g) {
        return obj -> g.apply((UpdateDataRetentionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends KinesisVideoRequest.BuilderImpl
    implements Builder {
        private String streamName;
        private String streamARN;
        private String currentVersion;
        private String operation;
        private Integer dataRetentionChangeInHours;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateDataRetentionRequest model) {
            super(model);
            this.streamName(model.streamName);
            this.streamARN(model.streamARN);
            this.currentVersion(model.currentVersion);
            this.operation(model.operation);
            this.dataRetentionChangeInHours(model.dataRetentionChangeInHours);
        }

        public final String getStreamName() {
            return this.streamName;
        }

        @Override
        public final Builder streamName(String streamName) {
            this.streamName = streamName;
            return this;
        }

        public final void setStreamName(String streamName) {
            this.streamName = streamName;
        }

        public final String getStreamARN() {
            return this.streamARN;
        }

        @Override
        public final Builder streamARN(String streamARN) {
            this.streamARN = streamARN;
            return this;
        }

        public final void setStreamARN(String streamARN) {
            this.streamARN = streamARN;
        }

        public final String getCurrentVersion() {
            return this.currentVersion;
        }

        @Override
        public final Builder currentVersion(String currentVersion) {
            this.currentVersion = currentVersion;
            return this;
        }

        public final void setCurrentVersion(String currentVersion) {
            this.currentVersion = currentVersion;
        }

        public final String getOperationAsString() {
            return this.operation;
        }

        @Override
        public final Builder operation(String operation) {
            this.operation = operation;
            return this;
        }

        @Override
        public final Builder operation(UpdateDataRetentionOperation operation) {
            this.operation(operation.toString());
            return this;
        }

        public final void setOperation(String operation) {
            this.operation = operation;
        }

        public final Integer getDataRetentionChangeInHours() {
            return this.dataRetentionChangeInHours;
        }

        @Override
        public final Builder dataRetentionChangeInHours(Integer dataRetentionChangeInHours) {
            this.dataRetentionChangeInHours = dataRetentionChangeInHours;
            return this;
        }

        public final void setDataRetentionChangeInHours(Integer dataRetentionChangeInHours) {
            this.dataRetentionChangeInHours = dataRetentionChangeInHours;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateDataRetentionRequest build() {
            return new UpdateDataRetentionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends KinesisVideoRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateDataRetentionRequest> {
        public Builder streamName(String var1);

        public Builder streamARN(String var1);

        public Builder currentVersion(String var1);

        public Builder operation(String var1);

        public Builder operation(UpdateDataRetentionOperation var1);

        public Builder dataRetentionChangeInHours(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

