/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisvideoarchivedmedia.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the timestamp range and timestamp origin of a range of fragments.
 * </p>
 * <p>
 * Fragments that have duplicate producer timestamps are deduplicated. This means that if producers are producing a
 * stream of fragments with producer timestamps that are approximately equal to the true clock time, the clip will
 * contain all of the fragments within the requested timestamp range. If some fragments are ingested within the same
 * time range and very different points in time, only the oldest ingested collection of fragments are returned.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ClipFragmentSelector implements SdkPojo, Serializable,
        ToCopyableBuilder<ClipFragmentSelector.Builder, ClipFragmentSelector> {
    private static final SdkField<String> FRAGMENT_SELECTOR_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ClipFragmentSelector::fragmentSelectorTypeAsString)).setter(setter(Builder::fragmentSelectorType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FragmentSelectorType").build())
            .build();

    private static final SdkField<ClipTimestampRange> TIMESTAMP_RANGE_FIELD = SdkField
            .<ClipTimestampRange> builder(MarshallingType.SDK_POJO).getter(getter(ClipFragmentSelector::timestampRange))
            .setter(setter(Builder::timestampRange)).constructor(ClipTimestampRange::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimestampRange").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FRAGMENT_SELECTOR_TYPE_FIELD,
            TIMESTAMP_RANGE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String fragmentSelectorType;

    private final ClipTimestampRange timestampRange;

    private ClipFragmentSelector(BuilderImpl builder) {
        this.fragmentSelectorType = builder.fragmentSelectorType;
        this.timestampRange = builder.timestampRange;
    }

    /**
     * <p>
     * The origin of the timestamps to use (Server or Producer).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #fragmentSelectorType} will return {@link ClipFragmentSelectorType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #fragmentSelectorTypeAsString}.
     * </p>
     * 
     * @return The origin of the timestamps to use (Server or Producer).
     * @see ClipFragmentSelectorType
     */
    public ClipFragmentSelectorType fragmentSelectorType() {
        return ClipFragmentSelectorType.fromValue(fragmentSelectorType);
    }

    /**
     * <p>
     * The origin of the timestamps to use (Server or Producer).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #fragmentSelectorType} will return {@link ClipFragmentSelectorType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #fragmentSelectorTypeAsString}.
     * </p>
     * 
     * @return The origin of the timestamps to use (Server or Producer).
     * @see ClipFragmentSelectorType
     */
    public String fragmentSelectorTypeAsString() {
        return fragmentSelectorType;
    }

    /**
     * <p>
     * The range of timestamps to return.
     * </p>
     * 
     * @return The range of timestamps to return.
     */
    public ClipTimestampRange timestampRange() {
        return timestampRange;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(fragmentSelectorTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(timestampRange());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClipFragmentSelector)) {
            return false;
        }
        ClipFragmentSelector other = (ClipFragmentSelector) obj;
        return Objects.equals(fragmentSelectorTypeAsString(), other.fragmentSelectorTypeAsString())
                && Objects.equals(timestampRange(), other.timestampRange());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ClipFragmentSelector").add("FragmentSelectorType", fragmentSelectorTypeAsString())
                .add("TimestampRange", timestampRange()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FragmentSelectorType":
            return Optional.ofNullable(clazz.cast(fragmentSelectorTypeAsString()));
        case "TimestampRange":
            return Optional.ofNullable(clazz.cast(timestampRange()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ClipFragmentSelector, T> g) {
        return obj -> g.apply((ClipFragmentSelector) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ClipFragmentSelector> {
        /**
         * <p>
         * The origin of the timestamps to use (Server or Producer).
         * </p>
         * 
         * @param fragmentSelectorType
         *        The origin of the timestamps to use (Server or Producer).
         * @see ClipFragmentSelectorType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ClipFragmentSelectorType
         */
        Builder fragmentSelectorType(String fragmentSelectorType);

        /**
         * <p>
         * The origin of the timestamps to use (Server or Producer).
         * </p>
         * 
         * @param fragmentSelectorType
         *        The origin of the timestamps to use (Server or Producer).
         * @see ClipFragmentSelectorType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ClipFragmentSelectorType
         */
        Builder fragmentSelectorType(ClipFragmentSelectorType fragmentSelectorType);

        /**
         * <p>
         * The range of timestamps to return.
         * </p>
         * 
         * @param timestampRange
         *        The range of timestamps to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timestampRange(ClipTimestampRange timestampRange);

        /**
         * <p>
         * The range of timestamps to return.
         * </p>
         * This is a convenience that creates an instance of the {@link ClipTimestampRange.Builder} avoiding the need to
         * create one manually via {@link ClipTimestampRange#builder()}.
         *
         * When the {@link Consumer} completes, {@link ClipTimestampRange.Builder#build()} is called immediately and its
         * result is passed to {@link #timestampRange(ClipTimestampRange)}.
         * 
         * @param timestampRange
         *        a consumer that will call methods on {@link ClipTimestampRange.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #timestampRange(ClipTimestampRange)
         */
        default Builder timestampRange(Consumer<ClipTimestampRange.Builder> timestampRange) {
            return timestampRange(ClipTimestampRange.builder().applyMutation(timestampRange).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String fragmentSelectorType;

        private ClipTimestampRange timestampRange;

        private BuilderImpl() {
        }

        private BuilderImpl(ClipFragmentSelector model) {
            fragmentSelectorType(model.fragmentSelectorType);
            timestampRange(model.timestampRange);
        }

        public final String getFragmentSelectorType() {
            return fragmentSelectorType;
        }

        @Override
        public final Builder fragmentSelectorType(String fragmentSelectorType) {
            this.fragmentSelectorType = fragmentSelectorType;
            return this;
        }

        @Override
        public final Builder fragmentSelectorType(ClipFragmentSelectorType fragmentSelectorType) {
            this.fragmentSelectorType(fragmentSelectorType == null ? null : fragmentSelectorType.toString());
            return this;
        }

        public final void setFragmentSelectorType(String fragmentSelectorType) {
            this.fragmentSelectorType = fragmentSelectorType;
        }

        public final ClipTimestampRange.Builder getTimestampRange() {
            return timestampRange != null ? timestampRange.toBuilder() : null;
        }

        @Override
        public final Builder timestampRange(ClipTimestampRange timestampRange) {
            this.timestampRange = timestampRange;
            return this;
        }

        public final void setTimestampRange(ClipTimestampRange.BuilderImpl timestampRange) {
            this.timestampRange = timestampRange != null ? timestampRange.build() : null;
        }

        @Override
        public ClipFragmentSelector build() {
            return new ClipFragmentSelector(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
