/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisvideoarchivedmedia.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The range of timestamps for which to return fragments.
 * </p>
 * <p>
 * The values in the ClipTimestampRange are <code>inclusive</code>. Fragments that begin before the start time but
 * continue past it, or fragments that begin before the end time but continue past it, are included in the session.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ClipTimestampRange implements SdkPojo, Serializable,
        ToCopyableBuilder<ClipTimestampRange.Builder, ClipTimestampRange> {
    private static final SdkField<Instant> START_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("StartTimestamp").getter(getter(ClipTimestampRange::startTimestamp))
            .setter(setter(Builder::startTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTimestamp").build()).build();

    private static final SdkField<Instant> END_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("EndTimestamp").getter(getter(ClipTimestampRange::endTimestamp)).setter(setter(Builder::endTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTimestamp").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(START_TIMESTAMP_FIELD,
            END_TIMESTAMP_FIELD));

    private static final long serialVersionUID = 1L;

    private final Instant startTimestamp;

    private final Instant endTimestamp;

    private ClipTimestampRange(BuilderImpl builder) {
        this.startTimestamp = builder.startTimestamp;
        this.endTimestamp = builder.endTimestamp;
    }

    /**
     * <p>
     * The starting timestamp in the range of timestamps for which to return fragments.
     * </p>
     * <p>
     * This value is inclusive. Fragments that start before the <code>StartTimestamp</code> and continue past it are
     * included in the session. If <code>FragmentSelectorType</code> is <code>SERVER_TIMESTAMP</code>, the
     * <code>StartTimestamp</code> must be later than the stream head.
     * </p>
     * 
     * @return The starting timestamp in the range of timestamps for which to return fragments. </p>
     *         <p>
     *         This value is inclusive. Fragments that start before the <code>StartTimestamp</code> and continue past it
     *         are included in the session. If <code>FragmentSelectorType</code> is <code>SERVER_TIMESTAMP</code>, the
     *         <code>StartTimestamp</code> must be later than the stream head.
     */
    public Instant startTimestamp() {
        return startTimestamp;
    }

    /**
     * <p>
     * The end of the timestamp range for the requested media.
     * </p>
     * <p>
     * This value must be within 3 hours of the specified <code>StartTimestamp</code>, and it must be later than the
     * <code>StartTimestamp</code> value. If <code>FragmentSelectorType</code> for the request is
     * <code>SERVER_TIMESTAMP</code>, this value must be in the past.
     * </p>
     * <p>
     * This value is inclusive. The <code>EndTimestamp</code> is compared to the (starting) timestamp of the fragment.
     * Fragments that start before the <code>EndTimestamp</code> value and continue past it are included in the session.
     * </p>
     * 
     * @return The end of the timestamp range for the requested media.</p>
     *         <p>
     *         This value must be within 3 hours of the specified <code>StartTimestamp</code>, and it must be later than
     *         the <code>StartTimestamp</code> value. If <code>FragmentSelectorType</code> for the request is
     *         <code>SERVER_TIMESTAMP</code>, this value must be in the past.
     *         </p>
     *         <p>
     *         This value is inclusive. The <code>EndTimestamp</code> is compared to the (starting) timestamp of the
     *         fragment. Fragments that start before the <code>EndTimestamp</code> value and continue past it are
     *         included in the session.
     */
    public Instant endTimestamp() {
        return endTimestamp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(startTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(endTimestamp());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClipTimestampRange)) {
            return false;
        }
        ClipTimestampRange other = (ClipTimestampRange) obj;
        return Objects.equals(startTimestamp(), other.startTimestamp()) && Objects.equals(endTimestamp(), other.endTimestamp());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ClipTimestampRange").add("StartTimestamp", startTimestamp()).add("EndTimestamp", endTimestamp())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StartTimestamp":
            return Optional.ofNullable(clazz.cast(startTimestamp()));
        case "EndTimestamp":
            return Optional.ofNullable(clazz.cast(endTimestamp()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ClipTimestampRange, T> g) {
        return obj -> g.apply((ClipTimestampRange) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ClipTimestampRange> {
        /**
         * <p>
         * The starting timestamp in the range of timestamps for which to return fragments.
         * </p>
         * <p>
         * This value is inclusive. Fragments that start before the <code>StartTimestamp</code> and continue past it are
         * included in the session. If <code>FragmentSelectorType</code> is <code>SERVER_TIMESTAMP</code>, the
         * <code>StartTimestamp</code> must be later than the stream head.
         * </p>
         * 
         * @param startTimestamp
         *        The starting timestamp in the range of timestamps for which to return fragments. </p>
         *        <p>
         *        This value is inclusive. Fragments that start before the <code>StartTimestamp</code> and continue past
         *        it are included in the session. If <code>FragmentSelectorType</code> is <code>SERVER_TIMESTAMP</code>,
         *        the <code>StartTimestamp</code> must be later than the stream head.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTimestamp(Instant startTimestamp);

        /**
         * <p>
         * The end of the timestamp range for the requested media.
         * </p>
         * <p>
         * This value must be within 3 hours of the specified <code>StartTimestamp</code>, and it must be later than the
         * <code>StartTimestamp</code> value. If <code>FragmentSelectorType</code> for the request is
         * <code>SERVER_TIMESTAMP</code>, this value must be in the past.
         * </p>
         * <p>
         * This value is inclusive. The <code>EndTimestamp</code> is compared to the (starting) timestamp of the
         * fragment. Fragments that start before the <code>EndTimestamp</code> value and continue past it are included
         * in the session.
         * </p>
         * 
         * @param endTimestamp
         *        The end of the timestamp range for the requested media.</p>
         *        <p>
         *        This value must be within 3 hours of the specified <code>StartTimestamp</code>, and it must be later
         *        than the <code>StartTimestamp</code> value. If <code>FragmentSelectorType</code> for the request is
         *        <code>SERVER_TIMESTAMP</code>, this value must be in the past.
         *        </p>
         *        <p>
         *        This value is inclusive. The <code>EndTimestamp</code> is compared to the (starting) timestamp of the
         *        fragment. Fragments that start before the <code>EndTimestamp</code> value and continue past it are
         *        included in the session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTimestamp(Instant endTimestamp);
    }

    static final class BuilderImpl implements Builder {
        private Instant startTimestamp;

        private Instant endTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(ClipTimestampRange model) {
            startTimestamp(model.startTimestamp);
            endTimestamp(model.endTimestamp);
        }

        public final Instant getStartTimestamp() {
            return startTimestamp;
        }

        @Override
        public final Builder startTimestamp(Instant startTimestamp) {
            this.startTimestamp = startTimestamp;
            return this;
        }

        public final void setStartTimestamp(Instant startTimestamp) {
            this.startTimestamp = startTimestamp;
        }

        public final Instant getEndTimestamp() {
            return endTimestamp;
        }

        @Override
        public final Builder endTimestamp(Instant endTimestamp) {
            this.endTimestamp = endTimestamp;
            return this;
        }

        public final void setEndTimestamp(Instant endTimestamp) {
            this.endTimestamp = endTimestamp;
        }

        @Override
        public ClipTimestampRange build() {
            return new ClipTimestampRange(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
