/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisvideoarchivedmedia.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.ClipFragmentSelector;
import software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.KinesisVideoArchivedMediaRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetClipRequest
extends KinesisVideoArchivedMediaRequest
implements ToCopyableBuilder<Builder, GetClipRequest> {
    private static final SdkField<String> STREAM_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StreamName").getter(GetClipRequest.getter(GetClipRequest::streamName)).setter(GetClipRequest.setter(Builder::streamName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamName").build()}).build();
    private static final SdkField<String> STREAM_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StreamARN").getter(GetClipRequest.getter(GetClipRequest::streamARN)).setter(GetClipRequest.setter(Builder::streamARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamARN").build()}).build();
    private static final SdkField<ClipFragmentSelector> CLIP_FRAGMENT_SELECTOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ClipFragmentSelector").getter(GetClipRequest.getter(GetClipRequest::clipFragmentSelector)).setter(GetClipRequest.setter(Builder::clipFragmentSelector)).constructor(ClipFragmentSelector::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClipFragmentSelector").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STREAM_NAME_FIELD, STREAM_ARN_FIELD, CLIP_FRAGMENT_SELECTOR_FIELD));
    private final String streamName;
    private final String streamARN;
    private final ClipFragmentSelector clipFragmentSelector;

    private GetClipRequest(BuilderImpl builder) {
        super(builder);
        this.streamName = builder.streamName;
        this.streamARN = builder.streamARN;
        this.clipFragmentSelector = builder.clipFragmentSelector;
    }

    public String streamName() {
        return this.streamName;
    }

    public String streamARN() {
        return this.streamARN;
    }

    public ClipFragmentSelector clipFragmentSelector() {
        return this.clipFragmentSelector;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.streamName());
        hashCode = 31 * hashCode + Objects.hashCode(this.streamARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.clipFragmentSelector());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetClipRequest)) {
            return false;
        }
        GetClipRequest other = (GetClipRequest)((Object)obj);
        return Objects.equals(this.streamName(), other.streamName()) && Objects.equals(this.streamARN(), other.streamARN()) && Objects.equals(this.clipFragmentSelector(), other.clipFragmentSelector());
    }

    public String toString() {
        return ToString.builder((String)"GetClipRequest").add("StreamName", (Object)this.streamName()).add("StreamARN", (Object)this.streamARN()).add("ClipFragmentSelector", (Object)this.clipFragmentSelector()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StreamName": {
                return Optional.ofNullable(clazz.cast(this.streamName()));
            }
            case "StreamARN": {
                return Optional.ofNullable(clazz.cast(this.streamARN()));
            }
            case "ClipFragmentSelector": {
                return Optional.ofNullable(clazz.cast(this.clipFragmentSelector()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetClipRequest, T> g) {
        return obj -> g.apply((GetClipRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends KinesisVideoArchivedMediaRequest.BuilderImpl
    implements Builder {
        private String streamName;
        private String streamARN;
        private ClipFragmentSelector clipFragmentSelector;

        private BuilderImpl() {
        }

        private BuilderImpl(GetClipRequest model) {
            super(model);
            this.streamName(model.streamName);
            this.streamARN(model.streamARN);
            this.clipFragmentSelector(model.clipFragmentSelector);
        }

        public final String getStreamName() {
            return this.streamName;
        }

        @Override
        public final Builder streamName(String streamName) {
            this.streamName = streamName;
            return this;
        }

        public final void setStreamName(String streamName) {
            this.streamName = streamName;
        }

        public final String getStreamARN() {
            return this.streamARN;
        }

        @Override
        public final Builder streamARN(String streamARN) {
            this.streamARN = streamARN;
            return this;
        }

        public final void setStreamARN(String streamARN) {
            this.streamARN = streamARN;
        }

        public final ClipFragmentSelector.Builder getClipFragmentSelector() {
            return this.clipFragmentSelector != null ? this.clipFragmentSelector.toBuilder() : null;
        }

        @Override
        public final Builder clipFragmentSelector(ClipFragmentSelector clipFragmentSelector) {
            this.clipFragmentSelector = clipFragmentSelector;
            return this;
        }

        public final void setClipFragmentSelector(ClipFragmentSelector.BuilderImpl clipFragmentSelector) {
            this.clipFragmentSelector = clipFragmentSelector != null ? clipFragmentSelector.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetClipRequest build() {
            return new GetClipRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends KinesisVideoArchivedMediaRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetClipRequest> {
        public Builder streamName(String var1);

        public Builder streamARN(String var1);

        public Builder clipFragmentSelector(ClipFragmentSelector var1);

        default public Builder clipFragmentSelector(Consumer<ClipFragmentSelector.Builder> clipFragmentSelector) {
            return this.clipFragmentSelector((ClipFragmentSelector)((ClipFragmentSelector.Builder)ClipFragmentSelector.builder().applyMutation(clipFragmentSelector)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

