/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisvideoarchivedmedia.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.FragmentSelector;
import software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.KinesisVideoArchivedMediaRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListFragmentsRequest
extends KinesisVideoArchivedMediaRequest
implements ToCopyableBuilder<Builder, ListFragmentsRequest> {
    private static final SdkField<String> STREAM_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StreamName").getter(ListFragmentsRequest.getter(ListFragmentsRequest::streamName)).setter(ListFragmentsRequest.setter(Builder::streamName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamName").build()}).build();
    private static final SdkField<String> STREAM_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StreamARN").getter(ListFragmentsRequest.getter(ListFragmentsRequest::streamARN)).setter(ListFragmentsRequest.setter(Builder::streamARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamARN").build()}).build();
    private static final SdkField<Long> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("MaxResults").getter(ListFragmentsRequest.getter(ListFragmentsRequest::maxResults)).setter(ListFragmentsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListFragmentsRequest.getter(ListFragmentsRequest::nextToken)).setter(ListFragmentsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<FragmentSelector> FRAGMENT_SELECTOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("FragmentSelector").getter(ListFragmentsRequest.getter(ListFragmentsRequest::fragmentSelector)).setter(ListFragmentsRequest.setter(Builder::fragmentSelector)).constructor(FragmentSelector::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FragmentSelector").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STREAM_NAME_FIELD, STREAM_ARN_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, FRAGMENT_SELECTOR_FIELD));
    private final String streamName;
    private final String streamARN;
    private final Long maxResults;
    private final String nextToken;
    private final FragmentSelector fragmentSelector;

    private ListFragmentsRequest(BuilderImpl builder) {
        super(builder);
        this.streamName = builder.streamName;
        this.streamARN = builder.streamARN;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.fragmentSelector = builder.fragmentSelector;
    }

    public final String streamName() {
        return this.streamName;
    }

    public final String streamARN() {
        return this.streamARN;
    }

    public final Long maxResults() {
        return this.maxResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final FragmentSelector fragmentSelector() {
        return this.fragmentSelector;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.streamName());
        hashCode = 31 * hashCode + Objects.hashCode(this.streamARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.fragmentSelector());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListFragmentsRequest)) {
            return false;
        }
        ListFragmentsRequest other = (ListFragmentsRequest)((Object)obj);
        return Objects.equals(this.streamName(), other.streamName()) && Objects.equals(this.streamARN(), other.streamARN()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.fragmentSelector(), other.fragmentSelector());
    }

    public final String toString() {
        return ToString.builder((String)"ListFragmentsRequest").add("StreamName", (Object)this.streamName()).add("StreamARN", (Object)this.streamARN()).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).add("FragmentSelector", (Object)this.fragmentSelector()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StreamName": {
                return Optional.ofNullable(clazz.cast(this.streamName()));
            }
            case "StreamARN": {
                return Optional.ofNullable(clazz.cast(this.streamARN()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "FragmentSelector": {
                return Optional.ofNullable(clazz.cast(this.fragmentSelector()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListFragmentsRequest, T> g) {
        return obj -> g.apply((ListFragmentsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends KinesisVideoArchivedMediaRequest.BuilderImpl
    implements Builder {
        private String streamName;
        private String streamARN;
        private Long maxResults;
        private String nextToken;
        private FragmentSelector fragmentSelector;

        private BuilderImpl() {
        }

        private BuilderImpl(ListFragmentsRequest model) {
            super(model);
            this.streamName(model.streamName);
            this.streamARN(model.streamARN);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
            this.fragmentSelector(model.fragmentSelector);
        }

        public final String getStreamName() {
            return this.streamName;
        }

        @Override
        public final Builder streamName(String streamName) {
            this.streamName = streamName;
            return this;
        }

        public final void setStreamName(String streamName) {
            this.streamName = streamName;
        }

        public final String getStreamARN() {
            return this.streamARN;
        }

        @Override
        public final Builder streamARN(String streamARN) {
            this.streamARN = streamARN;
            return this;
        }

        public final void setStreamARN(String streamARN) {
            this.streamARN = streamARN;
        }

        public final Long getMaxResults() {
            return this.maxResults;
        }

        @Override
        public final Builder maxResults(Long maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Long maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final FragmentSelector.Builder getFragmentSelector() {
            return this.fragmentSelector != null ? this.fragmentSelector.toBuilder() : null;
        }

        @Override
        public final Builder fragmentSelector(FragmentSelector fragmentSelector) {
            this.fragmentSelector = fragmentSelector;
            return this;
        }

        public final void setFragmentSelector(FragmentSelector.BuilderImpl fragmentSelector) {
            this.fragmentSelector = fragmentSelector != null ? fragmentSelector.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListFragmentsRequest build() {
            return new ListFragmentsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends KinesisVideoArchivedMediaRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListFragmentsRequest> {
        public Builder streamName(String var1);

        public Builder streamARN(String var1);

        public Builder maxResults(Long var1);

        public Builder nextToken(String var1);

        public Builder fragmentSelector(FragmentSelector var1);

        default public Builder fragmentSelector(Consumer<FragmentSelector.Builder> fragmentSelector) {
            return this.fragmentSelector((FragmentSelector)((FragmentSelector.Builder)FragmentSelector.builder().applyMutation(fragmentSelector)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

