/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisvideoarchivedmedia;

import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.sync.ResponseTransformer;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.kinesisvideoarchivedmedia.KinesisVideoArchivedMediaClient;
import software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.ClientLimitExceededException;
import software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.GetClipRequest;
import software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.GetClipResponse;
import software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.GetDashStreamingSessionUrlRequest;
import software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.GetDashStreamingSessionUrlResponse;
import software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.GetHlsStreamingSessionUrlRequest;
import software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.GetHlsStreamingSessionUrlResponse;
import software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.GetMediaForFragmentListRequest;
import software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.GetMediaForFragmentListResponse;
import software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.InvalidArgumentException;
import software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.InvalidCodecPrivateDataException;
import software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.InvalidMediaFrameException;
import software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.KinesisVideoArchivedMediaException;
import software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.KinesisVideoArchivedMediaRequest;
import software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.ListFragmentsRequest;
import software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.ListFragmentsResponse;
import software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.MissingCodecPrivateDataException;
import software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.NoDataRetentionException;
import software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.NotAuthorizedException;
import software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.ResourceNotFoundException;
import software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.UnsupportedStreamMediaTypeException;
import software.amazon.awssdk.services.kinesisvideoarchivedmedia.paginators.ListFragmentsIterable;
import software.amazon.awssdk.services.kinesisvideoarchivedmedia.transform.GetClipRequestMarshaller;
import software.amazon.awssdk.services.kinesisvideoarchivedmedia.transform.GetDashStreamingSessionUrlRequestMarshaller;
import software.amazon.awssdk.services.kinesisvideoarchivedmedia.transform.GetHlsStreamingSessionUrlRequestMarshaller;
import software.amazon.awssdk.services.kinesisvideoarchivedmedia.transform.GetMediaForFragmentListRequestMarshaller;
import software.amazon.awssdk.services.kinesisvideoarchivedmedia.transform.ListFragmentsRequestMarshaller;
import software.amazon.awssdk.utils.Logger;

@SdkInternalApi
final class DefaultKinesisVideoArchivedMediaClient
implements KinesisVideoArchivedMediaClient {
    private static final Logger log = Logger.loggerFor(DefaultKinesisVideoArchivedMediaClient.class);
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultKinesisVideoArchivedMediaClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    public final String serviceName() {
        return "kinesisvideo";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <ReturnT> ReturnT getClip(GetClipRequest getClipRequest, ResponseTransformer<GetClipResponse, ReturnT> responseTransformer) throws ResourceNotFoundException, InvalidArgumentException, ClientLimitExceededException, NotAuthorizedException, UnsupportedStreamMediaTypeException, MissingCodecPrivateDataException, InvalidCodecPrivateDataException, InvalidMediaFrameException, NoDataRetentionException, AwsServiceException, SdkClientException, KinesisVideoArchivedMediaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(true).isPayloadJson(false).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetClipResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultKinesisVideoArchivedMediaClient.resolveMetricPublishers(this.clientConfiguration, getClipRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Kinesis Video Archived Media");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetClip");
            Object object = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetClip").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getClipRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetClipRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)), responseTransformer);
            return (ReturnT)object;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultKinesisVideoArchivedMediaClient.lambda$getClip$0((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetDashStreamingSessionUrlResponse getDASHStreamingSessionURL(GetDashStreamingSessionUrlRequest getDashStreamingSessionUrlRequest) throws ResourceNotFoundException, InvalidArgumentException, ClientLimitExceededException, NotAuthorizedException, UnsupportedStreamMediaTypeException, NoDataRetentionException, MissingCodecPrivateDataException, InvalidCodecPrivateDataException, AwsServiceException, SdkClientException, KinesisVideoArchivedMediaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetDashStreamingSessionUrlResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultKinesisVideoArchivedMediaClient.resolveMetricPublishers(this.clientConfiguration, getDashStreamingSessionUrlRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Kinesis Video Archived Media");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetDASHStreamingSessionURL");
            GetDashStreamingSessionUrlResponse getDashStreamingSessionUrlResponse = (GetDashStreamingSessionUrlResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetDASHStreamingSessionURL").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getDashStreamingSessionUrlRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetDashStreamingSessionUrlRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getDashStreamingSessionUrlResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultKinesisVideoArchivedMediaClient.lambda$getDASHStreamingSessionURL$1((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetHlsStreamingSessionUrlResponse getHLSStreamingSessionURL(GetHlsStreamingSessionUrlRequest getHlsStreamingSessionUrlRequest) throws ResourceNotFoundException, InvalidArgumentException, ClientLimitExceededException, NotAuthorizedException, UnsupportedStreamMediaTypeException, NoDataRetentionException, MissingCodecPrivateDataException, InvalidCodecPrivateDataException, AwsServiceException, SdkClientException, KinesisVideoArchivedMediaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetHlsStreamingSessionUrlResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultKinesisVideoArchivedMediaClient.resolveMetricPublishers(this.clientConfiguration, getHlsStreamingSessionUrlRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Kinesis Video Archived Media");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetHLSStreamingSessionURL");
            GetHlsStreamingSessionUrlResponse getHlsStreamingSessionUrlResponse = (GetHlsStreamingSessionUrlResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetHLSStreamingSessionURL").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getHlsStreamingSessionUrlRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetHlsStreamingSessionUrlRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getHlsStreamingSessionUrlResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultKinesisVideoArchivedMediaClient.lambda$getHLSStreamingSessionURL$2((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <ReturnT> ReturnT getMediaForFragmentList(GetMediaForFragmentListRequest getMediaForFragmentListRequest, ResponseTransformer<GetMediaForFragmentListResponse, ReturnT> responseTransformer) throws ResourceNotFoundException, InvalidArgumentException, ClientLimitExceededException, NotAuthorizedException, AwsServiceException, SdkClientException, KinesisVideoArchivedMediaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(true).isPayloadJson(false).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetMediaForFragmentListResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultKinesisVideoArchivedMediaClient.resolveMetricPublishers(this.clientConfiguration, getMediaForFragmentListRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Kinesis Video Archived Media");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetMediaForFragmentList");
            Object object = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetMediaForFragmentList").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getMediaForFragmentListRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetMediaForFragmentListRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)), responseTransformer);
            return (ReturnT)object;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultKinesisVideoArchivedMediaClient.lambda$getMediaForFragmentList$3((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListFragmentsResponse listFragments(ListFragmentsRequest listFragmentsRequest) throws ResourceNotFoundException, InvalidArgumentException, ClientLimitExceededException, NotAuthorizedException, AwsServiceException, SdkClientException, KinesisVideoArchivedMediaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListFragmentsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultKinesisVideoArchivedMediaClient.resolveMetricPublishers(this.clientConfiguration, listFragmentsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Kinesis Video Archived Media");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListFragments");
            ListFragmentsResponse listFragmentsResponse = (ListFragmentsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListFragments").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listFragmentsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListFragmentsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listFragmentsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultKinesisVideoArchivedMediaClient.lambda$listFragments$4((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListFragmentsIterable listFragmentsPaginator(ListFragmentsRequest listFragmentsRequest) throws ResourceNotFoundException, InvalidArgumentException, ClientLimitExceededException, NotAuthorizedException, AwsServiceException, SdkClientException, KinesisVideoArchivedMediaException {
        return new ListFragmentsIterable(this, this.applyPaginatorUserAgent(listFragmentsRequest));
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(KinesisVideoArchivedMediaException::builder).protocol(AwsJsonProtocol.REST_JSON).protocolVersion("1.1").registerModeledException(ExceptionMetadata.builder().errorCode("NotAuthorizedException").exceptionBuilderSupplier(NotAuthorizedException::builder).httpStatusCode(Integer.valueOf(401)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidCodecPrivateDataException").exceptionBuilderSupplier(InvalidCodecPrivateDataException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidArgumentException").exceptionBuilderSupplier(InvalidArgumentException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ClientLimitExceededException").exceptionBuilderSupplier(ClientLimitExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("NoDataRetentionException").exceptionBuilderSupplier(NoDataRetentionException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").exceptionBuilderSupplier(ResourceNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("UnsupportedStreamMediaTypeException").exceptionBuilderSupplier(UnsupportedStreamMediaTypeException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidMediaFrameException").exceptionBuilderSupplier(InvalidMediaFrameException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("MissingCodecPrivateDataException").exceptionBuilderSupplier(MissingCodecPrivateDataException::builder).httpStatusCode(Integer.valueOf(400)).build());
    }

    public void close() {
        this.clientHandler.close();
    }

    private <T extends KinesisVideoArchivedMediaRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> {
            AwsRequestOverrideConfiguration.Builder cfr_ignored_0 = (AwsRequestOverrideConfiguration.Builder)b.addApiName(ApiName.builder().version("2.17.111").name("PAGINATED").build());
        };
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((KinesisVideoArchivedMediaRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }

    private static /* synthetic */ void lambda$listFragments$4(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getMediaForFragmentList$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getHLSStreamingSessionURL$2(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getDASHStreamingSessionURL$1(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getClip$0(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }
}

