/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisvideoarchivedmedia.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Fragment
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Fragment> {
    private static final SdkField<String> FRAGMENT_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FragmentNumber").getter(Fragment.getter(Fragment::fragmentNumber)).setter(Fragment.setter(Builder::fragmentNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FragmentNumber").build()}).build();
    private static final SdkField<Long> FRAGMENT_SIZE_IN_BYTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("FragmentSizeInBytes").getter(Fragment.getter(Fragment::fragmentSizeInBytes)).setter(Fragment.setter(Builder::fragmentSizeInBytes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FragmentSizeInBytes").build()}).build();
    private static final SdkField<Instant> PRODUCER_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ProducerTimestamp").getter(Fragment.getter(Fragment::producerTimestamp)).setter(Fragment.setter(Builder::producerTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProducerTimestamp").build()}).build();
    private static final SdkField<Instant> SERVER_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ServerTimestamp").getter(Fragment.getter(Fragment::serverTimestamp)).setter(Fragment.setter(Builder::serverTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerTimestamp").build()}).build();
    private static final SdkField<Long> FRAGMENT_LENGTH_IN_MILLISECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("FragmentLengthInMilliseconds").getter(Fragment.getter(Fragment::fragmentLengthInMilliseconds)).setter(Fragment.setter(Builder::fragmentLengthInMilliseconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FragmentLengthInMilliseconds").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FRAGMENT_NUMBER_FIELD, FRAGMENT_SIZE_IN_BYTES_FIELD, PRODUCER_TIMESTAMP_FIELD, SERVER_TIMESTAMP_FIELD, FRAGMENT_LENGTH_IN_MILLISECONDS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String fragmentNumber;
    private final Long fragmentSizeInBytes;
    private final Instant producerTimestamp;
    private final Instant serverTimestamp;
    private final Long fragmentLengthInMilliseconds;

    private Fragment(BuilderImpl builder) {
        this.fragmentNumber = builder.fragmentNumber;
        this.fragmentSizeInBytes = builder.fragmentSizeInBytes;
        this.producerTimestamp = builder.producerTimestamp;
        this.serverTimestamp = builder.serverTimestamp;
        this.fragmentLengthInMilliseconds = builder.fragmentLengthInMilliseconds;
    }

    public final String fragmentNumber() {
        return this.fragmentNumber;
    }

    public final Long fragmentSizeInBytes() {
        return this.fragmentSizeInBytes;
    }

    public final Instant producerTimestamp() {
        return this.producerTimestamp;
    }

    public final Instant serverTimestamp() {
        return this.serverTimestamp;
    }

    public final Long fragmentLengthInMilliseconds() {
        return this.fragmentLengthInMilliseconds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.fragmentNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.fragmentSizeInBytes());
        hashCode = 31 * hashCode + Objects.hashCode(this.producerTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.serverTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.fragmentLengthInMilliseconds());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Fragment)) {
            return false;
        }
        Fragment other = (Fragment)obj;
        return Objects.equals(this.fragmentNumber(), other.fragmentNumber()) && Objects.equals(this.fragmentSizeInBytes(), other.fragmentSizeInBytes()) && Objects.equals(this.producerTimestamp(), other.producerTimestamp()) && Objects.equals(this.serverTimestamp(), other.serverTimestamp()) && Objects.equals(this.fragmentLengthInMilliseconds(), other.fragmentLengthInMilliseconds());
    }

    public final String toString() {
        return ToString.builder((String)"Fragment").add("FragmentNumber", (Object)this.fragmentNumber()).add("FragmentSizeInBytes", (Object)this.fragmentSizeInBytes()).add("ProducerTimestamp", (Object)this.producerTimestamp()).add("ServerTimestamp", (Object)this.serverTimestamp()).add("FragmentLengthInMilliseconds", (Object)this.fragmentLengthInMilliseconds()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FragmentNumber": {
                return Optional.ofNullable(clazz.cast(this.fragmentNumber()));
            }
            case "FragmentSizeInBytes": {
                return Optional.ofNullable(clazz.cast(this.fragmentSizeInBytes()));
            }
            case "ProducerTimestamp": {
                return Optional.ofNullable(clazz.cast(this.producerTimestamp()));
            }
            case "ServerTimestamp": {
                return Optional.ofNullable(clazz.cast(this.serverTimestamp()));
            }
            case "FragmentLengthInMilliseconds": {
                return Optional.ofNullable(clazz.cast(this.fragmentLengthInMilliseconds()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Fragment, T> g) {
        return obj -> g.apply((Fragment)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String fragmentNumber;
        private Long fragmentSizeInBytes;
        private Instant producerTimestamp;
        private Instant serverTimestamp;
        private Long fragmentLengthInMilliseconds;

        private BuilderImpl() {
        }

        private BuilderImpl(Fragment model) {
            this.fragmentNumber(model.fragmentNumber);
            this.fragmentSizeInBytes(model.fragmentSizeInBytes);
            this.producerTimestamp(model.producerTimestamp);
            this.serverTimestamp(model.serverTimestamp);
            this.fragmentLengthInMilliseconds(model.fragmentLengthInMilliseconds);
        }

        public final String getFragmentNumber() {
            return this.fragmentNumber;
        }

        public final void setFragmentNumber(String fragmentNumber) {
            this.fragmentNumber = fragmentNumber;
        }

        @Override
        @Transient
        public final Builder fragmentNumber(String fragmentNumber) {
            this.fragmentNumber = fragmentNumber;
            return this;
        }

        public final Long getFragmentSizeInBytes() {
            return this.fragmentSizeInBytes;
        }

        public final void setFragmentSizeInBytes(Long fragmentSizeInBytes) {
            this.fragmentSizeInBytes = fragmentSizeInBytes;
        }

        @Override
        @Transient
        public final Builder fragmentSizeInBytes(Long fragmentSizeInBytes) {
            this.fragmentSizeInBytes = fragmentSizeInBytes;
            return this;
        }

        public final Instant getProducerTimestamp() {
            return this.producerTimestamp;
        }

        public final void setProducerTimestamp(Instant producerTimestamp) {
            this.producerTimestamp = producerTimestamp;
        }

        @Override
        @Transient
        public final Builder producerTimestamp(Instant producerTimestamp) {
            this.producerTimestamp = producerTimestamp;
            return this;
        }

        public final Instant getServerTimestamp() {
            return this.serverTimestamp;
        }

        public final void setServerTimestamp(Instant serverTimestamp) {
            this.serverTimestamp = serverTimestamp;
        }

        @Override
        @Transient
        public final Builder serverTimestamp(Instant serverTimestamp) {
            this.serverTimestamp = serverTimestamp;
            return this;
        }

        public final Long getFragmentLengthInMilliseconds() {
            return this.fragmentLengthInMilliseconds;
        }

        public final void setFragmentLengthInMilliseconds(Long fragmentLengthInMilliseconds) {
            this.fragmentLengthInMilliseconds = fragmentLengthInMilliseconds;
        }

        @Override
        @Transient
        public final Builder fragmentLengthInMilliseconds(Long fragmentLengthInMilliseconds) {
            this.fragmentLengthInMilliseconds = fragmentLengthInMilliseconds;
            return this;
        }

        public Fragment build() {
            return new Fragment(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Fragment> {
        public Builder fragmentNumber(String var1);

        public Builder fragmentSizeInBytes(Long var1);

        public Builder producerTimestamp(Instant var1);

        public Builder serverTimestamp(Instant var1);

        public Builder fragmentLengthInMilliseconds(Long var1);
    }
}

