/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisvideoarchivedmedia.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetImagesResponse extends KinesisVideoArchivedMediaResponse implements
        ToCopyableBuilder<GetImagesResponse.Builder, GetImagesResponse> {
    private static final SdkField<List<Image>> IMAGES_FIELD = SdkField
            .<List<Image>> builder(MarshallingType.LIST)
            .memberName("Images")
            .getter(getter(GetImagesResponse::images))
            .setter(setter(Builder::images))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Images").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Image> builder(MarshallingType.SDK_POJO)
                                            .constructor(Image::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(GetImagesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(IMAGES_FIELD, NEXT_TOKEN_FIELD));

    private final List<Image> images;

    private final String nextToken;

    private GetImagesResponse(BuilderImpl builder) {
        super(builder);
        this.images = builder.images;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Images property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasImages() {
        return images != null && !(images instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of images generated from the video stream. If there is no media available for the given timestamp, the
     * <code>NO_MEDIA</code> error will be listed in the output. If an error occurs while the image is being generated,
     * the <code>MEDIA_ERROR</code> will be listed in the output as the cause of the missing image.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasImages} method.
     * </p>
     * 
     * @return The list of images generated from the video stream. If there is no media available for the given
     *         timestamp, the <code>NO_MEDIA</code> error will be listed in the output. If an error occurs while the
     *         image is being generated, the <code>MEDIA_ERROR</code> will be listed in the output as the cause of the
     *         missing image.
     */
    public final List<Image> images() {
        return images;
    }

    /**
     * <p>
     * The encrypted token that was used in the request to get more images.
     * </p>
     * 
     * @return The encrypted token that was used in the request to get more images.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasImages() ? images() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetImagesResponse)) {
            return false;
        }
        GetImagesResponse other = (GetImagesResponse) obj;
        return hasImages() == other.hasImages() && Objects.equals(images(), other.images())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetImagesResponse").add("Images", hasImages() ? images() : null).add("NextToken", nextToken())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Images":
            return Optional.ofNullable(clazz.cast(images()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetImagesResponse, T> g) {
        return obj -> g.apply((GetImagesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends KinesisVideoArchivedMediaResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetImagesResponse> {
        /**
         * <p>
         * The list of images generated from the video stream. If there is no media available for the given timestamp,
         * the <code>NO_MEDIA</code> error will be listed in the output. If an error occurs while the image is being
         * generated, the <code>MEDIA_ERROR</code> will be listed in the output as the cause of the missing image.
         * </p>
         * 
         * @param images
         *        The list of images generated from the video stream. If there is no media available for the given
         *        timestamp, the <code>NO_MEDIA</code> error will be listed in the output. If an error occurs while the
         *        image is being generated, the <code>MEDIA_ERROR</code> will be listed in the output as the cause of
         *        the missing image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder images(Collection<Image> images);

        /**
         * <p>
         * The list of images generated from the video stream. If there is no media available for the given timestamp,
         * the <code>NO_MEDIA</code> error will be listed in the output. If an error occurs while the image is being
         * generated, the <code>MEDIA_ERROR</code> will be listed in the output as the cause of the missing image.
         * </p>
         * 
         * @param images
         *        The list of images generated from the video stream. If there is no media available for the given
         *        timestamp, the <code>NO_MEDIA</code> error will be listed in the output. If an error occurs while the
         *        image is being generated, the <code>MEDIA_ERROR</code> will be listed in the output as the cause of
         *        the missing image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder images(Image... images);

        /**
         * <p>
         * The list of images generated from the video stream. If there is no media available for the given timestamp,
         * the <code>NO_MEDIA</code> error will be listed in the output. If an error occurs while the image is being
         * generated, the <code>MEDIA_ERROR</code> will be listed in the output as the cause of the missing image.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<Image>.Builder} avoiding the need to
         * create one manually via {@link List<Image>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Image>.Builder#build()} is called immediately and its result
         * is passed to {@link #images(List<Image>)}.
         * 
         * @param images
         *        a consumer that will call methods on {@link List<Image>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #images(List<Image>)
         */
        Builder images(Consumer<Image.Builder>... images);

        /**
         * <p>
         * The encrypted token that was used in the request to get more images.
         * </p>
         * 
         * @param nextToken
         *        The encrypted token that was used in the request to get more images.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends KinesisVideoArchivedMediaResponse.BuilderImpl implements Builder {
        private List<Image> images = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetImagesResponse model) {
            super(model);
            images(model.images);
            nextToken(model.nextToken);
        }

        public final List<Image.Builder> getImages() {
            List<Image.Builder> result = ImagesCopier.copyToBuilder(this.images);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setImages(Collection<Image.BuilderImpl> images) {
            this.images = ImagesCopier.copyFromBuilder(images);
        }

        @Override
        public final Builder images(Collection<Image> images) {
            this.images = ImagesCopier.copy(images);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder images(Image... images) {
            images(Arrays.asList(images));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder images(Consumer<Image.Builder>... images) {
            images(Stream.of(images).map(c -> Image.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public GetImagesResponse build() {
            return new GetImagesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
