/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisvideoarchivedmedia.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetHlsStreamingSessionUrlResponse extends KinesisVideoArchivedMediaResponse implements
        ToCopyableBuilder<GetHlsStreamingSessionUrlResponse.Builder, GetHlsStreamingSessionUrlResponse> {
    private static final SdkField<String> HLS_STREAMING_SESSION_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HLSStreamingSessionURL").getter(getter(GetHlsStreamingSessionUrlResponse::hlsStreamingSessionURL))
            .setter(setter(Builder::hlsStreamingSessionURL))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HLSStreamingSessionURL").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(HLS_STREAMING_SESSION_URL_FIELD));

    private final String hlsStreamingSessionURL;

    private GetHlsStreamingSessionUrlResponse(BuilderImpl builder) {
        super(builder);
        this.hlsStreamingSessionURL = builder.hlsStreamingSessionURL;
    }

    /**
     * <p>
     * The URL (containing the session token) that a media player can use to retrieve the HLS master playlist.
     * </p>
     * 
     * @return The URL (containing the session token) that a media player can use to retrieve the HLS master playlist.
     */
    public final String hlsStreamingSessionURL() {
        return hlsStreamingSessionURL;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hlsStreamingSessionURL());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetHlsStreamingSessionUrlResponse)) {
            return false;
        }
        GetHlsStreamingSessionUrlResponse other = (GetHlsStreamingSessionUrlResponse) obj;
        return Objects.equals(hlsStreamingSessionURL(), other.hlsStreamingSessionURL());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetHlsStreamingSessionUrlResponse").add("HLSStreamingSessionURL", hlsStreamingSessionURL())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "HLSStreamingSessionURL":
            return Optional.ofNullable(clazz.cast(hlsStreamingSessionURL()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetHlsStreamingSessionUrlResponse, T> g) {
        return obj -> g.apply((GetHlsStreamingSessionUrlResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends KinesisVideoArchivedMediaResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetHlsStreamingSessionUrlResponse> {
        /**
         * <p>
         * The URL (containing the session token) that a media player can use to retrieve the HLS master playlist.
         * </p>
         * 
         * @param hlsStreamingSessionURL
         *        The URL (containing the session token) that a media player can use to retrieve the HLS master
         *        playlist.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hlsStreamingSessionURL(String hlsStreamingSessionURL);
    }

    static final class BuilderImpl extends KinesisVideoArchivedMediaResponse.BuilderImpl implements Builder {
        private String hlsStreamingSessionURL;

        private BuilderImpl() {
        }

        private BuilderImpl(GetHlsStreamingSessionUrlResponse model) {
            super(model);
            hlsStreamingSessionURL(model.hlsStreamingSessionURL);
        }

        public final String getHlsStreamingSessionURL() {
            return hlsStreamingSessionURL;
        }

        public final void setHlsStreamingSessionURL(String hlsStreamingSessionURL) {
            this.hlsStreamingSessionURL = hlsStreamingSessionURL;
        }

        @Override
        @Transient
        public final Builder hlsStreamingSessionURL(String hlsStreamingSessionURL) {
            this.hlsStreamingSessionURL = hlsStreamingSessionURL;
            return this;
        }

        @Override
        public GetHlsStreamingSessionUrlResponse build() {
            return new GetHlsStreamingSessionUrlResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
