/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisvideoarchivedmedia.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a segment of video or other time-delimited data.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Fragment implements SdkPojo, Serializable, ToCopyableBuilder<Fragment.Builder, Fragment> {
    private static final SdkField<String> FRAGMENT_NUMBER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FragmentNumber").getter(getter(Fragment::fragmentNumber)).setter(setter(Builder::fragmentNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FragmentNumber").build()).build();

    private static final SdkField<Long> FRAGMENT_SIZE_IN_BYTES_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("FragmentSizeInBytes").getter(getter(Fragment::fragmentSizeInBytes))
            .setter(setter(Builder::fragmentSizeInBytes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FragmentSizeInBytes").build())
            .build();

    private static final SdkField<Instant> PRODUCER_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("ProducerTimestamp").getter(getter(Fragment::producerTimestamp))
            .setter(setter(Builder::producerTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProducerTimestamp").build()).build();

    private static final SdkField<Instant> SERVER_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("ServerTimestamp").getter(getter(Fragment::serverTimestamp)).setter(setter(Builder::serverTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerTimestamp").build()).build();

    private static final SdkField<Long> FRAGMENT_LENGTH_IN_MILLISECONDS_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .memberName("FragmentLengthInMilliseconds")
            .getter(getter(Fragment::fragmentLengthInMilliseconds))
            .setter(setter(Builder::fragmentLengthInMilliseconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FragmentLengthInMilliseconds")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(FRAGMENT_NUMBER_FIELD, FRAGMENT_SIZE_IN_BYTES_FIELD, PRODUCER_TIMESTAMP_FIELD, SERVER_TIMESTAMP_FIELD,
                    FRAGMENT_LENGTH_IN_MILLISECONDS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String fragmentNumber;

    private final Long fragmentSizeInBytes;

    private final Instant producerTimestamp;

    private final Instant serverTimestamp;

    private final Long fragmentLengthInMilliseconds;

    private Fragment(BuilderImpl builder) {
        this.fragmentNumber = builder.fragmentNumber;
        this.fragmentSizeInBytes = builder.fragmentSizeInBytes;
        this.producerTimestamp = builder.producerTimestamp;
        this.serverTimestamp = builder.serverTimestamp;
        this.fragmentLengthInMilliseconds = builder.fragmentLengthInMilliseconds;
    }

    /**
     * <p>
     * The unique identifier of the fragment. This value monotonically increases based on the ingestion order.
     * </p>
     * 
     * @return The unique identifier of the fragment. This value monotonically increases based on the ingestion order.
     */
    public final String fragmentNumber() {
        return fragmentNumber;
    }

    /**
     * <p>
     * The total fragment size, including information about the fragment and contained media data.
     * </p>
     * 
     * @return The total fragment size, including information about the fragment and contained media data.
     */
    public final Long fragmentSizeInBytes() {
        return fragmentSizeInBytes;
    }

    /**
     * <p>
     * The timestamp from the producer corresponding to the fragment.
     * </p>
     * 
     * @return The timestamp from the producer corresponding to the fragment.
     */
    public final Instant producerTimestamp() {
        return producerTimestamp;
    }

    /**
     * <p>
     * The timestamp from the AWS server corresponding to the fragment.
     * </p>
     * 
     * @return The timestamp from the AWS server corresponding to the fragment.
     */
    public final Instant serverTimestamp() {
        return serverTimestamp;
    }

    /**
     * <p>
     * The playback duration or other time value associated with the fragment.
     * </p>
     * 
     * @return The playback duration or other time value associated with the fragment.
     */
    public final Long fragmentLengthInMilliseconds() {
        return fragmentLengthInMilliseconds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(fragmentNumber());
        hashCode = 31 * hashCode + Objects.hashCode(fragmentSizeInBytes());
        hashCode = 31 * hashCode + Objects.hashCode(producerTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(serverTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(fragmentLengthInMilliseconds());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Fragment)) {
            return false;
        }
        Fragment other = (Fragment) obj;
        return Objects.equals(fragmentNumber(), other.fragmentNumber())
                && Objects.equals(fragmentSizeInBytes(), other.fragmentSizeInBytes())
                && Objects.equals(producerTimestamp(), other.producerTimestamp())
                && Objects.equals(serverTimestamp(), other.serverTimestamp())
                && Objects.equals(fragmentLengthInMilliseconds(), other.fragmentLengthInMilliseconds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Fragment").add("FragmentNumber", fragmentNumber())
                .add("FragmentSizeInBytes", fragmentSizeInBytes()).add("ProducerTimestamp", producerTimestamp())
                .add("ServerTimestamp", serverTimestamp()).add("FragmentLengthInMilliseconds", fragmentLengthInMilliseconds())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FragmentNumber":
            return Optional.ofNullable(clazz.cast(fragmentNumber()));
        case "FragmentSizeInBytes":
            return Optional.ofNullable(clazz.cast(fragmentSizeInBytes()));
        case "ProducerTimestamp":
            return Optional.ofNullable(clazz.cast(producerTimestamp()));
        case "ServerTimestamp":
            return Optional.ofNullable(clazz.cast(serverTimestamp()));
        case "FragmentLengthInMilliseconds":
            return Optional.ofNullable(clazz.cast(fragmentLengthInMilliseconds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Fragment, T> g) {
        return obj -> g.apply((Fragment) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Fragment> {
        /**
         * <p>
         * The unique identifier of the fragment. This value monotonically increases based on the ingestion order.
         * </p>
         * 
         * @param fragmentNumber
         *        The unique identifier of the fragment. This value monotonically increases based on the ingestion
         *        order.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fragmentNumber(String fragmentNumber);

        /**
         * <p>
         * The total fragment size, including information about the fragment and contained media data.
         * </p>
         * 
         * @param fragmentSizeInBytes
         *        The total fragment size, including information about the fragment and contained media data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fragmentSizeInBytes(Long fragmentSizeInBytes);

        /**
         * <p>
         * The timestamp from the producer corresponding to the fragment.
         * </p>
         * 
         * @param producerTimestamp
         *        The timestamp from the producer corresponding to the fragment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder producerTimestamp(Instant producerTimestamp);

        /**
         * <p>
         * The timestamp from the AWS server corresponding to the fragment.
         * </p>
         * 
         * @param serverTimestamp
         *        The timestamp from the AWS server corresponding to the fragment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serverTimestamp(Instant serverTimestamp);

        /**
         * <p>
         * The playback duration or other time value associated with the fragment.
         * </p>
         * 
         * @param fragmentLengthInMilliseconds
         *        The playback duration or other time value associated with the fragment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fragmentLengthInMilliseconds(Long fragmentLengthInMilliseconds);
    }

    static final class BuilderImpl implements Builder {
        private String fragmentNumber;

        private Long fragmentSizeInBytes;

        private Instant producerTimestamp;

        private Instant serverTimestamp;

        private Long fragmentLengthInMilliseconds;

        private BuilderImpl() {
        }

        private BuilderImpl(Fragment model) {
            fragmentNumber(model.fragmentNumber);
            fragmentSizeInBytes(model.fragmentSizeInBytes);
            producerTimestamp(model.producerTimestamp);
            serverTimestamp(model.serverTimestamp);
            fragmentLengthInMilliseconds(model.fragmentLengthInMilliseconds);
        }

        public final String getFragmentNumber() {
            return fragmentNumber;
        }

        public final void setFragmentNumber(String fragmentNumber) {
            this.fragmentNumber = fragmentNumber;
        }

        @Override
        @Transient
        public final Builder fragmentNumber(String fragmentNumber) {
            this.fragmentNumber = fragmentNumber;
            return this;
        }

        public final Long getFragmentSizeInBytes() {
            return fragmentSizeInBytes;
        }

        public final void setFragmentSizeInBytes(Long fragmentSizeInBytes) {
            this.fragmentSizeInBytes = fragmentSizeInBytes;
        }

        @Override
        @Transient
        public final Builder fragmentSizeInBytes(Long fragmentSizeInBytes) {
            this.fragmentSizeInBytes = fragmentSizeInBytes;
            return this;
        }

        public final Instant getProducerTimestamp() {
            return producerTimestamp;
        }

        public final void setProducerTimestamp(Instant producerTimestamp) {
            this.producerTimestamp = producerTimestamp;
        }

        @Override
        @Transient
        public final Builder producerTimestamp(Instant producerTimestamp) {
            this.producerTimestamp = producerTimestamp;
            return this;
        }

        public final Instant getServerTimestamp() {
            return serverTimestamp;
        }

        public final void setServerTimestamp(Instant serverTimestamp) {
            this.serverTimestamp = serverTimestamp;
        }

        @Override
        @Transient
        public final Builder serverTimestamp(Instant serverTimestamp) {
            this.serverTimestamp = serverTimestamp;
            return this;
        }

        public final Long getFragmentLengthInMilliseconds() {
            return fragmentLengthInMilliseconds;
        }

        public final void setFragmentLengthInMilliseconds(Long fragmentLengthInMilliseconds) {
            this.fragmentLengthInMilliseconds = fragmentLengthInMilliseconds;
        }

        @Override
        @Transient
        public final Builder fragmentLengthInMilliseconds(Long fragmentLengthInMilliseconds) {
            this.fragmentLengthInMilliseconds = fragmentLengthInMilliseconds;
            return this;
        }

        @Override
        public Fragment build() {
            return new Fragment(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
