/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisvideoarchivedmedia.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.ContainerFormat;
import software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.HLSDiscontinuityMode;
import software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.HLSDisplayFragmentTimestamp;
import software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.HLSFragmentSelector;
import software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.HLSPlaybackMode;
import software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.KinesisVideoArchivedMediaRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetHlsStreamingSessionUrlRequest
extends KinesisVideoArchivedMediaRequest
implements ToCopyableBuilder<Builder, GetHlsStreamingSessionUrlRequest> {
    private static final SdkField<String> STREAM_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StreamName").getter(GetHlsStreamingSessionUrlRequest.getter(GetHlsStreamingSessionUrlRequest::streamName)).setter(GetHlsStreamingSessionUrlRequest.setter(Builder::streamName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamName").build()}).build();
    private static final SdkField<String> STREAM_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StreamARN").getter(GetHlsStreamingSessionUrlRequest.getter(GetHlsStreamingSessionUrlRequest::streamARN)).setter(GetHlsStreamingSessionUrlRequest.setter(Builder::streamARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamARN").build()}).build();
    private static final SdkField<String> PLAYBACK_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PlaybackMode").getter(GetHlsStreamingSessionUrlRequest.getter(GetHlsStreamingSessionUrlRequest::playbackModeAsString)).setter(GetHlsStreamingSessionUrlRequest.setter(Builder::playbackMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlaybackMode").build()}).build();
    private static final SdkField<HLSFragmentSelector> HLS_FRAGMENT_SELECTOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("HLSFragmentSelector").getter(GetHlsStreamingSessionUrlRequest.getter(GetHlsStreamingSessionUrlRequest::hlsFragmentSelector)).setter(GetHlsStreamingSessionUrlRequest.setter(Builder::hlsFragmentSelector)).constructor(HLSFragmentSelector::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HLSFragmentSelector").build()}).build();
    private static final SdkField<String> CONTAINER_FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ContainerFormat").getter(GetHlsStreamingSessionUrlRequest.getter(GetHlsStreamingSessionUrlRequest::containerFormatAsString)).setter(GetHlsStreamingSessionUrlRequest.setter(Builder::containerFormat)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContainerFormat").build()}).build();
    private static final SdkField<String> DISCONTINUITY_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DiscontinuityMode").getter(GetHlsStreamingSessionUrlRequest.getter(GetHlsStreamingSessionUrlRequest::discontinuityModeAsString)).setter(GetHlsStreamingSessionUrlRequest.setter(Builder::discontinuityMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DiscontinuityMode").build()}).build();
    private static final SdkField<String> DISPLAY_FRAGMENT_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DisplayFragmentTimestamp").getter(GetHlsStreamingSessionUrlRequest.getter(GetHlsStreamingSessionUrlRequest::displayFragmentTimestampAsString)).setter(GetHlsStreamingSessionUrlRequest.setter(Builder::displayFragmentTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisplayFragmentTimestamp").build()}).build();
    private static final SdkField<Integer> EXPIRES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Expires").getter(GetHlsStreamingSessionUrlRequest.getter(GetHlsStreamingSessionUrlRequest::expires)).setter(GetHlsStreamingSessionUrlRequest.setter(Builder::expires)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Expires").build()}).build();
    private static final SdkField<Long> MAX_MEDIA_PLAYLIST_FRAGMENT_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("MaxMediaPlaylistFragmentResults").getter(GetHlsStreamingSessionUrlRequest.getter(GetHlsStreamingSessionUrlRequest::maxMediaPlaylistFragmentResults)).setter(GetHlsStreamingSessionUrlRequest.setter(Builder::maxMediaPlaylistFragmentResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxMediaPlaylistFragmentResults").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STREAM_NAME_FIELD, STREAM_ARN_FIELD, PLAYBACK_MODE_FIELD, HLS_FRAGMENT_SELECTOR_FIELD, CONTAINER_FORMAT_FIELD, DISCONTINUITY_MODE_FIELD, DISPLAY_FRAGMENT_TIMESTAMP_FIELD, EXPIRES_FIELD, MAX_MEDIA_PLAYLIST_FRAGMENT_RESULTS_FIELD));
    private final String streamName;
    private final String streamARN;
    private final String playbackMode;
    private final HLSFragmentSelector hlsFragmentSelector;
    private final String containerFormat;
    private final String discontinuityMode;
    private final String displayFragmentTimestamp;
    private final Integer expires;
    private final Long maxMediaPlaylistFragmentResults;

    private GetHlsStreamingSessionUrlRequest(BuilderImpl builder) {
        super(builder);
        this.streamName = builder.streamName;
        this.streamARN = builder.streamARN;
        this.playbackMode = builder.playbackMode;
        this.hlsFragmentSelector = builder.hlsFragmentSelector;
        this.containerFormat = builder.containerFormat;
        this.discontinuityMode = builder.discontinuityMode;
        this.displayFragmentTimestamp = builder.displayFragmentTimestamp;
        this.expires = builder.expires;
        this.maxMediaPlaylistFragmentResults = builder.maxMediaPlaylistFragmentResults;
    }

    public final String streamName() {
        return this.streamName;
    }

    public final String streamARN() {
        return this.streamARN;
    }

    public final HLSPlaybackMode playbackMode() {
        return HLSPlaybackMode.fromValue(this.playbackMode);
    }

    public final String playbackModeAsString() {
        return this.playbackMode;
    }

    public final HLSFragmentSelector hlsFragmentSelector() {
        return this.hlsFragmentSelector;
    }

    public final ContainerFormat containerFormat() {
        return ContainerFormat.fromValue(this.containerFormat);
    }

    public final String containerFormatAsString() {
        return this.containerFormat;
    }

    public final HLSDiscontinuityMode discontinuityMode() {
        return HLSDiscontinuityMode.fromValue(this.discontinuityMode);
    }

    public final String discontinuityModeAsString() {
        return this.discontinuityMode;
    }

    public final HLSDisplayFragmentTimestamp displayFragmentTimestamp() {
        return HLSDisplayFragmentTimestamp.fromValue(this.displayFragmentTimestamp);
    }

    public final String displayFragmentTimestampAsString() {
        return this.displayFragmentTimestamp;
    }

    public final Integer expires() {
        return this.expires;
    }

    public final Long maxMediaPlaylistFragmentResults() {
        return this.maxMediaPlaylistFragmentResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.streamName());
        hashCode = 31 * hashCode + Objects.hashCode(this.streamARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.playbackModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hlsFragmentSelector());
        hashCode = 31 * hashCode + Objects.hashCode(this.containerFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.discontinuityModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.displayFragmentTimestampAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.expires());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxMediaPlaylistFragmentResults());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetHlsStreamingSessionUrlRequest)) {
            return false;
        }
        GetHlsStreamingSessionUrlRequest other = (GetHlsStreamingSessionUrlRequest)((Object)obj);
        return Objects.equals(this.streamName(), other.streamName()) && Objects.equals(this.streamARN(), other.streamARN()) && Objects.equals(this.playbackModeAsString(), other.playbackModeAsString()) && Objects.equals(this.hlsFragmentSelector(), other.hlsFragmentSelector()) && Objects.equals(this.containerFormatAsString(), other.containerFormatAsString()) && Objects.equals(this.discontinuityModeAsString(), other.discontinuityModeAsString()) && Objects.equals(this.displayFragmentTimestampAsString(), other.displayFragmentTimestampAsString()) && Objects.equals(this.expires(), other.expires()) && Objects.equals(this.maxMediaPlaylistFragmentResults(), other.maxMediaPlaylistFragmentResults());
    }

    public final String toString() {
        return ToString.builder((String)"GetHlsStreamingSessionUrlRequest").add("StreamName", (Object)this.streamName()).add("StreamARN", (Object)this.streamARN()).add("PlaybackMode", (Object)this.playbackModeAsString()).add("HLSFragmentSelector", (Object)this.hlsFragmentSelector()).add("ContainerFormat", (Object)this.containerFormatAsString()).add("DiscontinuityMode", (Object)this.discontinuityModeAsString()).add("DisplayFragmentTimestamp", (Object)this.displayFragmentTimestampAsString()).add("Expires", (Object)this.expires()).add("MaxMediaPlaylistFragmentResults", (Object)this.maxMediaPlaylistFragmentResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StreamName": {
                return Optional.ofNullable(clazz.cast(this.streamName()));
            }
            case "StreamARN": {
                return Optional.ofNullable(clazz.cast(this.streamARN()));
            }
            case "PlaybackMode": {
                return Optional.ofNullable(clazz.cast(this.playbackModeAsString()));
            }
            case "HLSFragmentSelector": {
                return Optional.ofNullable(clazz.cast(this.hlsFragmentSelector()));
            }
            case "ContainerFormat": {
                return Optional.ofNullable(clazz.cast(this.containerFormatAsString()));
            }
            case "DiscontinuityMode": {
                return Optional.ofNullable(clazz.cast(this.discontinuityModeAsString()));
            }
            case "DisplayFragmentTimestamp": {
                return Optional.ofNullable(clazz.cast(this.displayFragmentTimestampAsString()));
            }
            case "Expires": {
                return Optional.ofNullable(clazz.cast(this.expires()));
            }
            case "MaxMediaPlaylistFragmentResults": {
                return Optional.ofNullable(clazz.cast(this.maxMediaPlaylistFragmentResults()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetHlsStreamingSessionUrlRequest, T> g) {
        return obj -> g.apply((GetHlsStreamingSessionUrlRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends KinesisVideoArchivedMediaRequest.BuilderImpl
    implements Builder {
        private String streamName;
        private String streamARN;
        private String playbackMode;
        private HLSFragmentSelector hlsFragmentSelector;
        private String containerFormat;
        private String discontinuityMode;
        private String displayFragmentTimestamp;
        private Integer expires;
        private Long maxMediaPlaylistFragmentResults;

        private BuilderImpl() {
        }

        private BuilderImpl(GetHlsStreamingSessionUrlRequest model) {
            super(model);
            this.streamName(model.streamName);
            this.streamARN(model.streamARN);
            this.playbackMode(model.playbackMode);
            this.hlsFragmentSelector(model.hlsFragmentSelector);
            this.containerFormat(model.containerFormat);
            this.discontinuityMode(model.discontinuityMode);
            this.displayFragmentTimestamp(model.displayFragmentTimestamp);
            this.expires(model.expires);
            this.maxMediaPlaylistFragmentResults(model.maxMediaPlaylistFragmentResults);
        }

        public final String getStreamName() {
            return this.streamName;
        }

        public final void setStreamName(String streamName) {
            this.streamName = streamName;
        }

        @Override
        @Transient
        public final Builder streamName(String streamName) {
            this.streamName = streamName;
            return this;
        }

        public final String getStreamARN() {
            return this.streamARN;
        }

        public final void setStreamARN(String streamARN) {
            this.streamARN = streamARN;
        }

        @Override
        @Transient
        public final Builder streamARN(String streamARN) {
            this.streamARN = streamARN;
            return this;
        }

        public final String getPlaybackMode() {
            return this.playbackMode;
        }

        public final void setPlaybackMode(String playbackMode) {
            this.playbackMode = playbackMode;
        }

        @Override
        @Transient
        public final Builder playbackMode(String playbackMode) {
            this.playbackMode = playbackMode;
            return this;
        }

        @Override
        @Transient
        public final Builder playbackMode(HLSPlaybackMode playbackMode) {
            this.playbackMode(playbackMode == null ? null : playbackMode.toString());
            return this;
        }

        public final HLSFragmentSelector.Builder getHlsFragmentSelector() {
            return this.hlsFragmentSelector != null ? this.hlsFragmentSelector.toBuilder() : null;
        }

        public final void setHlsFragmentSelector(HLSFragmentSelector.BuilderImpl hlsFragmentSelector) {
            this.hlsFragmentSelector = hlsFragmentSelector != null ? hlsFragmentSelector.build() : null;
        }

        @Override
        @Transient
        public final Builder hlsFragmentSelector(HLSFragmentSelector hlsFragmentSelector) {
            this.hlsFragmentSelector = hlsFragmentSelector;
            return this;
        }

        public final String getContainerFormat() {
            return this.containerFormat;
        }

        public final void setContainerFormat(String containerFormat) {
            this.containerFormat = containerFormat;
        }

        @Override
        @Transient
        public final Builder containerFormat(String containerFormat) {
            this.containerFormat = containerFormat;
            return this;
        }

        @Override
        @Transient
        public final Builder containerFormat(ContainerFormat containerFormat) {
            this.containerFormat(containerFormat == null ? null : containerFormat.toString());
            return this;
        }

        public final String getDiscontinuityMode() {
            return this.discontinuityMode;
        }

        public final void setDiscontinuityMode(String discontinuityMode) {
            this.discontinuityMode = discontinuityMode;
        }

        @Override
        @Transient
        public final Builder discontinuityMode(String discontinuityMode) {
            this.discontinuityMode = discontinuityMode;
            return this;
        }

        @Override
        @Transient
        public final Builder discontinuityMode(HLSDiscontinuityMode discontinuityMode) {
            this.discontinuityMode(discontinuityMode == null ? null : discontinuityMode.toString());
            return this;
        }

        public final String getDisplayFragmentTimestamp() {
            return this.displayFragmentTimestamp;
        }

        public final void setDisplayFragmentTimestamp(String displayFragmentTimestamp) {
            this.displayFragmentTimestamp = displayFragmentTimestamp;
        }

        @Override
        @Transient
        public final Builder displayFragmentTimestamp(String displayFragmentTimestamp) {
            this.displayFragmentTimestamp = displayFragmentTimestamp;
            return this;
        }

        @Override
        @Transient
        public final Builder displayFragmentTimestamp(HLSDisplayFragmentTimestamp displayFragmentTimestamp) {
            this.displayFragmentTimestamp(displayFragmentTimestamp == null ? null : displayFragmentTimestamp.toString());
            return this;
        }

        public final Integer getExpires() {
            return this.expires;
        }

        public final void setExpires(Integer expires) {
            this.expires = expires;
        }

        @Override
        @Transient
        public final Builder expires(Integer expires) {
            this.expires = expires;
            return this;
        }

        public final Long getMaxMediaPlaylistFragmentResults() {
            return this.maxMediaPlaylistFragmentResults;
        }

        public final void setMaxMediaPlaylistFragmentResults(Long maxMediaPlaylistFragmentResults) {
            this.maxMediaPlaylistFragmentResults = maxMediaPlaylistFragmentResults;
        }

        @Override
        @Transient
        public final Builder maxMediaPlaylistFragmentResults(Long maxMediaPlaylistFragmentResults) {
            this.maxMediaPlaylistFragmentResults = maxMediaPlaylistFragmentResults;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetHlsStreamingSessionUrlRequest build() {
            return new GetHlsStreamingSessionUrlRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends KinesisVideoArchivedMediaRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetHlsStreamingSessionUrlRequest> {
        public Builder streamName(String var1);

        public Builder streamARN(String var1);

        public Builder playbackMode(String var1);

        public Builder playbackMode(HLSPlaybackMode var1);

        public Builder hlsFragmentSelector(HLSFragmentSelector var1);

        default public Builder hlsFragmentSelector(Consumer<HLSFragmentSelector.Builder> hlsFragmentSelector) {
            return this.hlsFragmentSelector((HLSFragmentSelector)((HLSFragmentSelector.Builder)HLSFragmentSelector.builder().applyMutation(hlsFragmentSelector)).build());
        }

        public Builder containerFormat(String var1);

        public Builder containerFormat(ContainerFormat var1);

        public Builder discontinuityMode(String var1);

        public Builder discontinuityMode(HLSDiscontinuityMode var1);

        public Builder displayFragmentTimestamp(String var1);

        public Builder displayFragmentTimestamp(HLSDisplayFragmentTimestamp var1);

        public Builder expires(Integer var1);

        public Builder maxMediaPlaylistFragmentResults(Long var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

