/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisvideoarchivedmedia.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetMediaForFragmentListRequest extends KinesisVideoArchivedMediaRequest implements
        ToCopyableBuilder<GetMediaForFragmentListRequest.Builder, GetMediaForFragmentListRequest> {
    private static final SdkField<String> STREAM_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StreamName").getter(getter(GetMediaForFragmentListRequest::streamName))
            .setter(setter(Builder::streamName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamName").build()).build();

    private static final SdkField<String> STREAM_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StreamARN").getter(getter(GetMediaForFragmentListRequest::streamARN)).setter(setter(Builder::streamARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamARN").build()).build();

    private static final SdkField<List<String>> FRAGMENTS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Fragments")
            .getter(getter(GetMediaForFragmentListRequest::fragments))
            .setter(setter(Builder::fragments))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Fragments").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STREAM_NAME_FIELD,
            STREAM_ARN_FIELD, FRAGMENTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("StreamName", STREAM_NAME_FIELD);
                    put("StreamARN", STREAM_ARN_FIELD);
                    put("Fragments", FRAGMENTS_FIELD);
                }
            });

    private final String streamName;

    private final String streamARN;

    private final List<String> fragments;

    private GetMediaForFragmentListRequest(BuilderImpl builder) {
        super(builder);
        this.streamName = builder.streamName;
        this.streamARN = builder.streamARN;
        this.fragments = builder.fragments;
    }

    /**
     * <p>
     * The name of the stream from which to retrieve fragment media. Specify either this parameter or the
     * <code>StreamARN</code> parameter.
     * </p>
     * 
     * @return The name of the stream from which to retrieve fragment media. Specify either this parameter or the
     *         <code>StreamARN</code> parameter.
     */
    public final String streamName() {
        return streamName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the stream from which to retrieve fragment media. Specify either this parameter
     * or the <code>StreamName</code> parameter.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the stream from which to retrieve fragment media. Specify either this
     *         parameter or the <code>StreamName</code> parameter.
     */
    public final String streamARN() {
        return streamARN;
    }

    /**
     * For responses, this returns true if the service returned a value for the Fragments property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFragments() {
        return fragments != null && !(fragments instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of the numbers of fragments for which to retrieve media. You retrieve these values with
     * <a>ListFragments</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFragments} method.
     * </p>
     * 
     * @return A list of the numbers of fragments for which to retrieve media. You retrieve these values with
     *         <a>ListFragments</a>.
     */
    public final List<String> fragments() {
        return fragments;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(streamName());
        hashCode = 31 * hashCode + Objects.hashCode(streamARN());
        hashCode = 31 * hashCode + Objects.hashCode(hasFragments() ? fragments() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetMediaForFragmentListRequest)) {
            return false;
        }
        GetMediaForFragmentListRequest other = (GetMediaForFragmentListRequest) obj;
        return Objects.equals(streamName(), other.streamName()) && Objects.equals(streamARN(), other.streamARN())
                && hasFragments() == other.hasFragments() && Objects.equals(fragments(), other.fragments());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetMediaForFragmentListRequest").add("StreamName", streamName()).add("StreamARN", streamARN())
                .add("Fragments", hasFragments() ? fragments() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StreamName":
            return Optional.ofNullable(clazz.cast(streamName()));
        case "StreamARN":
            return Optional.ofNullable(clazz.cast(streamARN()));
        case "Fragments":
            return Optional.ofNullable(clazz.cast(fragments()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetMediaForFragmentListRequest, T> g) {
        return obj -> g.apply((GetMediaForFragmentListRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends KinesisVideoArchivedMediaRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, GetMediaForFragmentListRequest> {
        /**
         * <p>
         * The name of the stream from which to retrieve fragment media. Specify either this parameter or the
         * <code>StreamARN</code> parameter.
         * </p>
         * 
         * @param streamName
         *        The name of the stream from which to retrieve fragment media. Specify either this parameter or the
         *        <code>StreamARN</code> parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamName(String streamName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the stream from which to retrieve fragment media. Specify either this
         * parameter or the <code>StreamName</code> parameter.
         * </p>
         * 
         * @param streamARN
         *        The Amazon Resource Name (ARN) of the stream from which to retrieve fragment media. Specify either
         *        this parameter or the <code>StreamName</code> parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamARN(String streamARN);

        /**
         * <p>
         * A list of the numbers of fragments for which to retrieve media. You retrieve these values with
         * <a>ListFragments</a>.
         * </p>
         * 
         * @param fragments
         *        A list of the numbers of fragments for which to retrieve media. You retrieve these values with
         *        <a>ListFragments</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fragments(Collection<String> fragments);

        /**
         * <p>
         * A list of the numbers of fragments for which to retrieve media. You retrieve these values with
         * <a>ListFragments</a>.
         * </p>
         * 
         * @param fragments
         *        A list of the numbers of fragments for which to retrieve media. You retrieve these values with
         *        <a>ListFragments</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fragments(String... fragments);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends KinesisVideoArchivedMediaRequest.BuilderImpl implements Builder {
        private String streamName;

        private String streamARN;

        private List<String> fragments = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetMediaForFragmentListRequest model) {
            super(model);
            streamName(model.streamName);
            streamARN(model.streamARN);
            fragments(model.fragments);
        }

        public final String getStreamName() {
            return streamName;
        }

        public final void setStreamName(String streamName) {
            this.streamName = streamName;
        }

        @Override
        public final Builder streamName(String streamName) {
            this.streamName = streamName;
            return this;
        }

        public final String getStreamARN() {
            return streamARN;
        }

        public final void setStreamARN(String streamARN) {
            this.streamARN = streamARN;
        }

        @Override
        public final Builder streamARN(String streamARN) {
            this.streamARN = streamARN;
            return this;
        }

        public final Collection<String> getFragments() {
            if (fragments instanceof SdkAutoConstructList) {
                return null;
            }
            return fragments;
        }

        public final void setFragments(Collection<String> fragments) {
            this.fragments = FragmentNumberListCopier.copy(fragments);
        }

        @Override
        public final Builder fragments(Collection<String> fragments) {
            this.fragments = FragmentNumberListCopier.copy(fragments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fragments(String... fragments) {
            fragments(Arrays.asList(fragments));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetMediaForFragmentListRequest build() {
            return new GetMediaForFragmentListRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
