/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisvideoarchivedmedia.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetImagesRequest extends KinesisVideoArchivedMediaRequest implements
        ToCopyableBuilder<GetImagesRequest.Builder, GetImagesRequest> {
    private static final SdkField<String> STREAM_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StreamName").getter(getter(GetImagesRequest::streamName)).setter(setter(Builder::streamName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamName").build()).build();

    private static final SdkField<String> STREAM_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StreamARN").getter(getter(GetImagesRequest::streamARN)).setter(setter(Builder::streamARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamARN").build()).build();

    private static final SdkField<String> IMAGE_SELECTOR_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ImageSelectorType").getter(getter(GetImagesRequest::imageSelectorTypeAsString))
            .setter(setter(Builder::imageSelectorType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageSelectorType").build()).build();

    private static final SdkField<Instant> START_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("StartTimestamp").getter(getter(GetImagesRequest::startTimestamp))
            .setter(setter(Builder::startTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTimestamp").build()).build();

    private static final SdkField<Instant> END_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("EndTimestamp").getter(getter(GetImagesRequest::endTimestamp)).setter(setter(Builder::endTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTimestamp").build()).build();

    private static final SdkField<Integer> SAMPLING_INTERVAL_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("SamplingInterval").getter(getter(GetImagesRequest::samplingInterval))
            .setter(setter(Builder::samplingInterval))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SamplingInterval").build()).build();

    private static final SdkField<String> FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Format")
            .getter(getter(GetImagesRequest::formatAsString)).setter(setter(Builder::format))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Format").build()).build();

    private static final SdkField<Map<String, String>> FORMAT_CONFIG_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("FormatConfig")
            .getter(getter(GetImagesRequest::formatConfigAsStrings))
            .setter(setter(Builder::formatConfigWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FormatConfig").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Integer> WIDTH_PIXELS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("WidthPixels").getter(getter(GetImagesRequest::widthPixels)).setter(setter(Builder::widthPixels))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WidthPixels").build()).build();

    private static final SdkField<Integer> HEIGHT_PIXELS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("HeightPixels").getter(getter(GetImagesRequest::heightPixels)).setter(setter(Builder::heightPixels))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HeightPixels").build()).build();

    private static final SdkField<Long> MAX_RESULTS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("MaxResults").getter(getter(GetImagesRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(GetImagesRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STREAM_NAME_FIELD,
            STREAM_ARN_FIELD, IMAGE_SELECTOR_TYPE_FIELD, START_TIMESTAMP_FIELD, END_TIMESTAMP_FIELD, SAMPLING_INTERVAL_FIELD,
            FORMAT_FIELD, FORMAT_CONFIG_FIELD, WIDTH_PIXELS_FIELD, HEIGHT_PIXELS_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("StreamName", STREAM_NAME_FIELD);
                    put("StreamARN", STREAM_ARN_FIELD);
                    put("ImageSelectorType", IMAGE_SELECTOR_TYPE_FIELD);
                    put("StartTimestamp", START_TIMESTAMP_FIELD);
                    put("EndTimestamp", END_TIMESTAMP_FIELD);
                    put("SamplingInterval", SAMPLING_INTERVAL_FIELD);
                    put("Format", FORMAT_FIELD);
                    put("FormatConfig", FORMAT_CONFIG_FIELD);
                    put("WidthPixels", WIDTH_PIXELS_FIELD);
                    put("HeightPixels", HEIGHT_PIXELS_FIELD);
                    put("MaxResults", MAX_RESULTS_FIELD);
                    put("NextToken", NEXT_TOKEN_FIELD);
                }
            });

    private final String streamName;

    private final String streamARN;

    private final String imageSelectorType;

    private final Instant startTimestamp;

    private final Instant endTimestamp;

    private final Integer samplingInterval;

    private final String format;

    private final Map<String, String> formatConfig;

    private final Integer widthPixels;

    private final Integer heightPixels;

    private final Long maxResults;

    private final String nextToken;

    private GetImagesRequest(BuilderImpl builder) {
        super(builder);
        this.streamName = builder.streamName;
        this.streamARN = builder.streamARN;
        this.imageSelectorType = builder.imageSelectorType;
        this.startTimestamp = builder.startTimestamp;
        this.endTimestamp = builder.endTimestamp;
        this.samplingInterval = builder.samplingInterval;
        this.format = builder.format;
        this.formatConfig = builder.formatConfig;
        this.widthPixels = builder.widthPixels;
        this.heightPixels = builder.heightPixels;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The name of the stream from which to retrieve the images. You must specify either the <code>StreamName</code> or
     * the <code>StreamARN</code>.
     * </p>
     * 
     * @return The name of the stream from which to retrieve the images. You must specify either the
     *         <code>StreamName</code> or the <code>StreamARN</code>.
     */
    public final String streamName() {
        return streamName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the stream from which to retrieve the images. You must specify either the
     * <code>StreamName</code> or the <code>StreamARN</code>.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the stream from which to retrieve the images. You must specify either
     *         the <code>StreamName</code> or the <code>StreamARN</code>.
     */
    public final String streamARN() {
        return streamARN;
    }

    /**
     * <p>
     * The origin of the Server or Producer timestamps to use to generate the images.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #imageSelectorType}
     * will return {@link ImageSelectorType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #imageSelectorTypeAsString}.
     * </p>
     * 
     * @return The origin of the Server or Producer timestamps to use to generate the images.
     * @see ImageSelectorType
     */
    public final ImageSelectorType imageSelectorType() {
        return ImageSelectorType.fromValue(imageSelectorType);
    }

    /**
     * <p>
     * The origin of the Server or Producer timestamps to use to generate the images.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #imageSelectorType}
     * will return {@link ImageSelectorType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #imageSelectorTypeAsString}.
     * </p>
     * 
     * @return The origin of the Server or Producer timestamps to use to generate the images.
     * @see ImageSelectorType
     */
    public final String imageSelectorTypeAsString() {
        return imageSelectorType;
    }

    /**
     * <p>
     * The starting point from which the images should be generated. This <code>StartTimestamp</code> must be within an
     * inclusive range of timestamps for an image to be returned.
     * </p>
     * 
     * @return The starting point from which the images should be generated. This <code>StartTimestamp</code> must be
     *         within an inclusive range of timestamps for an image to be returned.
     */
    public final Instant startTimestamp() {
        return startTimestamp;
    }

    /**
     * <p>
     * The end timestamp for the range of images to be generated. If the time range between <code>StartTimestamp</code>
     * and <code>EndTimestamp</code> is more than 300 seconds above <code>StartTimestamp</code>, you will receive an
     * <code>IllegalArgumentException</code>.
     * </p>
     * 
     * @return The end timestamp for the range of images to be generated. If the time range between
     *         <code>StartTimestamp</code> and <code>EndTimestamp</code> is more than 300 seconds above
     *         <code>StartTimestamp</code>, you will receive an <code>IllegalArgumentException</code>.
     */
    public final Instant endTimestamp() {
        return endTimestamp;
    }

    /**
     * <p>
     * The time interval in milliseconds (ms) at which the images need to be generated from the stream. The minimum
     * value that can be provided is 200 ms (5 images per second). If the timestamp range is less than the sampling
     * interval, the image from the <code>startTimestamp</code> will be returned if available.
     * </p>
     * 
     * @return The time interval in milliseconds (ms) at which the images need to be generated from the stream. The
     *         minimum value that can be provided is 200 ms (5 images per second). If the timestamp range is less than
     *         the sampling interval, the image from the <code>startTimestamp</code> will be returned if available.
     */
    public final Integer samplingInterval() {
        return samplingInterval;
    }

    /**
     * <p>
     * The format that will be used to encode the image.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #format} will
     * return {@link Format#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #formatAsString}.
     * </p>
     * 
     * @return The format that will be used to encode the image.
     * @see Format
     */
    public final Format format() {
        return Format.fromValue(format);
    }

    /**
     * <p>
     * The format that will be used to encode the image.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #format} will
     * return {@link Format#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #formatAsString}.
     * </p>
     * 
     * @return The format that will be used to encode the image.
     * @see Format
     */
    public final String formatAsString() {
        return format;
    }

    /**
     * <p>
     * The list of a key-value pair structure that contains extra parameters that can be applied when the image is
     * generated. The <code>FormatConfig</code> key is the <code>JPEGQuality</code>, which indicates the JPEG quality
     * key to be used to generate the image. The <code>FormatConfig</code> value accepts ints from 1 to 100. If the
     * value is 1, the image will be generated with less quality and the best compression. If the value is 100, the
     * image will be generated with the best quality and less compression. If no value is provided, the default value of
     * the <code>JPEGQuality</code> key will be set to 80.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFormatConfig} method.
     * </p>
     * 
     * @return The list of a key-value pair structure that contains extra parameters that can be applied when the image
     *         is generated. The <code>FormatConfig</code> key is the <code>JPEGQuality</code>, which indicates the JPEG
     *         quality key to be used to generate the image. The <code>FormatConfig</code> value accepts ints from 1 to
     *         100. If the value is 1, the image will be generated with less quality and the best compression. If the
     *         value is 100, the image will be generated with the best quality and less compression. If no value is
     *         provided, the default value of the <code>JPEGQuality</code> key will be set to 80.
     */
    public final Map<FormatConfigKey, String> formatConfig() {
        return FormatConfigCopier.copyStringToEnum(formatConfig);
    }

    /**
     * For responses, this returns true if the service returned a value for the FormatConfig property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasFormatConfig() {
        return formatConfig != null && !(formatConfig instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The list of a key-value pair structure that contains extra parameters that can be applied when the image is
     * generated. The <code>FormatConfig</code> key is the <code>JPEGQuality</code>, which indicates the JPEG quality
     * key to be used to generate the image. The <code>FormatConfig</code> value accepts ints from 1 to 100. If the
     * value is 1, the image will be generated with less quality and the best compression. If the value is 100, the
     * image will be generated with the best quality and less compression. If no value is provided, the default value of
     * the <code>JPEGQuality</code> key will be set to 80.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFormatConfig} method.
     * </p>
     * 
     * @return The list of a key-value pair structure that contains extra parameters that can be applied when the image
     *         is generated. The <code>FormatConfig</code> key is the <code>JPEGQuality</code>, which indicates the JPEG
     *         quality key to be used to generate the image. The <code>FormatConfig</code> value accepts ints from 1 to
     *         100. If the value is 1, the image will be generated with less quality and the best compression. If the
     *         value is 100, the image will be generated with the best quality and less compression. If no value is
     *         provided, the default value of the <code>JPEGQuality</code> key will be set to 80.
     */
    public final Map<String, String> formatConfigAsStrings() {
        return formatConfig;
    }

    /**
     * <p>
     * The width of the output image that is used in conjunction with the <code>HeightPixels</code> parameter. When both
     * <code>WidthPixels</code> and <code>HeightPixels</code> parameters are provided, the image will be stretched to
     * fit the specified aspect ratio. If only the <code>WidthPixels</code> parameter is provided or if only the
     * <code>HeightPixels</code> is provided, a <code>ValidationException</code> will be thrown. If neither parameter is
     * provided, the original image size from the stream will be returned.
     * </p>
     * 
     * @return The width of the output image that is used in conjunction with the <code>HeightPixels</code> parameter.
     *         When both <code>WidthPixels</code> and <code>HeightPixels</code> parameters are provided, the image will
     *         be stretched to fit the specified aspect ratio. If only the <code>WidthPixels</code> parameter is
     *         provided or if only the <code>HeightPixels</code> is provided, a <code>ValidationException</code> will be
     *         thrown. If neither parameter is provided, the original image size from the stream will be returned.
     */
    public final Integer widthPixels() {
        return widthPixels;
    }

    /**
     * <p>
     * The height of the output image that is used in conjunction with the <code>WidthPixels</code> parameter. When both
     * <code>HeightPixels</code> and <code>WidthPixels</code> parameters are provided, the image will be stretched to
     * fit the specified aspect ratio. If only the <code>HeightPixels</code> parameter is provided, its original aspect
     * ratio will be used to calculate the <code>WidthPixels</code> ratio. If neither parameter is provided, the
     * original image size will be returned.
     * </p>
     * 
     * @return The height of the output image that is used in conjunction with the <code>WidthPixels</code> parameter.
     *         When both <code>HeightPixels</code> and <code>WidthPixels</code> parameters are provided, the image will
     *         be stretched to fit the specified aspect ratio. If only the <code>HeightPixels</code> parameter is
     *         provided, its original aspect ratio will be used to calculate the <code>WidthPixels</code> ratio. If
     *         neither parameter is provided, the original image size will be returned.
     */
    public final Integer heightPixels() {
        return heightPixels;
    }

    /**
     * <p>
     * The maximum number of images to be returned by the API.
     * </p>
     * <note>
     * <p>
     * The default limit is 25 images per API response. Providing a <code>MaxResults</code> greater than this value will
     * result in a page size of 25. Any additional results will be paginated.
     * </p>
     * </note>
     * 
     * @return The maximum number of images to be returned by the API. </p> <note>
     *         <p>
     *         The default limit is 25 images per API response. Providing a <code>MaxResults</code> greater than this
     *         value will result in a page size of 25. Any additional results will be paginated.
     *         </p>
     */
    public final Long maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * A token that specifies where to start paginating the next set of Images. This is the
     * <code>GetImages:NextToken</code> from a previously truncated response.
     * </p>
     * 
     * @return A token that specifies where to start paginating the next set of Images. This is the
     *         <code>GetImages:NextToken</code> from a previously truncated response.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(streamName());
        hashCode = 31 * hashCode + Objects.hashCode(streamARN());
        hashCode = 31 * hashCode + Objects.hashCode(imageSelectorTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(startTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(endTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(samplingInterval());
        hashCode = 31 * hashCode + Objects.hashCode(formatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasFormatConfig() ? formatConfigAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(widthPixels());
        hashCode = 31 * hashCode + Objects.hashCode(heightPixels());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetImagesRequest)) {
            return false;
        }
        GetImagesRequest other = (GetImagesRequest) obj;
        return Objects.equals(streamName(), other.streamName()) && Objects.equals(streamARN(), other.streamARN())
                && Objects.equals(imageSelectorTypeAsString(), other.imageSelectorTypeAsString())
                && Objects.equals(startTimestamp(), other.startTimestamp())
                && Objects.equals(endTimestamp(), other.endTimestamp())
                && Objects.equals(samplingInterval(), other.samplingInterval())
                && Objects.equals(formatAsString(), other.formatAsString()) && hasFormatConfig() == other.hasFormatConfig()
                && Objects.equals(formatConfigAsStrings(), other.formatConfigAsStrings())
                && Objects.equals(widthPixels(), other.widthPixels()) && Objects.equals(heightPixels(), other.heightPixels())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetImagesRequest").add("StreamName", streamName()).add("StreamARN", streamARN())
                .add("ImageSelectorType", imageSelectorTypeAsString()).add("StartTimestamp", startTimestamp())
                .add("EndTimestamp", endTimestamp()).add("SamplingInterval", samplingInterval()).add("Format", formatAsString())
                .add("FormatConfig", hasFormatConfig() ? formatConfigAsStrings() : null).add("WidthPixels", widthPixels())
                .add("HeightPixels", heightPixels()).add("MaxResults", maxResults()).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StreamName":
            return Optional.ofNullable(clazz.cast(streamName()));
        case "StreamARN":
            return Optional.ofNullable(clazz.cast(streamARN()));
        case "ImageSelectorType":
            return Optional.ofNullable(clazz.cast(imageSelectorTypeAsString()));
        case "StartTimestamp":
            return Optional.ofNullable(clazz.cast(startTimestamp()));
        case "EndTimestamp":
            return Optional.ofNullable(clazz.cast(endTimestamp()));
        case "SamplingInterval":
            return Optional.ofNullable(clazz.cast(samplingInterval()));
        case "Format":
            return Optional.ofNullable(clazz.cast(formatAsString()));
        case "FormatConfig":
            return Optional.ofNullable(clazz.cast(formatConfigAsStrings()));
        case "WidthPixels":
            return Optional.ofNullable(clazz.cast(widthPixels()));
        case "HeightPixels":
            return Optional.ofNullable(clazz.cast(heightPixels()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetImagesRequest, T> g) {
        return obj -> g.apply((GetImagesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends KinesisVideoArchivedMediaRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, GetImagesRequest> {
        /**
         * <p>
         * The name of the stream from which to retrieve the images. You must specify either the <code>StreamName</code>
         * or the <code>StreamARN</code>.
         * </p>
         * 
         * @param streamName
         *        The name of the stream from which to retrieve the images. You must specify either the
         *        <code>StreamName</code> or the <code>StreamARN</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamName(String streamName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the stream from which to retrieve the images. You must specify either the
         * <code>StreamName</code> or the <code>StreamARN</code>.
         * </p>
         * 
         * @param streamARN
         *        The Amazon Resource Name (ARN) of the stream from which to retrieve the images. You must specify
         *        either the <code>StreamName</code> or the <code>StreamARN</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamARN(String streamARN);

        /**
         * <p>
         * The origin of the Server or Producer timestamps to use to generate the images.
         * </p>
         * 
         * @param imageSelectorType
         *        The origin of the Server or Producer timestamps to use to generate the images.
         * @see ImageSelectorType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ImageSelectorType
         */
        Builder imageSelectorType(String imageSelectorType);

        /**
         * <p>
         * The origin of the Server or Producer timestamps to use to generate the images.
         * </p>
         * 
         * @param imageSelectorType
         *        The origin of the Server or Producer timestamps to use to generate the images.
         * @see ImageSelectorType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ImageSelectorType
         */
        Builder imageSelectorType(ImageSelectorType imageSelectorType);

        /**
         * <p>
         * The starting point from which the images should be generated. This <code>StartTimestamp</code> must be within
         * an inclusive range of timestamps for an image to be returned.
         * </p>
         * 
         * @param startTimestamp
         *        The starting point from which the images should be generated. This <code>StartTimestamp</code> must be
         *        within an inclusive range of timestamps for an image to be returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTimestamp(Instant startTimestamp);

        /**
         * <p>
         * The end timestamp for the range of images to be generated. If the time range between
         * <code>StartTimestamp</code> and <code>EndTimestamp</code> is more than 300 seconds above
         * <code>StartTimestamp</code>, you will receive an <code>IllegalArgumentException</code>.
         * </p>
         * 
         * @param endTimestamp
         *        The end timestamp for the range of images to be generated. If the time range between
         *        <code>StartTimestamp</code> and <code>EndTimestamp</code> is more than 300 seconds above
         *        <code>StartTimestamp</code>, you will receive an <code>IllegalArgumentException</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTimestamp(Instant endTimestamp);

        /**
         * <p>
         * The time interval in milliseconds (ms) at which the images need to be generated from the stream. The minimum
         * value that can be provided is 200 ms (5 images per second). If the timestamp range is less than the sampling
         * interval, the image from the <code>startTimestamp</code> will be returned if available.
         * </p>
         * 
         * @param samplingInterval
         *        The time interval in milliseconds (ms) at which the images need to be generated from the stream. The
         *        minimum value that can be provided is 200 ms (5 images per second). If the timestamp range is less
         *        than the sampling interval, the image from the <code>startTimestamp</code> will be returned if
         *        available.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder samplingInterval(Integer samplingInterval);

        /**
         * <p>
         * The format that will be used to encode the image.
         * </p>
         * 
         * @param format
         *        The format that will be used to encode the image.
         * @see Format
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Format
         */
        Builder format(String format);

        /**
         * <p>
         * The format that will be used to encode the image.
         * </p>
         * 
         * @param format
         *        The format that will be used to encode the image.
         * @see Format
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Format
         */
        Builder format(Format format);

        /**
         * <p>
         * The list of a key-value pair structure that contains extra parameters that can be applied when the image is
         * generated. The <code>FormatConfig</code> key is the <code>JPEGQuality</code>, which indicates the JPEG
         * quality key to be used to generate the image. The <code>FormatConfig</code> value accepts ints from 1 to 100.
         * If the value is 1, the image will be generated with less quality and the best compression. If the value is
         * 100, the image will be generated with the best quality and less compression. If no value is provided, the
         * default value of the <code>JPEGQuality</code> key will be set to 80.
         * </p>
         * 
         * @param formatConfig
         *        The list of a key-value pair structure that contains extra parameters that can be applied when the
         *        image is generated. The <code>FormatConfig</code> key is the <code>JPEGQuality</code>, which indicates
         *        the JPEG quality key to be used to generate the image. The <code>FormatConfig</code> value accepts
         *        ints from 1 to 100. If the value is 1, the image will be generated with less quality and the best
         *        compression. If the value is 100, the image will be generated with the best quality and less
         *        compression. If no value is provided, the default value of the <code>JPEGQuality</code> key will be
         *        set to 80.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder formatConfigWithStrings(Map<String, String> formatConfig);

        /**
         * <p>
         * The list of a key-value pair structure that contains extra parameters that can be applied when the image is
         * generated. The <code>FormatConfig</code> key is the <code>JPEGQuality</code>, which indicates the JPEG
         * quality key to be used to generate the image. The <code>FormatConfig</code> value accepts ints from 1 to 100.
         * If the value is 1, the image will be generated with less quality and the best compression. If the value is
         * 100, the image will be generated with the best quality and less compression. If no value is provided, the
         * default value of the <code>JPEGQuality</code> key will be set to 80.
         * </p>
         * 
         * @param formatConfig
         *        The list of a key-value pair structure that contains extra parameters that can be applied when the
         *        image is generated. The <code>FormatConfig</code> key is the <code>JPEGQuality</code>, which indicates
         *        the JPEG quality key to be used to generate the image. The <code>FormatConfig</code> value accepts
         *        ints from 1 to 100. If the value is 1, the image will be generated with less quality and the best
         *        compression. If the value is 100, the image will be generated with the best quality and less
         *        compression. If no value is provided, the default value of the <code>JPEGQuality</code> key will be
         *        set to 80.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder formatConfig(Map<FormatConfigKey, String> formatConfig);

        /**
         * <p>
         * The width of the output image that is used in conjunction with the <code>HeightPixels</code> parameter. When
         * both <code>WidthPixels</code> and <code>HeightPixels</code> parameters are provided, the image will be
         * stretched to fit the specified aspect ratio. If only the <code>WidthPixels</code> parameter is provided or if
         * only the <code>HeightPixels</code> is provided, a <code>ValidationException</code> will be thrown. If neither
         * parameter is provided, the original image size from the stream will be returned.
         * </p>
         * 
         * @param widthPixels
         *        The width of the output image that is used in conjunction with the <code>HeightPixels</code>
         *        parameter. When both <code>WidthPixels</code> and <code>HeightPixels</code> parameters are provided,
         *        the image will be stretched to fit the specified aspect ratio. If only the <code>WidthPixels</code>
         *        parameter is provided or if only the <code>HeightPixels</code> is provided, a
         *        <code>ValidationException</code> will be thrown. If neither parameter is provided, the original image
         *        size from the stream will be returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder widthPixels(Integer widthPixels);

        /**
         * <p>
         * The height of the output image that is used in conjunction with the <code>WidthPixels</code> parameter. When
         * both <code>HeightPixels</code> and <code>WidthPixels</code> parameters are provided, the image will be
         * stretched to fit the specified aspect ratio. If only the <code>HeightPixels</code> parameter is provided, its
         * original aspect ratio will be used to calculate the <code>WidthPixels</code> ratio. If neither parameter is
         * provided, the original image size will be returned.
         * </p>
         * 
         * @param heightPixels
         *        The height of the output image that is used in conjunction with the <code>WidthPixels</code>
         *        parameter. When both <code>HeightPixels</code> and <code>WidthPixels</code> parameters are provided,
         *        the image will be stretched to fit the specified aspect ratio. If only the <code>HeightPixels</code>
         *        parameter is provided, its original aspect ratio will be used to calculate the
         *        <code>WidthPixels</code> ratio. If neither parameter is provided, the original image size will be
         *        returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder heightPixels(Integer heightPixels);

        /**
         * <p>
         * The maximum number of images to be returned by the API.
         * </p>
         * <note>
         * <p>
         * The default limit is 25 images per API response. Providing a <code>MaxResults</code> greater than this value
         * will result in a page size of 25. Any additional results will be paginated.
         * </p>
         * </note>
         * 
         * @param maxResults
         *        The maximum number of images to be returned by the API. </p> <note>
         *        <p>
         *        The default limit is 25 images per API response. Providing a <code>MaxResults</code> greater than this
         *        value will result in a page size of 25. Any additional results will be paginated.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Long maxResults);

        /**
         * <p>
         * A token that specifies where to start paginating the next set of Images. This is the
         * <code>GetImages:NextToken</code> from a previously truncated response.
         * </p>
         * 
         * @param nextToken
         *        A token that specifies where to start paginating the next set of Images. This is the
         *        <code>GetImages:NextToken</code> from a previously truncated response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends KinesisVideoArchivedMediaRequest.BuilderImpl implements Builder {
        private String streamName;

        private String streamARN;

        private String imageSelectorType;

        private Instant startTimestamp;

        private Instant endTimestamp;

        private Integer samplingInterval;

        private String format;

        private Map<String, String> formatConfig = DefaultSdkAutoConstructMap.getInstance();

        private Integer widthPixels;

        private Integer heightPixels;

        private Long maxResults;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetImagesRequest model) {
            super(model);
            streamName(model.streamName);
            streamARN(model.streamARN);
            imageSelectorType(model.imageSelectorType);
            startTimestamp(model.startTimestamp);
            endTimestamp(model.endTimestamp);
            samplingInterval(model.samplingInterval);
            format(model.format);
            formatConfigWithStrings(model.formatConfig);
            widthPixels(model.widthPixels);
            heightPixels(model.heightPixels);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
        }

        public final String getStreamName() {
            return streamName;
        }

        public final void setStreamName(String streamName) {
            this.streamName = streamName;
        }

        @Override
        public final Builder streamName(String streamName) {
            this.streamName = streamName;
            return this;
        }

        public final String getStreamARN() {
            return streamARN;
        }

        public final void setStreamARN(String streamARN) {
            this.streamARN = streamARN;
        }

        @Override
        public final Builder streamARN(String streamARN) {
            this.streamARN = streamARN;
            return this;
        }

        public final String getImageSelectorType() {
            return imageSelectorType;
        }

        public final void setImageSelectorType(String imageSelectorType) {
            this.imageSelectorType = imageSelectorType;
        }

        @Override
        public final Builder imageSelectorType(String imageSelectorType) {
            this.imageSelectorType = imageSelectorType;
            return this;
        }

        @Override
        public final Builder imageSelectorType(ImageSelectorType imageSelectorType) {
            this.imageSelectorType(imageSelectorType == null ? null : imageSelectorType.toString());
            return this;
        }

        public final Instant getStartTimestamp() {
            return startTimestamp;
        }

        public final void setStartTimestamp(Instant startTimestamp) {
            this.startTimestamp = startTimestamp;
        }

        @Override
        public final Builder startTimestamp(Instant startTimestamp) {
            this.startTimestamp = startTimestamp;
            return this;
        }

        public final Instant getEndTimestamp() {
            return endTimestamp;
        }

        public final void setEndTimestamp(Instant endTimestamp) {
            this.endTimestamp = endTimestamp;
        }

        @Override
        public final Builder endTimestamp(Instant endTimestamp) {
            this.endTimestamp = endTimestamp;
            return this;
        }

        public final Integer getSamplingInterval() {
            return samplingInterval;
        }

        public final void setSamplingInterval(Integer samplingInterval) {
            this.samplingInterval = samplingInterval;
        }

        @Override
        public final Builder samplingInterval(Integer samplingInterval) {
            this.samplingInterval = samplingInterval;
            return this;
        }

        public final String getFormat() {
            return format;
        }

        public final void setFormat(String format) {
            this.format = format;
        }

        @Override
        public final Builder format(String format) {
            this.format = format;
            return this;
        }

        @Override
        public final Builder format(Format format) {
            this.format(format == null ? null : format.toString());
            return this;
        }

        public final Map<String, String> getFormatConfig() {
            if (formatConfig instanceof SdkAutoConstructMap) {
                return null;
            }
            return formatConfig;
        }

        public final void setFormatConfig(Map<String, String> formatConfig) {
            this.formatConfig = FormatConfigCopier.copy(formatConfig);
        }

        @Override
        public final Builder formatConfigWithStrings(Map<String, String> formatConfig) {
            this.formatConfig = FormatConfigCopier.copy(formatConfig);
            return this;
        }

        @Override
        public final Builder formatConfig(Map<FormatConfigKey, String> formatConfig) {
            this.formatConfig = FormatConfigCopier.copyEnumToString(formatConfig);
            return this;
        }

        public final Integer getWidthPixels() {
            return widthPixels;
        }

        public final void setWidthPixels(Integer widthPixels) {
            this.widthPixels = widthPixels;
        }

        @Override
        public final Builder widthPixels(Integer widthPixels) {
            this.widthPixels = widthPixels;
            return this;
        }

        public final Integer getHeightPixels() {
            return heightPixels;
        }

        public final void setHeightPixels(Integer heightPixels) {
            this.heightPixels = heightPixels;
        }

        @Override
        public final Builder heightPixels(Integer heightPixels) {
            this.heightPixels = heightPixels;
            return this;
        }

        public final Long getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Long maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Long maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetImagesRequest build() {
            return new GetImagesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
