/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisvideoarchivedmedia.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListFragmentsRequest extends KinesisVideoArchivedMediaRequest implements
        ToCopyableBuilder<ListFragmentsRequest.Builder, ListFragmentsRequest> {
    private static final SdkField<String> STREAM_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StreamName").getter(getter(ListFragmentsRequest::streamName)).setter(setter(Builder::streamName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamName").build()).build();

    private static final SdkField<String> STREAM_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StreamARN").getter(getter(ListFragmentsRequest::streamARN)).setter(setter(Builder::streamARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamARN").build()).build();

    private static final SdkField<Long> MAX_RESULTS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("MaxResults").getter(getter(ListFragmentsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListFragmentsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<FragmentSelector> FRAGMENT_SELECTOR_FIELD = SdkField
            .<FragmentSelector> builder(MarshallingType.SDK_POJO).memberName("FragmentSelector")
            .getter(getter(ListFragmentsRequest::fragmentSelector)).setter(setter(Builder::fragmentSelector))
            .constructor(FragmentSelector::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FragmentSelector").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STREAM_NAME_FIELD,
            STREAM_ARN_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, FRAGMENT_SELECTOR_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String streamName;

    private final String streamARN;

    private final Long maxResults;

    private final String nextToken;

    private final FragmentSelector fragmentSelector;

    private ListFragmentsRequest(BuilderImpl builder) {
        super(builder);
        this.streamName = builder.streamName;
        this.streamARN = builder.streamARN;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.fragmentSelector = builder.fragmentSelector;
    }

    /**
     * <p>
     * The name of the stream from which to retrieve a fragment list. Specify either this parameter or the
     * <code>StreamARN</code> parameter.
     * </p>
     * 
     * @return The name of the stream from which to retrieve a fragment list. Specify either this parameter or the
     *         <code>StreamARN</code> parameter.
     */
    public final String streamName() {
        return streamName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the stream from which to retrieve a fragment list. Specify either this
     * parameter or the <code>StreamName</code> parameter.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the stream from which to retrieve a fragment list. Specify either this
     *         parameter or the <code>StreamName</code> parameter.
     */
    public final String streamARN() {
        return streamARN;
    }

    /**
     * <p>
     * The total number of fragments to return. If the total number of fragments available is more than the value
     * specified in <code>max-results</code>, then a <a>ListFragmentsOutput$NextToken</a> is provided in the output that
     * you can use to resume pagination.
     * </p>
     * 
     * @return The total number of fragments to return. If the total number of fragments available is more than the
     *         value specified in <code>max-results</code>, then a <a>ListFragmentsOutput$NextToken</a> is provided in
     *         the output that you can use to resume pagination.
     */
    public final Long maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * A token to specify where to start paginating. This is the <a>ListFragmentsOutput$NextToken</a> from a previously
     * truncated response.
     * </p>
     * 
     * @return A token to specify where to start paginating. This is the <a>ListFragmentsOutput$NextToken</a> from a
     *         previously truncated response.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * Describes the timestamp range and timestamp origin for the range of fragments to return.
     * </p>
     * <note>
     * <p>
     * This is only required when the <code>NextToken</code> isn't passed in the API.
     * </p>
     * </note>
     * 
     * @return Describes the timestamp range and timestamp origin for the range of fragments to return.</p> <note>
     *         <p>
     *         This is only required when the <code>NextToken</code> isn't passed in the API.
     *         </p>
     */
    public final FragmentSelector fragmentSelector() {
        return fragmentSelector;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(streamName());
        hashCode = 31 * hashCode + Objects.hashCode(streamARN());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(fragmentSelector());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListFragmentsRequest)) {
            return false;
        }
        ListFragmentsRequest other = (ListFragmentsRequest) obj;
        return Objects.equals(streamName(), other.streamName()) && Objects.equals(streamARN(), other.streamARN())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(fragmentSelector(), other.fragmentSelector());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListFragmentsRequest").add("StreamName", streamName()).add("StreamARN", streamARN())
                .add("MaxResults", maxResults()).add("NextToken", nextToken()).add("FragmentSelector", fragmentSelector())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StreamName":
            return Optional.ofNullable(clazz.cast(streamName()));
        case "StreamARN":
            return Optional.ofNullable(clazz.cast(streamARN()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "FragmentSelector":
            return Optional.ofNullable(clazz.cast(fragmentSelector()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("StreamName", STREAM_NAME_FIELD);
        map.put("StreamARN", STREAM_ARN_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("FragmentSelector", FRAGMENT_SELECTOR_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListFragmentsRequest, T> g) {
        return obj -> g.apply((ListFragmentsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends KinesisVideoArchivedMediaRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ListFragmentsRequest> {
        /**
         * <p>
         * The name of the stream from which to retrieve a fragment list. Specify either this parameter or the
         * <code>StreamARN</code> parameter.
         * </p>
         * 
         * @param streamName
         *        The name of the stream from which to retrieve a fragment list. Specify either this parameter or the
         *        <code>StreamARN</code> parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamName(String streamName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the stream from which to retrieve a fragment list. Specify either this
         * parameter or the <code>StreamName</code> parameter.
         * </p>
         * 
         * @param streamARN
         *        The Amazon Resource Name (ARN) of the stream from which to retrieve a fragment list. Specify either
         *        this parameter or the <code>StreamName</code> parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamARN(String streamARN);

        /**
         * <p>
         * The total number of fragments to return. If the total number of fragments available is more than the value
         * specified in <code>max-results</code>, then a <a>ListFragmentsOutput$NextToken</a> is provided in the output
         * that you can use to resume pagination.
         * </p>
         * 
         * @param maxResults
         *        The total number of fragments to return. If the total number of fragments available is more than the
         *        value specified in <code>max-results</code>, then a <a>ListFragmentsOutput$NextToken</a> is provided
         *        in the output that you can use to resume pagination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Long maxResults);

        /**
         * <p>
         * A token to specify where to start paginating. This is the <a>ListFragmentsOutput$NextToken</a> from a
         * previously truncated response.
         * </p>
         * 
         * @param nextToken
         *        A token to specify where to start paginating. This is the <a>ListFragmentsOutput$NextToken</a> from a
         *        previously truncated response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * Describes the timestamp range and timestamp origin for the range of fragments to return.
         * </p>
         * <note>
         * <p>
         * This is only required when the <code>NextToken</code> isn't passed in the API.
         * </p>
         * </note>
         * 
         * @param fragmentSelector
         *        Describes the timestamp range and timestamp origin for the range of fragments to return.</p> <note>
         *        <p>
         *        This is only required when the <code>NextToken</code> isn't passed in the API.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fragmentSelector(FragmentSelector fragmentSelector);

        /**
         * <p>
         * Describes the timestamp range and timestamp origin for the range of fragments to return.
         * </p>
         * <note>
         * <p>
         * This is only required when the <code>NextToken</code> isn't passed in the API.
         * </p>
         * </note> This is a convenience method that creates an instance of the {@link FragmentSelector.Builder}
         * avoiding the need to create one manually via {@link FragmentSelector#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FragmentSelector.Builder#build()} is called immediately and its
         * result is passed to {@link #fragmentSelector(FragmentSelector)}.
         * 
         * @param fragmentSelector
         *        a consumer that will call methods on {@link FragmentSelector.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fragmentSelector(FragmentSelector)
         */
        default Builder fragmentSelector(Consumer<FragmentSelector.Builder> fragmentSelector) {
            return fragmentSelector(FragmentSelector.builder().applyMutation(fragmentSelector).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends KinesisVideoArchivedMediaRequest.BuilderImpl implements Builder {
        private String streamName;

        private String streamARN;

        private Long maxResults;

        private String nextToken;

        private FragmentSelector fragmentSelector;

        private BuilderImpl() {
        }

        private BuilderImpl(ListFragmentsRequest model) {
            super(model);
            streamName(model.streamName);
            streamARN(model.streamARN);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
            fragmentSelector(model.fragmentSelector);
        }

        public final String getStreamName() {
            return streamName;
        }

        public final void setStreamName(String streamName) {
            this.streamName = streamName;
        }

        @Override
        public final Builder streamName(String streamName) {
            this.streamName = streamName;
            return this;
        }

        public final String getStreamARN() {
            return streamARN;
        }

        public final void setStreamARN(String streamARN) {
            this.streamARN = streamARN;
        }

        @Override
        public final Builder streamARN(String streamARN) {
            this.streamARN = streamARN;
            return this;
        }

        public final Long getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Long maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Long maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final FragmentSelector.Builder getFragmentSelector() {
            return fragmentSelector != null ? fragmentSelector.toBuilder() : null;
        }

        public final void setFragmentSelector(FragmentSelector.BuilderImpl fragmentSelector) {
            this.fragmentSelector = fragmentSelector != null ? fragmentSelector.build() : null;
        }

        @Override
        public final Builder fragmentSelector(FragmentSelector fragmentSelector) {
            this.fragmentSelector = fragmentSelector;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListFragmentsRequest build() {
            return new ListFragmentsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
