/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisvideoarchivedmedia;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkProtocolMetadata;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.SdkServiceClientConfiguration;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.sync.ResponseTransformer;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.kinesisvideoarchivedmedia.KinesisVideoArchivedMediaClient;
import software.amazon.awssdk.services.kinesisvideoarchivedmedia.KinesisVideoArchivedMediaServiceClientConfiguration;
import software.amazon.awssdk.services.kinesisvideoarchivedmedia.internal.KinesisVideoArchivedMediaServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.ClientLimitExceededException;
import software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.GetClipRequest;
import software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.GetClipResponse;
import software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.GetDashStreamingSessionUrlRequest;
import software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.GetDashStreamingSessionUrlResponse;
import software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.GetHlsStreamingSessionUrlRequest;
import software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.GetHlsStreamingSessionUrlResponse;
import software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.GetImagesRequest;
import software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.GetImagesResponse;
import software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.GetMediaForFragmentListRequest;
import software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.GetMediaForFragmentListResponse;
import software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.InvalidArgumentException;
import software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.InvalidCodecPrivateDataException;
import software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.InvalidMediaFrameException;
import software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.KinesisVideoArchivedMediaException;
import software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.ListFragmentsRequest;
import software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.ListFragmentsResponse;
import software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.MissingCodecPrivateDataException;
import software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.NoDataRetentionException;
import software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.NotAuthorizedException;
import software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.ResourceNotFoundException;
import software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.UnsupportedStreamMediaTypeException;
import software.amazon.awssdk.services.kinesisvideoarchivedmedia.transform.GetClipRequestMarshaller;
import software.amazon.awssdk.services.kinesisvideoarchivedmedia.transform.GetDashStreamingSessionUrlRequestMarshaller;
import software.amazon.awssdk.services.kinesisvideoarchivedmedia.transform.GetHlsStreamingSessionUrlRequestMarshaller;
import software.amazon.awssdk.services.kinesisvideoarchivedmedia.transform.GetImagesRequestMarshaller;
import software.amazon.awssdk.services.kinesisvideoarchivedmedia.transform.GetMediaForFragmentListRequestMarshaller;
import software.amazon.awssdk.services.kinesisvideoarchivedmedia.transform.ListFragmentsRequestMarshaller;
import software.amazon.awssdk.utils.Logger;

@SdkInternalApi
final class DefaultKinesisVideoArchivedMediaClient
implements KinesisVideoArchivedMediaClient {
    private static final Logger log = Logger.loggerFor(DefaultKinesisVideoArchivedMediaClient.class);
    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder().serviceProtocol(AwsServiceProtocol.REST_JSON).build();
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultKinesisVideoArchivedMediaClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option((ClientOption)SdkClientOption.SDK_CLIENT, (Object)this).option((ClientOption)SdkClientOption.API_METADATA, (Object)"Kinesis_Video_Archived_Media#2.36.x").build();
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <ReturnT> ReturnT getClip(GetClipRequest getClipRequest, ResponseTransformer<GetClipResponse, ReturnT> responseTransformer) throws ResourceNotFoundException, InvalidArgumentException, ClientLimitExceededException, NotAuthorizedException, UnsupportedStreamMediaTypeException, MissingCodecPrivateDataException, InvalidCodecPrivateDataException, InvalidMediaFrameException, NoDataRetentionException, AwsServiceException, SdkClientException, KinesisVideoArchivedMediaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(true).isPayloadJson(false).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetClipResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "NotAuthorizedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotAuthorizedException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(NotAuthorizedException::builder).build());
                }
                case "InvalidCodecPrivateDataException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCodecPrivateDataException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCodecPrivateDataException::builder).build());
                }
                case "InvalidArgumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                }
                case "ClientLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientLimitExceededException::builder).build());
                }
                case "NoDataRetentionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoDataRetentionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoDataRetentionException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "UnsupportedStreamMediaTypeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedStreamMediaTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedStreamMediaTypeException::builder).build());
                }
                case "InvalidMediaFrameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMediaFrameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMediaFrameException::builder).build());
                }
                case "MissingCodecPrivateDataException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingCodecPrivateDataException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingCodecPrivateDataException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getClipRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKinesisVideoArchivedMediaClient.resolveMetricPublishers(clientConfiguration, getClipRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Kinesis Video Archived Media");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetClip");
            Object object = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetClip").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getClipRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withResponseTransformer(responseTransformer).withMarshaller((Marshaller)new GetClipRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)), responseTransformer);
            return (ReturnT)object;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultKinesisVideoArchivedMediaClient.lambda$getClip$1((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetDashStreamingSessionUrlResponse getDASHStreamingSessionURL(GetDashStreamingSessionUrlRequest getDashStreamingSessionUrlRequest) throws ResourceNotFoundException, InvalidArgumentException, ClientLimitExceededException, NotAuthorizedException, UnsupportedStreamMediaTypeException, NoDataRetentionException, MissingCodecPrivateDataException, InvalidCodecPrivateDataException, AwsServiceException, SdkClientException, KinesisVideoArchivedMediaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetDashStreamingSessionUrlResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "NotAuthorizedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotAuthorizedException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(NotAuthorizedException::builder).build());
                }
                case "InvalidCodecPrivateDataException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCodecPrivateDataException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCodecPrivateDataException::builder).build());
                }
                case "InvalidArgumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                }
                case "ClientLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientLimitExceededException::builder).build());
                }
                case "NoDataRetentionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoDataRetentionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoDataRetentionException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "UnsupportedStreamMediaTypeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedStreamMediaTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedStreamMediaTypeException::builder).build());
                }
                case "InvalidMediaFrameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMediaFrameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMediaFrameException::builder).build());
                }
                case "MissingCodecPrivateDataException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingCodecPrivateDataException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingCodecPrivateDataException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getDashStreamingSessionUrlRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKinesisVideoArchivedMediaClient.resolveMetricPublishers(clientConfiguration, getDashStreamingSessionUrlRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Kinesis Video Archived Media");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetDASHStreamingSessionURL");
            GetDashStreamingSessionUrlResponse getDashStreamingSessionUrlResponse = (GetDashStreamingSessionUrlResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetDASHStreamingSessionURL").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getDashStreamingSessionUrlRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetDashStreamingSessionUrlRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getDashStreamingSessionUrlResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultKinesisVideoArchivedMediaClient.lambda$getDASHStreamingSessionURL$3((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetHlsStreamingSessionUrlResponse getHLSStreamingSessionURL(GetHlsStreamingSessionUrlRequest getHlsStreamingSessionUrlRequest) throws ResourceNotFoundException, InvalidArgumentException, ClientLimitExceededException, NotAuthorizedException, UnsupportedStreamMediaTypeException, NoDataRetentionException, MissingCodecPrivateDataException, InvalidCodecPrivateDataException, AwsServiceException, SdkClientException, KinesisVideoArchivedMediaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetHlsStreamingSessionUrlResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "NotAuthorizedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotAuthorizedException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(NotAuthorizedException::builder).build());
                }
                case "InvalidCodecPrivateDataException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCodecPrivateDataException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCodecPrivateDataException::builder).build());
                }
                case "InvalidArgumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                }
                case "ClientLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientLimitExceededException::builder).build());
                }
                case "NoDataRetentionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoDataRetentionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoDataRetentionException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "UnsupportedStreamMediaTypeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedStreamMediaTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedStreamMediaTypeException::builder).build());
                }
                case "InvalidMediaFrameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMediaFrameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMediaFrameException::builder).build());
                }
                case "MissingCodecPrivateDataException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingCodecPrivateDataException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingCodecPrivateDataException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getHlsStreamingSessionUrlRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKinesisVideoArchivedMediaClient.resolveMetricPublishers(clientConfiguration, getHlsStreamingSessionUrlRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Kinesis Video Archived Media");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetHLSStreamingSessionURL");
            GetHlsStreamingSessionUrlResponse getHlsStreamingSessionUrlResponse = (GetHlsStreamingSessionUrlResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetHLSStreamingSessionURL").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getHlsStreamingSessionUrlRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetHlsStreamingSessionUrlRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getHlsStreamingSessionUrlResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultKinesisVideoArchivedMediaClient.lambda$getHLSStreamingSessionURL$5((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetImagesResponse getImages(GetImagesRequest getImagesRequest) throws ResourceNotFoundException, InvalidArgumentException, ClientLimitExceededException, NotAuthorizedException, NoDataRetentionException, AwsServiceException, SdkClientException, KinesisVideoArchivedMediaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetImagesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "NotAuthorizedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotAuthorizedException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(NotAuthorizedException::builder).build());
                }
                case "InvalidCodecPrivateDataException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCodecPrivateDataException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCodecPrivateDataException::builder).build());
                }
                case "InvalidArgumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                }
                case "ClientLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientLimitExceededException::builder).build());
                }
                case "NoDataRetentionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoDataRetentionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoDataRetentionException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "UnsupportedStreamMediaTypeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedStreamMediaTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedStreamMediaTypeException::builder).build());
                }
                case "InvalidMediaFrameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMediaFrameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMediaFrameException::builder).build());
                }
                case "MissingCodecPrivateDataException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingCodecPrivateDataException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingCodecPrivateDataException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getImagesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKinesisVideoArchivedMediaClient.resolveMetricPublishers(clientConfiguration, getImagesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Kinesis Video Archived Media");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetImages");
            GetImagesResponse getImagesResponse = (GetImagesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetImages").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getImagesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetImagesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getImagesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultKinesisVideoArchivedMediaClient.lambda$getImages$7((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <ReturnT> ReturnT getMediaForFragmentList(GetMediaForFragmentListRequest getMediaForFragmentListRequest, ResponseTransformer<GetMediaForFragmentListResponse, ReturnT> responseTransformer) throws ResourceNotFoundException, InvalidArgumentException, ClientLimitExceededException, NotAuthorizedException, AwsServiceException, SdkClientException, KinesisVideoArchivedMediaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(true).isPayloadJson(false).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetMediaForFragmentListResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "NotAuthorizedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotAuthorizedException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(NotAuthorizedException::builder).build());
                }
                case "InvalidCodecPrivateDataException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCodecPrivateDataException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCodecPrivateDataException::builder).build());
                }
                case "InvalidArgumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                }
                case "ClientLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientLimitExceededException::builder).build());
                }
                case "NoDataRetentionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoDataRetentionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoDataRetentionException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "UnsupportedStreamMediaTypeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedStreamMediaTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedStreamMediaTypeException::builder).build());
                }
                case "InvalidMediaFrameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMediaFrameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMediaFrameException::builder).build());
                }
                case "MissingCodecPrivateDataException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingCodecPrivateDataException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingCodecPrivateDataException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getMediaForFragmentListRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKinesisVideoArchivedMediaClient.resolveMetricPublishers(clientConfiguration, getMediaForFragmentListRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Kinesis Video Archived Media");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetMediaForFragmentList");
            Object object = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetMediaForFragmentList").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getMediaForFragmentListRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withResponseTransformer(responseTransformer).withMarshaller((Marshaller)new GetMediaForFragmentListRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)), responseTransformer);
            return (ReturnT)object;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultKinesisVideoArchivedMediaClient.lambda$getMediaForFragmentList$9((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListFragmentsResponse listFragments(ListFragmentsRequest listFragmentsRequest) throws ResourceNotFoundException, InvalidArgumentException, ClientLimitExceededException, NotAuthorizedException, AwsServiceException, SdkClientException, KinesisVideoArchivedMediaException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListFragmentsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "NotAuthorizedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotAuthorizedException").httpStatusCode(Integer.valueOf(401)).exceptionBuilderSupplier(NotAuthorizedException::builder).build());
                }
                case "InvalidCodecPrivateDataException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCodecPrivateDataException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCodecPrivateDataException::builder).build());
                }
                case "InvalidArgumentException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidArgumentException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidArgumentException::builder).build());
                }
                case "ClientLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ClientLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ClientLimitExceededException::builder).build());
                }
                case "NoDataRetentionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoDataRetentionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoDataRetentionException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "UnsupportedStreamMediaTypeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedStreamMediaTypeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedStreamMediaTypeException::builder).build());
                }
                case "InvalidMediaFrameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMediaFrameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMediaFrameException::builder).build());
                }
                case "MissingCodecPrivateDataException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MissingCodecPrivateDataException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MissingCodecPrivateDataException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listFragmentsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultKinesisVideoArchivedMediaClient.resolveMetricPublishers(clientConfiguration, listFragmentsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Kinesis Video Archived Media");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListFragments");
            ListFragmentsResponse listFragmentsResponse = (ListFragmentsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListFragments").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listFragmentsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListFragmentsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listFragmentsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultKinesisVideoArchivedMediaClient.lambda$listFragments$11((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    public final String serviceName() {
        return "kinesisvideo";
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata, Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper) {
        return protocolFactory.createErrorResponseHandler(operationMetadata, exceptionMetadataMapper);
    }

    private void updateRetryStrategyClientConfiguration(SdkClientConfiguration.Builder configuration) {
        ClientOverrideConfiguration.Builder builder = configuration.asOverrideConfigurationBuilder();
        RetryMode retryMode = builder.retryMode();
        if (retryMode != null) {
            configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)AwsRetryStrategy.forRetryMode((RetryMode)retryMode));
        } else {
            Consumer configurator = builder.retryStrategyConfigurator();
            if (configurator != null) {
                RetryStrategy.Builder defaultBuilder = AwsRetryStrategy.defaultRetryStrategy().toBuilder();
                configurator.accept(defaultBuilder);
                configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)defaultBuilder.build());
            } else {
                RetryStrategy retryStrategy = builder.retryStrategy();
                if (retryStrategy != null) {
                    configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)retryStrategy);
                }
            }
        }
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_MODE, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_STRATEGY, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_CONFIGURATOR, null);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        if (plugins.isEmpty()) {
            return clientConfiguration;
        }
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        KinesisVideoArchivedMediaServiceClientConfigurationBuilder serviceConfigBuilder = new KinesisVideoArchivedMediaServiceClientConfigurationBuilder(configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient((SdkServiceClientConfiguration.Builder)serviceConfigBuilder);
        }
        this.updateRetryStrategyClientConfiguration(configuration);
        return configuration.build();
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(KinesisVideoArchivedMediaException::builder).protocol(AwsJsonProtocol.REST_JSON).protocolVersion("1.1");
    }

    @Override
    public final KinesisVideoArchivedMediaServiceClientConfiguration serviceClientConfiguration() {
        return new KinesisVideoArchivedMediaServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    public void close() {
        this.clientHandler.close();
    }

    private static /* synthetic */ void lambda$listFragments$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getMediaForFragmentList$9(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getImages$7(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getHLSStreamingSessionURL$5(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getDASHStreamingSessionURL$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getClip$1(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }
}

