/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisvideoarchivedmedia.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.FragmentNumberListCopier;
import software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.KinesisVideoArchivedMediaRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetMediaForFragmentListRequest
extends KinesisVideoArchivedMediaRequest
implements ToCopyableBuilder<Builder, GetMediaForFragmentListRequest> {
    private static final SdkField<String> STREAM_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetMediaForFragmentListRequest.getter(GetMediaForFragmentListRequest::streamName)).setter(GetMediaForFragmentListRequest.setter(Builder::streamName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamName").build()}).build();
    private static final SdkField<List<String>> FRAGMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(GetMediaForFragmentListRequest.getter(GetMediaForFragmentListRequest::fragments)).setter(GetMediaForFragmentListRequest.setter(Builder::fragments)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Fragments").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STREAM_NAME_FIELD, FRAGMENTS_FIELD));
    private final String streamName;
    private final List<String> fragments;

    private GetMediaForFragmentListRequest(BuilderImpl builder) {
        super(builder);
        this.streamName = builder.streamName;
        this.fragments = builder.fragments;
    }

    public String streamName() {
        return this.streamName;
    }

    public List<String> fragments() {
        return this.fragments;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.streamName());
        hashCode = 31 * hashCode + Objects.hashCode(this.fragments());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetMediaForFragmentListRequest)) {
            return false;
        }
        GetMediaForFragmentListRequest other = (GetMediaForFragmentListRequest)((Object)obj);
        return Objects.equals(this.streamName(), other.streamName()) && Objects.equals(this.fragments(), other.fragments());
    }

    public String toString() {
        return ToString.builder((String)"GetMediaForFragmentListRequest").add("StreamName", (Object)this.streamName()).add("Fragments", this.fragments()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StreamName": {
                return Optional.ofNullable(clazz.cast(this.streamName()));
            }
            case "Fragments": {
                return Optional.ofNullable(clazz.cast(this.fragments()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetMediaForFragmentListRequest, T> g) {
        return obj -> g.apply((GetMediaForFragmentListRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends KinesisVideoArchivedMediaRequest.BuilderImpl
    implements Builder {
        private String streamName;
        private List<String> fragments = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetMediaForFragmentListRequest model) {
            super(model);
            this.streamName(model.streamName);
            this.fragments(model.fragments);
        }

        public final String getStreamName() {
            return this.streamName;
        }

        @Override
        public final Builder streamName(String streamName) {
            this.streamName = streamName;
            return this;
        }

        public final void setStreamName(String streamName) {
            this.streamName = streamName;
        }

        public final Collection<String> getFragments() {
            return this.fragments;
        }

        @Override
        public final Builder fragments(Collection<String> fragments) {
            this.fragments = FragmentNumberListCopier.copy(fragments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fragments(String ... fragments) {
            this.fragments(Arrays.asList(fragments));
            return this;
        }

        public final void setFragments(Collection<String> fragments) {
            this.fragments = FragmentNumberListCopier.copy(fragments);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetMediaForFragmentListRequest build() {
            return new GetMediaForFragmentListRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends KinesisVideoArchivedMediaRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetMediaForFragmentListRequest> {
        public Builder streamName(String var1);

        public Builder fragments(Collection<String> var1);

        public Builder fragments(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

