/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisvideoarchivedmedia.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the range of timestamps for the requested media, and the source of the timestamps.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DASHFragmentSelector implements SdkPojo, Serializable,
        ToCopyableBuilder<DASHFragmentSelector.Builder, DASHFragmentSelector> {
    private static final SdkField<String> FRAGMENT_SELECTOR_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DASHFragmentSelector::fragmentSelectorTypeAsString)).setter(setter(Builder::fragmentSelectorType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FragmentSelectorType").build())
            .build();

    private static final SdkField<DASHTimestampRange> TIMESTAMP_RANGE_FIELD = SdkField
            .<DASHTimestampRange> builder(MarshallingType.SDK_POJO).getter(getter(DASHFragmentSelector::timestampRange))
            .setter(setter(Builder::timestampRange)).constructor(DASHTimestampRange::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimestampRange").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FRAGMENT_SELECTOR_TYPE_FIELD,
            TIMESTAMP_RANGE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String fragmentSelectorType;

    private final DASHTimestampRange timestampRange;

    private DASHFragmentSelector(BuilderImpl builder) {
        this.fragmentSelectorType = builder.fragmentSelectorType;
        this.timestampRange = builder.timestampRange;
    }

    /**
     * <p>
     * The source of the timestamps for the requested media.
     * </p>
     * <p>
     * When <code>FragmentSelectorType</code> is set to <code>PRODUCER_TIMESTAMP</code> and
     * <a>GetDASHStreamingSessionURLInput$PlaybackMode</a> is <code>ON_DEMAND</code> or <code>LIVE_REPLAY</code>, the
     * first fragment ingested with a producer timestamp within the specified <a>FragmentSelector$TimestampRange</a> is
     * included in the media playlist. In addition, the fragments with producer timestamps within the
     * <code>TimestampRange</code> ingested immediately following the first fragment (up to the
     * <a>GetDASHStreamingSessionURLInput$MaxManifestFragmentResults</a> value) are included.
     * </p>
     * <p>
     * Fragments that have duplicate producer timestamps are deduplicated. This means that if producers are producing a
     * stream of fragments with producer timestamps that are approximately equal to the true clock time, the MPEG-DASH
     * manifest will contain all of the fragments within the requested timestamp range. If some fragments are ingested
     * within the same time range and very different points in time, only the oldest ingested collection of fragments
     * are returned.
     * </p>
     * <p>
     * When <code>FragmentSelectorType</code> is set to <code>PRODUCER_TIMESTAMP</code> and
     * <a>GetDASHStreamingSessionURLInput$PlaybackMode</a> is <code>LIVE</code>, the producer timestamps are used in the
     * MP4 fragments and for deduplication. But the most recently ingested fragments based on server timestamps are
     * included in the MPEG-DASH manifest. This means that even if fragments ingested in the past have producer
     * timestamps with values now, they are not included in the HLS media playlist.
     * </p>
     * <p>
     * The default is <code>SERVER_TIMESTAMP</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #fragmentSelectorType} will return {@link DASHFragmentSelectorType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #fragmentSelectorTypeAsString}.
     * </p>
     * 
     * @return The source of the timestamps for the requested media.</p>
     *         <p>
     *         When <code>FragmentSelectorType</code> is set to <code>PRODUCER_TIMESTAMP</code> and
     *         <a>GetDASHStreamingSessionURLInput$PlaybackMode</a> is <code>ON_DEMAND</code> or <code>LIVE_REPLAY</code>
     *         , the first fragment ingested with a producer timestamp within the specified
     *         <a>FragmentSelector$TimestampRange</a> is included in the media playlist. In addition, the fragments with
     *         producer timestamps within the <code>TimestampRange</code> ingested immediately following the first
     *         fragment (up to the <a>GetDASHStreamingSessionURLInput$MaxManifestFragmentResults</a> value) are
     *         included.
     *         </p>
     *         <p>
     *         Fragments that have duplicate producer timestamps are deduplicated. This means that if producers are
     *         producing a stream of fragments with producer timestamps that are approximately equal to the true clock
     *         time, the MPEG-DASH manifest will contain all of the fragments within the requested timestamp range. If
     *         some fragments are ingested within the same time range and very different points in time, only the oldest
     *         ingested collection of fragments are returned.
     *         </p>
     *         <p>
     *         When <code>FragmentSelectorType</code> is set to <code>PRODUCER_TIMESTAMP</code> and
     *         <a>GetDASHStreamingSessionURLInput$PlaybackMode</a> is <code>LIVE</code>, the producer timestamps are
     *         used in the MP4 fragments and for deduplication. But the most recently ingested fragments based on server
     *         timestamps are included in the MPEG-DASH manifest. This means that even if fragments ingested in the past
     *         have producer timestamps with values now, they are not included in the HLS media playlist.
     *         </p>
     *         <p>
     *         The default is <code>SERVER_TIMESTAMP</code>.
     * @see DASHFragmentSelectorType
     */
    public DASHFragmentSelectorType fragmentSelectorType() {
        return DASHFragmentSelectorType.fromValue(fragmentSelectorType);
    }

    /**
     * <p>
     * The source of the timestamps for the requested media.
     * </p>
     * <p>
     * When <code>FragmentSelectorType</code> is set to <code>PRODUCER_TIMESTAMP</code> and
     * <a>GetDASHStreamingSessionURLInput$PlaybackMode</a> is <code>ON_DEMAND</code> or <code>LIVE_REPLAY</code>, the
     * first fragment ingested with a producer timestamp within the specified <a>FragmentSelector$TimestampRange</a> is
     * included in the media playlist. In addition, the fragments with producer timestamps within the
     * <code>TimestampRange</code> ingested immediately following the first fragment (up to the
     * <a>GetDASHStreamingSessionURLInput$MaxManifestFragmentResults</a> value) are included.
     * </p>
     * <p>
     * Fragments that have duplicate producer timestamps are deduplicated. This means that if producers are producing a
     * stream of fragments with producer timestamps that are approximately equal to the true clock time, the MPEG-DASH
     * manifest will contain all of the fragments within the requested timestamp range. If some fragments are ingested
     * within the same time range and very different points in time, only the oldest ingested collection of fragments
     * are returned.
     * </p>
     * <p>
     * When <code>FragmentSelectorType</code> is set to <code>PRODUCER_TIMESTAMP</code> and
     * <a>GetDASHStreamingSessionURLInput$PlaybackMode</a> is <code>LIVE</code>, the producer timestamps are used in the
     * MP4 fragments and for deduplication. But the most recently ingested fragments based on server timestamps are
     * included in the MPEG-DASH manifest. This means that even if fragments ingested in the past have producer
     * timestamps with values now, they are not included in the HLS media playlist.
     * </p>
     * <p>
     * The default is <code>SERVER_TIMESTAMP</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #fragmentSelectorType} will return {@link DASHFragmentSelectorType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #fragmentSelectorTypeAsString}.
     * </p>
     * 
     * @return The source of the timestamps for the requested media.</p>
     *         <p>
     *         When <code>FragmentSelectorType</code> is set to <code>PRODUCER_TIMESTAMP</code> and
     *         <a>GetDASHStreamingSessionURLInput$PlaybackMode</a> is <code>ON_DEMAND</code> or <code>LIVE_REPLAY</code>
     *         , the first fragment ingested with a producer timestamp within the specified
     *         <a>FragmentSelector$TimestampRange</a> is included in the media playlist. In addition, the fragments with
     *         producer timestamps within the <code>TimestampRange</code> ingested immediately following the first
     *         fragment (up to the <a>GetDASHStreamingSessionURLInput$MaxManifestFragmentResults</a> value) are
     *         included.
     *         </p>
     *         <p>
     *         Fragments that have duplicate producer timestamps are deduplicated. This means that if producers are
     *         producing a stream of fragments with producer timestamps that are approximately equal to the true clock
     *         time, the MPEG-DASH manifest will contain all of the fragments within the requested timestamp range. If
     *         some fragments are ingested within the same time range and very different points in time, only the oldest
     *         ingested collection of fragments are returned.
     *         </p>
     *         <p>
     *         When <code>FragmentSelectorType</code> is set to <code>PRODUCER_TIMESTAMP</code> and
     *         <a>GetDASHStreamingSessionURLInput$PlaybackMode</a> is <code>LIVE</code>, the producer timestamps are
     *         used in the MP4 fragments and for deduplication. But the most recently ingested fragments based on server
     *         timestamps are included in the MPEG-DASH manifest. This means that even if fragments ingested in the past
     *         have producer timestamps with values now, they are not included in the HLS media playlist.
     *         </p>
     *         <p>
     *         The default is <code>SERVER_TIMESTAMP</code>.
     * @see DASHFragmentSelectorType
     */
    public String fragmentSelectorTypeAsString() {
        return fragmentSelectorType;
    }

    /**
     * <p>
     * The start and end of the timestamp range for the requested media.
     * </p>
     * <p>
     * This value should not be present if <code>PlaybackType</code> is <code>LIVE</code>.
     * </p>
     * 
     * @return The start and end of the timestamp range for the requested media.</p>
     *         <p>
     *         This value should not be present if <code>PlaybackType</code> is <code>LIVE</code>.
     */
    public DASHTimestampRange timestampRange() {
        return timestampRange;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(fragmentSelectorTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(timestampRange());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DASHFragmentSelector)) {
            return false;
        }
        DASHFragmentSelector other = (DASHFragmentSelector) obj;
        return Objects.equals(fragmentSelectorTypeAsString(), other.fragmentSelectorTypeAsString())
                && Objects.equals(timestampRange(), other.timestampRange());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DASHFragmentSelector").add("FragmentSelectorType", fragmentSelectorTypeAsString())
                .add("TimestampRange", timestampRange()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FragmentSelectorType":
            return Optional.ofNullable(clazz.cast(fragmentSelectorTypeAsString()));
        case "TimestampRange":
            return Optional.ofNullable(clazz.cast(timestampRange()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DASHFragmentSelector, T> g) {
        return obj -> g.apply((DASHFragmentSelector) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DASHFragmentSelector> {
        /**
         * <p>
         * The source of the timestamps for the requested media.
         * </p>
         * <p>
         * When <code>FragmentSelectorType</code> is set to <code>PRODUCER_TIMESTAMP</code> and
         * <a>GetDASHStreamingSessionURLInput$PlaybackMode</a> is <code>ON_DEMAND</code> or <code>LIVE_REPLAY</code>,
         * the first fragment ingested with a producer timestamp within the specified
         * <a>FragmentSelector$TimestampRange</a> is included in the media playlist. In addition, the fragments with
         * producer timestamps within the <code>TimestampRange</code> ingested immediately following the first fragment
         * (up to the <a>GetDASHStreamingSessionURLInput$MaxManifestFragmentResults</a> value) are included.
         * </p>
         * <p>
         * Fragments that have duplicate producer timestamps are deduplicated. This means that if producers are
         * producing a stream of fragments with producer timestamps that are approximately equal to the true clock time,
         * the MPEG-DASH manifest will contain all of the fragments within the requested timestamp range. If some
         * fragments are ingested within the same time range and very different points in time, only the oldest ingested
         * collection of fragments are returned.
         * </p>
         * <p>
         * When <code>FragmentSelectorType</code> is set to <code>PRODUCER_TIMESTAMP</code> and
         * <a>GetDASHStreamingSessionURLInput$PlaybackMode</a> is <code>LIVE</code>, the producer timestamps are used in
         * the MP4 fragments and for deduplication. But the most recently ingested fragments based on server timestamps
         * are included in the MPEG-DASH manifest. This means that even if fragments ingested in the past have producer
         * timestamps with values now, they are not included in the HLS media playlist.
         * </p>
         * <p>
         * The default is <code>SERVER_TIMESTAMP</code>.
         * </p>
         * 
         * @param fragmentSelectorType
         *        The source of the timestamps for the requested media.</p>
         *        <p>
         *        When <code>FragmentSelectorType</code> is set to <code>PRODUCER_TIMESTAMP</code> and
         *        <a>GetDASHStreamingSessionURLInput$PlaybackMode</a> is <code>ON_DEMAND</code> or
         *        <code>LIVE_REPLAY</code>, the first fragment ingested with a producer timestamp within the specified
         *        <a>FragmentSelector$TimestampRange</a> is included in the media playlist. In addition, the fragments
         *        with producer timestamps within the <code>TimestampRange</code> ingested immediately following the
         *        first fragment (up to the <a>GetDASHStreamingSessionURLInput$MaxManifestFragmentResults</a> value) are
         *        included.
         *        </p>
         *        <p>
         *        Fragments that have duplicate producer timestamps are deduplicated. This means that if producers are
         *        producing a stream of fragments with producer timestamps that are approximately equal to the true
         *        clock time, the MPEG-DASH manifest will contain all of the fragments within the requested timestamp
         *        range. If some fragments are ingested within the same time range and very different points in time,
         *        only the oldest ingested collection of fragments are returned.
         *        </p>
         *        <p>
         *        When <code>FragmentSelectorType</code> is set to <code>PRODUCER_TIMESTAMP</code> and
         *        <a>GetDASHStreamingSessionURLInput$PlaybackMode</a> is <code>LIVE</code>, the producer timestamps are
         *        used in the MP4 fragments and for deduplication. But the most recently ingested fragments based on
         *        server timestamps are included in the MPEG-DASH manifest. This means that even if fragments ingested
         *        in the past have producer timestamps with values now, they are not included in the HLS media playlist.
         *        </p>
         *        <p>
         *        The default is <code>SERVER_TIMESTAMP</code>.
         * @see DASHFragmentSelectorType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DASHFragmentSelectorType
         */
        Builder fragmentSelectorType(String fragmentSelectorType);

        /**
         * <p>
         * The source of the timestamps for the requested media.
         * </p>
         * <p>
         * When <code>FragmentSelectorType</code> is set to <code>PRODUCER_TIMESTAMP</code> and
         * <a>GetDASHStreamingSessionURLInput$PlaybackMode</a> is <code>ON_DEMAND</code> or <code>LIVE_REPLAY</code>,
         * the first fragment ingested with a producer timestamp within the specified
         * <a>FragmentSelector$TimestampRange</a> is included in the media playlist. In addition, the fragments with
         * producer timestamps within the <code>TimestampRange</code> ingested immediately following the first fragment
         * (up to the <a>GetDASHStreamingSessionURLInput$MaxManifestFragmentResults</a> value) are included.
         * </p>
         * <p>
         * Fragments that have duplicate producer timestamps are deduplicated. This means that if producers are
         * producing a stream of fragments with producer timestamps that are approximately equal to the true clock time,
         * the MPEG-DASH manifest will contain all of the fragments within the requested timestamp range. If some
         * fragments are ingested within the same time range and very different points in time, only the oldest ingested
         * collection of fragments are returned.
         * </p>
         * <p>
         * When <code>FragmentSelectorType</code> is set to <code>PRODUCER_TIMESTAMP</code> and
         * <a>GetDASHStreamingSessionURLInput$PlaybackMode</a> is <code>LIVE</code>, the producer timestamps are used in
         * the MP4 fragments and for deduplication. But the most recently ingested fragments based on server timestamps
         * are included in the MPEG-DASH manifest. This means that even if fragments ingested in the past have producer
         * timestamps with values now, they are not included in the HLS media playlist.
         * </p>
         * <p>
         * The default is <code>SERVER_TIMESTAMP</code>.
         * </p>
         * 
         * @param fragmentSelectorType
         *        The source of the timestamps for the requested media.</p>
         *        <p>
         *        When <code>FragmentSelectorType</code> is set to <code>PRODUCER_TIMESTAMP</code> and
         *        <a>GetDASHStreamingSessionURLInput$PlaybackMode</a> is <code>ON_DEMAND</code> or
         *        <code>LIVE_REPLAY</code>, the first fragment ingested with a producer timestamp within the specified
         *        <a>FragmentSelector$TimestampRange</a> is included in the media playlist. In addition, the fragments
         *        with producer timestamps within the <code>TimestampRange</code> ingested immediately following the
         *        first fragment (up to the <a>GetDASHStreamingSessionURLInput$MaxManifestFragmentResults</a> value) are
         *        included.
         *        </p>
         *        <p>
         *        Fragments that have duplicate producer timestamps are deduplicated. This means that if producers are
         *        producing a stream of fragments with producer timestamps that are approximately equal to the true
         *        clock time, the MPEG-DASH manifest will contain all of the fragments within the requested timestamp
         *        range. If some fragments are ingested within the same time range and very different points in time,
         *        only the oldest ingested collection of fragments are returned.
         *        </p>
         *        <p>
         *        When <code>FragmentSelectorType</code> is set to <code>PRODUCER_TIMESTAMP</code> and
         *        <a>GetDASHStreamingSessionURLInput$PlaybackMode</a> is <code>LIVE</code>, the producer timestamps are
         *        used in the MP4 fragments and for deduplication. But the most recently ingested fragments based on
         *        server timestamps are included in the MPEG-DASH manifest. This means that even if fragments ingested
         *        in the past have producer timestamps with values now, they are not included in the HLS media playlist.
         *        </p>
         *        <p>
         *        The default is <code>SERVER_TIMESTAMP</code>.
         * @see DASHFragmentSelectorType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DASHFragmentSelectorType
         */
        Builder fragmentSelectorType(DASHFragmentSelectorType fragmentSelectorType);

        /**
         * <p>
         * The start and end of the timestamp range for the requested media.
         * </p>
         * <p>
         * This value should not be present if <code>PlaybackType</code> is <code>LIVE</code>.
         * </p>
         * 
         * @param timestampRange
         *        The start and end of the timestamp range for the requested media.</p>
         *        <p>
         *        This value should not be present if <code>PlaybackType</code> is <code>LIVE</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timestampRange(DASHTimestampRange timestampRange);

        /**
         * <p>
         * The start and end of the timestamp range for the requested media.
         * </p>
         * <p>
         * This value should not be present if <code>PlaybackType</code> is <code>LIVE</code>.
         * </p>
         * This is a convenience that creates an instance of the {@link DASHTimestampRange.Builder} avoiding the need to
         * create one manually via {@link DASHTimestampRange#builder()}.
         *
         * When the {@link Consumer} completes, {@link DASHTimestampRange.Builder#build()} is called immediately and its
         * result is passed to {@link #timestampRange(DASHTimestampRange)}.
         * 
         * @param timestampRange
         *        a consumer that will call methods on {@link DASHTimestampRange.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #timestampRange(DASHTimestampRange)
         */
        default Builder timestampRange(Consumer<DASHTimestampRange.Builder> timestampRange) {
            return timestampRange(DASHTimestampRange.builder().applyMutation(timestampRange).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String fragmentSelectorType;

        private DASHTimestampRange timestampRange;

        private BuilderImpl() {
        }

        private BuilderImpl(DASHFragmentSelector model) {
            fragmentSelectorType(model.fragmentSelectorType);
            timestampRange(model.timestampRange);
        }

        public final String getFragmentSelectorTypeAsString() {
            return fragmentSelectorType;
        }

        @Override
        public final Builder fragmentSelectorType(String fragmentSelectorType) {
            this.fragmentSelectorType = fragmentSelectorType;
            return this;
        }

        @Override
        public final Builder fragmentSelectorType(DASHFragmentSelectorType fragmentSelectorType) {
            this.fragmentSelectorType(fragmentSelectorType.toString());
            return this;
        }

        public final void setFragmentSelectorType(String fragmentSelectorType) {
            this.fragmentSelectorType = fragmentSelectorType;
        }

        public final DASHTimestampRange.Builder getTimestampRange() {
            return timestampRange != null ? timestampRange.toBuilder() : null;
        }

        @Override
        public final Builder timestampRange(DASHTimestampRange timestampRange) {
            this.timestampRange = timestampRange;
            return this;
        }

        public final void setTimestampRange(DASHTimestampRange.BuilderImpl timestampRange) {
            this.timestampRange = timestampRange != null ? timestampRange.build() : null;
        }

        @Override
        public DASHFragmentSelector build() {
            return new DASHFragmentSelector(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
