/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisvideoarchivedmedia.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the range of timestamps for the requested media, and the source of the timestamps.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class HLSFragmentSelector implements SdkPojo, Serializable,
        ToCopyableBuilder<HLSFragmentSelector.Builder, HLSFragmentSelector> {
    private static final SdkField<String> FRAGMENT_SELECTOR_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(HLSFragmentSelector::fragmentSelectorTypeAsString)).setter(setter(Builder::fragmentSelectorType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FragmentSelectorType").build())
            .build();

    private static final SdkField<HLSTimestampRange> TIMESTAMP_RANGE_FIELD = SdkField
            .<HLSTimestampRange> builder(MarshallingType.SDK_POJO).getter(getter(HLSFragmentSelector::timestampRange))
            .setter(setter(Builder::timestampRange)).constructor(HLSTimestampRange::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimestampRange").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FRAGMENT_SELECTOR_TYPE_FIELD,
            TIMESTAMP_RANGE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String fragmentSelectorType;

    private final HLSTimestampRange timestampRange;

    private HLSFragmentSelector(BuilderImpl builder) {
        this.fragmentSelectorType = builder.fragmentSelectorType;
        this.timestampRange = builder.timestampRange;
    }

    /**
     * <p>
     * The source of the timestamps for the requested media.
     * </p>
     * <p>
     * When <code>FragmentSelectorType</code> is set to <code>PRODUCER_TIMESTAMP</code> and
     * <a>GetHLSStreamingSessionURLInput$PlaybackMode</a> is <code>ON_DEMAND</code> or <code>LIVE_REPLAY</code>, the
     * first fragment ingested with a producer timestamp within the specified <a>FragmentSelector$TimestampRange</a> is
     * included in the media playlist. In addition, the fragments with producer timestamps within the
     * <code>TimestampRange</code> ingested immediately following the first fragment (up to the
     * <a>GetHLSStreamingSessionURLInput$MaxMediaPlaylistFragmentResults</a> value) are included.
     * </p>
     * <p>
     * Fragments that have duplicate producer timestamps are deduplicated. This means that if producers are producing a
     * stream of fragments with producer timestamps that are approximately equal to the true clock time, the HLS media
     * playlists will contain all of the fragments within the requested timestamp range. If some fragments are ingested
     * within the same time range and very different points in time, only the oldest ingested collection of fragments
     * are returned.
     * </p>
     * <p>
     * When <code>FragmentSelectorType</code> is set to <code>PRODUCER_TIMESTAMP</code> and
     * <a>GetHLSStreamingSessionURLInput$PlaybackMode</a> is <code>LIVE</code>, the producer timestamps are used in the
     * MP4 fragments and for deduplication. But the most recently ingested fragments based on server timestamps are
     * included in the HLS media playlist. This means that even if fragments ingested in the past have producer
     * timestamps with values now, they are not included in the HLS media playlist.
     * </p>
     * <p>
     * The default is <code>SERVER_TIMESTAMP</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #fragmentSelectorType} will return {@link HLSFragmentSelectorType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #fragmentSelectorTypeAsString}.
     * </p>
     * 
     * @return The source of the timestamps for the requested media.</p>
     *         <p>
     *         When <code>FragmentSelectorType</code> is set to <code>PRODUCER_TIMESTAMP</code> and
     *         <a>GetHLSStreamingSessionURLInput$PlaybackMode</a> is <code>ON_DEMAND</code> or <code>LIVE_REPLAY</code>,
     *         the first fragment ingested with a producer timestamp within the specified
     *         <a>FragmentSelector$TimestampRange</a> is included in the media playlist. In addition, the fragments with
     *         producer timestamps within the <code>TimestampRange</code> ingested immediately following the first
     *         fragment (up to the <a>GetHLSStreamingSessionURLInput$MaxMediaPlaylistFragmentResults</a> value) are
     *         included.
     *         </p>
     *         <p>
     *         Fragments that have duplicate producer timestamps are deduplicated. This means that if producers are
     *         producing a stream of fragments with producer timestamps that are approximately equal to the true clock
     *         time, the HLS media playlists will contain all of the fragments within the requested timestamp range. If
     *         some fragments are ingested within the same time range and very different points in time, only the oldest
     *         ingested collection of fragments are returned.
     *         </p>
     *         <p>
     *         When <code>FragmentSelectorType</code> is set to <code>PRODUCER_TIMESTAMP</code> and
     *         <a>GetHLSStreamingSessionURLInput$PlaybackMode</a> is <code>LIVE</code>, the producer timestamps are used
     *         in the MP4 fragments and for deduplication. But the most recently ingested fragments based on server
     *         timestamps are included in the HLS media playlist. This means that even if fragments ingested in the past
     *         have producer timestamps with values now, they are not included in the HLS media playlist.
     *         </p>
     *         <p>
     *         The default is <code>SERVER_TIMESTAMP</code>.
     * @see HLSFragmentSelectorType
     */
    public HLSFragmentSelectorType fragmentSelectorType() {
        return HLSFragmentSelectorType.fromValue(fragmentSelectorType);
    }

    /**
     * <p>
     * The source of the timestamps for the requested media.
     * </p>
     * <p>
     * When <code>FragmentSelectorType</code> is set to <code>PRODUCER_TIMESTAMP</code> and
     * <a>GetHLSStreamingSessionURLInput$PlaybackMode</a> is <code>ON_DEMAND</code> or <code>LIVE_REPLAY</code>, the
     * first fragment ingested with a producer timestamp within the specified <a>FragmentSelector$TimestampRange</a> is
     * included in the media playlist. In addition, the fragments with producer timestamps within the
     * <code>TimestampRange</code> ingested immediately following the first fragment (up to the
     * <a>GetHLSStreamingSessionURLInput$MaxMediaPlaylistFragmentResults</a> value) are included.
     * </p>
     * <p>
     * Fragments that have duplicate producer timestamps are deduplicated. This means that if producers are producing a
     * stream of fragments with producer timestamps that are approximately equal to the true clock time, the HLS media
     * playlists will contain all of the fragments within the requested timestamp range. If some fragments are ingested
     * within the same time range and very different points in time, only the oldest ingested collection of fragments
     * are returned.
     * </p>
     * <p>
     * When <code>FragmentSelectorType</code> is set to <code>PRODUCER_TIMESTAMP</code> and
     * <a>GetHLSStreamingSessionURLInput$PlaybackMode</a> is <code>LIVE</code>, the producer timestamps are used in the
     * MP4 fragments and for deduplication. But the most recently ingested fragments based on server timestamps are
     * included in the HLS media playlist. This means that even if fragments ingested in the past have producer
     * timestamps with values now, they are not included in the HLS media playlist.
     * </p>
     * <p>
     * The default is <code>SERVER_TIMESTAMP</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #fragmentSelectorType} will return {@link HLSFragmentSelectorType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #fragmentSelectorTypeAsString}.
     * </p>
     * 
     * @return The source of the timestamps for the requested media.</p>
     *         <p>
     *         When <code>FragmentSelectorType</code> is set to <code>PRODUCER_TIMESTAMP</code> and
     *         <a>GetHLSStreamingSessionURLInput$PlaybackMode</a> is <code>ON_DEMAND</code> or <code>LIVE_REPLAY</code>,
     *         the first fragment ingested with a producer timestamp within the specified
     *         <a>FragmentSelector$TimestampRange</a> is included in the media playlist. In addition, the fragments with
     *         producer timestamps within the <code>TimestampRange</code> ingested immediately following the first
     *         fragment (up to the <a>GetHLSStreamingSessionURLInput$MaxMediaPlaylistFragmentResults</a> value) are
     *         included.
     *         </p>
     *         <p>
     *         Fragments that have duplicate producer timestamps are deduplicated. This means that if producers are
     *         producing a stream of fragments with producer timestamps that are approximately equal to the true clock
     *         time, the HLS media playlists will contain all of the fragments within the requested timestamp range. If
     *         some fragments are ingested within the same time range and very different points in time, only the oldest
     *         ingested collection of fragments are returned.
     *         </p>
     *         <p>
     *         When <code>FragmentSelectorType</code> is set to <code>PRODUCER_TIMESTAMP</code> and
     *         <a>GetHLSStreamingSessionURLInput$PlaybackMode</a> is <code>LIVE</code>, the producer timestamps are used
     *         in the MP4 fragments and for deduplication. But the most recently ingested fragments based on server
     *         timestamps are included in the HLS media playlist. This means that even if fragments ingested in the past
     *         have producer timestamps with values now, they are not included in the HLS media playlist.
     *         </p>
     *         <p>
     *         The default is <code>SERVER_TIMESTAMP</code>.
     * @see HLSFragmentSelectorType
     */
    public String fragmentSelectorTypeAsString() {
        return fragmentSelectorType;
    }

    /**
     * <p>
     * The start and end of the timestamp range for the requested media.
     * </p>
     * <p>
     * This value should not be present if <code>PlaybackType</code> is <code>LIVE</code>.
     * </p>
     * 
     * @return The start and end of the timestamp range for the requested media.</p>
     *         <p>
     *         This value should not be present if <code>PlaybackType</code> is <code>LIVE</code>.
     */
    public HLSTimestampRange timestampRange() {
        return timestampRange;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(fragmentSelectorTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(timestampRange());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HLSFragmentSelector)) {
            return false;
        }
        HLSFragmentSelector other = (HLSFragmentSelector) obj;
        return Objects.equals(fragmentSelectorTypeAsString(), other.fragmentSelectorTypeAsString())
                && Objects.equals(timestampRange(), other.timestampRange());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("HLSFragmentSelector").add("FragmentSelectorType", fragmentSelectorTypeAsString())
                .add("TimestampRange", timestampRange()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FragmentSelectorType":
            return Optional.ofNullable(clazz.cast(fragmentSelectorTypeAsString()));
        case "TimestampRange":
            return Optional.ofNullable(clazz.cast(timestampRange()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<HLSFragmentSelector, T> g) {
        return obj -> g.apply((HLSFragmentSelector) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, HLSFragmentSelector> {
        /**
         * <p>
         * The source of the timestamps for the requested media.
         * </p>
         * <p>
         * When <code>FragmentSelectorType</code> is set to <code>PRODUCER_TIMESTAMP</code> and
         * <a>GetHLSStreamingSessionURLInput$PlaybackMode</a> is <code>ON_DEMAND</code> or <code>LIVE_REPLAY</code>, the
         * first fragment ingested with a producer timestamp within the specified <a>FragmentSelector$TimestampRange</a>
         * is included in the media playlist. In addition, the fragments with producer timestamps within the
         * <code>TimestampRange</code> ingested immediately following the first fragment (up to the
         * <a>GetHLSStreamingSessionURLInput$MaxMediaPlaylistFragmentResults</a> value) are included.
         * </p>
         * <p>
         * Fragments that have duplicate producer timestamps are deduplicated. This means that if producers are
         * producing a stream of fragments with producer timestamps that are approximately equal to the true clock time,
         * the HLS media playlists will contain all of the fragments within the requested timestamp range. If some
         * fragments are ingested within the same time range and very different points in time, only the oldest ingested
         * collection of fragments are returned.
         * </p>
         * <p>
         * When <code>FragmentSelectorType</code> is set to <code>PRODUCER_TIMESTAMP</code> and
         * <a>GetHLSStreamingSessionURLInput$PlaybackMode</a> is <code>LIVE</code>, the producer timestamps are used in
         * the MP4 fragments and for deduplication. But the most recently ingested fragments based on server timestamps
         * are included in the HLS media playlist. This means that even if fragments ingested in the past have producer
         * timestamps with values now, they are not included in the HLS media playlist.
         * </p>
         * <p>
         * The default is <code>SERVER_TIMESTAMP</code>.
         * </p>
         * 
         * @param fragmentSelectorType
         *        The source of the timestamps for the requested media.</p>
         *        <p>
         *        When <code>FragmentSelectorType</code> is set to <code>PRODUCER_TIMESTAMP</code> and
         *        <a>GetHLSStreamingSessionURLInput$PlaybackMode</a> is <code>ON_DEMAND</code> or
         *        <code>LIVE_REPLAY</code>, the first fragment ingested with a producer timestamp within the specified
         *        <a>FragmentSelector$TimestampRange</a> is included in the media playlist. In addition, the fragments
         *        with producer timestamps within the <code>TimestampRange</code> ingested immediately following the
         *        first fragment (up to the <a>GetHLSStreamingSessionURLInput$MaxMediaPlaylistFragmentResults</a> value)
         *        are included.
         *        </p>
         *        <p>
         *        Fragments that have duplicate producer timestamps are deduplicated. This means that if producers are
         *        producing a stream of fragments with producer timestamps that are approximately equal to the true
         *        clock time, the HLS media playlists will contain all of the fragments within the requested timestamp
         *        range. If some fragments are ingested within the same time range and very different points in time,
         *        only the oldest ingested collection of fragments are returned.
         *        </p>
         *        <p>
         *        When <code>FragmentSelectorType</code> is set to <code>PRODUCER_TIMESTAMP</code> and
         *        <a>GetHLSStreamingSessionURLInput$PlaybackMode</a> is <code>LIVE</code>, the producer timestamps are
         *        used in the MP4 fragments and for deduplication. But the most recently ingested fragments based on
         *        server timestamps are included in the HLS media playlist. This means that even if fragments ingested
         *        in the past have producer timestamps with values now, they are not included in the HLS media playlist.
         *        </p>
         *        <p>
         *        The default is <code>SERVER_TIMESTAMP</code>.
         * @see HLSFragmentSelectorType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HLSFragmentSelectorType
         */
        Builder fragmentSelectorType(String fragmentSelectorType);

        /**
         * <p>
         * The source of the timestamps for the requested media.
         * </p>
         * <p>
         * When <code>FragmentSelectorType</code> is set to <code>PRODUCER_TIMESTAMP</code> and
         * <a>GetHLSStreamingSessionURLInput$PlaybackMode</a> is <code>ON_DEMAND</code> or <code>LIVE_REPLAY</code>, the
         * first fragment ingested with a producer timestamp within the specified <a>FragmentSelector$TimestampRange</a>
         * is included in the media playlist. In addition, the fragments with producer timestamps within the
         * <code>TimestampRange</code> ingested immediately following the first fragment (up to the
         * <a>GetHLSStreamingSessionURLInput$MaxMediaPlaylistFragmentResults</a> value) are included.
         * </p>
         * <p>
         * Fragments that have duplicate producer timestamps are deduplicated. This means that if producers are
         * producing a stream of fragments with producer timestamps that are approximately equal to the true clock time,
         * the HLS media playlists will contain all of the fragments within the requested timestamp range. If some
         * fragments are ingested within the same time range and very different points in time, only the oldest ingested
         * collection of fragments are returned.
         * </p>
         * <p>
         * When <code>FragmentSelectorType</code> is set to <code>PRODUCER_TIMESTAMP</code> and
         * <a>GetHLSStreamingSessionURLInput$PlaybackMode</a> is <code>LIVE</code>, the producer timestamps are used in
         * the MP4 fragments and for deduplication. But the most recently ingested fragments based on server timestamps
         * are included in the HLS media playlist. This means that even if fragments ingested in the past have producer
         * timestamps with values now, they are not included in the HLS media playlist.
         * </p>
         * <p>
         * The default is <code>SERVER_TIMESTAMP</code>.
         * </p>
         * 
         * @param fragmentSelectorType
         *        The source of the timestamps for the requested media.</p>
         *        <p>
         *        When <code>FragmentSelectorType</code> is set to <code>PRODUCER_TIMESTAMP</code> and
         *        <a>GetHLSStreamingSessionURLInput$PlaybackMode</a> is <code>ON_DEMAND</code> or
         *        <code>LIVE_REPLAY</code>, the first fragment ingested with a producer timestamp within the specified
         *        <a>FragmentSelector$TimestampRange</a> is included in the media playlist. In addition, the fragments
         *        with producer timestamps within the <code>TimestampRange</code> ingested immediately following the
         *        first fragment (up to the <a>GetHLSStreamingSessionURLInput$MaxMediaPlaylistFragmentResults</a> value)
         *        are included.
         *        </p>
         *        <p>
         *        Fragments that have duplicate producer timestamps are deduplicated. This means that if producers are
         *        producing a stream of fragments with producer timestamps that are approximately equal to the true
         *        clock time, the HLS media playlists will contain all of the fragments within the requested timestamp
         *        range. If some fragments are ingested within the same time range and very different points in time,
         *        only the oldest ingested collection of fragments are returned.
         *        </p>
         *        <p>
         *        When <code>FragmentSelectorType</code> is set to <code>PRODUCER_TIMESTAMP</code> and
         *        <a>GetHLSStreamingSessionURLInput$PlaybackMode</a> is <code>LIVE</code>, the producer timestamps are
         *        used in the MP4 fragments and for deduplication. But the most recently ingested fragments based on
         *        server timestamps are included in the HLS media playlist. This means that even if fragments ingested
         *        in the past have producer timestamps with values now, they are not included in the HLS media playlist.
         *        </p>
         *        <p>
         *        The default is <code>SERVER_TIMESTAMP</code>.
         * @see HLSFragmentSelectorType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HLSFragmentSelectorType
         */
        Builder fragmentSelectorType(HLSFragmentSelectorType fragmentSelectorType);

        /**
         * <p>
         * The start and end of the timestamp range for the requested media.
         * </p>
         * <p>
         * This value should not be present if <code>PlaybackType</code> is <code>LIVE</code>.
         * </p>
         * 
         * @param timestampRange
         *        The start and end of the timestamp range for the requested media.</p>
         *        <p>
         *        This value should not be present if <code>PlaybackType</code> is <code>LIVE</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timestampRange(HLSTimestampRange timestampRange);

        /**
         * <p>
         * The start and end of the timestamp range for the requested media.
         * </p>
         * <p>
         * This value should not be present if <code>PlaybackType</code> is <code>LIVE</code>.
         * </p>
         * This is a convenience that creates an instance of the {@link HLSTimestampRange.Builder} avoiding the need to
         * create one manually via {@link HLSTimestampRange#builder()}.
         *
         * When the {@link Consumer} completes, {@link HLSTimestampRange.Builder#build()} is called immediately and its
         * result is passed to {@link #timestampRange(HLSTimestampRange)}.
         * 
         * @param timestampRange
         *        a consumer that will call methods on {@link HLSTimestampRange.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #timestampRange(HLSTimestampRange)
         */
        default Builder timestampRange(Consumer<HLSTimestampRange.Builder> timestampRange) {
            return timestampRange(HLSTimestampRange.builder().applyMutation(timestampRange).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String fragmentSelectorType;

        private HLSTimestampRange timestampRange;

        private BuilderImpl() {
        }

        private BuilderImpl(HLSFragmentSelector model) {
            fragmentSelectorType(model.fragmentSelectorType);
            timestampRange(model.timestampRange);
        }

        public final String getFragmentSelectorTypeAsString() {
            return fragmentSelectorType;
        }

        @Override
        public final Builder fragmentSelectorType(String fragmentSelectorType) {
            this.fragmentSelectorType = fragmentSelectorType;
            return this;
        }

        @Override
        public final Builder fragmentSelectorType(HLSFragmentSelectorType fragmentSelectorType) {
            this.fragmentSelectorType(fragmentSelectorType.toString());
            return this;
        }

        public final void setFragmentSelectorType(String fragmentSelectorType) {
            this.fragmentSelectorType = fragmentSelectorType;
        }

        public final HLSTimestampRange.Builder getTimestampRange() {
            return timestampRange != null ? timestampRange.toBuilder() : null;
        }

        @Override
        public final Builder timestampRange(HLSTimestampRange timestampRange) {
            this.timestampRange = timestampRange;
            return this;
        }

        public final void setTimestampRange(HLSTimestampRange.BuilderImpl timestampRange) {
            this.timestampRange = timestampRange != null ? timestampRange.build() : null;
        }

        @Override
        public HLSFragmentSelector build() {
            return new HLSFragmentSelector(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
