/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisvideoarchivedmedia.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.FragmentSelectorType;
import software.amazon.awssdk.services.kinesisvideoarchivedmedia.model.TimestampRange;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FragmentSelector
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FragmentSelector> {
    private static final SdkField<String> FRAGMENT_SELECTOR_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(FragmentSelector.getter(FragmentSelector::fragmentSelectorTypeAsString)).setter(FragmentSelector.setter(Builder::fragmentSelectorType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FragmentSelectorType").build()}).build();
    private static final SdkField<TimestampRange> TIMESTAMP_RANGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(FragmentSelector.getter(FragmentSelector::timestampRange)).setter(FragmentSelector.setter(Builder::timestampRange)).constructor(TimestampRange::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimestampRange").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FRAGMENT_SELECTOR_TYPE_FIELD, TIMESTAMP_RANGE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String fragmentSelectorType;
    private final TimestampRange timestampRange;

    private FragmentSelector(BuilderImpl builder) {
        this.fragmentSelectorType = builder.fragmentSelectorType;
        this.timestampRange = builder.timestampRange;
    }

    public FragmentSelectorType fragmentSelectorType() {
        return FragmentSelectorType.fromValue(this.fragmentSelectorType);
    }

    public String fragmentSelectorTypeAsString() {
        return this.fragmentSelectorType;
    }

    public TimestampRange timestampRange() {
        return this.timestampRange;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.fragmentSelectorTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.timestampRange());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FragmentSelector)) {
            return false;
        }
        FragmentSelector other = (FragmentSelector)obj;
        return Objects.equals(this.fragmentSelectorTypeAsString(), other.fragmentSelectorTypeAsString()) && Objects.equals(this.timestampRange(), other.timestampRange());
    }

    public String toString() {
        return ToString.builder((String)"FragmentSelector").add("FragmentSelectorType", (Object)this.fragmentSelectorTypeAsString()).add("TimestampRange", (Object)this.timestampRange()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FragmentSelectorType": {
                return Optional.ofNullable(clazz.cast(this.fragmentSelectorTypeAsString()));
            }
            case "TimestampRange": {
                return Optional.ofNullable(clazz.cast(this.timestampRange()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FragmentSelector, T> g) {
        return obj -> g.apply((FragmentSelector)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String fragmentSelectorType;
        private TimestampRange timestampRange;

        private BuilderImpl() {
        }

        private BuilderImpl(FragmentSelector model) {
            this.fragmentSelectorType(model.fragmentSelectorType);
            this.timestampRange(model.timestampRange);
        }

        public final String getFragmentSelectorTypeAsString() {
            return this.fragmentSelectorType;
        }

        @Override
        public final Builder fragmentSelectorType(String fragmentSelectorType) {
            this.fragmentSelectorType = fragmentSelectorType;
            return this;
        }

        @Override
        public final Builder fragmentSelectorType(FragmentSelectorType fragmentSelectorType) {
            this.fragmentSelectorType(fragmentSelectorType.toString());
            return this;
        }

        public final void setFragmentSelectorType(String fragmentSelectorType) {
            this.fragmentSelectorType = fragmentSelectorType;
        }

        public final TimestampRange.Builder getTimestampRange() {
            return this.timestampRange != null ? this.timestampRange.toBuilder() : null;
        }

        @Override
        public final Builder timestampRange(TimestampRange timestampRange) {
            this.timestampRange = timestampRange;
            return this;
        }

        public final void setTimestampRange(TimestampRange.BuilderImpl timestampRange) {
            this.timestampRange = timestampRange != null ? timestampRange.build() : null;
        }

        public FragmentSelector build() {
            return new FragmentSelector(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FragmentSelector> {
        public Builder fragmentSelectorType(String var1);

        public Builder fragmentSelectorType(FragmentSelectorType var1);

        public Builder timestampRange(TimestampRange var1);

        default public Builder timestampRange(Consumer<TimestampRange.Builder> timestampRange) {
            return this.timestampRange((TimestampRange)((TimestampRange.Builder)TimestampRange.builder().applyMutation(timestampRange)).build());
        }
    }
}

