/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisvideomedia.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Identifies the chunk on the Kinesis video stream where you want the <code>GetMedia</code> API to start returning
 * media data. You have the following options to identify the starting chunk:
 * </p>
 * <ul>
 * <li>
 * <p>
 * Choose the latest (or oldest) chunk.
 * </p>
 * </li>
 * <li>
 * <p>
 * Identify a specific chunk. You can identify a specific chunk either by providing a fragment number or timestamp
 * (server or producer).
 * </p>
 * </li>
 * <li>
 * <p>
 * Each chunk's metadata includes a continuation token as a Matroska (MKV) tag (
 * <code>AWS_KINESISVIDEO_CONTINUATION_TOKEN</code>). If your previous <code>GetMedia</code> request terminated, you can
 * use this tag value in your next <code>GetMedia</code> request. The API then starts returning chunks starting where
 * the last API ended.
 * </p>
 * </li>
 * </ul>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartSelector implements SdkPojo, Serializable, ToCopyableBuilder<StartSelector.Builder, StartSelector> {
    private static final SdkField<String> START_SELECTOR_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(StartSelector::startSelectorTypeAsString)).setter(setter(Builder::startSelectorType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartSelectorType").build()).build();

    private static final SdkField<String> AFTER_FRAGMENT_NUMBER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(StartSelector::afterFragmentNumber)).setter(setter(Builder::afterFragmentNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AfterFragmentNumber").build())
            .build();

    private static final SdkField<Instant> START_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(StartSelector::startTimestamp)).setter(setter(Builder::startTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTimestamp").build()).build();

    private static final SdkField<String> CONTINUATION_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(StartSelector::continuationToken)).setter(setter(Builder::continuationToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContinuationToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(START_SELECTOR_TYPE_FIELD,
            AFTER_FRAGMENT_NUMBER_FIELD, START_TIMESTAMP_FIELD, CONTINUATION_TOKEN_FIELD));

    private static final long serialVersionUID = 1L;

    private final String startSelectorType;

    private final String afterFragmentNumber;

    private final Instant startTimestamp;

    private final String continuationToken;

    private StartSelector(BuilderImpl builder) {
        this.startSelectorType = builder.startSelectorType;
        this.afterFragmentNumber = builder.afterFragmentNumber;
        this.startTimestamp = builder.startTimestamp;
        this.continuationToken = builder.continuationToken;
    }

    /**
     * <p>
     * Identifies the fragment on the Kinesis video stream where you want to start getting the data from.
     * </p>
     * <ul>
     * <li>
     * <p>
     * NOW - Start with the latest chunk on the stream.
     * </p>
     * </li>
     * <li>
     * <p>
     * EARLIEST - Start with earliest available chunk on the stream.
     * </p>
     * </li>
     * <li>
     * <p>
     * FRAGMENT_NUMBER - Start with the chunk after a specific fragment. You must also specify the
     * <code>AfterFragmentNumber</code> parameter.
     * </p>
     * </li>
     * <li>
     * <p>
     * PRODUCER_TIMESTAMP or SERVER_TIMESTAMP - Start with the chunk containing a fragment with the specified producer
     * or server timestamp. You specify the timestamp by adding <code>StartTimestamp</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * CONTINUATION_TOKEN - Read using the specified continuation token.
     * </p>
     * </li>
     * </ul>
     * <note>
     * <p>
     * If you choose the NOW, EARLIEST, or CONTINUATION_TOKEN as the <code>startSelectorType</code>, you don't provide
     * any additional information in the <code>startSelector</code>.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #startSelectorType}
     * will return {@link StartSelectorType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #startSelectorTypeAsString}.
     * </p>
     * 
     * @return Identifies the fragment on the Kinesis video stream where you want to start getting the data from.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         NOW - Start with the latest chunk on the stream.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         EARLIEST - Start with earliest available chunk on the stream.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         FRAGMENT_NUMBER - Start with the chunk after a specific fragment. You must also specify the
     *         <code>AfterFragmentNumber</code> parameter.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         PRODUCER_TIMESTAMP or SERVER_TIMESTAMP - Start with the chunk containing a fragment with the specified
     *         producer or server timestamp. You specify the timestamp by adding <code>StartTimestamp</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CONTINUATION_TOKEN - Read using the specified continuation token.
     *         </p>
     *         </li>
     *         </ul>
     *         <note>
     *         <p>
     *         If you choose the NOW, EARLIEST, or CONTINUATION_TOKEN as the <code>startSelectorType</code>, you don't
     *         provide any additional information in the <code>startSelector</code>.
     *         </p>
     * @see StartSelectorType
     */
    public StartSelectorType startSelectorType() {
        return StartSelectorType.fromValue(startSelectorType);
    }

    /**
     * <p>
     * Identifies the fragment on the Kinesis video stream where you want to start getting the data from.
     * </p>
     * <ul>
     * <li>
     * <p>
     * NOW - Start with the latest chunk on the stream.
     * </p>
     * </li>
     * <li>
     * <p>
     * EARLIEST - Start with earliest available chunk on the stream.
     * </p>
     * </li>
     * <li>
     * <p>
     * FRAGMENT_NUMBER - Start with the chunk after a specific fragment. You must also specify the
     * <code>AfterFragmentNumber</code> parameter.
     * </p>
     * </li>
     * <li>
     * <p>
     * PRODUCER_TIMESTAMP or SERVER_TIMESTAMP - Start with the chunk containing a fragment with the specified producer
     * or server timestamp. You specify the timestamp by adding <code>StartTimestamp</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * CONTINUATION_TOKEN - Read using the specified continuation token.
     * </p>
     * </li>
     * </ul>
     * <note>
     * <p>
     * If you choose the NOW, EARLIEST, or CONTINUATION_TOKEN as the <code>startSelectorType</code>, you don't provide
     * any additional information in the <code>startSelector</code>.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #startSelectorType}
     * will return {@link StartSelectorType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #startSelectorTypeAsString}.
     * </p>
     * 
     * @return Identifies the fragment on the Kinesis video stream where you want to start getting the data from.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         NOW - Start with the latest chunk on the stream.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         EARLIEST - Start with earliest available chunk on the stream.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         FRAGMENT_NUMBER - Start with the chunk after a specific fragment. You must also specify the
     *         <code>AfterFragmentNumber</code> parameter.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         PRODUCER_TIMESTAMP or SERVER_TIMESTAMP - Start with the chunk containing a fragment with the specified
     *         producer or server timestamp. You specify the timestamp by adding <code>StartTimestamp</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         CONTINUATION_TOKEN - Read using the specified continuation token.
     *         </p>
     *         </li>
     *         </ul>
     *         <note>
     *         <p>
     *         If you choose the NOW, EARLIEST, or CONTINUATION_TOKEN as the <code>startSelectorType</code>, you don't
     *         provide any additional information in the <code>startSelector</code>.
     *         </p>
     * @see StartSelectorType
     */
    public String startSelectorTypeAsString() {
        return startSelectorType;
    }

    /**
     * <p>
     * Specifies the fragment number from where you want the <code>GetMedia</code> API to start returning the fragments.
     * </p>
     * 
     * @return Specifies the fragment number from where you want the <code>GetMedia</code> API to start returning the
     *         fragments.
     */
    public String afterFragmentNumber() {
        return afterFragmentNumber;
    }

    /**
     * <p>
     * A timestamp value. This value is required if you choose the PRODUCER_TIMESTAMP or the SERVER_TIMESTAMP as the
     * <code>startSelectorType</code>. The <code>GetMedia</code> API then starts with the chunk containing the fragment
     * that has the specified timestamp.
     * </p>
     * 
     * @return A timestamp value. This value is required if you choose the PRODUCER_TIMESTAMP or the SERVER_TIMESTAMP as
     *         the <code>startSelectorType</code>. The <code>GetMedia</code> API then starts with the chunk containing
     *         the fragment that has the specified timestamp.
     */
    public Instant startTimestamp() {
        return startTimestamp;
    }

    /**
     * <p>
     * Continuation token that Kinesis Video Streams returned in the previous <code>GetMedia</code> response. The
     * <code>GetMedia</code> API then starts with the chunk identified by the continuation token.
     * </p>
     * 
     * @return Continuation token that Kinesis Video Streams returned in the previous <code>GetMedia</code> response.
     *         The <code>GetMedia</code> API then starts with the chunk identified by the continuation token.
     */
    public String continuationToken() {
        return continuationToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(startSelectorTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(afterFragmentNumber());
        hashCode = 31 * hashCode + Objects.hashCode(startTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(continuationToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartSelector)) {
            return false;
        }
        StartSelector other = (StartSelector) obj;
        return Objects.equals(startSelectorTypeAsString(), other.startSelectorTypeAsString())
                && Objects.equals(afterFragmentNumber(), other.afterFragmentNumber())
                && Objects.equals(startTimestamp(), other.startTimestamp())
                && Objects.equals(continuationToken(), other.continuationToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("StartSelector").add("StartSelectorType", startSelectorTypeAsString())
                .add("AfterFragmentNumber", afterFragmentNumber()).add("StartTimestamp", startTimestamp())
                .add("ContinuationToken", continuationToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StartSelectorType":
            return Optional.ofNullable(clazz.cast(startSelectorTypeAsString()));
        case "AfterFragmentNumber":
            return Optional.ofNullable(clazz.cast(afterFragmentNumber()));
        case "StartTimestamp":
            return Optional.ofNullable(clazz.cast(startTimestamp()));
        case "ContinuationToken":
            return Optional.ofNullable(clazz.cast(continuationToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartSelector, T> g) {
        return obj -> g.apply((StartSelector) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, StartSelector> {
        /**
         * <p>
         * Identifies the fragment on the Kinesis video stream where you want to start getting the data from.
         * </p>
         * <ul>
         * <li>
         * <p>
         * NOW - Start with the latest chunk on the stream.
         * </p>
         * </li>
         * <li>
         * <p>
         * EARLIEST - Start with earliest available chunk on the stream.
         * </p>
         * </li>
         * <li>
         * <p>
         * FRAGMENT_NUMBER - Start with the chunk after a specific fragment. You must also specify the
         * <code>AfterFragmentNumber</code> parameter.
         * </p>
         * </li>
         * <li>
         * <p>
         * PRODUCER_TIMESTAMP or SERVER_TIMESTAMP - Start with the chunk containing a fragment with the specified
         * producer or server timestamp. You specify the timestamp by adding <code>StartTimestamp</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * CONTINUATION_TOKEN - Read using the specified continuation token.
         * </p>
         * </li>
         * </ul>
         * <note>
         * <p>
         * If you choose the NOW, EARLIEST, or CONTINUATION_TOKEN as the <code>startSelectorType</code>, you don't
         * provide any additional information in the <code>startSelector</code>.
         * </p>
         * </note>
         * 
         * @param startSelectorType
         *        Identifies the fragment on the Kinesis video stream where you want to start getting the data from.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        NOW - Start with the latest chunk on the stream.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        EARLIEST - Start with earliest available chunk on the stream.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        FRAGMENT_NUMBER - Start with the chunk after a specific fragment. You must also specify the
         *        <code>AfterFragmentNumber</code> parameter.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        PRODUCER_TIMESTAMP or SERVER_TIMESTAMP - Start with the chunk containing a fragment with the specified
         *        producer or server timestamp. You specify the timestamp by adding <code>StartTimestamp</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        CONTINUATION_TOKEN - Read using the specified continuation token.
         *        </p>
         *        </li>
         *        </ul>
         *        <note>
         *        <p>
         *        If you choose the NOW, EARLIEST, or CONTINUATION_TOKEN as the <code>startSelectorType</code>, you
         *        don't provide any additional information in the <code>startSelector</code>.
         *        </p>
         * @see StartSelectorType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StartSelectorType
         */
        Builder startSelectorType(String startSelectorType);

        /**
         * <p>
         * Identifies the fragment on the Kinesis video stream where you want to start getting the data from.
         * </p>
         * <ul>
         * <li>
         * <p>
         * NOW - Start with the latest chunk on the stream.
         * </p>
         * </li>
         * <li>
         * <p>
         * EARLIEST - Start with earliest available chunk on the stream.
         * </p>
         * </li>
         * <li>
         * <p>
         * FRAGMENT_NUMBER - Start with the chunk after a specific fragment. You must also specify the
         * <code>AfterFragmentNumber</code> parameter.
         * </p>
         * </li>
         * <li>
         * <p>
         * PRODUCER_TIMESTAMP or SERVER_TIMESTAMP - Start with the chunk containing a fragment with the specified
         * producer or server timestamp. You specify the timestamp by adding <code>StartTimestamp</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * CONTINUATION_TOKEN - Read using the specified continuation token.
         * </p>
         * </li>
         * </ul>
         * <note>
         * <p>
         * If you choose the NOW, EARLIEST, or CONTINUATION_TOKEN as the <code>startSelectorType</code>, you don't
         * provide any additional information in the <code>startSelector</code>.
         * </p>
         * </note>
         * 
         * @param startSelectorType
         *        Identifies the fragment on the Kinesis video stream where you want to start getting the data from.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        NOW - Start with the latest chunk on the stream.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        EARLIEST - Start with earliest available chunk on the stream.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        FRAGMENT_NUMBER - Start with the chunk after a specific fragment. You must also specify the
         *        <code>AfterFragmentNumber</code> parameter.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        PRODUCER_TIMESTAMP or SERVER_TIMESTAMP - Start with the chunk containing a fragment with the specified
         *        producer or server timestamp. You specify the timestamp by adding <code>StartTimestamp</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        CONTINUATION_TOKEN - Read using the specified continuation token.
         *        </p>
         *        </li>
         *        </ul>
         *        <note>
         *        <p>
         *        If you choose the NOW, EARLIEST, or CONTINUATION_TOKEN as the <code>startSelectorType</code>, you
         *        don't provide any additional information in the <code>startSelector</code>.
         *        </p>
         * @see StartSelectorType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StartSelectorType
         */
        Builder startSelectorType(StartSelectorType startSelectorType);

        /**
         * <p>
         * Specifies the fragment number from where you want the <code>GetMedia</code> API to start returning the
         * fragments.
         * </p>
         * 
         * @param afterFragmentNumber
         *        Specifies the fragment number from where you want the <code>GetMedia</code> API to start returning the
         *        fragments.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder afterFragmentNumber(String afterFragmentNumber);

        /**
         * <p>
         * A timestamp value. This value is required if you choose the PRODUCER_TIMESTAMP or the SERVER_TIMESTAMP as the
         * <code>startSelectorType</code>. The <code>GetMedia</code> API then starts with the chunk containing the
         * fragment that has the specified timestamp.
         * </p>
         * 
         * @param startTimestamp
         *        A timestamp value. This value is required if you choose the PRODUCER_TIMESTAMP or the SERVER_TIMESTAMP
         *        as the <code>startSelectorType</code>. The <code>GetMedia</code> API then starts with the chunk
         *        containing the fragment that has the specified timestamp.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTimestamp(Instant startTimestamp);

        /**
         * <p>
         * Continuation token that Kinesis Video Streams returned in the previous <code>GetMedia</code> response. The
         * <code>GetMedia</code> API then starts with the chunk identified by the continuation token.
         * </p>
         * 
         * @param continuationToken
         *        Continuation token that Kinesis Video Streams returned in the previous <code>GetMedia</code> response.
         *        The <code>GetMedia</code> API then starts with the chunk identified by the continuation token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder continuationToken(String continuationToken);
    }

    static final class BuilderImpl implements Builder {
        private String startSelectorType;

        private String afterFragmentNumber;

        private Instant startTimestamp;

        private String continuationToken;

        private BuilderImpl() {
        }

        private BuilderImpl(StartSelector model) {
            startSelectorType(model.startSelectorType);
            afterFragmentNumber(model.afterFragmentNumber);
            startTimestamp(model.startTimestamp);
            continuationToken(model.continuationToken);
        }

        public final String getStartSelectorTypeAsString() {
            return startSelectorType;
        }

        @Override
        public final Builder startSelectorType(String startSelectorType) {
            this.startSelectorType = startSelectorType;
            return this;
        }

        @Override
        public final Builder startSelectorType(StartSelectorType startSelectorType) {
            this.startSelectorType(startSelectorType == null ? null : startSelectorType.toString());
            return this;
        }

        public final void setStartSelectorType(String startSelectorType) {
            this.startSelectorType = startSelectorType;
        }

        public final String getAfterFragmentNumber() {
            return afterFragmentNumber;
        }

        @Override
        public final Builder afterFragmentNumber(String afterFragmentNumber) {
            this.afterFragmentNumber = afterFragmentNumber;
            return this;
        }

        public final void setAfterFragmentNumber(String afterFragmentNumber) {
            this.afterFragmentNumber = afterFragmentNumber;
        }

        public final Instant getStartTimestamp() {
            return startTimestamp;
        }

        @Override
        public final Builder startTimestamp(Instant startTimestamp) {
            this.startTimestamp = startTimestamp;
            return this;
        }

        public final void setStartTimestamp(Instant startTimestamp) {
            this.startTimestamp = startTimestamp;
        }

        public final String getContinuationToken() {
            return continuationToken;
        }

        @Override
        public final Builder continuationToken(String continuationToken) {
            this.continuationToken = continuationToken;
            return this;
        }

        public final void setContinuationToken(String continuationToken) {
            this.continuationToken = continuationToken;
        }

        @Override
        public StartSelector build() {
            return new StartSelector(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
