/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kinesisvideomedia.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetMediaRequest extends KinesisVideoMediaRequest implements
        ToCopyableBuilder<GetMediaRequest.Builder, GetMediaRequest> {
    private static final SdkField<String> STREAM_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StreamName").getter(getter(GetMediaRequest::streamName)).setter(setter(Builder::streamName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamName").build()).build();

    private static final SdkField<String> STREAM_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StreamARN").getter(getter(GetMediaRequest::streamARN)).setter(setter(Builder::streamARN))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamARN").build()).build();

    private static final SdkField<StartSelector> START_SELECTOR_FIELD = SdkField
            .<StartSelector> builder(MarshallingType.SDK_POJO).memberName("StartSelector")
            .getter(getter(GetMediaRequest::startSelector)).setter(setter(Builder::startSelector))
            .constructor(StartSelector::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartSelector").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STREAM_NAME_FIELD,
            STREAM_ARN_FIELD, START_SELECTOR_FIELD));

    private final String streamName;

    private final String streamARN;

    private final StartSelector startSelector;

    private GetMediaRequest(BuilderImpl builder) {
        super(builder);
        this.streamName = builder.streamName;
        this.streamARN = builder.streamARN;
        this.startSelector = builder.startSelector;
    }

    /**
     * <p>
     * The Kinesis video stream name from where you want to get the media content. If you don't specify the
     * <code>streamName</code>, you must specify the <code>streamARN</code>.
     * </p>
     * 
     * @return The Kinesis video stream name from where you want to get the media content. If you don't specify the
     *         <code>streamName</code>, you must specify the <code>streamARN</code>.
     */
    public final String streamName() {
        return streamName;
    }

    /**
     * <p>
     * The ARN of the stream from where you want to get the media content. If you don't specify the
     * <code>streamARN</code>, you must specify the <code>streamName</code>.
     * </p>
     * 
     * @return The ARN of the stream from where you want to get the media content. If you don't specify the
     *         <code>streamARN</code>, you must specify the <code>streamName</code>.
     */
    public final String streamARN() {
        return streamARN;
    }

    /**
     * <p>
     * Identifies the starting chunk to get from the specified stream.
     * </p>
     * 
     * @return Identifies the starting chunk to get from the specified stream.
     */
    public final StartSelector startSelector() {
        return startSelector;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(streamName());
        hashCode = 31 * hashCode + Objects.hashCode(streamARN());
        hashCode = 31 * hashCode + Objects.hashCode(startSelector());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetMediaRequest)) {
            return false;
        }
        GetMediaRequest other = (GetMediaRequest) obj;
        return Objects.equals(streamName(), other.streamName()) && Objects.equals(streamARN(), other.streamARN())
                && Objects.equals(startSelector(), other.startSelector());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetMediaRequest").add("StreamName", streamName()).add("StreamARN", streamARN())
                .add("StartSelector", startSelector()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StreamName":
            return Optional.ofNullable(clazz.cast(streamName()));
        case "StreamARN":
            return Optional.ofNullable(clazz.cast(streamARN()));
        case "StartSelector":
            return Optional.ofNullable(clazz.cast(startSelector()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetMediaRequest, T> g) {
        return obj -> g.apply((GetMediaRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends KinesisVideoMediaRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetMediaRequest> {
        /**
         * <p>
         * The Kinesis video stream name from where you want to get the media content. If you don't specify the
         * <code>streamName</code>, you must specify the <code>streamARN</code>.
         * </p>
         * 
         * @param streamName
         *        The Kinesis video stream name from where you want to get the media content. If you don't specify the
         *        <code>streamName</code>, you must specify the <code>streamARN</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamName(String streamName);

        /**
         * <p>
         * The ARN of the stream from where you want to get the media content. If you don't specify the
         * <code>streamARN</code>, you must specify the <code>streamName</code>.
         * </p>
         * 
         * @param streamARN
         *        The ARN of the stream from where you want to get the media content. If you don't specify the
         *        <code>streamARN</code>, you must specify the <code>streamName</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streamARN(String streamARN);

        /**
         * <p>
         * Identifies the starting chunk to get from the specified stream.
         * </p>
         * 
         * @param startSelector
         *        Identifies the starting chunk to get from the specified stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startSelector(StartSelector startSelector);

        /**
         * <p>
         * Identifies the starting chunk to get from the specified stream.
         * </p>
         * This is a convenience method that creates an instance of the {@link StartSelector.Builder} avoiding the need
         * to create one manually via {@link StartSelector#builder()}.
         *
         * When the {@link Consumer} completes, {@link StartSelector.Builder#build()} is called immediately and its
         * result is passed to {@link #startSelector(StartSelector)}.
         * 
         * @param startSelector
         *        a consumer that will call methods on {@link StartSelector.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #startSelector(StartSelector)
         */
        default Builder startSelector(Consumer<StartSelector.Builder> startSelector) {
            return startSelector(StartSelector.builder().applyMutation(startSelector).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends KinesisVideoMediaRequest.BuilderImpl implements Builder {
        private String streamName;

        private String streamARN;

        private StartSelector startSelector;

        private BuilderImpl() {
        }

        private BuilderImpl(GetMediaRequest model) {
            super(model);
            streamName(model.streamName);
            streamARN(model.streamARN);
            startSelector(model.startSelector);
        }

        public final String getStreamName() {
            return streamName;
        }

        public final void setStreamName(String streamName) {
            this.streamName = streamName;
        }

        @Override
        public final Builder streamName(String streamName) {
            this.streamName = streamName;
            return this;
        }

        public final String getStreamARN() {
            return streamARN;
        }

        public final void setStreamARN(String streamARN) {
            this.streamARN = streamARN;
        }

        @Override
        public final Builder streamARN(String streamARN) {
            this.streamARN = streamARN;
            return this;
        }

        public final StartSelector.Builder getStartSelector() {
            return startSelector != null ? startSelector.toBuilder() : null;
        }

        public final void setStartSelector(StartSelector.BuilderImpl startSelector) {
            this.startSelector = startSelector != null ? startSelector.build() : null;
        }

        @Override
        public final Builder startSelector(StartSelector startSelector) {
            this.startSelector = startSelector;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetMediaRequest build() {
            return new GetMediaRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
