/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisvideomedia;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.kinesisvideomedia.DefaultKinesisVideoMediaBaseClientBuilder;
import software.amazon.awssdk.services.kinesisvideomedia.DefaultKinesisVideoMediaClient;
import software.amazon.awssdk.services.kinesisvideomedia.KinesisVideoMediaClient;
import software.amazon.awssdk.services.kinesisvideomedia.KinesisVideoMediaClientBuilder;
import software.amazon.awssdk.services.kinesisvideomedia.KinesisVideoMediaServiceClientConfiguration;
import software.amazon.awssdk.services.kinesisvideomedia.endpoints.KinesisVideoMediaEndpointProvider;

@SdkInternalApi
final class DefaultKinesisVideoMediaClientBuilder
extends DefaultKinesisVideoMediaBaseClientBuilder<KinesisVideoMediaClientBuilder, KinesisVideoMediaClient>
implements KinesisVideoMediaClientBuilder {
    DefaultKinesisVideoMediaClientBuilder() {
    }

    @Override
    public DefaultKinesisVideoMediaClientBuilder endpointProvider(KinesisVideoMediaEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final KinesisVideoMediaClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultKinesisVideoMediaClientBuilder.validateClientOptions(clientConfiguration);
        KinesisVideoMediaServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultKinesisVideoMediaClient client = new DefaultKinesisVideoMediaClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private KinesisVideoMediaServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        if (Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return KinesisVideoMediaServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider((EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER)).build();
    }
}

