/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisvideomedia;

import java.nio.file.Path;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.core.async.AsyncResponseTransformer;
import software.amazon.awssdk.services.kinesisvideomedia.DefaultKinesisVideoMediaAsyncClientBuilder;
import software.amazon.awssdk.services.kinesisvideomedia.KinesisVideoMediaAsyncClientBuilder;
import software.amazon.awssdk.services.kinesisvideomedia.KinesisVideoMediaServiceClientConfiguration;
import software.amazon.awssdk.services.kinesisvideomedia.model.GetMediaRequest;
import software.amazon.awssdk.services.kinesisvideomedia.model.GetMediaResponse;

@SdkPublicApi
@ThreadSafe
public interface KinesisVideoMediaAsyncClient
extends AwsClient {
    public static final String SERVICE_NAME = "kinesisvideo";
    public static final String SERVICE_METADATA_ID = "kinesisvideo";

    default public <ReturnT> CompletableFuture<ReturnT> getMedia(GetMediaRequest getMediaRequest, AsyncResponseTransformer<GetMediaResponse, ReturnT> asyncResponseTransformer) {
        throw new UnsupportedOperationException();
    }

    default public <ReturnT> CompletableFuture<ReturnT> getMedia(Consumer<GetMediaRequest.Builder> getMediaRequest, AsyncResponseTransformer<GetMediaResponse, ReturnT> asyncResponseTransformer) {
        return this.getMedia((GetMediaRequest)((Object)((GetMediaRequest.Builder)GetMediaRequest.builder().applyMutation(getMediaRequest)).build()), asyncResponseTransformer);
    }

    default public CompletableFuture<GetMediaResponse> getMedia(GetMediaRequest getMediaRequest, Path destinationPath) {
        return this.getMedia(getMediaRequest, AsyncResponseTransformer.toFile((Path)destinationPath));
    }

    default public CompletableFuture<GetMediaResponse> getMedia(Consumer<GetMediaRequest.Builder> getMediaRequest, Path destinationPath) {
        return this.getMedia((GetMediaRequest)((Object)((GetMediaRequest.Builder)GetMediaRequest.builder().applyMutation(getMediaRequest)).build()), destinationPath);
    }

    default public KinesisVideoMediaServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }

    public static KinesisVideoMediaAsyncClient create() {
        return (KinesisVideoMediaAsyncClient)KinesisVideoMediaAsyncClient.builder().build();
    }

    public static KinesisVideoMediaAsyncClientBuilder builder() {
        return new DefaultKinesisVideoMediaAsyncClientBuilder();
    }
}

