/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kinesisvideosignaling.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.kinesisvideosignaling.model.KinesisVideoSignalingRequest;
import software.amazon.awssdk.services.kinesisvideosignaling.model.Service;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetIceServerConfigRequest
extends KinesisVideoSignalingRequest
implements ToCopyableBuilder<Builder, GetIceServerConfigRequest> {
    private static final SdkField<String> CHANNEL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetIceServerConfigRequest.getter(GetIceServerConfigRequest::channelARN)).setter(GetIceServerConfigRequest.setter(Builder::channelARN)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChannelARN").build()}).build();
    private static final SdkField<String> CLIENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetIceServerConfigRequest.getter(GetIceServerConfigRequest::clientId)).setter(GetIceServerConfigRequest.setter(Builder::clientId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientId").build()}).build();
    private static final SdkField<String> SERVICE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetIceServerConfigRequest.getter(GetIceServerConfigRequest::serviceAsString)).setter(GetIceServerConfigRequest.setter(Builder::service)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Service").build()}).build();
    private static final SdkField<String> USERNAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetIceServerConfigRequest.getter(GetIceServerConfigRequest::username)).setter(GetIceServerConfigRequest.setter(Builder::username)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Username").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANNEL_ARN_FIELD, CLIENT_ID_FIELD, SERVICE_FIELD, USERNAME_FIELD));
    private final String channelARN;
    private final String clientId;
    private final String service;
    private final String username;

    private GetIceServerConfigRequest(BuilderImpl builder) {
        super(builder);
        this.channelARN = builder.channelARN;
        this.clientId = builder.clientId;
        this.service = builder.service;
        this.username = builder.username;
    }

    public String channelARN() {
        return this.channelARN;
    }

    public String clientId() {
        return this.clientId;
    }

    public Service service() {
        return Service.fromValue(this.service);
    }

    public String serviceAsString() {
        return this.service;
    }

    public String username() {
        return this.username;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.channelARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientId());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.username());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetIceServerConfigRequest)) {
            return false;
        }
        GetIceServerConfigRequest other = (GetIceServerConfigRequest)((Object)obj);
        return Objects.equals(this.channelARN(), other.channelARN()) && Objects.equals(this.clientId(), other.clientId()) && Objects.equals(this.serviceAsString(), other.serviceAsString()) && Objects.equals(this.username(), other.username());
    }

    public String toString() {
        return ToString.builder((String)"GetIceServerConfigRequest").add("ChannelARN", (Object)this.channelARN()).add("ClientId", (Object)this.clientId()).add("Service", (Object)this.serviceAsString()).add("Username", (Object)this.username()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ChannelARN": {
                return Optional.ofNullable(clazz.cast(this.channelARN()));
            }
            case "ClientId": {
                return Optional.ofNullable(clazz.cast(this.clientId()));
            }
            case "Service": {
                return Optional.ofNullable(clazz.cast(this.serviceAsString()));
            }
            case "Username": {
                return Optional.ofNullable(clazz.cast(this.username()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetIceServerConfigRequest, T> g) {
        return obj -> g.apply((GetIceServerConfigRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends KinesisVideoSignalingRequest.BuilderImpl
    implements Builder {
        private String channelARN;
        private String clientId;
        private String service;
        private String username;

        private BuilderImpl() {
        }

        private BuilderImpl(GetIceServerConfigRequest model) {
            super(model);
            this.channelARN(model.channelARN);
            this.clientId(model.clientId);
            this.service(model.service);
            this.username(model.username);
        }

        public final String getChannelARN() {
            return this.channelARN;
        }

        @Override
        public final Builder channelARN(String channelARN) {
            this.channelARN = channelARN;
            return this;
        }

        public final void setChannelARN(String channelARN) {
            this.channelARN = channelARN;
        }

        public final String getClientId() {
            return this.clientId;
        }

        @Override
        public final Builder clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public final void setClientId(String clientId) {
            this.clientId = clientId;
        }

        public final String getServiceAsString() {
            return this.service;
        }

        @Override
        public final Builder service(String service) {
            this.service = service;
            return this;
        }

        @Override
        public final Builder service(Service service) {
            this.service(service == null ? null : service.toString());
            return this;
        }

        public final void setService(String service) {
            this.service = service;
        }

        public final String getUsername() {
            return this.username;
        }

        @Override
        public final Builder username(String username) {
            this.username = username;
            return this;
        }

        public final void setUsername(String username) {
            this.username = username;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetIceServerConfigRequest build() {
            return new GetIceServerConfigRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends KinesisVideoSignalingRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetIceServerConfigRequest> {
        public Builder channelARN(String var1);

        public Builder clientId(String var1);

        public Builder service(String var1);

        public Builder service(Service var1);

        public Builder username(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

